/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.content.Context;
import android.os.Looper;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.ExoPlayerLibraryInfo;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.audio.AudioProcessor;
import com.google.android.exoplayer2.effect.DebugTraceUtil;
import com.google.android.exoplayer2.effect.DefaultVideoFrameProcessor;
import com.google.android.exoplayer2.effect.Presentation;
import com.google.android.exoplayer2.transformer.AssetLoader;
import com.google.android.exoplayer2.transformer.Codec;
import com.google.android.exoplayer2.transformer.Composition;
import com.google.android.exoplayer2.transformer.DefaultAssetLoaderFactory;
import com.google.android.exoplayer2.transformer.DefaultDecoderFactory;
import com.google.android.exoplayer2.transformer.DefaultEncoderFactory;
import com.google.android.exoplayer2.transformer.DefaultMuxer;
import com.google.android.exoplayer2.transformer.EditedMediaItem;
import com.google.android.exoplayer2.transformer.EditedMediaItemSequence;
import com.google.android.exoplayer2.transformer.Effects;
import com.google.android.exoplayer2.transformer.ExportException;
import com.google.android.exoplayer2.transformer.ExportResult;
import com.google.android.exoplayer2.transformer.FallbackListener;
import com.google.android.exoplayer2.transformer.Muxer;
import com.google.android.exoplayer2.transformer.ProgressHolder;
import com.google.android.exoplayer2.transformer.TransformationException;
import com.google.android.exoplayer2.transformer.TransformationRequest;
import com.google.android.exoplayer2.transformer.TransformationResult;
import com.google.android.exoplayer2.transformer.TransformerInternal;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.util.DebugViewProvider;
import com.google.android.exoplayer2.util.Effect;
import com.google.android.exoplayer2.util.HandlerWrapper;
import com.google.android.exoplayer2.util.ListenerSet;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.util.VideoFrameProcessor;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.InlineMe;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@Deprecated
public final class Transformer {
    public static final int PROGRESS_STATE_NOT_STARTED = 0;
    @Deprecated
    public static final int PROGRESS_STATE_NO_TRANSFORMATION = 0;
    public static final int PROGRESS_STATE_WAITING_FOR_AVAILABILITY = 1;
    public static final int PROGRESS_STATE_AVAILABLE = 2;
    public static final int PROGRESS_STATE_UNAVAILABLE = 3;
    private final Context context;
    private final TransformationRequest transformationRequest;
    private final ImmutableList<AudioProcessor> audioProcessors;
    private final ImmutableList<Effect> videoEffects;
    private final boolean removeAudio;
    private final boolean removeVideo;
    private final boolean flattenForSlowMotion;
    private final ListenerSet<Listener> listeners;
    private final AssetLoader.Factory assetLoaderFactory;
    private final VideoFrameProcessor.Factory videoFrameProcessorFactory;
    private final Codec.EncoderFactory encoderFactory;
    private final Muxer.Factory muxerFactory;
    private final Looper looper;
    private final DebugViewProvider debugViewProvider;
    private final Clock clock;
    @Nullable
    private TransformerInternal transformerInternal;

    private Transformer(Context context, TransformationRequest transformationRequest, ImmutableList<AudioProcessor> audioProcessors, ImmutableList<Effect> videoEffects, boolean removeAudio, boolean removeVideo, boolean flattenForSlowMotion, ListenerSet<Listener> listeners, AssetLoader.Factory assetLoaderFactory, VideoFrameProcessor.Factory videoFrameProcessorFactory, Codec.EncoderFactory encoderFactory, Muxer.Factory muxerFactory, Looper looper, DebugViewProvider debugViewProvider, Clock clock) {
        Assertions.checkState((!removeAudio || !removeVideo ? 1 : 0) != 0, (Object)"Audio and video cannot both be removed.");
        this.context = context;
        this.transformationRequest = transformationRequest;
        this.audioProcessors = audioProcessors;
        this.videoEffects = videoEffects;
        this.removeAudio = removeAudio;
        this.removeVideo = removeVideo;
        this.flattenForSlowMotion = flattenForSlowMotion;
        this.listeners = listeners;
        this.assetLoaderFactory = assetLoaderFactory;
        this.videoFrameProcessorFactory = videoFrameProcessorFactory;
        this.encoderFactory = encoderFactory;
        this.muxerFactory = muxerFactory;
        this.looper = looper;
        this.debugViewProvider = debugViewProvider;
        this.clock = clock;
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    @Deprecated
    public void setListener(Listener listener) {
        this.verifyApplicationThread();
        this.listeners.clear();
        this.listeners.add((Object)listener);
    }

    public void addListener(Listener listener) {
        this.verifyApplicationThread();
        this.listeners.add((Object)listener);
    }

    public void removeListener(Listener listener) {
        this.verifyApplicationThread();
        this.listeners.remove((Object)listener);
    }

    public void removeAllListeners() {
        this.verifyApplicationThread();
        this.listeners.clear();
    }

    public void start(Composition composition, String path) {
        Assertions.checkArgument((boolean)composition.effects.audioProcessors.isEmpty());
        ImmutableList<Effect> videoEffects = composition.effects.videoEffects;
        Assertions.checkArgument((videoEffects.isEmpty() || videoEffects.size() == 1 && videoEffects.get(0) instanceof Presentation ? 1 : 0) != 0);
        this.verifyApplicationThread();
        Assertions.checkState((this.transformerInternal == null ? 1 : 0) != 0, (Object)"There is already an export in progress.");
        TransformerInternalListener transformerInternalListener = new TransformerInternalListener(composition);
        HandlerWrapper applicationHandler = this.clock.createHandler(this.looper, null);
        FallbackListener fallbackListener = new FallbackListener(composition, this.listeners, applicationHandler, this.transformationRequest);
        DebugTraceUtil.reset();
        this.transformerInternal = new TransformerInternal(this.context, composition, path, this.transformationRequest, this.assetLoaderFactory, this.videoFrameProcessorFactory, this.encoderFactory, this.muxerFactory, transformerInternalListener, fallbackListener, applicationHandler, this.debugViewProvider, this.clock);
        this.transformerInternal.start();
    }

    public void start(EditedMediaItem editedMediaItem, String path) {
        EditedMediaItemSequence sequence = new EditedMediaItemSequence((List<EditedMediaItem>)ImmutableList.of((Object)editedMediaItem));
        this.start(new Composition.Builder((List<EditedMediaItemSequence>)ImmutableList.of((Object)sequence)).build(), path);
    }

    public void start(MediaItem mediaItem, String path) {
        if (!mediaItem.clippingConfiguration.equals((Object)MediaItem.ClippingConfiguration.UNSET) && this.flattenForSlowMotion) {
            throw new IllegalArgumentException("Clipping is not supported when slow motion flattening is requested");
        }
        EditedMediaItem editedMediaItem = new EditedMediaItem.Builder(mediaItem).setRemoveAudio(this.removeAudio).setRemoveVideo(this.removeVideo).setFlattenForSlowMotion(this.flattenForSlowMotion).setEffects(new Effects((List<AudioProcessor>)this.audioProcessors, (List<Effect>)this.videoEffects)).build();
        this.start(editedMediaItem, path);
    }

    @Deprecated
    @InlineMe(replacement="this.start(mediaItem, path)")
    public void startTransformation(MediaItem mediaItem, String path) {
        this.start(mediaItem, path);
    }

    public Looper getApplicationLooper() {
        return this.looper;
    }

    public int getProgress(ProgressHolder progressHolder) {
        this.verifyApplicationThread();
        return this.transformerInternal == null ? 0 : this.transformerInternal.getProgress(progressHolder);
    }

    public void cancel() {
        this.verifyApplicationThread();
        if (this.transformerInternal == null) {
            return;
        }
        try {
            this.transformerInternal.cancel();
        }
        finally {
            this.transformerInternal = null;
        }
    }

    private void verifyApplicationThread() {
        if (Looper.myLooper() != this.looper) {
            throw new IllegalStateException("Transformer is accessed on the wrong thread.");
        }
    }

    static {
        ExoPlayerLibraryInfo.registerModule((String)"goog.exo.transformer");
    }

    private final class TransformerInternalListener
    implements TransformerInternal.Listener {
        private final Composition composition;

        public TransformerInternalListener(Composition composition) {
            this.composition = composition;
        }

        @Override
        public void onCompleted(ExportResult exportResult) {
            Transformer.this.transformerInternal = null;
            Transformer.this.listeners.queueEvent(-1, listener -> listener.onCompleted(this.composition, exportResult));
            Transformer.this.listeners.flushEvents();
        }

        @Override
        public void onError(ExportResult exportResult, ExportException exportException) {
            Transformer.this.transformerInternal = null;
            Transformer.this.listeners.queueEvent(-1, listener -> listener.onError(this.composition, exportResult, exportException));
            Transformer.this.listeners.flushEvents();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface ProgressState {
    }

    public static interface Listener {
        @Deprecated
        default public void onTransformationCompleted(MediaItem inputMediaItem) {
        }

        @Deprecated
        default public void onTransformationCompleted(MediaItem inputMediaItem, TransformationResult result) {
            this.onTransformationCompleted(inputMediaItem);
        }

        default public void onCompleted(Composition composition, ExportResult exportResult) {
            MediaItem mediaItem = ((EditedMediaItem)((EditedMediaItemSequence)composition.sequences.get((int)0)).editedMediaItems.get((int)0)).mediaItem;
            this.onTransformationCompleted(mediaItem, new TransformationResult.Builder(exportResult).build());
        }

        @Deprecated
        default public void onTransformationError(MediaItem inputMediaItem, Exception exception) {
        }

        @Deprecated
        default public void onTransformationError(MediaItem inputMediaItem, TransformationException exception) {
            this.onTransformationError(inputMediaItem, (Exception)exception);
        }

        @Deprecated
        default public void onTransformationError(MediaItem inputMediaItem, TransformationResult result, TransformationException exception) {
            this.onTransformationError(inputMediaItem, exception);
        }

        default public void onError(Composition composition, ExportResult exportResult, ExportException exportException) {
            MediaItem mediaItem = ((EditedMediaItem)((EditedMediaItemSequence)composition.sequences.get((int)0)).editedMediaItems.get((int)0)).mediaItem;
            this.onTransformationError(mediaItem, new TransformationResult.Builder(exportResult).build(), new TransformationException(exportException));
        }

        @Deprecated
        default public void onFallbackApplied(MediaItem inputMediaItem, TransformationRequest originalTransformationRequest, TransformationRequest fallbackTransformationRequest) {
        }

        default public void onFallbackApplied(Composition composition, TransformationRequest originalTransformationRequest, TransformationRequest fallbackTransformationRequest) {
            MediaItem mediaItem = ((EditedMediaItem)((EditedMediaItemSequence)composition.sequences.get((int)0)).editedMediaItems.get((int)0)).mediaItem;
            this.onFallbackApplied(mediaItem, originalTransformationRequest, fallbackTransformationRequest);
        }
    }

    public static final class Builder {
        private final Context context;
        private TransformationRequest transformationRequest;
        private ImmutableList<AudioProcessor> audioProcessors;
        private ImmutableList<Effect> videoEffects;
        private boolean removeAudio;
        private boolean removeVideo;
        private boolean flattenForSlowMotion;
        private ListenerSet<Listener> listeners;
        private @MonotonicNonNull AssetLoader.Factory assetLoaderFactory;
        private VideoFrameProcessor.Factory videoFrameProcessorFactory;
        private Codec.EncoderFactory encoderFactory;
        private Muxer.Factory muxerFactory;
        private Looper looper;
        private DebugViewProvider debugViewProvider;
        private Clock clock;

        public Builder(Context context) {
            this.context = context.getApplicationContext();
            this.transformationRequest = new TransformationRequest.Builder().build();
            this.audioProcessors = ImmutableList.of();
            this.videoEffects = ImmutableList.of();
            this.videoFrameProcessorFactory = new DefaultVideoFrameProcessor.Factory.Builder().build();
            this.encoderFactory = new DefaultEncoderFactory.Builder(this.context).build();
            this.muxerFactory = new DefaultMuxer.Factory();
            this.looper = Util.getCurrentOrMainLooper();
            this.debugViewProvider = DebugViewProvider.NONE;
            this.clock = Clock.DEFAULT;
            this.listeners = new ListenerSet(this.looper, this.clock, (listener, flags) -> {});
        }

        private Builder(Transformer transformer) {
            this.context = transformer.context;
            this.transformationRequest = transformer.transformationRequest;
            this.audioProcessors = transformer.audioProcessors;
            this.videoEffects = transformer.videoEffects;
            this.removeAudio = transformer.removeAudio;
            this.removeVideo = transformer.removeVideo;
            this.listeners = transformer.listeners;
            this.assetLoaderFactory = transformer.assetLoaderFactory;
            this.videoFrameProcessorFactory = transformer.videoFrameProcessorFactory;
            this.encoderFactory = transformer.encoderFactory;
            this.muxerFactory = transformer.muxerFactory;
            this.looper = transformer.looper;
            this.debugViewProvider = transformer.debugViewProvider;
            this.clock = transformer.clock;
        }

        @CanIgnoreReturnValue
        public Builder setTransformationRequest(TransformationRequest transformationRequest) {
            this.transformationRequest = transformationRequest;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder setAudioProcessors(List<AudioProcessor> audioProcessors) {
            this.audioProcessors = ImmutableList.copyOf(audioProcessors);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder setVideoEffects(List<Effect> effects) {
            this.videoEffects = ImmutableList.copyOf(effects);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder setRemoveAudio(boolean removeAudio) {
            this.removeAudio = removeAudio;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder setRemoveVideo(boolean removeVideo) {
            this.removeVideo = removeVideo;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder setFlattenForSlowMotion(boolean flattenForSlowMotion) {
            this.flattenForSlowMotion = flattenForSlowMotion;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder setListener(Listener listener) {
            this.listeners.clear();
            this.listeners.add((Object)listener);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addListener(Listener listener) {
            this.listeners.add((Object)listener);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder removeListener(Listener listener) {
            this.listeners.remove((Object)listener);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder removeAllListeners() {
            this.listeners.clear();
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setAssetLoaderFactory(AssetLoader.Factory assetLoaderFactory) {
            this.assetLoaderFactory = assetLoaderFactory;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setVideoFrameProcessorFactory(VideoFrameProcessor.Factory videoFrameProcessorFactory) {
            this.videoFrameProcessorFactory = videoFrameProcessorFactory;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setEncoderFactory(Codec.EncoderFactory encoderFactory) {
            this.encoderFactory = encoderFactory;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMuxerFactory(Muxer.Factory muxerFactory) {
            this.muxerFactory = muxerFactory;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setLooper(Looper looper) {
            this.looper = looper;
            this.listeners = this.listeners.copy(looper, (listener, flags) -> {});
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setDebugViewProvider(DebugViewProvider debugViewProvider) {
            this.debugViewProvider = debugViewProvider;
            return this;
        }

        @CanIgnoreReturnValue
        @VisibleForTesting
        Builder setClock(Clock clock) {
            this.clock = clock;
            this.listeners = this.listeners.copy(this.looper, clock, (listener, flags) -> {});
            return this;
        }

        public Transformer build() {
            if (this.transformationRequest.audioMimeType != null) {
                this.checkSampleMimeType(this.transformationRequest.audioMimeType);
            }
            if (this.transformationRequest.videoMimeType != null) {
                this.checkSampleMimeType(this.transformationRequest.videoMimeType);
            }
            if (this.assetLoaderFactory == null) {
                this.assetLoaderFactory = new DefaultAssetLoaderFactory(this.context, new DefaultDecoderFactory(this.context), this.transformationRequest.hdrMode == 3, this.clock);
            }
            return new Transformer(this.context, this.transformationRequest, this.audioProcessors, this.videoEffects, this.removeAudio, this.removeVideo, this.flattenForSlowMotion, this.listeners, this.assetLoaderFactory, this.videoFrameProcessorFactory, this.encoderFactory, this.muxerFactory, this.looper, this.debugViewProvider, this.clock);
        }

        private void checkSampleMimeType(String sampleMimeType) {
            Assertions.checkState((boolean)this.muxerFactory.getSupportedSampleMimeTypes(MimeTypes.getTrackType((String)sampleMimeType)).contains((Object)sampleMimeType), (Object)("Unsupported sample MIME type " + sampleMimeType));
        }
    }
}

