/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import com.google.android.exoplayer2.audio.AudioProcessor;
import com.google.android.exoplayer2.util.Util;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicLong;

@Deprecated
final class SilentAudioGenerator {
    private static final int DEFAULT_BUFFER_SIZE_FRAMES = 1024;
    private final int sampleRate;
    private final int frameSize;
    private final ByteBuffer internalBuffer;
    private final AtomicLong remainingBytesToOutput;

    public SilentAudioGenerator(AudioProcessor.AudioFormat format) {
        this.sampleRate = format.sampleRate;
        this.frameSize = Util.getPcmFrameSize((int)format.encoding, (int)format.channelCount);
        this.internalBuffer = ByteBuffer.allocateDirect(1024 * this.frameSize).order(ByteOrder.nativeOrder());
        this.internalBuffer.flip();
        this.remainingBytesToOutput = new AtomicLong();
    }

    public void addSilence(long durationUs) {
        long outputFrameCount = (long)this.sampleRate * durationUs / 1000000L;
        this.remainingBytesToOutput.addAndGet((long)this.frameSize * outputFrameCount);
    }

    public ByteBuffer getBuffer() {
        long remainingBytesToOutput = this.remainingBytesToOutput.get();
        if (!this.internalBuffer.hasRemaining()) {
            this.internalBuffer.clear();
            if (remainingBytesToOutput < (long)this.internalBuffer.capacity()) {
                this.internalBuffer.limit((int)remainingBytesToOutput);
            }
            this.remainingBytesToOutput.addAndGet(-this.internalBuffer.remaining());
        }
        return this.internalBuffer;
    }

    public boolean hasRemaining() {
        return this.internalBuffer.hasRemaining() || this.remainingBytesToOutput.get() > 0L;
    }
}

