/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.graphics.Bitmap;
import android.os.Looper;
import android.view.Surface;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.transformer.AssetLoader;
import com.google.android.exoplayer2.transformer.EditedMediaItem;
import com.google.android.exoplayer2.transformer.EditedMediaItemSequence;
import com.google.android.exoplayer2.transformer.ExportException;
import com.google.android.exoplayer2.transformer.ExportResult;
import com.google.android.exoplayer2.transformer.OnMediaItemChangedListener;
import com.google.android.exoplayer2.transformer.ProgressHolder;
import com.google.android.exoplayer2.transformer.SampleConsumer;
import com.google.android.exoplayer2.transformer.TransformerUtil;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.util.HandlerWrapper;
import com.google.android.exoplayer2.util.OnInputFrameProcessedListener;
import com.google.android.exoplayer2.video.ColorInfo;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

@Deprecated
final class SequenceAssetLoader
implements AssetLoader,
AssetLoader.Listener {
    private static final Format FORCE_AUDIO_TRACK_FORMAT = new Format.Builder().setSampleMimeType("audio/mp4a-latm").setSampleRate(44100).setChannelCount(2).build();
    private final List<EditedMediaItem> editedMediaItems;
    private final boolean isLooping;
    private final boolean forceAudioTrack;
    private final AssetLoader.Factory assetLoaderFactory;
    private final HandlerWrapper handler;
    private final AssetLoader.Listener sequenceAssetLoaderListener;
    private final Map<Integer, SampleConsumer> sampleConsumersByTrackType;
    private final Map<Integer, OnMediaItemChangedListener> mediaItemChangedListenersByTrackType;
    private final ImmutableList.Builder<ExportResult.ProcessedInput> processedInputsBuilder;
    private final AtomicInteger nonEndedTracks;
    private boolean isCurrentAssetFirstAsset;
    private int currentMediaItemIndex;
    private AssetLoader currentAssetLoader;
    private boolean trackCountReported;
    private boolean decodeAudio;
    private boolean decodeVideo;
    private long totalDurationUs;
    private int sequenceLoopCount;
    private boolean audioLoopingEnded;
    private boolean videoLoopingEnded;
    private int processedInputsSize;
    private boolean released;
    private volatile long currentAssetDurationUs;
    private volatile long maxSequenceDurationUs;
    private volatile boolean isMaxSequenceDurationUsFinal;

    public SequenceAssetLoader(EditedMediaItemSequence sequence, boolean forceAudioTrack, AssetLoader.Factory assetLoaderFactory, Looper looper, AssetLoader.Listener listener, Clock clock) {
        AssetLoader currentAssetLoader;
        this.editedMediaItems = sequence.editedMediaItems;
        this.isLooping = sequence.isLooping;
        this.forceAudioTrack = forceAudioTrack;
        this.assetLoaderFactory = assetLoaderFactory;
        this.sequenceAssetLoaderListener = listener;
        this.handler = clock.createHandler(looper, null);
        this.sampleConsumersByTrackType = new HashMap<Integer, SampleConsumer>();
        this.mediaItemChangedListenersByTrackType = new HashMap<Integer, OnMediaItemChangedListener>();
        this.processedInputsBuilder = new ImmutableList.Builder();
        this.nonEndedTracks = new AtomicInteger();
        this.isCurrentAssetFirstAsset = true;
        this.currentAssetLoader = currentAssetLoader = assetLoaderFactory.createAssetLoader(this.editedMediaItems.get(0), looper, this);
    }

    @Override
    public void start() {
        this.currentAssetLoader.start();
        if (this.editedMediaItems.size() > 1 || this.isLooping) {
            this.sequenceAssetLoaderListener.onDurationUs(-9223372036854775807L);
        }
    }

    @Override
    public int getProgress(ProgressHolder progressHolder) {
        if (this.isLooping) {
            return 3;
        }
        int progressState = this.currentAssetLoader.getProgress(progressHolder);
        int mediaItemCount = this.editedMediaItems.size();
        if (mediaItemCount == 1 || progressState == 0) {
            return progressState;
        }
        int progress = this.currentMediaItemIndex * 100 / mediaItemCount;
        if (progressState == 2) {
            progress += progressHolder.progress / mediaItemCount;
        }
        progressHolder.progress = progress;
        return 2;
    }

    @Override
    public ImmutableMap<Integer, String> getDecoderNames() {
        return this.currentAssetLoader.getDecoderNames();
    }

    public ImmutableList<ExportResult.ProcessedInput> getProcessedInputs() {
        this.addCurrentProcessedInput();
        return this.processedInputsBuilder.build();
    }

    @Override
    public void release() {
        this.currentAssetLoader.release();
        this.released = true;
    }

    private void addCurrentProcessedInput() {
        if (this.sequenceLoopCount * this.editedMediaItems.size() + this.currentMediaItemIndex >= this.processedInputsSize) {
            MediaItem mediaItem = this.editedMediaItems.get((int)this.currentMediaItemIndex).mediaItem;
            ImmutableMap<Integer, String> decoders = this.currentAssetLoader.getDecoderNames();
            this.processedInputsBuilder.add((Object)new ExportResult.ProcessedInput(mediaItem, (String)decoders.get((Object)1), (String)decoders.get((Object)2)));
            ++this.processedInputsSize;
        }
    }

    public void addOnMediaItemChangedListener(OnMediaItemChangedListener onMediaItemChangedListener, int trackType) {
        Assertions.checkArgument((trackType == 1 || trackType == 2 ? 1 : 0) != 0);
        Assertions.checkArgument((this.mediaItemChangedListenersByTrackType.get(trackType) == null ? 1 : 0) != 0);
        this.mediaItemChangedListenersByTrackType.put(trackType, onMediaItemChangedListener);
    }

    @Override
    public boolean onTrackAdded(Format inputFormat, int supportedOutputTypes) {
        boolean addForcedAudioTrack;
        boolean isAudio;
        boolean bl = isAudio = TransformerUtil.getProcessedTrackType(inputFormat.sampleMimeType) == 1;
        if (!this.isCurrentAssetFirstAsset) {
            return isAudio ? this.decodeAudio : this.decodeVideo;
        }
        boolean bl2 = addForcedAudioTrack = this.forceAudioTrack && this.nonEndedTracks.get() == 1 && !isAudio;
        if (!this.trackCountReported) {
            int trackCount = this.nonEndedTracks.get() + (addForcedAudioTrack ? 1 : 0);
            this.sequenceAssetLoaderListener.onTrackCount(trackCount);
            this.trackCountReported = true;
        }
        boolean decodeOutput = this.sequenceAssetLoaderListener.onTrackAdded(inputFormat, supportedOutputTypes);
        if (isAudio) {
            this.decodeAudio = decodeOutput;
        } else {
            this.decodeVideo = decodeOutput;
        }
        if (addForcedAudioTrack) {
            this.sequenceAssetLoaderListener.onTrackAdded(FORCE_AUDIO_TRACK_FORMAT, 2);
        }
        return decodeOutput;
    }

    @Override
    @Nullable
    public SampleConsumer onOutputFormat(Format format) throws ExportException {
        SampleConsumer sampleConsumer;
        int trackType = TransformerUtil.getProcessedTrackType(format.sampleMimeType);
        if (this.isCurrentAssetFirstAsset) {
            SampleConsumer wrappedSampleConsumer = this.sequenceAssetLoaderListener.onOutputFormat(format);
            if (wrappedSampleConsumer == null) {
                return null;
            }
            sampleConsumer = new SampleConsumerWrapper(wrappedSampleConsumer);
            this.sampleConsumersByTrackType.put(trackType, sampleConsumer);
            if (this.forceAudioTrack && this.nonEndedTracks.get() == 1 && trackType == 2) {
                SampleConsumer wrappedAudioSampleConsumer = (SampleConsumer)Assertions.checkStateNotNull((Object)this.sequenceAssetLoaderListener.onOutputFormat(FORCE_AUDIO_TRACK_FORMAT.buildUpon().setSampleMimeType("audio/raw").setPcmEncoding(2).build()));
                this.sampleConsumersByTrackType.put(1, new SampleConsumerWrapper(wrappedAudioSampleConsumer));
            }
        } else {
            boolean videoTrackDisappeared = this.nonEndedTracks.get() == 1 && trackType == 1 && this.sampleConsumersByTrackType.size() == 2;
            Assertions.checkState((!videoTrackDisappeared ? 1 : 0) != 0, (Object)"Inputs with no video track are not supported when the output contains a video track");
            sampleConsumer = (SampleConsumer)Assertions.checkStateNotNull((Object)this.sampleConsumersByTrackType.get(trackType), (Object)("The preceding MediaItem does not contain any track of type " + trackType));
        }
        this.onMediaItemChanged(trackType, format);
        if (this.nonEndedTracks.get() == 1 && this.sampleConsumersByTrackType.size() == 2) {
            for (Map.Entry<Integer, SampleConsumer> entry : this.sampleConsumersByTrackType.entrySet()) {
                int outputTrackType = entry.getKey();
                if (trackType == outputTrackType) continue;
                this.onMediaItemChanged(outputTrackType, null);
            }
        }
        return sampleConsumer;
    }

    private void onMediaItemChanged(int trackType, @Nullable Format format) {
        OnMediaItemChangedListener onMediaItemChangedListener = this.mediaItemChangedListenersByTrackType.get(trackType);
        if (onMediaItemChangedListener == null) {
            return;
        }
        onMediaItemChangedListener.onMediaItemChanged(this.editedMediaItems.get(this.currentMediaItemIndex), this.currentAssetDurationUs, format, this.currentMediaItemIndex == this.editedMediaItems.size() - 1);
    }

    public void setMaxSequenceDurationUs(long maxSequenceDurationUs, boolean isFinal) {
        this.maxSequenceDurationUs = maxSequenceDurationUs;
        this.isMaxSequenceDurationUsFinal = isFinal;
    }

    @Override
    public void onDurationUs(long durationUs) {
        Assertions.checkArgument((durationUs != -9223372036854775807L || this.currentMediaItemIndex == this.editedMediaItems.size() - 1 ? 1 : 0) != 0, (Object)("Could not retrieve required duration for EditedMediaItem " + this.currentMediaItemIndex));
        this.currentAssetDurationUs = durationUs;
        if (this.editedMediaItems.size() == 1 && !this.isLooping) {
            this.sequenceAssetLoaderListener.onDurationUs(durationUs);
        }
    }

    @Override
    public void onTrackCount(int trackCount) {
        this.nonEndedTracks.set(trackCount);
    }

    @Override
    public void onError(ExportException exportException) {
        this.sequenceAssetLoaderListener.onError(exportException);
    }

    private final class SampleConsumerWrapper
    implements SampleConsumer {
        private final SampleConsumer sampleConsumer;

        public SampleConsumerWrapper(SampleConsumer sampleConsumer) {
            this.sampleConsumer = sampleConsumer;
        }

        @Override
        @Nullable
        public DecoderInputBuffer getInputBuffer() {
            return this.sampleConsumer.getInputBuffer();
        }

        @Override
        public boolean queueInputBuffer() {
            DecoderInputBuffer inputBuffer = (DecoderInputBuffer)Assertions.checkStateNotNull((Object)this.sampleConsumer.getInputBuffer());
            long globalTimestampUs = SequenceAssetLoader.this.totalDurationUs + inputBuffer.timeUs;
            if (SequenceAssetLoader.this.isLooping && globalTimestampUs >= SequenceAssetLoader.this.maxSequenceDurationUs) {
                if (SequenceAssetLoader.this.isMaxSequenceDurationUsFinal && !SequenceAssetLoader.this.audioLoopingEnded) {
                    ((ByteBuffer)Assertions.checkNotNull((Object)inputBuffer.data)).limit(0);
                    inputBuffer.setFlags(4);
                    Assertions.checkState((boolean)this.sampleConsumer.queueInputBuffer());
                    SequenceAssetLoader.this.audioLoopingEnded = true;
                    SequenceAssetLoader.this.nonEndedTracks.decrementAndGet();
                }
                return false;
            }
            if (inputBuffer.isEndOfStream()) {
                SequenceAssetLoader.this.nonEndedTracks.decrementAndGet();
                if (SequenceAssetLoader.this.currentMediaItemIndex < SequenceAssetLoader.this.editedMediaItems.size() - 1 || SequenceAssetLoader.this.isLooping) {
                    inputBuffer.clear();
                    inputBuffer.timeUs = 0L;
                    if (SequenceAssetLoader.this.nonEndedTracks.get() == 0) {
                        this.switchAssetLoader();
                    }
                    return true;
                }
            }
            Assertions.checkState((boolean)this.sampleConsumer.queueInputBuffer());
            return true;
        }

        @Override
        public boolean queueInputBitmap(Bitmap inputBitmap, long durationUs, int frameRate) {
            if (SequenceAssetLoader.this.isLooping && SequenceAssetLoader.this.totalDurationUs + durationUs > SequenceAssetLoader.this.maxSequenceDurationUs) {
                if (!SequenceAssetLoader.this.isMaxSequenceDurationUsFinal) {
                    return false;
                }
                durationUs = SequenceAssetLoader.this.maxSequenceDurationUs - SequenceAssetLoader.this.totalDurationUs;
                if (durationUs == 0L) {
                    if (!SequenceAssetLoader.this.videoLoopingEnded) {
                        SequenceAssetLoader.this.videoLoopingEnded = true;
                        this.signalEndOfVideoInput();
                    }
                    return false;
                }
                SequenceAssetLoader.this.videoLoopingEnded = true;
            }
            return this.sampleConsumer.queueInputBitmap(inputBitmap, durationUs, frameRate);
        }

        @Override
        public void setOnInputFrameProcessedListener(OnInputFrameProcessedListener listener) {
            this.sampleConsumer.setOnInputFrameProcessedListener(listener);
        }

        @Override
        public boolean queueInputTexture(int texId, long presentationTimeUs) {
            long globalTimestampUs = SequenceAssetLoader.this.totalDurationUs + presentationTimeUs;
            if (SequenceAssetLoader.this.isLooping && globalTimestampUs >= SequenceAssetLoader.this.maxSequenceDurationUs) {
                if (SequenceAssetLoader.this.isMaxSequenceDurationUsFinal && !SequenceAssetLoader.this.videoLoopingEnded) {
                    SequenceAssetLoader.this.videoLoopingEnded = true;
                    this.signalEndOfVideoInput();
                }
                return false;
            }
            return this.sampleConsumer.queueInputTexture(texId, presentationTimeUs);
        }

        @Override
        public Surface getInputSurface() {
            return this.sampleConsumer.getInputSurface();
        }

        @Override
        public ColorInfo getExpectedInputColorInfo() {
            return this.sampleConsumer.getExpectedInputColorInfo();
        }

        @Override
        public int getPendingVideoFrameCount() {
            return this.sampleConsumer.getPendingVideoFrameCount();
        }

        @Override
        public boolean registerVideoFrame(long presentationTimeUs) {
            long globalTimestampUs = SequenceAssetLoader.this.totalDurationUs + presentationTimeUs;
            if (SequenceAssetLoader.this.isLooping && globalTimestampUs >= SequenceAssetLoader.this.maxSequenceDurationUs) {
                if (SequenceAssetLoader.this.isMaxSequenceDurationUsFinal && !SequenceAssetLoader.this.videoLoopingEnded) {
                    SequenceAssetLoader.this.videoLoopingEnded = true;
                    this.signalEndOfVideoInput();
                }
                return false;
            }
            return this.sampleConsumer.registerVideoFrame(presentationTimeUs);
        }

        @Override
        public void signalEndOfVideoInput() {
            boolean videoEnded;
            SequenceAssetLoader.this.nonEndedTracks.decrementAndGet();
            boolean bl = SequenceAssetLoader.this.isLooping ? SequenceAssetLoader.this.videoLoopingEnded : (videoEnded = SequenceAssetLoader.this.currentMediaItemIndex == SequenceAssetLoader.this.editedMediaItems.size() - 1);
            if (videoEnded) {
                this.sampleConsumer.signalEndOfVideoInput();
            } else if (SequenceAssetLoader.this.nonEndedTracks.get() == 0) {
                this.switchAssetLoader();
            }
        }

        private void switchAssetLoader() {
            SequenceAssetLoader.this.handler.post(() -> {
                try {
                    if (SequenceAssetLoader.this.released) {
                        return;
                    }
                    SequenceAssetLoader.this.addCurrentProcessedInput();
                    SequenceAssetLoader.this.totalDurationUs += SequenceAssetLoader.this.currentAssetDurationUs;
                    SequenceAssetLoader.this.currentAssetLoader.release();
                    SequenceAssetLoader.this.isCurrentAssetFirstAsset = false;
                    SequenceAssetLoader.this.currentMediaItemIndex++;
                    if (SequenceAssetLoader.this.currentMediaItemIndex == SequenceAssetLoader.this.editedMediaItems.size()) {
                        SequenceAssetLoader.this.currentMediaItemIndex = 0;
                        SequenceAssetLoader.this.sequenceLoopCount++;
                    }
                    EditedMediaItem editedMediaItem = (EditedMediaItem)SequenceAssetLoader.this.editedMediaItems.get(SequenceAssetLoader.this.currentMediaItemIndex);
                    SequenceAssetLoader.this.currentAssetLoader = SequenceAssetLoader.this.assetLoaderFactory.createAssetLoader(editedMediaItem, (Looper)Assertions.checkNotNull((Object)Looper.myLooper()), SequenceAssetLoader.this);
                    SequenceAssetLoader.this.currentAssetLoader.start();
                }
                catch (RuntimeException e) {
                    SequenceAssetLoader.this.onError(ExportException.createForAssetLoader(e, 1000));
                }
            });
        }
    }
}

