/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.transformer.EncoderUtil;
import com.google.android.exoplayer2.transformer.ExportException;
import com.google.android.exoplayer2.transformer.Muxer;
import com.google.android.exoplayer2.transformer.MuxerWrapper;
import com.google.android.exoplayer2.transformer.OnMediaItemChangedListener;
import com.google.android.exoplayer2.transformer.SampleConsumer;
import com.google.android.exoplayer2.transformer.TransformerUtil;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.video.ColorInfo;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.nio.ByteBuffer;
import java.util.List;

@Deprecated
abstract class SamplePipeline
implements SampleConsumer,
OnMediaItemChangedListener {
    private final MuxerWrapper muxerWrapper;
    private final int outputTrackType;
    @Nullable
    private final Metadata metadata;
    private boolean muxerWrapperTrackAdded;

    public SamplePipeline(Format firstInputFormat, MuxerWrapper muxerWrapper) {
        this.muxerWrapper = muxerWrapper;
        this.metadata = firstInputFormat.metadata;
        this.outputTrackType = TransformerUtil.getProcessedTrackType(firstInputFormat.sampleMimeType);
    }

    public final boolean processData() throws ExportException {
        return this.feedMuxer() || this.processDataUpToMuxer();
    }

    public abstract void release();

    protected boolean processDataUpToMuxer() throws ExportException {
        return false;
    }

    @Nullable
    protected abstract Format getMuxerInputFormat() throws ExportException;

    @Nullable
    protected abstract DecoderInputBuffer getMuxerInputBuffer() throws ExportException;

    protected abstract void releaseMuxerInputBuffer() throws ExportException;

    protected abstract boolean isMuxerInputEnded();

    private boolean feedMuxer() throws ExportException {
        if (!this.muxerWrapperTrackAdded) {
            Format inputFormat = this.getMuxerInputFormat();
            if (inputFormat == null) {
                return false;
            }
            if (this.metadata != null) {
                inputFormat = inputFormat.buildUpon().setMetadata(this.metadata).build();
            }
            try {
                this.muxerWrapper.addTrackFormat(inputFormat);
            }
            catch (Muxer.MuxerException e) {
                throw ExportException.createForMuxer(e, 7001);
            }
            this.muxerWrapperTrackAdded = true;
        }
        if (this.isMuxerInputEnded()) {
            this.muxerWrapper.endTrack(this.outputTrackType);
            return false;
        }
        DecoderInputBuffer muxerInputBuffer = this.getMuxerInputBuffer();
        if (muxerInputBuffer == null) {
            return false;
        }
        try {
            if (!this.muxerWrapper.writeSample(this.outputTrackType, (ByteBuffer)Assertions.checkStateNotNull((Object)muxerInputBuffer.data), muxerInputBuffer.isKeyFrame(), muxerInputBuffer.timeUs)) {
                return false;
            }
        }
        catch (Muxer.MuxerException e) {
            throw ExportException.createForMuxer(e, 7001);
        }
        this.releaseMuxerInputBuffer();
        return true;
    }

    protected static String findSupportedMimeTypeForEncoderAndMuxer(Format requestedFormat, List<String> muxerSupportedMimeTypes) throws ExportException {
        boolean isVideo = MimeTypes.isVideo((String)((String)Assertions.checkNotNull((Object)requestedFormat.sampleMimeType)));
        ImmutableSet.Builder mimeTypesToCheckSetBuilder = new ImmutableSet.Builder().add((Object)requestedFormat.sampleMimeType);
        if (isVideo) {
            mimeTypesToCheckSetBuilder.add((Object)"video/hevc").add((Object)"video/avc");
        }
        mimeTypesToCheckSetBuilder.addAll(muxerSupportedMimeTypes);
        ImmutableList mimeTypesToCheck = mimeTypesToCheckSetBuilder.build().asList();
        for (int i = 0; i < mimeTypesToCheck.size(); ++i) {
            String mimeType = (String)mimeTypesToCheck.get(i);
            if (!muxerSupportedMimeTypes.contains(mimeType) || !(isVideo && ColorInfo.isTransferHdr((ColorInfo)requestedFormat.colorInfo) ? !EncoderUtil.getSupportedEncodersForHdrEditing(mimeType, requestedFormat.colorInfo).isEmpty() : !EncoderUtil.getSupportedEncoders(mimeType).isEmpty())) continue;
            return mimeType;
        }
        throw SamplePipeline.createNoSupportedMimeTypeException(requestedFormat);
    }

    private static ExportException createNoSupportedMimeTypeException(Format format) {
        String errorMessage = "No MIME type is supported by both encoder and muxer.";
        int errorCode = 4003;
        boolean isVideo = MimeTypes.isVideo((String)format.sampleMimeType);
        if (isVideo && ColorInfo.isTransferHdr((ColorInfo)format.colorInfo)) {
            errorMessage = errorMessage + " Requested HDR colorInfo: " + format.colorInfo;
        }
        return ExportException.createForCodec((Throwable)new IllegalArgumentException(errorMessage), errorCode, isVideo, false, format);
    }
}

