/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

@Deprecated
public final class MssimCalculator {
    private static final int PIXEL_MAX_VALUE = 255;
    private static final double K1 = 0.01;
    private static final double K2 = 0.03;
    private static final double C1 = Math.pow(2.5500000000000003, 2.0);
    private static final double C2 = Math.pow(7.6499999999999995, 2.0);
    private static final int WINDOW_SIZE = 8;

    private MssimCalculator() {
    }

    public static double calculate(byte[] referenceBuffer, byte[] distortedBuffer, int width, int height) {
        return MssimCalculator.calculate(referenceBuffer, distortedBuffer, width, height, true);
    }

    public static double calculate(byte[] referenceBuffer, byte[] distortedBuffer, int width, int height, boolean enableWindowSkipping) {
        double totalSsim = 0.0;
        int windowsCount = 0;
        int dimensionIncrement = 8 * (enableWindowSkipping ? 2 : 1);
        for (int currentWindowY = 0; currentWindowY < height; currentWindowY += dimensionIncrement) {
            int windowHeight = MssimCalculator.computeWindowSize(currentWindowY, height);
            for (int currentWindowX = 0; currentWindowX < width; currentWindowX += dimensionIncrement) {
                ++windowsCount;
                int windowWidth = MssimCalculator.computeWindowSize(currentWindowX, width);
                int bufferIndexOffset = MssimCalculator.get1dIndex(currentWindowX, currentWindowY, width, 0);
                double referenceMean = MssimCalculator.getMean(referenceBuffer, bufferIndexOffset, width, windowWidth, windowHeight);
                double distortedMean = MssimCalculator.getMean(distortedBuffer, bufferIndexOffset, width, windowWidth, windowHeight);
                double[] variances = MssimCalculator.getVariancesAndCovariance(referenceBuffer, distortedBuffer, referenceMean, distortedMean, bufferIndexOffset, width, windowWidth, windowHeight);
                double referenceVariance = variances[0];
                double distortedVariance = variances[1];
                double referenceDistortedCovariance = variances[2];
                totalSsim += MssimCalculator.getWindowSsim(referenceMean, distortedMean, referenceVariance, distortedVariance, referenceDistortedCovariance);
            }
        }
        if (windowsCount == 0) {
            return 1.0;
        }
        return totalSsim / (double)windowsCount;
    }

    private static int computeWindowSize(int start, int dimension) {
        if (start + 8 <= dimension) {
            return 8;
        }
        return dimension - start;
    }

    private static double getWindowSsim(double referenceMean, double distortedMean, double referenceVariance, double distortedVariance, double referenceDistortedCovariance) {
        double numerator = (2.0 * referenceMean * distortedMean + C1) * (2.0 * referenceDistortedCovariance + C2);
        double denominator = (referenceMean * referenceMean + distortedMean * distortedMean + C1) * (referenceVariance + distortedVariance + C2);
        return numerator / denominator;
    }

    private static double getMean(byte[] pixelBuffer, int bufferIndexOffset, int stride, int windowWidth, int windowHeight) {
        double total = 0.0;
        for (int y = 0; y < windowHeight; ++y) {
            for (int x = 0; x < windowWidth; ++x) {
                total += (double)(pixelBuffer[MssimCalculator.get1dIndex(x, y, stride, bufferIndexOffset)] & 0xFF);
            }
        }
        return total / (double)(windowWidth * windowHeight);
    }

    private static double[] getVariancesAndCovariance(byte[] referenceBuffer, byte[] distortedBuffer, double referenceMean, double distortedMean, int bufferIndexOffset, int stride, int windowWidth, int windowHeight) {
        double referenceVariance = 0.0;
        double distortedVariance = 0.0;
        double referenceDistortedCovariance = 0.0;
        for (int y = 0; y < windowHeight; ++y) {
            for (int x = 0; x < windowWidth; ++x) {
                int index = MssimCalculator.get1dIndex(x, y, stride, bufferIndexOffset);
                double referencePixelDeviation = (double)(referenceBuffer[index] & 0xFF) - referenceMean;
                double distortedPixelDeviation = (double)(distortedBuffer[index] & 0xFF) - distortedMean;
                referenceVariance += referencePixelDeviation * referencePixelDeviation;
                distortedVariance += distortedPixelDeviation * distortedPixelDeviation;
                referenceDistortedCovariance += referencePixelDeviation * distortedPixelDeviation;
            }
        }
        int normalizationFactor = windowWidth * windowHeight - 1;
        return new double[]{referenceVariance / (double)normalizationFactor, distortedVariance / (double)normalizationFactor, referenceDistortedCovariance / (double)normalizationFactor};
    }

    private static int get1dIndex(int x, int y, int stride, int offset) {
        return x + y * stride + offset;
    }
}

