/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.annotation.SuppressLint;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.util.SparseLongArray;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.container.Mp4LocationData;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.transformer.Muxer;
import com.google.android.exoplayer2.transformer.TransformerUtil;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MediaFormatUtil;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.ColorInfo;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.List;

@Deprecated
final class FrameworkMuxer
implements Muxer {
    private static final ImmutableList<String> SUPPORTED_VIDEO_SAMPLE_MIME_TYPES = Util.SDK_INT >= 24 ? ImmutableList.of((Object)"video/3gpp", (Object)"video/avc", (Object)"video/mp4v-es", (Object)"video/hevc") : ImmutableList.of((Object)"video/3gpp", (Object)"video/avc", (Object)"video/mp4v-es");
    private static final ImmutableList<String> SUPPORTED_AUDIO_SAMPLE_MIME_TYPES = ImmutableList.of((Object)"audio/mp4a-latm", (Object)"audio/3gpp", (Object)"audio/amr-wb");
    private final MediaMuxer mediaMuxer;
    private final long maxDelayBetweenSamplesMs;
    private final long videoDurationUs;
    private final MediaCodec.BufferInfo bufferInfo;
    private final SparseLongArray trackIndexToLastPresentationTimeUs;
    private int videoTrackIndex;
    private boolean isStarted;

    private FrameworkMuxer(MediaMuxer mediaMuxer, long maxDelayBetweenSamplesMs, long videoDurationMs) {
        this.mediaMuxer = mediaMuxer;
        this.maxDelayBetweenSamplesMs = maxDelayBetweenSamplesMs;
        this.videoDurationUs = Util.msToUs((long)videoDurationMs);
        this.bufferInfo = new MediaCodec.BufferInfo();
        this.trackIndexToLastPresentationTimeUs = new SparseLongArray();
        this.videoTrackIndex = -1;
    }

    @Override
    public int addTrack(Format format) throws Muxer.MuxerException {
        int trackIndex;
        MediaFormat mediaFormat;
        String sampleMimeType = (String)Assertions.checkNotNull((Object)format.sampleMimeType);
        boolean isVideo = MimeTypes.isVideo((String)sampleMimeType);
        if (isVideo) {
            mediaFormat = MediaFormat.createVideoFormat((String)sampleMimeType, (int)format.width, (int)format.height);
            MediaFormatUtil.maybeSetColorInfo((MediaFormat)mediaFormat, (ColorInfo)format.colorInfo);
            try {
                this.mediaMuxer.setOrientationHint(format.rotationDegrees);
            }
            catch (RuntimeException e) {
                throw new Muxer.MuxerException("Failed to set orientation hint with rotationDegrees=" + format.rotationDegrees, e);
            }
        } else {
            mediaFormat = MediaFormat.createAudioFormat((String)sampleMimeType, (int)format.sampleRate, (int)format.channelCount);
        }
        MediaFormatUtil.setCsdBuffers((MediaFormat)mediaFormat, (List)format.initializationData);
        try {
            trackIndex = this.mediaMuxer.addTrack(mediaFormat);
        }
        catch (RuntimeException e) {
            throw new Muxer.MuxerException("Failed to add track with format=" + format, e);
        }
        if (isVideo) {
            this.videoTrackIndex = trackIndex;
        }
        return trackIndex;
    }

    @Override
    public void writeSampleData(int trackIndex, ByteBuffer data, long presentationTimeUs, int flags) throws Muxer.MuxerException {
        if (this.videoDurationUs != -9223372036854775807L && trackIndex == this.videoTrackIndex && presentationTimeUs > this.videoDurationUs) {
            return;
        }
        if (!this.isStarted) {
            this.isStarted = true;
            try {
                this.mediaMuxer.start();
            }
            catch (RuntimeException e) {
                throw new Muxer.MuxerException("Failed to start the muxer", e);
            }
        }
        int offset = data.position();
        int size = data.limit() - offset;
        this.bufferInfo.set(offset, size, presentationTimeUs, TransformerUtil.getMediaCodecFlags(flags));
        long lastSamplePresentationTimeUs = this.trackIndexToLastPresentationTimeUs.get(trackIndex);
        Assertions.checkState((Util.SDK_INT > 24 || presentationTimeUs >= lastSamplePresentationTimeUs ? 1 : 0) != 0, (Object)("Samples not in presentation order (" + presentationTimeUs + " < " + lastSamplePresentationTimeUs + ") unsupported on this API version"));
        this.trackIndexToLastPresentationTimeUs.put(trackIndex, presentationTimeUs);
        try {
            this.mediaMuxer.writeSampleData(trackIndex, data, this.bufferInfo);
        }
        catch (RuntimeException e) {
            throw new Muxer.MuxerException("Failed to write sample for trackIndex=" + trackIndex + ", presentationTimeUs=" + presentationTimeUs + ", size=" + size, e);
        }
    }

    @Override
    public void addMetadata(Metadata metadata) {
        for (int i = 0; i < metadata.length(); ++i) {
            Metadata.Entry entry = metadata.get(i);
            if (!(entry instanceof Mp4LocationData)) continue;
            this.mediaMuxer.setLocation(((Mp4LocationData)entry).latitude, ((Mp4LocationData)entry).longitude);
        }
    }

    @Override
    public void release(boolean forCancellation) throws Muxer.MuxerException {
        if (!this.isStarted) {
            this.mediaMuxer.release();
            return;
        }
        if (this.videoDurationUs != -9223372036854775807L && this.videoTrackIndex != -1) {
            this.writeSampleData(this.videoTrackIndex, ByteBuffer.allocateDirect(0), this.videoDurationUs, 4);
        }
        this.isStarted = false;
        try {
            FrameworkMuxer.stopMuxer(this.mediaMuxer);
        }
        catch (RuntimeException e) {
            if (!forCancellation) {
                throw new Muxer.MuxerException("Failed to stop the muxer", e);
            }
        }
        finally {
            this.mediaMuxer.release();
        }
    }

    @Override
    public long getMaxDelayBetweenSamplesMs() {
        return this.maxDelayBetweenSamplesMs;
    }

    @SuppressLint(value={"PrivateApi"})
    private static void stopMuxer(MediaMuxer mediaMuxer) {
        try {
            mediaMuxer.stop();
        }
        catch (RuntimeException e) {
            if (Util.SDK_INT < 30) {
                try {
                    Field muxerStoppedStateField = MediaMuxer.class.getDeclaredField("MUXER_STATE_STOPPED");
                    muxerStoppedStateField.setAccessible(true);
                    int muxerStoppedState = (Integer)Util.castNonNull((Object)((Integer)muxerStoppedStateField.get(mediaMuxer)));
                    Field muxerStateField = MediaMuxer.class.getDeclaredField("mState");
                    muxerStateField.setAccessible(true);
                    muxerStateField.set(mediaMuxer, muxerStoppedState);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    public static final class Factory
    implements Muxer.Factory {
        private final long maxDelayBetweenSamplesMs;
        private final long videoDurationMs;

        public Factory(long maxDelayBetweenSamplesMs, long videoDurationMs) {
            this.maxDelayBetweenSamplesMs = maxDelayBetweenSamplesMs;
            this.videoDurationMs = videoDurationMs;
        }

        @Override
        public FrameworkMuxer create(String path) throws Muxer.MuxerException {
            MediaMuxer mediaMuxer;
            try {
                mediaMuxer = new MediaMuxer(path, 0);
            }
            catch (IOException e) {
                throw new Muxer.MuxerException("Error creating muxer", e);
            }
            return new FrameworkMuxer(mediaMuxer, this.maxDelayBetweenSamplesMs, this.videoDurationMs);
        }

        @Override
        public ImmutableList<String> getSupportedSampleMimeTypes(int trackType) {
            if (trackType == 2) {
                return SUPPORTED_VIDEO_SAMPLE_MIME_TYPES;
            }
            if (trackType == 1) {
                return SUPPORTED_AUDIO_SAMPLE_MIME_TYPES;
            }
            return ImmutableList.of();
        }
    }
}

