/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.annotation.SuppressLint;
import com.google.android.exoplayer2.audio.AudioProcessor;
import com.google.android.exoplayer2.audio.ChannelMixingMatrix;
import com.google.android.exoplayer2.transformer.AudioMixingAlgorithm;
import com.google.android.exoplayer2.util.Assertions;
import java.nio.ByteBuffer;

@Deprecated
class FloatAudioMixingAlgorithm
implements AudioMixingAlgorithm {
    private static final float SCALE_S16_FOR_NEGATIVE_INPUT = 3.0517578E-5f;
    private static final float SCALE_S16_FOR_POSITIVE_INPUT = 3.051851E-5f;
    private final AudioProcessor.AudioFormat mixingAudioFormat;

    public FloatAudioMixingAlgorithm(AudioProcessor.AudioFormat mixingAudioFormat) {
        Assertions.checkArgument((mixingAudioFormat.encoding == 4 ? 1 : 0) != 0);
        Assertions.checkArgument((mixingAudioFormat.channelCount != -1 ? 1 : 0) != 0);
        this.mixingAudioFormat = mixingAudioFormat;
    }

    @Override
    @SuppressLint(value={"SwitchIntDef"})
    public boolean supportsSourceAudioFormat(AudioProcessor.AudioFormat sourceAudioFormat) {
        if (sourceAudioFormat.sampleRate != this.mixingAudioFormat.sampleRate) {
            return false;
        }
        switch (sourceAudioFormat.encoding) {
            case 2: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    @Override
    @SuppressLint(value={"SwitchIntDef"})
    public ByteBuffer mix(ByteBuffer sourceBuffer, AudioProcessor.AudioFormat sourceAudioFormat, ChannelMixingMatrix channelMixingMatrix, int frameCount, ByteBuffer mixingBuffer) {
        Assertions.checkArgument((boolean)this.supportsSourceAudioFormat(sourceAudioFormat), (Object)"Source audio format is not supported.");
        Assertions.checkArgument((channelMixingMatrix.getInputChannelCount() == sourceAudioFormat.channelCount ? 1 : 0) != 0, (Object)"Input channel count does not match source format.");
        Assertions.checkArgument((channelMixingMatrix.getOutputChannelCount() == this.mixingAudioFormat.channelCount ? 1 : 0) != 0, (Object)"Output channel count does not match mixing format.");
        Assertions.checkArgument((sourceBuffer.remaining() >= frameCount * sourceAudioFormat.bytesPerFrame ? 1 : 0) != 0, (Object)"Source buffer is too small.");
        Assertions.checkArgument((mixingBuffer.remaining() >= frameCount * this.mixingAudioFormat.bytesPerFrame ? 1 : 0) != 0, (Object)"Mixing buffer is too small.");
        switch (sourceAudioFormat.encoding) {
            case 4: {
                return FloatAudioMixingAlgorithm.mixFloatIntoFloat(sourceBuffer, channelMixingMatrix, frameCount, mixingBuffer);
            }
            case 2: {
                return FloatAudioMixingAlgorithm.mixS16IntoFloat(sourceBuffer, channelMixingMatrix, frameCount, mixingBuffer);
            }
        }
        throw new IllegalArgumentException("Source encoding is not supported.");
    }

    private static ByteBuffer mixFloatIntoFloat(ByteBuffer sourceBuffer, ChannelMixingMatrix channelMixingMatrix, int frameCount, ByteBuffer mixingBuffer) {
        if (channelMixingMatrix.isDiagonal()) {
            return FloatAudioMixingAlgorithm.mixFloatIntoFloatDiagonal(sourceBuffer, channelMixingMatrix, frameCount, mixingBuffer);
        }
        int sourceChannelCount = channelMixingMatrix.getInputChannelCount();
        float[] sourceFrame = new float[sourceChannelCount];
        for (int i = 0; i < frameCount; ++i) {
            for (int sourceChannel = 0; sourceChannel < sourceChannelCount; ++sourceChannel) {
                sourceFrame[sourceChannel] = sourceBuffer.getFloat();
            }
            FloatAudioMixingAlgorithm.mixFloatFrameIntoFloat(sourceFrame, channelMixingMatrix, mixingBuffer);
        }
        return mixingBuffer;
    }

    private static void mixFloatFrameIntoFloat(float[] sourceFrame, ChannelMixingMatrix channelMixingMatrix, ByteBuffer mixingBuffer) {
        int mixingChannelCount = channelMixingMatrix.getOutputChannelCount();
        for (int mixingChannel = 0; mixingChannel < mixingChannelCount; ++mixingChannel) {
            float mixedSample = mixingBuffer.getFloat(mixingBuffer.position());
            for (int sourceChannel = 0; sourceChannel < sourceFrame.length; ++sourceChannel) {
                mixedSample += channelMixingMatrix.getMixingCoefficient(sourceChannel, mixingChannel) * sourceFrame[sourceChannel];
            }
            mixingBuffer.putFloat(mixedSample);
        }
    }

    private static ByteBuffer mixFloatIntoFloatDiagonal(ByteBuffer sourceBuffer, ChannelMixingMatrix channelMixingMatrix, int frameCount, ByteBuffer mixingBuffer) {
        int channelCount = channelMixingMatrix.getInputChannelCount();
        for (int i = 0; i < frameCount; ++i) {
            for (int c = 0; c < channelCount; ++c) {
                float sourceSample = sourceBuffer.getFloat();
                float mixedSample = mixingBuffer.getFloat(mixingBuffer.position()) + channelMixingMatrix.getMixingCoefficient(c, c) * sourceSample;
                mixingBuffer.putFloat(mixedSample);
            }
        }
        return mixingBuffer;
    }

    private static ByteBuffer mixS16IntoFloat(ByteBuffer sourceBuffer, ChannelMixingMatrix channelMixingMatrix, int frameCount, ByteBuffer mixingBuffer) {
        if (channelMixingMatrix.isDiagonal()) {
            return FloatAudioMixingAlgorithm.mixS16IntoFloatDiagonal(sourceBuffer, channelMixingMatrix, frameCount, mixingBuffer);
        }
        int sourceChannelCount = channelMixingMatrix.getInputChannelCount();
        float[] sourceFrame = new float[sourceChannelCount];
        for (int i = 0; i < frameCount; ++i) {
            for (int sourceChannel = 0; sourceChannel < sourceChannelCount; ++sourceChannel) {
                sourceFrame[sourceChannel] = FloatAudioMixingAlgorithm.s16ToFloat(sourceBuffer.getShort());
            }
            FloatAudioMixingAlgorithm.mixFloatFrameIntoFloat(sourceFrame, channelMixingMatrix, mixingBuffer);
        }
        return mixingBuffer;
    }

    private static ByteBuffer mixS16IntoFloatDiagonal(ByteBuffer sourceBuffer, ChannelMixingMatrix channelMixingMatrix, int frameCount, ByteBuffer mixingBuffer) {
        int channelCount = channelMixingMatrix.getInputChannelCount();
        for (int i = 0; i < frameCount; ++i) {
            for (int c = 0; c < channelCount; ++c) {
                float sourceSample = FloatAudioMixingAlgorithm.s16ToFloat(sourceBuffer.getShort());
                float mixedSample = mixingBuffer.getFloat(mixingBuffer.position()) + channelMixingMatrix.getMixingCoefficient(c, c) * sourceSample;
                mixingBuffer.putFloat(mixedSample);
            }
        }
        return mixingBuffer;
    }

    private static float s16ToFloat(short shortValue) {
        return (float)shortValue * (shortValue < 0 ? 3.0517578E-5f : 3.051851E-5f);
    }
}

