/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.transformer.ExportException;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.video.ColorInfo;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@Deprecated
public final class ExportResult {
    public final ImmutableList<ProcessedInput> processedInputs;
    public final long durationMs;
    public final long fileSizeBytes;
    public final int averageAudioBitrate;
    public final int channelCount;
    public final int sampleRate;
    @Nullable
    public final String audioEncoderName;
    public final int averageVideoBitrate;
    @Nullable
    public final ColorInfo colorInfo;
    public final int height;
    public final int width;
    public final int videoFrameCount;
    @Nullable
    public final String videoEncoderName;
    @Nullable
    public final ExportException exportException;

    private ExportResult(ImmutableList<ProcessedInput> processedInputs, long durationMs, long fileSizeBytes, int averageAudioBitrate, int channelCount, int sampleRate, @Nullable String audioEncoderName, int averageVideoBitrate, @Nullable ColorInfo colorInfo, int height, int width, int videoFrameCount, @Nullable String videoEncoderName, @Nullable ExportException exportException) {
        this.processedInputs = processedInputs;
        this.durationMs = durationMs;
        this.fileSizeBytes = fileSizeBytes;
        this.averageAudioBitrate = averageAudioBitrate;
        this.channelCount = channelCount;
        this.sampleRate = sampleRate;
        this.audioEncoderName = audioEncoderName;
        this.averageVideoBitrate = averageVideoBitrate;
        this.colorInfo = colorInfo;
        this.height = height;
        this.width = width;
        this.videoFrameCount = videoFrameCount;
        this.videoEncoderName = videoEncoderName;
        this.exportException = exportException;
    }

    public Builder buildUpon() {
        return new Builder().setProcessedInputs(this.processedInputs).setDurationMs(this.durationMs).setFileSizeBytes(this.fileSizeBytes).setAverageAudioBitrate(this.averageAudioBitrate).setChannelCount(this.channelCount).setSampleRate(this.sampleRate).setAudioEncoderName(this.audioEncoderName).setAverageVideoBitrate(this.averageVideoBitrate).setColorInfo(this.colorInfo).setHeight(this.height).setWidth(this.width).setVideoFrameCount(this.videoFrameCount).setVideoEncoderName(this.videoEncoderName).setExportException(this.exportException);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExportResult)) {
            return false;
        }
        ExportResult result = (ExportResult)o;
        return Objects.equals(this.processedInputs, result.processedInputs) && this.durationMs == result.durationMs && this.fileSizeBytes == result.fileSizeBytes && this.averageAudioBitrate == result.averageAudioBitrate && this.channelCount == result.channelCount && this.sampleRate == result.sampleRate && Objects.equals(this.audioEncoderName, result.audioEncoderName) && this.averageVideoBitrate == result.averageVideoBitrate && Objects.equals(this.colorInfo, result.colorInfo) && this.height == result.height && this.width == result.width && this.videoFrameCount == result.videoFrameCount && Objects.equals(this.videoEncoderName, result.videoEncoderName) && Objects.equals(this.exportException, result.exportException);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.processedInputs);
        result = 31 * result + (int)this.durationMs;
        result = 31 * result + (int)this.fileSizeBytes;
        result = 31 * result + this.averageAudioBitrate;
        result = 31 * result + this.channelCount;
        result = 31 * result + this.sampleRate;
        result = 31 * result + Objects.hashCode(this.audioEncoderName);
        result = 31 * result + this.averageVideoBitrate;
        result = 31 * result + Objects.hashCode(this.colorInfo);
        result = 31 * result + this.height;
        result = 31 * result + this.width;
        result = 31 * result + this.videoFrameCount;
        result = 31 * result + Objects.hashCode(this.videoEncoderName);
        result = 31 * result + Objects.hashCode(this.exportException);
        return result;
    }

    public static final class ProcessedInput {
        public final MediaItem mediaItem;
        public final @MonotonicNonNull String audioDecoderName;
        public final @MonotonicNonNull String videoDecoderName;

        public ProcessedInput(MediaItem mediaItem, @Nullable String audioDecoderName, @Nullable String videoDecoderName) {
            this.mediaItem = mediaItem;
            this.audioDecoderName = audioDecoderName;
            this.videoDecoderName = videoDecoderName;
        }
    }

    public static final class Builder {
        private ImmutableList<ProcessedInput> processedInputs = ImmutableList.of();
        private long durationMs = -9223372036854775807L;
        private long fileSizeBytes = -1L;
        private int averageAudioBitrate = -2147483647;
        private int channelCount = -1;
        private int sampleRate = -2147483647;
        @Nullable
        private String audioEncoderName;
        private int averageVideoBitrate = -2147483647;
        @Nullable
        ColorInfo colorInfo;
        private int height = -1;
        private int width = -1;
        private int videoFrameCount;
        @Nullable
        private String videoEncoderName;
        @Nullable
        private ExportException exportException;

        @CanIgnoreReturnValue
        public Builder setProcessedInputs(ImmutableList<ProcessedInput> processedInputs) {
            this.processedInputs = processedInputs;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setDurationMs(long durationMs) {
            Assertions.checkArgument((durationMs >= 0L || durationMs == -9223372036854775807L ? 1 : 0) != 0);
            this.durationMs = durationMs;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setFileSizeBytes(long fileSizeBytes) {
            Assertions.checkArgument((fileSizeBytes > 0L || fileSizeBytes == -1L ? 1 : 0) != 0);
            this.fileSizeBytes = fileSizeBytes;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setAverageAudioBitrate(int averageAudioBitrate) {
            Assertions.checkArgument((averageAudioBitrate > 0 || averageAudioBitrate == -2147483647 ? 1 : 0) != 0);
            this.averageAudioBitrate = averageAudioBitrate;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setChannelCount(int channelCount) {
            Assertions.checkArgument((channelCount > 0 || channelCount == -1 ? 1 : 0) != 0);
            this.channelCount = channelCount;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setSampleRate(int sampleRate) {
            Assertions.checkArgument((sampleRate > 0 || sampleRate == -2147483647 ? 1 : 0) != 0);
            this.sampleRate = sampleRate;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setAudioEncoderName(@Nullable String audioEncoderName) {
            this.audioEncoderName = audioEncoderName;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setAverageVideoBitrate(int averageVideoBitrate) {
            Assertions.checkArgument((averageVideoBitrate > 0 || averageVideoBitrate == -2147483647 ? 1 : 0) != 0);
            this.averageVideoBitrate = averageVideoBitrate;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setColorInfo(@Nullable ColorInfo colorInfo) {
            this.colorInfo = colorInfo;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setHeight(int height) {
            Assertions.checkArgument((height > 0 || height == -1 ? 1 : 0) != 0);
            this.height = height;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setWidth(int width) {
            Assertions.checkArgument((width > 0 || width == -1 ? 1 : 0) != 0);
            this.width = width;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setVideoFrameCount(int videoFrameCount) {
            Assertions.checkArgument((videoFrameCount >= 0 ? 1 : 0) != 0);
            this.videoFrameCount = videoFrameCount;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setVideoEncoderName(@Nullable String videoEncoderName) {
            this.videoEncoderName = videoEncoderName;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setExportException(@Nullable ExportException exportException) {
            this.exportException = exportException;
            return this;
        }

        public ExportResult build() {
            return new ExportResult(this.processedInputs, this.durationMs, this.fileSizeBytes, this.averageAudioBitrate, this.channelCount, this.sampleRate, this.audioEncoderName, this.averageVideoBitrate, this.colorInfo, this.height, this.width, this.videoFrameCount, this.videoEncoderName, this.exportException);
        }
    }
}

