/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.DefaultLoadControl;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.PlaybackException;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Renderer;
import com.google.android.exoplayer2.RenderersFactory;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.Tracks;
import com.google.android.exoplayer2.audio.AudioRendererEventListener;
import com.google.android.exoplayer2.extractor.DefaultExtractorsFactory;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.metadata.MetadataOutput;
import com.google.android.exoplayer2.source.DefaultMediaSourceFactory;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.text.TextOutput;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelectionParameters;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.transformer.AssetLoader;
import com.google.android.exoplayer2.transformer.CapturingDecoderFactory;
import com.google.android.exoplayer2.transformer.Codec;
import com.google.android.exoplayer2.transformer.EditedMediaItem;
import com.google.android.exoplayer2.transformer.ExoAssetLoaderAudioRenderer;
import com.google.android.exoplayer2.transformer.ExoAssetLoaderVideoRenderer;
import com.google.android.exoplayer2.transformer.ExportException;
import com.google.android.exoplayer2.transformer.ProgressHolder;
import com.google.android.exoplayer2.transformer.TransformerMediaClock;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.video.VideoRendererEventListener;
import com.google.common.collect.ImmutableMap;

@Deprecated
public final class ExoPlayerAssetLoader
implements AssetLoader {
    private final EditedMediaItem editedMediaItem;
    private final CapturingDecoderFactory decoderFactory;
    private final ExoPlayer player;
    private int progressState;

    private ExoPlayerAssetLoader(Context context, EditedMediaItem editedMediaItem, MediaSource.Factory mediaSourceFactory, Codec.DecoderFactory decoderFactory, boolean forceInterpretHdrAsSdr, Looper looper, AssetLoader.Listener listener, Clock clock) {
        this.editedMediaItem = editedMediaItem;
        this.decoderFactory = new CapturingDecoderFactory(decoderFactory);
        DefaultTrackSelector trackSelector = new DefaultTrackSelector(context);
        trackSelector.setParameters((TrackSelectionParameters)new DefaultTrackSelector.Parameters.Builder(context).setForceHighestSupportedBitrate(true).build());
        DefaultLoadControl loadControl = new DefaultLoadControl.Builder().setBufferDurationsMs(50000, 50000, 250, 500).build();
        ExoPlayer.Builder playerBuilder = new ExoPlayer.Builder(context, (RenderersFactory)new RenderersFactoryImpl(editedMediaItem.removeAudio, editedMediaItem.removeVideo, editedMediaItem.flattenForSlowMotion, this.decoderFactory, forceInterpretHdrAsSdr, listener)).setMediaSourceFactory(mediaSourceFactory).setTrackSelector((TrackSelector)trackSelector).setLoadControl((LoadControl)loadControl).setLooper(looper).setUsePlatformDiagnostics(false);
        if (clock != Clock.DEFAULT) {
            ExoPlayer.Builder builder = playerBuilder.setClock(clock);
        }
        this.player = playerBuilder.build();
        this.player.addListener((Player.Listener)new PlayerListener(listener));
        this.progressState = 0;
    }

    @Override
    public void start() {
        this.player.setMediaItem(this.editedMediaItem.mediaItem);
        this.player.prepare();
        this.progressState = 1;
    }

    @Override
    public int getProgress(ProgressHolder progressHolder) {
        if (this.progressState == 2) {
            long durationMs = this.player.getDuration();
            long positionMs = this.player.getCurrentPosition();
            progressHolder.progress = Math.min((int)(positionMs * 100L / durationMs), 99);
        }
        return this.progressState;
    }

    @Override
    public ImmutableMap<Integer, String> getDecoderNames() {
        String videoDecoderName;
        ImmutableMap.Builder decoderNamesByTrackType = new ImmutableMap.Builder();
        String audioDecoderName = this.decoderFactory.getAudioDecoderName();
        if (audioDecoderName != null) {
            decoderNamesByTrackType.put((Object)1, (Object)audioDecoderName);
        }
        if ((videoDecoderName = this.decoderFactory.getVideoDecoderName()) != null) {
            decoderNamesByTrackType.put((Object)2, (Object)videoDecoderName);
        }
        return decoderNamesByTrackType.buildOrThrow();
    }

    @Override
    public void release() {
        this.player.release();
        this.progressState = 0;
    }

    private final class PlayerListener
    implements Player.Listener {
        private final AssetLoader.Listener assetLoaderListener;

        public PlayerListener(AssetLoader.Listener assetLoaderListener) {
            this.assetLoaderListener = assetLoaderListener;
        }

        public void onTimelineChanged(Timeline timeline, int reason) {
            try {
                if (ExoPlayerAssetLoader.this.progressState != 1) {
                    return;
                }
                Timeline.Window window = new Timeline.Window();
                timeline.getWindow(0, window);
                if (!window.isPlaceholder) {
                    long durationUs = window.durationUs;
                    ExoPlayerAssetLoader.this.progressState = durationUs <= 0L || durationUs == -9223372036854775807L ? 3 : 2;
                    this.assetLoaderListener.onDurationUs(window.durationUs);
                }
            }
            catch (RuntimeException e) {
                this.assetLoaderListener.onError(ExportException.createForAssetLoader(e, 1000));
            }
        }

        public void onTracksChanged(Tracks tracks) {
            try {
                int trackCount = 0;
                if (tracks.isTypeSelected(1)) {
                    ++trackCount;
                }
                if (tracks.isTypeSelected(2)) {
                    ++trackCount;
                }
                if (trackCount > 0) {
                    this.assetLoaderListener.onTrackCount(trackCount);
                    ExoPlayerAssetLoader.this.player.play();
                } else {
                    this.assetLoaderListener.onError(ExportException.createForAssetLoader(new IllegalStateException("The asset loader has no track to output."), 1001));
                }
            }
            catch (RuntimeException e) {
                this.assetLoaderListener.onError(ExportException.createForAssetLoader(e, 1000));
            }
        }

        public void onPlayerError(PlaybackException error) {
            int errorCode = (Integer)Assertions.checkNotNull((Object)((Integer)ExportException.NAME_TO_ERROR_CODE.getOrDefault((Object)error.getErrorCodeName(), (Object)1000)));
            this.assetLoaderListener.onError(ExportException.createForAssetLoader((Throwable)error, errorCode));
        }
    }

    private static final class RenderersFactoryImpl
    implements RenderersFactory {
        private final TransformerMediaClock mediaClock;
        private final boolean removeAudio;
        private final boolean removeVideo;
        private final boolean flattenForSlowMotion;
        private final Codec.DecoderFactory decoderFactory;
        private final boolean forceInterpretHdrAsSdr;
        private final AssetLoader.Listener assetLoaderListener;

        public RenderersFactoryImpl(boolean removeAudio, boolean removeVideo, boolean flattenForSlowMotion, Codec.DecoderFactory decoderFactory, boolean forceInterpretHdrAsSdr, AssetLoader.Listener assetLoaderListener) {
            this.removeAudio = removeAudio;
            this.removeVideo = removeVideo;
            this.flattenForSlowMotion = flattenForSlowMotion;
            this.decoderFactory = decoderFactory;
            this.forceInterpretHdrAsSdr = forceInterpretHdrAsSdr;
            this.assetLoaderListener = assetLoaderListener;
            this.mediaClock = new TransformerMediaClock();
        }

        public Renderer[] createRenderers(Handler eventHandler, VideoRendererEventListener videoRendererEventListener, AudioRendererEventListener audioRendererEventListener, TextOutput textRendererOutput, MetadataOutput metadataRendererOutput) {
            int rendererCount = this.removeAudio || this.removeVideo ? 1 : 2;
            Renderer[] renderers = new Renderer[rendererCount];
            int index = 0;
            if (!this.removeAudio) {
                renderers[index] = new ExoAssetLoaderAudioRenderer(this.decoderFactory, this.mediaClock, this.assetLoaderListener);
                ++index;
            }
            if (!this.removeVideo) {
                renderers[index] = new ExoAssetLoaderVideoRenderer(this.flattenForSlowMotion, this.decoderFactory, this.forceInterpretHdrAsSdr, this.mediaClock, this.assetLoaderListener);
                ++index;
            }
            return renderers;
        }
    }

    public static final class Factory
    implements AssetLoader.Factory {
        private final Context context;
        private final Codec.DecoderFactory decoderFactory;
        private final boolean forceInterpretHdrAsSdr;
        private final Clock clock;
        @Nullable
        private final MediaSource.Factory mediaSourceFactory;

        public Factory(Context context, Codec.DecoderFactory decoderFactory, boolean forceInterpretHdrAsSdr, Clock clock) {
            this.context = context;
            this.decoderFactory = decoderFactory;
            this.forceInterpretHdrAsSdr = forceInterpretHdrAsSdr;
            this.clock = clock;
            this.mediaSourceFactory = null;
        }

        public Factory(Context context, Codec.DecoderFactory decoderFactory, boolean forceInterpretHdrAsSdr, Clock clock, MediaSource.Factory mediaSourceFactory) {
            this.context = context;
            this.decoderFactory = decoderFactory;
            this.forceInterpretHdrAsSdr = forceInterpretHdrAsSdr;
            this.clock = clock;
            this.mediaSourceFactory = mediaSourceFactory;
        }

        @Override
        public AssetLoader createAssetLoader(EditedMediaItem editedMediaItem, Looper looper, AssetLoader.Listener listener) {
            MediaSource.Factory mediaSourceFactory = this.mediaSourceFactory;
            if (mediaSourceFactory == null) {
                DefaultExtractorsFactory defaultExtractorsFactory = new DefaultExtractorsFactory();
                if (editedMediaItem.flattenForSlowMotion) {
                    defaultExtractorsFactory.setMp4ExtractorFlags(4);
                }
                mediaSourceFactory = new DefaultMediaSourceFactory(this.context, (ExtractorsFactory)defaultExtractorsFactory);
            }
            return new ExoPlayerAssetLoader(this.context, editedMediaItem, mediaSourceFactory, this.decoderFactory, this.forceInterpretHdrAsSdr, looper, listener, this.clock);
        }
    }
}

