/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import com.google.android.exoplayer2.BaseRenderer;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.RendererCapabilities;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.transformer.AssetLoader;
import com.google.android.exoplayer2.transformer.Codec;
import com.google.android.exoplayer2.transformer.ExportException;
import com.google.android.exoplayer2.transformer.SampleConsumer;
import com.google.android.exoplayer2.transformer.TransformerMediaClock;
import com.google.android.exoplayer2.transformer.TransformerUtil;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MediaClock;
import com.google.android.exoplayer2.util.MimeTypes;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

@Deprecated
abstract class ExoAssetLoaderBaseRenderer
extends BaseRenderer {
    protected long streamStartPositionUs;
    protected long streamOffsetUs;
    protected @MonotonicNonNull SampleConsumer sampleConsumer;
    protected @MonotonicNonNull Codec decoder;
    protected boolean isEnded;
    private @MonotonicNonNull Format inputFormat;
    private @MonotonicNonNull Format outputFormat;
    private final TransformerMediaClock mediaClock;
    private final AssetLoader.Listener assetLoaderListener;
    private final DecoderInputBuffer decoderInputBuffer;
    private boolean isRunning;
    private boolean shouldInitDecoder;
    private boolean hasPendingConsumerInput;

    public ExoAssetLoaderBaseRenderer(int trackType, TransformerMediaClock mediaClock, AssetLoader.Listener assetLoaderListener) {
        super(trackType);
        this.mediaClock = mediaClock;
        this.assetLoaderListener = assetLoaderListener;
        this.decoderInputBuffer = new DecoderInputBuffer(0);
    }

    public int supportsFormat(Format format) {
        return RendererCapabilities.create((int)(MimeTypes.getTrackType((String)format.sampleMimeType) == this.getTrackType() ? 4 : 0));
    }

    public MediaClock getMediaClock() {
        return this.mediaClock;
    }

    public boolean isReady() {
        return this.isSourceReady();
    }

    public boolean isEnded() {
        return this.isEnded;
    }

    public void render(long positionUs, long elapsedRealtimeUs) {
        try {
            if (!this.isRunning || this.isEnded() || !this.readInputFormatAndInitDecoderIfNeeded()) {
                return;
            }
            if (this.decoder != null) {
                do {
                    boolean progressMade = false;
                    if (!this.ensureSampleConsumerInitialized()) continue;
                    progressMade = this.feedConsumerFromDecoder();
                } while (progressMade |= this.feedDecoderFromInput());
            } else if (this.ensureSampleConsumerInitialized()) {
                while (this.feedConsumerFromInput()) {
                }
            }
        }
        catch (ExportException e) {
            this.isRunning = false;
            this.assetLoaderListener.onError(e);
        }
    }

    protected void onStreamChanged(Format[] formats, long startPositionUs, long offsetUs) {
        this.streamStartPositionUs = startPositionUs;
        this.streamOffsetUs = offsetUs;
    }

    protected void onEnabled(boolean joining, boolean mayRenderStartOfStream) {
        this.mediaClock.updateTimeForTrackType(this.getTrackType(), 0L);
    }

    protected void onStarted() {
        this.isRunning = true;
    }

    protected void onStopped() {
        this.isRunning = false;
    }

    protected void onReset() {
        if (this.decoder != null) {
            this.decoder.release();
        }
    }

    protected Format overrideFormat(Format inputFormat) {
        return inputFormat;
    }

    protected void onInputFormatRead(Format inputFormat) {
    }

    @EnsuresNonNull(value={"decoder"})
    protected abstract void initDecoder(Format var1) throws ExportException;

    protected boolean shouldDropInputBuffer(DecoderInputBuffer inputBuffer) {
        return false;
    }

    protected void onDecoderInputReady(DecoderInputBuffer inputBuffer) {
    }

    @RequiresNonNull(value={"sampleConsumer", "decoder"})
    protected abstract boolean feedConsumerFromDecoder() throws ExportException;

    @EnsuresNonNullIf(expression={"inputFormat"}, result=true)
    private boolean readInputFormatAndInitDecoderIfNeeded() throws ExportException {
        if (this.inputFormat != null && !this.shouldInitDecoder) {
            return true;
        }
        if (this.inputFormat == null) {
            FormatHolder formatHolder = this.getFormatHolder();
            int result = this.readSource(formatHolder, this.decoderInputBuffer, 2);
            if (result != -5) {
                return false;
            }
            this.inputFormat = this.overrideFormat((Format)Assertions.checkNotNull((Object)formatHolder.format));
            this.onInputFormatRead(this.inputFormat);
            this.shouldInitDecoder = this.assetLoaderListener.onTrackAdded(this.inputFormat, 3);
        }
        if (this.shouldInitDecoder) {
            if (TransformerUtil.getProcessedTrackType(this.inputFormat.sampleMimeType) == 2 && !this.ensureSampleConsumerInitialized()) {
                return false;
            }
            this.initDecoder(this.inputFormat);
            this.shouldInitDecoder = false;
        }
        return true;
    }

    @RequiresNonNull(value={"inputFormat"})
    @EnsuresNonNullIf(expression={"sampleConsumer"}, result=true)
    private boolean ensureSampleConsumerInitialized() throws ExportException {
        SampleConsumer sampleConsumer;
        if (this.sampleConsumer != null) {
            return true;
        }
        if (this.outputFormat == null) {
            if (this.decoder != null && TransformerUtil.getProcessedTrackType(this.inputFormat.sampleMimeType) == 1) {
                Format decoderOutputFormat = this.decoder.getOutputFormat();
                if (decoderOutputFormat == null) {
                    return false;
                }
                this.outputFormat = decoderOutputFormat;
            } else {
                this.outputFormat = this.inputFormat;
            }
        }
        if ((sampleConsumer = this.assetLoaderListener.onOutputFormat(this.outputFormat)) == null) {
            return false;
        }
        this.sampleConsumer = sampleConsumer;
        return true;
    }

    @RequiresNonNull(value={"decoder"})
    private boolean feedDecoderFromInput() throws ExportException {
        if (!this.decoder.maybeDequeueInputBuffer(this.decoderInputBuffer)) {
            return false;
        }
        if (!this.readInput(this.decoderInputBuffer)) {
            return false;
        }
        if (this.shouldDropInputBuffer(this.decoderInputBuffer)) {
            return true;
        }
        this.onDecoderInputReady(this.decoderInputBuffer);
        this.decoder.queueInputBuffer(this.decoderInputBuffer);
        return true;
    }

    @RequiresNonNull(value={"sampleConsumer"})
    private boolean feedConsumerFromInput() {
        DecoderInputBuffer sampleConsumerInputBuffer = this.sampleConsumer.getInputBuffer();
        if (sampleConsumerInputBuffer == null) {
            return false;
        }
        if (!this.hasPendingConsumerInput) {
            if (!this.readInput(sampleConsumerInputBuffer)) {
                return false;
            }
            if (this.shouldDropInputBuffer(sampleConsumerInputBuffer)) {
                return true;
            }
            this.hasPendingConsumerInput = true;
        }
        boolean isInputEnded = sampleConsumerInputBuffer.isEndOfStream();
        if (!this.sampleConsumer.queueInputBuffer()) {
            return false;
        }
        this.hasPendingConsumerInput = false;
        this.isEnded = isInputEnded;
        return !this.isEnded;
    }

    private boolean readInput(DecoderInputBuffer buffer) {
        int result = this.readSource(this.getFormatHolder(), buffer, 0);
        switch (result) {
            case -4: {
                buffer.flip();
                if (!buffer.isEndOfStream()) {
                    this.mediaClock.updateTimeForTrackType(this.getTrackType(), buffer.timeUs);
                }
                return true;
            }
            case -5: {
                throw new IllegalStateException("Format changes are not supported.");
            }
        }
        return false;
    }
}

