/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.media.MediaCodec;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.transformer.AssetLoader;
import com.google.android.exoplayer2.transformer.Codec;
import com.google.android.exoplayer2.transformer.ExoAssetLoaderBaseRenderer;
import com.google.android.exoplayer2.transformer.ExportException;
import com.google.android.exoplayer2.transformer.TransformerMediaClock;
import com.google.android.exoplayer2.util.Assertions;
import java.nio.ByteBuffer;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

@Deprecated
final class ExoAssetLoaderAudioRenderer
extends ExoAssetLoaderBaseRenderer {
    private static final String TAG = "ExoAssetLoaderAudioRenderer";
    private final Codec.DecoderFactory decoderFactory;
    private boolean hasPendingConsumerInput;

    public ExoAssetLoaderAudioRenderer(Codec.DecoderFactory decoderFactory, TransformerMediaClock mediaClock, AssetLoader.Listener assetLoaderListener) {
        super(1, mediaClock, assetLoaderListener);
        this.decoderFactory = decoderFactory;
    }

    public String getName() {
        return TAG;
    }

    @Override
    protected void initDecoder(Format inputFormat) throws ExportException {
        this.decoder = this.decoderFactory.createForAudioDecoding(inputFormat);
    }

    @Override
    protected boolean shouldDropInputBuffer(DecoderInputBuffer inputBuffer) {
        if (inputBuffer.isEndOfStream()) {
            return false;
        }
        inputBuffer.timeUs -= this.streamStartPositionUs;
        if (this.decoder != null && inputBuffer.timeUs < 0L) {
            inputBuffer.clear();
            return true;
        }
        return false;
    }

    @Override
    @RequiresNonNull(value={"sampleConsumer", "decoder"})
    protected boolean feedConsumerFromDecoder() throws ExportException {
        DecoderInputBuffer sampleConsumerInputBuffer = this.sampleConsumer.getInputBuffer();
        if (sampleConsumerInputBuffer == null) {
            return false;
        }
        if (!this.hasPendingConsumerInput) {
            if (this.decoder.isEnded()) {
                ((ByteBuffer)Assertions.checkNotNull((Object)sampleConsumerInputBuffer.data)).limit(0);
                sampleConsumerInputBuffer.addFlag(4);
                this.isEnded = this.sampleConsumer.queueInputBuffer();
                return false;
            }
            ByteBuffer decoderOutputBuffer = this.decoder.getOutputBuffer();
            if (decoderOutputBuffer == null) {
                return false;
            }
            sampleConsumerInputBuffer.ensureSpaceForWrite(decoderOutputBuffer.limit());
            sampleConsumerInputBuffer.data.put(decoderOutputBuffer).flip();
            MediaCodec.BufferInfo bufferInfo = (MediaCodec.BufferInfo)Assertions.checkNotNull((Object)this.decoder.getOutputBufferInfo());
            sampleConsumerInputBuffer.timeUs = bufferInfo.presentationTimeUs;
            sampleConsumerInputBuffer.setFlags(bufferInfo.flags);
            this.decoder.releaseOutputBuffer(false);
            this.hasPendingConsumerInput = true;
        }
        if (!this.sampleConsumer.queueInputBuffer()) {
            return false;
        }
        this.hasPendingConsumerInput = false;
        return true;
    }
}

