/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.content.Context;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.util.Size;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.transformer.Codec;
import com.google.android.exoplayer2.transformer.DefaultCodec;
import com.google.android.exoplayer2.transformer.DeviceMappedEncoderBitrateProvider;
import com.google.android.exoplayer2.transformer.EncoderSelector;
import com.google.android.exoplayer2.transformer.EncoderUtil;
import com.google.android.exoplayer2.transformer.ExportException;
import com.google.android.exoplayer2.transformer.VideoEncoderSettings;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MediaFormatUtil;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.ColorInfo;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

@Deprecated
public final class DefaultEncoderFactory
implements Codec.EncoderFactory {
    private static final int DEFAULT_FRAME_RATE = 30;
    private static final int PRIORITY_BEST_EFFORT = 1;
    private static final String TAG = "DefaultEncoderFactory";
    private final Context context;
    private final EncoderSelector videoEncoderSelector;
    private final VideoEncoderSettings requestedVideoEncoderSettings;
    private final boolean enableFallback;

    @Deprecated
    public DefaultEncoderFactory(Context context) {
        this(context, EncoderSelector.DEFAULT, true);
    }

    @Deprecated
    public DefaultEncoderFactory(Context context, EncoderSelector videoEncoderSelector, boolean enableFallback) {
        this(context, videoEncoderSelector, VideoEncoderSettings.DEFAULT, enableFallback);
    }

    @Deprecated
    public DefaultEncoderFactory(Context context, EncoderSelector videoEncoderSelector, VideoEncoderSettings requestedVideoEncoderSettings, boolean enableFallback) {
        this.context = context;
        this.videoEncoderSelector = videoEncoderSelector;
        this.requestedVideoEncoderSettings = requestedVideoEncoderSettings;
        this.enableFallback = enableFallback;
    }

    @Override
    public DefaultCodec createForAudioEncoding(Format format) throws ExportException {
        Assertions.checkNotNull((Object)format.sampleMimeType);
        MediaFormat mediaFormat = MediaFormatUtil.createMediaFormatFromFormat((Format)format);
        ImmutableList<MediaCodecInfo> mediaCodecInfos = EncoderUtil.getSupportedEncoders(format.sampleMimeType);
        if (mediaCodecInfos.isEmpty()) {
            throw DefaultEncoderFactory.createExportException(format, "No audio media codec found");
        }
        return new DefaultCodec(this.context, format, mediaFormat, ((MediaCodecInfo)mediaCodecInfos.get(0)).getName(), false, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DefaultCodec createForVideoEncoding(Format format) throws ExportException {
        if (format.frameRate == -1.0f) {
            format = format.buildUpon().setFrameRate(30.0f).build();
        }
        Assertions.checkArgument((format.width != -1 ? 1 : 0) != 0);
        Assertions.checkArgument((format.height != -1 ? 1 : 0) != 0);
        Assertions.checkArgument((format.height <= format.width ? 1 : 0) != 0);
        Assertions.checkArgument((format.rotationDegrees == 0 ? 1 : 0) != 0);
        Assertions.checkNotNull((Object)format.sampleMimeType);
        Assertions.checkStateNotNull((Object)this.videoEncoderSelector);
        VideoEncoderQueryResult encoderAndClosestFormatSupport = DefaultEncoderFactory.findEncoderWithClosestSupportedFormat(format, this.requestedVideoEncoderSettings, this.videoEncoderSelector, this.enableFallback);
        if (encoderAndClosestFormatSupport == null) {
            throw DefaultEncoderFactory.createExportException(format, "The requested video encoding format is not supported.");
        }
        MediaCodecInfo encoderInfo = encoderAndClosestFormatSupport.encoder;
        Format encoderSupportedFormat = encoderAndClosestFormatSupport.supportedFormat;
        VideoEncoderSettings supportedVideoEncoderSettings = encoderAndClosestFormatSupport.supportedEncoderSettings;
        String mimeType = (String)Assertions.checkNotNull((Object)encoderSupportedFormat.sampleMimeType);
        int finalBitrate = this.enableFallback ? supportedVideoEncoderSettings.bitrate : (supportedVideoEncoderSettings.bitrate != -1 ? supportedVideoEncoderSettings.bitrate : (supportedVideoEncoderSettings.enableHighQualityTargeting ? new DeviceMappedEncoderBitrateProvider().getBitrate(encoderInfo.getName(), encoderSupportedFormat.width, encoderSupportedFormat.height, encoderSupportedFormat.frameRate) : (encoderSupportedFormat.averageBitrate != -1 ? encoderSupportedFormat.averageBitrate : DefaultEncoderFactory.getSuggestedBitrate(encoderSupportedFormat.width, encoderSupportedFormat.height, encoderSupportedFormat.frameRate))));
        encoderSupportedFormat = encoderSupportedFormat.buildUpon().setAverageBitrate(finalBitrate).build();
        MediaFormat mediaFormat = MediaFormatUtil.createMediaFormatFromFormat((Format)encoderSupportedFormat);
        mediaFormat.setInteger("bitrate-mode", supportedVideoEncoderSettings.bitrateMode);
        mediaFormat.setInteger("frame-rate", Math.round(encoderSupportedFormat.frameRate));
        if (supportedVideoEncoderSettings.profile != -1 && supportedVideoEncoderSettings.level != -1 && Util.SDK_INT >= 23) {
            mediaFormat.setInteger("profile", supportedVideoEncoderSettings.profile);
            mediaFormat.setInteger("level", supportedVideoEncoderSettings.level);
        }
        if (mimeType.equals("video/avc")) {
            DefaultEncoderFactory.adjustMediaFormatForH264EncoderSettings(format.colorInfo, encoderInfo, mediaFormat);
        }
        if (Util.SDK_INT >= 31 && ColorInfo.isTransferHdr((ColorInfo)format.colorInfo)) {
            if (!EncoderUtil.getSupportedColorFormats(encoderInfo, mimeType).contains((Object)2130750114)) throw DefaultEncoderFactory.createExportException(format, "Encoding HDR is not supported on this device.");
            mediaFormat.setInteger("color-format", 2130750114);
        } else {
            mediaFormat.setInteger("color-format", 2130708361);
        }
        if (Util.SDK_INT >= 25) {
            mediaFormat.setFloat("i-frame-interval", supportedVideoEncoderSettings.iFrameIntervalSeconds);
        } else {
            float iFrameIntervalSeconds = supportedVideoEncoderSettings.iFrameIntervalSeconds;
            mediaFormat.setInteger("i-frame-interval", iFrameIntervalSeconds > 0.0f && iFrameIntervalSeconds <= 1.0f ? 1 : (int)Math.floor(iFrameIntervalSeconds));
        }
        if (Util.SDK_INT < 23) return new DefaultCodec(this.context, encoderSupportedFormat, mediaFormat, encoderInfo.getName(), false, null);
        if (supportedVideoEncoderSettings.operatingRate == -1 && supportedVideoEncoderSettings.priority == -1) {
            DefaultEncoderFactory.adjustMediaFormatForEncoderPerformanceSettings(mediaFormat);
            return new DefaultCodec(this.context, encoderSupportedFormat, mediaFormat, encoderInfo.getName(), false, null);
        } else {
            if (supportedVideoEncoderSettings.operatingRate != -1) {
                mediaFormat.setInteger("operating-rate", supportedVideoEncoderSettings.operatingRate);
            }
            if (supportedVideoEncoderSettings.priority == -1) return new DefaultCodec(this.context, encoderSupportedFormat, mediaFormat, encoderInfo.getName(), false, null);
            mediaFormat.setInteger("priority", supportedVideoEncoderSettings.priority);
        }
        return new DefaultCodec(this.context, encoderSupportedFormat, mediaFormat, encoderInfo.getName(), false, null);
    }

    @Override
    public boolean videoNeedsEncoding() {
        return !this.requestedVideoEncoderSettings.equals(VideoEncoderSettings.DEFAULT);
    }

    @RequiresNonNull(value={"#1.sampleMimeType"})
    @Nullable
    private static VideoEncoderQueryResult findEncoderWithClosestSupportedFormat(Format requestedFormat, VideoEncoderSettings videoEncoderSettings, EncoderSelector encoderSelector, boolean enableFallback) {
        String mimeType = (String)Assertions.checkNotNull((Object)requestedFormat.sampleMimeType);
        ImmutableList<MediaCodecInfo> filteredEncoderInfos = encoderSelector.selectEncoderInfos(mimeType);
        if (filteredEncoderInfos.isEmpty()) {
            return null;
        }
        if (!enableFallback) {
            return new VideoEncoderQueryResult((MediaCodecInfo)filteredEncoderInfos.get(0), requestedFormat, videoEncoderSettings);
        }
        if ((filteredEncoderInfos = DefaultEncoderFactory.filterEncodersByResolution(filteredEncoderInfos, mimeType, requestedFormat.width, requestedFormat.height)).isEmpty()) {
            return null;
        }
        Size finalResolution = (Size)Assertions.checkNotNull((Object)EncoderUtil.getSupportedResolution((MediaCodecInfo)filteredEncoderInfos.get(0), mimeType, requestedFormat.width, requestedFormat.height));
        int requestedBitrate = -1;
        if (!videoEncoderSettings.enableHighQualityTargeting && (filteredEncoderInfos = DefaultEncoderFactory.filterEncodersByBitrate(filteredEncoderInfos, mimeType, requestedBitrate = videoEncoderSettings.bitrate != -1 ? videoEncoderSettings.bitrate : (requestedFormat.averageBitrate != -1 ? requestedFormat.averageBitrate : DefaultEncoderFactory.getSuggestedBitrate(finalResolution.getWidth(), finalResolution.getHeight(), requestedFormat.frameRate)))).isEmpty()) {
            return null;
        }
        if ((filteredEncoderInfos = DefaultEncoderFactory.filterEncodersByBitrateMode(filteredEncoderInfos, mimeType, videoEncoderSettings.bitrateMode)).isEmpty()) {
            return null;
        }
        VideoEncoderSettings.Builder supportedEncodingSettingBuilder = videoEncoderSettings.buildUpon();
        Format.Builder encoderSupportedFormatBuilder = requestedFormat.buildUpon().setSampleMimeType(mimeType).setWidth(finalResolution.getWidth()).setHeight(finalResolution.getHeight());
        MediaCodecInfo pickedEncoderInfo = (MediaCodecInfo)filteredEncoderInfos.get(0);
        if (videoEncoderSettings.enableHighQualityTargeting) {
            requestedBitrate = new DeviceMappedEncoderBitrateProvider().getBitrate(pickedEncoderInfo.getName(), finalResolution.getWidth(), finalResolution.getHeight(), requestedFormat.frameRate);
            supportedEncodingSettingBuilder.experimentalSetEnableHighQualityTargeting(false);
        }
        int closestSupportedBitrate = (Integer)EncoderUtil.getSupportedBitrateRange(pickedEncoderInfo, mimeType).clamp((Comparable)Integer.valueOf(requestedBitrate));
        supportedEncodingSettingBuilder.setBitrate(closestSupportedBitrate);
        encoderSupportedFormatBuilder.setAverageBitrate(closestSupportedBitrate);
        if (videoEncoderSettings.profile == -1 || videoEncoderSettings.level == -1 || videoEncoderSettings.level > EncoderUtil.findHighestSupportedEncodingLevel(pickedEncoderInfo, mimeType, videoEncoderSettings.profile)) {
            supportedEncodingSettingBuilder.setEncodingProfileLevel(-1, -1);
        }
        return new VideoEncoderQueryResult(pickedEncoderInfo, encoderSupportedFormatBuilder.build(), supportedEncodingSettingBuilder.build());
    }

    private static ImmutableList<MediaCodecInfo> filterEncodersByResolution(List<MediaCodecInfo> encoders, String mimeType, int requestedWidth, int requestedHeight) {
        return DefaultEncoderFactory.filterEncoders(encoders, encoderInfo -> {
            Size closestSupportedResolution = EncoderUtil.getSupportedResolution(encoderInfo, mimeType, requestedWidth, requestedHeight);
            if (closestSupportedResolution == null) {
                return Integer.MAX_VALUE;
            }
            return Math.abs(requestedWidth * requestedHeight - closestSupportedResolution.getWidth() * closestSupportedResolution.getHeight());
        });
    }

    private static ImmutableList<MediaCodecInfo> filterEncodersByBitrate(List<MediaCodecInfo> encoders, String mimeType, int requestedBitrate) {
        return DefaultEncoderFactory.filterEncoders(encoders, encoderInfo -> {
            int achievableBitrate = (Integer)EncoderUtil.getSupportedBitrateRange(encoderInfo, mimeType).clamp((Comparable)Integer.valueOf(requestedBitrate));
            return Math.abs(achievableBitrate - requestedBitrate);
        });
    }

    private static ImmutableList<MediaCodecInfo> filterEncodersByBitrateMode(List<MediaCodecInfo> encoders, String mimeType, int requestedBitrateMode) {
        return DefaultEncoderFactory.filterEncoders(encoders, encoderInfo -> EncoderUtil.isBitrateModeSupported(encoderInfo, mimeType, requestedBitrateMode) ? 0 : Integer.MAX_VALUE);
    }

    private static void adjustMediaFormatForEncoderPerformanceSettings(MediaFormat mediaFormat) {
        if (Util.SDK_INT < 25) {
            return;
        }
        mediaFormat.setInteger("priority", 1);
        if (Util.SDK_INT == 26) {
            mediaFormat.setInteger("operating-rate", 30);
        } else {
            mediaFormat.setInteger("operating-rate", Integer.MAX_VALUE);
        }
    }

    private static void adjustMediaFormatForH264EncoderSettings(@Nullable ColorInfo colorInfo, MediaCodecInfo encoderInfo, MediaFormat mediaFormat) {
        String mimeType = "video/avc";
        if (Util.SDK_INT >= 29) {
            int supportedEncodingLevel;
            int colorTransfer;
            ImmutableList<Integer> codecProfiles;
            int expectedEncodingProfile = 8;
            if (colorInfo != null && !(codecProfiles = EncoderUtil.getCodecProfilesForHdrFormat(mimeType, colorTransfer = colorInfo.colorTransfer)).isEmpty()) {
                expectedEncodingProfile = (Integer)codecProfiles.get(0);
            }
            if ((supportedEncodingLevel = EncoderUtil.findHighestSupportedEncodingLevel(encoderInfo, mimeType, expectedEncodingProfile)) != -1) {
                mediaFormat.setInteger("profile", expectedEncodingProfile);
                mediaFormat.setInteger("level", supportedEncodingLevel);
            }
        } else if (Util.SDK_INT >= 26) {
            int expectedEncodingProfile = 8;
            int supportedEncodingLevel = EncoderUtil.findHighestSupportedEncodingLevel(encoderInfo, mimeType, expectedEncodingProfile);
            if (supportedEncodingLevel != -1) {
                mediaFormat.setInteger("profile", expectedEncodingProfile);
                mediaFormat.setInteger("level", supportedEncodingLevel);
                mediaFormat.setInteger("latency", 1);
            }
        } else if (Util.SDK_INT >= 24) {
            int expectedEncodingProfile = 1;
            int supportedLevel = EncoderUtil.findHighestSupportedEncodingLevel(encoderInfo, mimeType, expectedEncodingProfile);
            Assertions.checkState((supportedLevel != -1 ? 1 : 0) != 0);
            mediaFormat.setInteger("profile", expectedEncodingProfile);
            mediaFormat.setInteger("level", supportedLevel);
        }
    }

    private static ImmutableList<MediaCodecInfo> filterEncoders(List<MediaCodecInfo> encoders, EncoderFallbackCost cost) {
        ArrayList<MediaCodecInfo> filteredEncoders = new ArrayList<MediaCodecInfo>(encoders.size());
        int minGap = Integer.MAX_VALUE;
        for (int i = 0; i < encoders.size(); ++i) {
            MediaCodecInfo encoderInfo = encoders.get(i);
            int gap = cost.getParameterSupportGap(encoderInfo);
            if (gap == Integer.MAX_VALUE) continue;
            if (gap < minGap) {
                minGap = gap;
                filteredEncoders.clear();
                filteredEncoders.add(encoderInfo);
                continue;
            }
            if (gap != minGap) continue;
            filteredEncoders.add(encoderInfo);
        }
        return ImmutableList.copyOf(filteredEncoders);
    }

    private static int getSuggestedBitrate(int width, int height, float frameRate) {
        return (int)((double)((float)(width * height) * frameRate) * 0.07 * 2.0);
    }

    @RequiresNonNull(value={"#1.sampleMimeType"})
    private static ExportException createExportException(Format format, String errorString) {
        return ExportException.createForCodec((Throwable)new IllegalArgumentException(errorString), 4003, MimeTypes.isVideo((String)format.sampleMimeType), false, format);
    }

    private static interface EncoderFallbackCost {
        public int getParameterSupportGap(MediaCodecInfo var1);
    }

    private static final class VideoEncoderQueryResult {
        public final MediaCodecInfo encoder;
        public final Format supportedFormat;
        public final VideoEncoderSettings supportedEncoderSettings;

        public VideoEncoderQueryResult(MediaCodecInfo encoder, Format supportedFormat, VideoEncoderSettings supportedEncoderSettings) {
            this.encoder = encoder;
            this.supportedFormat = supportedFormat;
            this.supportedEncoderSettings = supportedEncoderSettings;
        }
    }

    public static final class Builder {
        private final Context context;
        @Nullable
        private EncoderSelector videoEncoderSelector;
        @Nullable
        private VideoEncoderSettings requestedVideoEncoderSettings;
        private boolean enableFallback;

        public Builder(Context context) {
            this.context = context;
            this.enableFallback = true;
        }

        @CanIgnoreReturnValue
        public Builder setVideoEncoderSelector(EncoderSelector videoEncoderSelector) {
            this.videoEncoderSelector = videoEncoderSelector;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setRequestedVideoEncoderSettings(VideoEncoderSettings requestedVideoEncoderSettings) {
            this.requestedVideoEncoderSettings = requestedVideoEncoderSettings;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setEnableFallback(boolean enableFallback) {
            this.enableFallback = enableFallback;
            return this;
        }

        public DefaultEncoderFactory build() {
            if (this.videoEncoderSelector == null) {
                this.videoEncoderSelector = EncoderSelector.DEFAULT;
            }
            if (this.requestedVideoEncoderSettings == null) {
                this.requestedVideoEncoderSettings = VideoEncoderSettings.DEFAULT;
            }
            return new DefaultEncoderFactory(this.context, this.videoEncoderSelector, this.requestedVideoEncoderSettings, this.enableFallback);
        }
    }
}

