/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.annotation.SuppressLint;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.os.ParcelFileDescriptor;
import android.util.SparseLongArray;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.transformer.Muxer;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MediaFormatUtil;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.ColorInfo;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.List;

final class FrameworkMuxer
implements Muxer {
    private static final ImmutableList<String> SUPPORTED_VIDEO_SAMPLE_MIME_TYPES = Util.SDK_INT >= 24 ? ImmutableList.of((Object)"video/3gpp", (Object)"video/avc", (Object)"video/mp4v-es", (Object)"video/hevc") : ImmutableList.of((Object)"video/3gpp", (Object)"video/avc", (Object)"video/mp4v-es");
    private static final ImmutableList<String> SUPPORTED_AUDIO_SAMPLE_MIME_TYPES = ImmutableList.of((Object)"audio/mp4a-latm", (Object)"audio/3gpp", (Object)"audio/amr-wb");
    private final MediaMuxer mediaMuxer;
    private final long maxDelayBetweenSamplesMs;
    private final MediaCodec.BufferInfo bufferInfo;
    private final SparseLongArray trackIndexToLastPresentationTimeUs;
    private boolean isStarted;

    private FrameworkMuxer(MediaMuxer mediaMuxer, long maxDelayBetweenSamplesMs) {
        this.mediaMuxer = mediaMuxer;
        this.maxDelayBetweenSamplesMs = maxDelayBetweenSamplesMs;
        this.bufferInfo = new MediaCodec.BufferInfo();
        this.trackIndexToLastPresentationTimeUs = new SparseLongArray();
    }

    @Override
    public int addTrack(Format format) throws Muxer.MuxerException {
        int trackIndex;
        MediaFormat mediaFormat;
        String sampleMimeType = (String)Assertions.checkNotNull((Object)format.sampleMimeType);
        if (MimeTypes.isAudio((String)sampleMimeType)) {
            mediaFormat = MediaFormat.createAudioFormat((String)((String)Util.castNonNull((Object)sampleMimeType)), (int)format.sampleRate, (int)format.channelCount);
        } else {
            mediaFormat = MediaFormat.createVideoFormat((String)((String)Util.castNonNull((Object)sampleMimeType)), (int)format.width, (int)format.height);
            MediaFormatUtil.maybeSetColorInfo((MediaFormat)mediaFormat, (ColorInfo)format.colorInfo);
            try {
                this.mediaMuxer.setOrientationHint(format.rotationDegrees);
            }
            catch (RuntimeException e) {
                throw new Muxer.MuxerException("Failed to set orientation hint with rotationDegrees=" + format.rotationDegrees, e);
            }
        }
        MediaFormatUtil.setCsdBuffers((MediaFormat)mediaFormat, (List)format.initializationData);
        try {
            trackIndex = this.mediaMuxer.addTrack(mediaFormat);
        }
        catch (RuntimeException e) {
            throw new Muxer.MuxerException("Failed to add track with format=" + format, e);
        }
        return trackIndex;
    }

    @Override
    @SuppressLint(value={"WrongConstant"})
    public void writeSampleData(int trackIndex, ByteBuffer data, boolean isKeyFrame, long presentationTimeUs) throws Muxer.MuxerException {
        if (!this.isStarted) {
            this.isStarted = true;
            try {
                this.mediaMuxer.start();
            }
            catch (RuntimeException e) {
                throw new Muxer.MuxerException("Failed to start the muxer", e);
            }
        }
        int offset = data.position();
        int size = data.limit() - offset;
        int flags = isKeyFrame ? 1 : 0;
        this.bufferInfo.set(offset, size, presentationTimeUs, flags);
        long lastSamplePresentationTimeUs = this.trackIndexToLastPresentationTimeUs.get(trackIndex);
        try {
            Assertions.checkState((Util.SDK_INT > 24 || presentationTimeUs >= lastSamplePresentationTimeUs ? 1 : 0) != 0, (Object)("Samples not in presentation order (" + presentationTimeUs + " < " + lastSamplePresentationTimeUs + ") unsupported on this API version"));
            this.trackIndexToLastPresentationTimeUs.put(trackIndex, presentationTimeUs);
            this.mediaMuxer.writeSampleData(trackIndex, data, this.bufferInfo);
        }
        catch (RuntimeException e) {
            throw new Muxer.MuxerException("Failed to write sample for trackIndex=" + trackIndex + ", presentationTimeUs=" + presentationTimeUs + ", size=" + size, e);
        }
    }

    @Override
    public void release(boolean forCancellation) throws Muxer.MuxerException {
        if (!this.isStarted) {
            this.mediaMuxer.release();
            return;
        }
        this.isStarted = false;
        try {
            FrameworkMuxer.stopMuxer(this.mediaMuxer);
        }
        catch (RuntimeException e) {
            if (!forCancellation) {
                throw new Muxer.MuxerException("Failed to stop the muxer", e);
            }
        }
        finally {
            this.mediaMuxer.release();
        }
    }

    @Override
    public long getMaxDelayBetweenSamplesMs() {
        return this.maxDelayBetweenSamplesMs;
    }

    @SuppressLint(value={"PrivateApi"})
    private static void stopMuxer(MediaMuxer mediaMuxer) {
        try {
            mediaMuxer.stop();
        }
        catch (RuntimeException e) {
            if (Util.SDK_INT < 30) {
                try {
                    Field muxerStoppedStateField = MediaMuxer.class.getDeclaredField("MUXER_STATE_STOPPED");
                    muxerStoppedStateField.setAccessible(true);
                    int muxerStoppedState = (Integer)Util.castNonNull((Object)((Integer)muxerStoppedStateField.get(mediaMuxer)));
                    Field muxerStateField = MediaMuxer.class.getDeclaredField("mState");
                    muxerStateField.setAccessible(true);
                    muxerStateField.set(mediaMuxer, muxerStoppedState);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    public static final class Factory
    implements Muxer.Factory {
        private final long maxDelayBetweenSamplesMs;

        public Factory(long maxDelayBetweenSamplesMs) {
            this.maxDelayBetweenSamplesMs = maxDelayBetweenSamplesMs;
        }

        @Override
        public FrameworkMuxer create(String path) throws Muxer.MuxerException {
            MediaMuxer mediaMuxer;
            try {
                mediaMuxer = new MediaMuxer(path, 0);
            }
            catch (IOException e) {
                throw new Muxer.MuxerException("Error creating muxer", e);
            }
            return new FrameworkMuxer(mediaMuxer, this.maxDelayBetweenSamplesMs);
        }

        @Override
        @RequiresApi(value=26)
        public FrameworkMuxer create(ParcelFileDescriptor parcelFileDescriptor) throws Muxer.MuxerException {
            MediaMuxer mediaMuxer;
            try {
                mediaMuxer = new MediaMuxer(parcelFileDescriptor.getFileDescriptor(), 0);
            }
            catch (IOException e) {
                throw new Muxer.MuxerException("Error creating muxer", e);
            }
            return new FrameworkMuxer(mediaMuxer, this.maxDelayBetweenSamplesMs);
        }

        @Override
        public ImmutableList<String> getSupportedSampleMimeTypes(int trackType) {
            if (trackType == 2) {
                return SUPPORTED_VIDEO_SAMPLE_MIME_TYPES;
            }
            if (trackType == 1) {
                return SUPPORTED_AUDIO_SAMPLE_MIME_TYPES;
            }
            return ImmutableList.of();
        }
    }
}

