/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.view.Surface;
import androidx.annotation.DoNotInline;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.transformer.Codec;
import com.google.android.exoplayer2.transformer.TransformationException;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.MediaFormatUtil;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.TraceUtil;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.ColorInfo;
import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class DefaultCodec
implements Codec {
    private static final String TAG = "DefaultCodec";
    private static final int MEDIA_CODEC_PCM_ENCODING = 2;
    private final MediaCodec.BufferInfo outputBufferInfo;
    private final MediaFormat configurationMediaFormat;
    private final Format configurationFormat;
    private final MediaCodec mediaCodec;
    @Nullable
    private final Surface inputSurface;
    private final boolean decoderNeedsFrameDroppingWorkaround;
    private @MonotonicNonNull Format outputFormat;
    @Nullable
    private ByteBuffer outputBuffer;
    private int inputBufferIndex;
    private int outputBufferIndex;
    private boolean inputStreamEnded;
    private boolean outputStreamEnded;

    public DefaultCodec(Context context, Format configurationFormat, MediaFormat configurationMediaFormat, String mediaCodecName, boolean isDecoder, @Nullable Surface outputSurface) throws TransformationException {
        this.configurationFormat = configurationFormat;
        this.configurationMediaFormat = configurationMediaFormat;
        this.outputBufferInfo = new MediaCodec.BufferInfo();
        this.inputBufferIndex = -1;
        this.outputBufferIndex = -1;
        boolean isVideo = MimeTypes.isVideo((String)((String)Assertions.checkNotNull((Object)configurationFormat.sampleMimeType)));
        MediaCodec mediaCodec = null;
        Surface inputSurface = null;
        try {
            boolean requestedHdrToneMapping = Util.SDK_INT >= 29 && Api29.isSdrToneMappingEnabled(configurationMediaFormat);
            mediaCodec = MediaCodec.createByCodecName((String)mediaCodecName);
            DefaultCodec.configureCodec(mediaCodec, configurationMediaFormat, isDecoder, outputSurface);
            if (Util.SDK_INT >= 29 && requestedHdrToneMapping) {
                Assertions.checkArgument((boolean)Api29.isSdrToneMappingEnabled(mediaCodec.getInputFormat()), (Object)"Tone-mapping requested but not supported by the decoder.");
            }
            if (isVideo && !isDecoder) {
                inputSurface = mediaCodec.createInputSurface();
            }
            DefaultCodec.startCodec(mediaCodec);
        }
        catch (Exception e) {
            if (inputSurface != null) {
                inputSurface.release();
            }
            if (mediaCodec != null) {
                mediaCodec.release();
            }
            throw DefaultCodec.createInitializationTransformationException(e, configurationMediaFormat, isVideo, isDecoder, mediaCodecName);
        }
        this.mediaCodec = mediaCodec;
        this.inputSurface = inputSurface;
        this.decoderNeedsFrameDroppingWorkaround = DefaultCodec.decoderNeedsFrameDroppingWorkaround(context);
    }

    @Override
    public Format getConfigurationFormat() {
        return this.configurationFormat;
    }

    @Override
    public Surface getInputSurface() {
        return (Surface)Assertions.checkStateNotNull((Object)this.inputSurface);
    }

    @Override
    public int getMaxPendingFrameCount() {
        if (this.decoderNeedsFrameDroppingWorkaround) {
            return 1;
        }
        if (Ascii.toUpperCase((String)this.getName()).startsWith("OMX.")) {
            return 5;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    @EnsuresNonNullIf(expression={"#1.data"}, result=true)
    public boolean maybeDequeueInputBuffer(DecoderInputBuffer inputBuffer) throws TransformationException {
        if (this.inputStreamEnded) {
            return false;
        }
        if (this.inputBufferIndex < 0) {
            try {
                this.inputBufferIndex = this.mediaCodec.dequeueInputBuffer(0L);
            }
            catch (RuntimeException e) {
                throw this.createTransformationException(e);
            }
            if (this.inputBufferIndex < 0) {
                return false;
            }
            try {
                inputBuffer.data = this.mediaCodec.getInputBuffer(this.inputBufferIndex);
            }
            catch (RuntimeException e) {
                throw this.createTransformationException(e);
            }
            inputBuffer.clear();
        }
        Assertions.checkNotNull((Object)inputBuffer.data);
        return true;
    }

    @Override
    public void queueInputBuffer(DecoderInputBuffer inputBuffer) throws TransformationException {
        Assertions.checkState((!this.inputStreamEnded ? 1 : 0) != 0, (Object)"Input buffer can not be queued after the input stream has ended.");
        int offset = 0;
        int size = 0;
        if (inputBuffer.data != null && inputBuffer.data.hasRemaining()) {
            offset = inputBuffer.data.position();
            size = inputBuffer.data.remaining();
        }
        int flags = 0;
        if (inputBuffer.isEndOfStream()) {
            this.inputStreamEnded = true;
            flags = 4;
        }
        try {
            this.mediaCodec.queueInputBuffer(this.inputBufferIndex, offset, size, inputBuffer.timeUs, flags);
        }
        catch (RuntimeException e) {
            throw this.createTransformationException(e);
        }
        this.inputBufferIndex = -1;
        inputBuffer.data = null;
    }

    @Override
    public void signalEndOfInputStream() throws TransformationException {
        try {
            this.mediaCodec.signalEndOfInputStream();
        }
        catch (RuntimeException e) {
            throw this.createTransformationException(e);
        }
    }

    @Override
    @Nullable
    public Format getOutputFormat() throws TransformationException {
        this.maybeDequeueOutputBuffer(false);
        return this.outputFormat;
    }

    @Override
    @Nullable
    public ByteBuffer getOutputBuffer() throws TransformationException {
        return this.maybeDequeueOutputBuffer(true) ? this.outputBuffer : null;
    }

    @Override
    @Nullable
    public MediaCodec.BufferInfo getOutputBufferInfo() throws TransformationException {
        return this.maybeDequeueOutputBuffer(false) ? this.outputBufferInfo : null;
    }

    @Override
    public void releaseOutputBuffer(boolean render) throws TransformationException {
        this.outputBuffer = null;
        try {
            if (render) {
                this.mediaCodec.releaseOutputBuffer(this.outputBufferIndex, ((MediaCodec.BufferInfo)Assertions.checkStateNotNull((Object)this.outputBufferInfo)).presentationTimeUs * 1000L);
            } else {
                this.mediaCodec.releaseOutputBuffer(this.outputBufferIndex, false);
            }
        }
        catch (RuntimeException e) {
            throw this.createTransformationException(e);
        }
        this.outputBufferIndex = -1;
    }

    @Override
    public boolean isEnded() {
        return this.outputStreamEnded && this.outputBufferIndex == -1;
    }

    @Override
    public void release() {
        this.outputBuffer = null;
        if (this.inputSurface != null) {
            this.inputSurface.release();
        }
        this.mediaCodec.release();
    }

    @Override
    public String getName() {
        return Util.SDK_INT >= 29 ? Api29.getCanonicalName(this.mediaCodec) : this.mediaCodec.getName();
    }

    @VisibleForTesting
    MediaFormat getConfigurationMediaFormat() {
        return this.configurationMediaFormat;
    }

    private boolean maybeDequeueOutputBuffer(boolean setOutputBuffer) throws TransformationException {
        if (this.outputBufferIndex >= 0) {
            return true;
        }
        if (this.outputStreamEnded) {
            return false;
        }
        try {
            this.outputBufferIndex = this.mediaCodec.dequeueOutputBuffer(this.outputBufferInfo, 0L);
        }
        catch (RuntimeException e) {
            throw this.createTransformationException(e);
        }
        if (this.outputBufferIndex < 0) {
            if (this.outputBufferIndex == -2) {
                ColorInfo expectedColorInfo;
                this.outputFormat = DefaultCodec.convertToFormat(this.mediaCodec.getOutputFormat());
                boolean isToneMappingEnabled = Util.SDK_INT >= 29 && Api29.isSdrToneMappingEnabled(this.configurationMediaFormat);
                ColorInfo colorInfo = expectedColorInfo = isToneMappingEnabled ? ColorInfo.SDR_BT709_LIMITED : this.configurationFormat.colorInfo;
                if (!DefaultCodec.areColorTransfersEqual(expectedColorInfo, this.outputFormat.colorInfo)) {
                    Log.w((String)TAG, (String)("Codec output color format does not match configured color format. Expected: " + expectedColorInfo + ". Actual: " + this.outputFormat.colorInfo));
                }
            }
            return false;
        }
        if ((this.outputBufferInfo.flags & 4) != 0) {
            this.outputStreamEnded = true;
            if (this.outputBufferInfo.size == 0) {
                this.releaseOutputBuffer(false);
                return false;
            }
        }
        if ((this.outputBufferInfo.flags & 2) != 0) {
            this.releaseOutputBuffer(false);
            return false;
        }
        if (setOutputBuffer) {
            try {
                this.outputBuffer = (ByteBuffer)Assertions.checkNotNull((Object)this.mediaCodec.getOutputBuffer(this.outputBufferIndex));
            }
            catch (RuntimeException e) {
                throw this.createTransformationException(e);
            }
            this.outputBuffer.position(this.outputBufferInfo.offset);
            this.outputBuffer.limit(this.outputBufferInfo.offset + this.outputBufferInfo.size);
        }
        return true;
    }

    private TransformationException createTransformationException(Exception cause) {
        boolean isDecoder = !this.mediaCodec.getCodecInfo().isEncoder();
        boolean isVideo = MimeTypes.isVideo((String)this.configurationFormat.sampleMimeType);
        return TransformationException.createForCodec((Throwable)cause, isVideo, isDecoder, this.configurationMediaFormat, this.getName(), isDecoder ? 3002 : 4002);
    }

    private static boolean areColorTransfersEqual(@Nullable ColorInfo colorInfo1, @Nullable ColorInfo colorInfo2) {
        int transfer1 = 3;
        if (colorInfo1 != null && colorInfo1.colorTransfer != -1) {
            transfer1 = colorInfo1.colorTransfer;
        }
        int transfer2 = 3;
        if (colorInfo2 != null && colorInfo2.colorTransfer != -1) {
            transfer2 = colorInfo2.colorTransfer;
        }
        return transfer1 == transfer2;
    }

    private static TransformationException createInitializationTransformationException(Exception cause, MediaFormat mediaFormat, boolean isVideo, boolean isDecoder, @Nullable String mediaCodecName) {
        if (cause instanceof IOException || cause instanceof MediaCodec.CodecException) {
            return TransformationException.createForCodec((Throwable)cause, isVideo, isDecoder, mediaFormat, mediaCodecName, isDecoder ? 3001 : 4001);
        }
        if (cause instanceof IllegalArgumentException) {
            return TransformationException.createForCodec((Throwable)cause, isVideo, isDecoder, mediaFormat, mediaCodecName, isDecoder ? 3003 : 4003);
        }
        return TransformationException.createForUnexpected(cause);
    }

    private static Format convertToFormat(MediaFormat mediaFormat) {
        ByteBuffer csdByteBuffer;
        ImmutableList.Builder csdBuffers = new ImmutableList.Builder();
        int csdIndex = 0;
        while ((csdByteBuffer = mediaFormat.getByteBuffer("csd-" + csdIndex)) != null) {
            byte[] csdBufferData = new byte[csdByteBuffer.remaining()];
            csdByteBuffer.get(csdBufferData);
            csdBuffers.add((Object)csdBufferData);
            ++csdIndex;
        }
        String mimeType = mediaFormat.getString("mime");
        Format.Builder formatBuilder = new Format.Builder().setSampleMimeType(mimeType).setInitializationData((List)csdBuffers.build());
        if (MimeTypes.isVideo((String)mimeType)) {
            formatBuilder.setWidth(mediaFormat.getInteger("width")).setHeight(mediaFormat.getInteger("height")).setColorInfo(MediaFormatUtil.getColorInfo((MediaFormat)mediaFormat));
        } else if (MimeTypes.isAudio((String)mimeType)) {
            formatBuilder.setChannelCount(mediaFormat.getInteger("channel-count")).setSampleRate(mediaFormat.getInteger("sample-rate")).setPcmEncoding(2);
        }
        return formatBuilder.build();
    }

    private static void configureCodec(MediaCodec codec, MediaFormat mediaFormat, boolean isDecoder, @Nullable Surface outputSurface) {
        TraceUtil.beginSection((String)"configureCodec");
        codec.configure(mediaFormat, outputSurface, null, isDecoder ? 0 : 1);
        TraceUtil.endSection();
    }

    private static void startCodec(MediaCodec codec) {
        TraceUtil.beginSection((String)"startCodec");
        codec.start();
        TraceUtil.endSection();
    }

    private static boolean decoderNeedsFrameDroppingWorkaround(Context context) {
        return Util.SDK_INT < 29 || context.getApplicationContext().getApplicationInfo().targetSdkVersion < 29;
    }

    @RequiresApi(value=29)
    private static final class Api29 {
        private Api29() {
        }

        @DoNotInline
        public static String getCanonicalName(MediaCodec mediaCodec) {
            return mediaCodec.getCanonicalName();
        }

        @DoNotInline
        public static boolean isSdrToneMappingEnabled(MediaFormat mediaFormat) {
            return Util.SDK_INT >= 31 && mediaFormat.getInteger("color-transfer-request", 0) == 3;
        }
    }
}

