/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.os.ParcelFileDescriptor;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.transformer.FrameworkMuxer;
import com.google.android.exoplayer2.transformer.Muxer;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;

public final class DefaultMuxer
implements Muxer {
    private final Muxer muxer;

    private DefaultMuxer(Muxer muxer) {
        this.muxer = muxer;
    }

    @Override
    public int addTrack(Format format) throws Muxer.MuxerException {
        return this.muxer.addTrack(format);
    }

    @Override
    public void writeSampleData(int trackIndex, ByteBuffer data, boolean isKeyFrame, long presentationTimeUs) throws Muxer.MuxerException {
        this.muxer.writeSampleData(trackIndex, data, isKeyFrame, presentationTimeUs);
    }

    @Override
    public void release(boolean forCancellation) throws Muxer.MuxerException {
        this.muxer.release(forCancellation);
    }

    @Override
    public long getMaxDelayBetweenSamplesMs() {
        return this.muxer.getMaxDelayBetweenSamplesMs();
    }

    public static final class Factory
    implements Muxer.Factory {
        public static final long DEFAULT_MAX_DELAY_BETWEEN_SAMPLES_MS = 3000L;
        private final Muxer.Factory muxerFactory;

        public Factory() {
            this.muxerFactory = new FrameworkMuxer.Factory(3000L);
        }

        public Factory(long maxDelayBetweenSamplesMs) {
            this.muxerFactory = new FrameworkMuxer.Factory(maxDelayBetweenSamplesMs);
        }

        @Override
        public Muxer create(String path) throws Muxer.MuxerException {
            return new DefaultMuxer(this.muxerFactory.create(path));
        }

        @Override
        public Muxer create(ParcelFileDescriptor parcelFileDescriptor) throws Muxer.MuxerException {
            return new DefaultMuxer(this.muxerFactory.create(parcelFileDescriptor));
        }

        @Override
        public ImmutableList<String> getSupportedSampleMimeTypes(int trackType) {
            return this.muxerFactory.getSupportedSampleMimeTypes(trackType);
        }
    }
}

