/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.transformer.Muxer;
import com.google.android.exoplayer2.transformer.MuxerWrapper;
import com.google.android.exoplayer2.transformer.SamplePipeline;
import com.google.android.exoplayer2.transformer.SefSlowMotionFlattener;
import com.google.android.exoplayer2.transformer.TransformationException;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MimeTypes;
import java.nio.ByteBuffer;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

abstract class BaseSamplePipeline
implements SamplePipeline {
    private final long streamOffsetUs;
    private final long streamStartPositionUs;
    private final MuxerWrapper muxerWrapper;
    private final int trackType;
    private final @MonotonicNonNull SefSlowMotionFlattener sefVideoSlowMotionFlattener;
    @Nullable
    private DecoderInputBuffer inputBuffer;
    private boolean muxerWrapperTrackAdded;
    private boolean isEnded;

    public BaseSamplePipeline(Format inputFormat, long streamOffsetUs, long streamStartPositionUs, boolean flattenForSlowMotion, MuxerWrapper muxerWrapper) {
        this.streamOffsetUs = streamOffsetUs;
        this.streamStartPositionUs = streamStartPositionUs;
        this.muxerWrapper = muxerWrapper;
        this.trackType = MimeTypes.getTrackType((String)inputFormat.sampleMimeType);
        this.sefVideoSlowMotionFlattener = flattenForSlowMotion && this.trackType == 2 ? new SefSlowMotionFlattener(inputFormat) : null;
    }

    @Override
    @Nullable
    public DecoderInputBuffer dequeueInputBuffer() throws TransformationException {
        this.inputBuffer = this.dequeueInputBufferInternal();
        return this.inputBuffer;
    }

    @Override
    public void queueInputBuffer() throws TransformationException {
        Assertions.checkNotNull((Object)this.inputBuffer);
        Assertions.checkNotNull((Object)this.inputBuffer.data);
        if (!this.shouldDropInputBuffer()) {
            this.queueInputBufferInternal();
        }
    }

    @Override
    public boolean processData() throws TransformationException {
        return this.feedMuxer() || this.processDataUpToMuxer();
    }

    @Override
    public boolean isEnded() {
        return this.isEnded;
    }

    @Nullable
    protected abstract DecoderInputBuffer dequeueInputBufferInternal() throws TransformationException;

    protected abstract void queueInputBufferInternal() throws TransformationException;

    protected abstract boolean processDataUpToMuxer() throws TransformationException;

    @Nullable
    protected abstract Format getMuxerInputFormat() throws TransformationException;

    @Nullable
    protected abstract DecoderInputBuffer getMuxerInputBuffer() throws TransformationException;

    protected abstract void releaseMuxerInputBuffer() throws TransformationException;

    protected abstract boolean isMuxerInputEnded();

    @RequiresNonNull(value={"inputBuffer", "inputBuffer.data"})
    private boolean shouldDropInputBuffer() {
        ByteBuffer inputBytes = this.inputBuffer.data;
        if (this.sefVideoSlowMotionFlattener == null || this.inputBuffer.isEndOfStream()) {
            return false;
        }
        long presentationTimeUs = this.inputBuffer.timeUs - this.streamOffsetUs;
        DecoderInputBuffer inputBuffer = this.inputBuffer;
        boolean shouldDropInputBuffer = this.sefVideoSlowMotionFlattener.dropOrTransformSample(inputBytes, presentationTimeUs);
        if (shouldDropInputBuffer) {
            inputBytes.clear();
        } else {
            inputBuffer.timeUs = this.streamOffsetUs + this.sefVideoSlowMotionFlattener.getSamplePresentationTimeUs();
        }
        return shouldDropInputBuffer;
    }

    private boolean feedMuxer() throws TransformationException {
        if (!this.muxerWrapperTrackAdded) {
            Format inputFormat = this.getMuxerInputFormat();
            if (inputFormat == null) {
                return false;
            }
            try {
                this.muxerWrapper.addTrackFormat(inputFormat);
            }
            catch (Muxer.MuxerException e) {
                throw TransformationException.createForMuxer(e, 6001);
            }
            this.muxerWrapperTrackAdded = true;
        }
        if (this.isMuxerInputEnded()) {
            this.muxerWrapper.endTrack(this.trackType);
            this.isEnded = true;
            return false;
        }
        DecoderInputBuffer muxerInputBuffer = this.getMuxerInputBuffer();
        if (muxerInputBuffer == null) {
            return false;
        }
        long samplePresentationTimeUs = muxerInputBuffer.timeUs - this.streamStartPositionUs;
        try {
            if (!this.muxerWrapper.writeSample(this.trackType, (ByteBuffer)Assertions.checkStateNotNull((Object)muxerInputBuffer.data), muxerInputBuffer.isKeyFrame(), samplePresentationTimeUs)) {
                return false;
            }
        }
        catch (Muxer.MuxerException e) {
            throw TransformationException.createForMuxer(e, 6001);
        }
        this.releaseMuxerInputBuffer();
        return true;
    }
}

