/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.ExoPlayerLibraryInfo;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.PlaybackException;
import com.google.android.exoplayer2.effect.GlEffectsFrameProcessor;
import com.google.android.exoplayer2.extractor.DefaultExtractorsFactory;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.source.DefaultMediaSourceFactory;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.transformer.Codec;
import com.google.android.exoplayer2.transformer.DefaultDecoderFactory;
import com.google.android.exoplayer2.transformer.DefaultEncoderFactory;
import com.google.android.exoplayer2.transformer.DefaultMuxer;
import com.google.android.exoplayer2.transformer.ExoPlayerAssetLoader;
import com.google.android.exoplayer2.transformer.FallbackListener;
import com.google.android.exoplayer2.transformer.Muxer;
import com.google.android.exoplayer2.transformer.MuxerWrapper;
import com.google.android.exoplayer2.transformer.ProgressHolder;
import com.google.android.exoplayer2.transformer.TransformationException;
import com.google.android.exoplayer2.transformer.TransformationRequest;
import com.google.android.exoplayer2.transformer.TransformationResult;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.util.DebugViewProvider;
import com.google.android.exoplayer2.util.Effect;
import com.google.android.exoplayer2.util.FrameProcessor;
import com.google.android.exoplayer2.util.ListenerSet;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.File;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class Transformer {
    public static final int PROGRESS_STATE_WAITING_FOR_AVAILABILITY = 0;
    public static final int PROGRESS_STATE_AVAILABLE = 1;
    public static final int PROGRESS_STATE_UNAVAILABLE = 2;
    public static final int PROGRESS_STATE_NO_TRANSFORMATION = 4;
    @VisibleForTesting
    final Codec.DecoderFactory decoderFactory;
    @VisibleForTesting
    final Codec.EncoderFactory encoderFactory;
    private final Context context;
    private final TransformationRequest transformationRequest;
    private final ImmutableList<Effect> videoEffects;
    private final boolean removeAudio;
    private final boolean removeVideo;
    private final ListenerSet<Listener> listeners;
    private final MediaSource.Factory mediaSourceFactory;
    private final FrameProcessor.Factory frameProcessorFactory;
    private final Muxer.Factory muxerFactory;
    private final Looper looper;
    private final DebugViewProvider debugViewProvider;
    private final Clock clock;
    private final ExoPlayerAssetLoader exoPlayerAssetLoader;
    @Nullable
    private MuxerWrapper muxerWrapper;
    @Nullable
    private String outputPath;
    @Nullable
    private ParcelFileDescriptor outputParcelFileDescriptor;
    private boolean transformationInProgress;
    private boolean isCancelling;

    private Transformer(Context context, TransformationRequest transformationRequest, ImmutableList<Effect> videoEffects, boolean removeAudio, boolean removeVideo, ListenerSet<Listener> listeners, MediaSource.Factory mediaSourceFactory, Codec.DecoderFactory decoderFactory, Codec.EncoderFactory encoderFactory, FrameProcessor.Factory frameProcessorFactory, Muxer.Factory muxerFactory, Looper looper, DebugViewProvider debugViewProvider, Clock clock) {
        Assertions.checkState((!removeAudio || !removeVideo ? 1 : 0) != 0, (Object)"Audio and video cannot both be removed.");
        this.context = context;
        this.transformationRequest = transformationRequest;
        this.videoEffects = videoEffects;
        this.removeAudio = removeAudio;
        this.removeVideo = removeVideo;
        this.listeners = listeners;
        this.mediaSourceFactory = mediaSourceFactory;
        this.decoderFactory = decoderFactory;
        this.encoderFactory = encoderFactory;
        this.frameProcessorFactory = frameProcessorFactory;
        this.muxerFactory = muxerFactory;
        this.looper = looper;
        this.debugViewProvider = debugViewProvider;
        this.clock = clock;
        this.exoPlayerAssetLoader = new ExoPlayerAssetLoader(context, transformationRequest, videoEffects, removeAudio, removeVideo, mediaSourceFactory, decoderFactory, encoderFactory, frameProcessorFactory, looper, debugViewProvider, clock);
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    @Deprecated
    public void setListener(Listener listener) {
        this.verifyApplicationThread();
        this.listeners.clear();
        this.listeners.add((Object)listener);
    }

    public void addListener(Listener listener) {
        this.verifyApplicationThread();
        this.listeners.add((Object)listener);
    }

    public void removeListener(Listener listener) {
        this.verifyApplicationThread();
        this.listeners.remove((Object)listener);
    }

    public void removeAllListeners() {
        this.verifyApplicationThread();
        this.listeners.clear();
    }

    public void startTransformation(MediaItem mediaItem, String path) {
        this.outputPath = path;
        this.outputParcelFileDescriptor = null;
        this.startTransformationInternal(mediaItem);
    }

    @RequiresApi(value=26)
    public void startTransformation(MediaItem mediaItem, ParcelFileDescriptor parcelFileDescriptor) {
        this.outputParcelFileDescriptor = parcelFileDescriptor;
        this.outputPath = null;
        this.startTransformationInternal(mediaItem);
    }

    private void startTransformationInternal(MediaItem mediaItem) {
        MuxerWrapper muxerWrapper;
        if (!mediaItem.clippingConfiguration.equals((Object)MediaItem.ClippingConfiguration.UNSET) && this.transformationRequest.flattenForSlowMotion) {
            throw new IllegalArgumentException("Clipping is not supported when slow motion flattening is requested");
        }
        this.verifyApplicationThread();
        if (this.transformationInProgress) {
            throw new IllegalStateException("There is already a transformation in progress.");
        }
        this.transformationInProgress = true;
        ComponentListener componentListener = new ComponentListener(mediaItem, this.looper);
        this.muxerWrapper = muxerWrapper = new MuxerWrapper(this.outputPath, this.outputParcelFileDescriptor, this.muxerFactory, componentListener);
        FallbackListener fallbackListener = new FallbackListener(mediaItem, this.listeners, this.transformationRequest);
        this.exoPlayerAssetLoader.start(mediaItem, muxerWrapper, componentListener, fallbackListener, componentListener);
    }

    public Looper getApplicationLooper() {
        return this.looper;
    }

    public int getProgress(ProgressHolder progressHolder) {
        this.verifyApplicationThread();
        return this.exoPlayerAssetLoader.getProgress(progressHolder);
    }

    public void cancel() {
        this.verifyApplicationThread();
        this.isCancelling = true;
        try {
            this.releaseResources(true);
        }
        catch (TransformationException impossible) {
            throw new IllegalStateException(impossible);
        }
        this.isCancelling = false;
    }

    private void releaseResources(boolean forCancellation) throws TransformationException {
        this.transformationInProgress = false;
        this.exoPlayerAssetLoader.release();
        if (this.muxerWrapper != null) {
            try {
                this.muxerWrapper.release(forCancellation);
            }
            catch (Muxer.MuxerException e) {
                throw TransformationException.createForMuxer(e, 6001);
            }
            this.muxerWrapper = null;
        }
    }

    private void verifyApplicationThread() {
        if (Looper.myLooper() != this.looper) {
            throw new IllegalStateException("Transformer is accessed on the wrong thread.");
        }
    }

    private long getCurrentOutputFileCurrentSizeBytes() {
        long fileSize = -1L;
        if (this.outputPath != null) {
            fileSize = new File(this.outputPath).length();
        } else if (this.outputParcelFileDescriptor != null) {
            fileSize = this.outputParcelFileDescriptor.getStatSize();
        }
        if (fileSize <= 0L) {
            fileSize = -1L;
        }
        return fileSize;
    }

    static {
        ExoPlayerLibraryInfo.registerModule((String)"goog.exo.transformer");
    }

    private final class ComponentListener
    implements ExoPlayerAssetLoader.Listener,
    AsyncErrorListener {
        private final MediaItem mediaItem;
        private final Handler handler;

        public ComponentListener(MediaItem mediaItem, Looper looper) {
            this.mediaItem = mediaItem;
            this.handler = new Handler(looper);
        }

        @Override
        public void onError(Exception e) {
            TransformationException transformationException = e instanceof PlaybackException ? TransformationException.createForPlaybackException((PlaybackException)e) : TransformationException.createForUnexpected(e);
            this.handleTransformationException(transformationException);
        }

        @Override
        public void onEnded() {
            this.handleTransformationEnded(null);
        }

        @Override
        public void onTransformationException(TransformationException exception) {
            if (Looper.myLooper() == Transformer.this.looper) {
                this.handleTransformationException(exception);
            } else {
                this.handler.post(() -> this.handleTransformationException(exception));
            }
        }

        private void handleTransformationException(TransformationException transformationException) {
            if (Transformer.this.isCancelling) {
                Transformer.this.listeners.queueEvent(-1, listener -> listener.onTransformationError(this.mediaItem, transformationException));
                Transformer.this.listeners.flushEvents();
            } else {
                this.handleTransformationEnded(transformationException);
            }
        }

        private void handleTransformationEnded(@Nullable TransformationException exception) {
            MuxerWrapper muxerWrapper = Transformer.this.muxerWrapper;
            TransformationException resourceReleaseException = null;
            try {
                Transformer.this.releaseResources(false);
            }
            catch (TransformationException e) {
                resourceReleaseException = e;
            }
            catch (RuntimeException e) {
                resourceReleaseException = TransformationException.createForUnexpected(e);
            }
            if (exception == null) {
                exception = resourceReleaseException;
            }
            if (exception != null) {
                TransformationException finalException = exception;
                Transformer.this.listeners.queueEvent(-1, listener -> listener.onTransformationError(this.mediaItem, finalException));
            } else {
                TransformationResult result = new TransformationResult.Builder().setDurationMs(((MuxerWrapper)Assertions.checkNotNull((Object)muxerWrapper)).getDurationMs()).setAverageAudioBitrate(muxerWrapper.getTrackAverageBitrate(1)).setAverageVideoBitrate(muxerWrapper.getTrackAverageBitrate(2)).setVideoFrameCount(muxerWrapper.getTrackSampleCount(2)).setFileSizeBytes(Transformer.this.getCurrentOutputFileCurrentSizeBytes()).build();
                Transformer.this.listeners.queueEvent(-1, listener -> listener.onTransformationCompleted(this.mediaItem, result));
            }
            Transformer.this.listeners.flushEvents();
        }
    }

    static interface AsyncErrorListener {
        public void onTransformationException(TransformationException var1);
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface ProgressState {
    }

    public static interface Listener {
        @Deprecated
        default public void onTransformationCompleted(MediaItem inputMediaItem) {
        }

        default public void onTransformationCompleted(MediaItem inputMediaItem, TransformationResult transformationResult) {
            this.onTransformationCompleted(inputMediaItem);
        }

        @Deprecated
        default public void onTransformationError(MediaItem inputMediaItem, Exception exception) {
            this.onTransformationError(inputMediaItem, (TransformationException)exception);
        }

        default public void onTransformationError(MediaItem inputMediaItem, TransformationException exception) {
        }

        default public void onFallbackApplied(MediaItem inputMediaItem, TransformationRequest originalTransformationRequest, TransformationRequest fallbackTransformationRequest) {
        }
    }

    public static final class Builder {
        private final Context context;
        private TransformationRequest transformationRequest;
        private ImmutableList<Effect> videoEffects;
        private boolean removeAudio;
        private boolean removeVideo;
        private ListenerSet<Listener> listeners;
        private // Could not load outer class - annotation placement on inner may be incorrect
         @MonotonicNonNull MediaSource.Factory mediaSourceFactory;
        private Codec.DecoderFactory decoderFactory;
        private Codec.EncoderFactory encoderFactory;
        private FrameProcessor.Factory frameProcessorFactory;
        private Muxer.Factory muxerFactory;
        private Looper looper;
        private DebugViewProvider debugViewProvider;
        private Clock clock;

        public Builder(Context context) {
            this.context = context.getApplicationContext();
            this.transformationRequest = new TransformationRequest.Builder().build();
            this.videoEffects = ImmutableList.of();
            this.decoderFactory = new DefaultDecoderFactory(this.context);
            this.encoderFactory = new DefaultEncoderFactory.Builder(this.context).build();
            this.frameProcessorFactory = new GlEffectsFrameProcessor.Factory();
            this.muxerFactory = new DefaultMuxer.Factory();
            this.looper = Util.getCurrentOrMainLooper();
            this.debugViewProvider = DebugViewProvider.NONE;
            this.clock = Clock.DEFAULT;
            this.listeners = new ListenerSet(this.looper, this.clock, (listener, flags) -> {});
        }

        private Builder(Transformer transformer) {
            this.context = transformer.context;
            this.transformationRequest = transformer.transformationRequest;
            this.videoEffects = transformer.videoEffects;
            this.removeAudio = transformer.removeAudio;
            this.removeVideo = transformer.removeVideo;
            this.listeners = transformer.listeners;
            this.mediaSourceFactory = transformer.mediaSourceFactory;
            this.decoderFactory = transformer.decoderFactory;
            this.encoderFactory = transformer.encoderFactory;
            this.frameProcessorFactory = transformer.frameProcessorFactory;
            this.muxerFactory = transformer.muxerFactory;
            this.looper = transformer.looper;
            this.debugViewProvider = transformer.debugViewProvider;
            this.clock = transformer.clock;
        }

        @CanIgnoreReturnValue
        public Builder setTransformationRequest(TransformationRequest transformationRequest) {
            this.transformationRequest = transformationRequest;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setVideoEffects(List<Effect> effects) {
            this.videoEffects = ImmutableList.copyOf(effects);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setRemoveAudio(boolean removeAudio) {
            this.removeAudio = removeAudio;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setRemoveVideo(boolean removeVideo) {
            this.removeVideo = removeVideo;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder setFlattenForSlowMotion(boolean flattenForSlowMotion) {
            this.transformationRequest = this.transformationRequest.buildUpon().setFlattenForSlowMotion(flattenForSlowMotion).build();
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder setListener(Listener listener) {
            this.listeners.clear();
            this.listeners.add((Object)listener);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addListener(Listener listener) {
            this.listeners.add((Object)listener);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder removeListener(Listener listener) {
            this.listeners.remove((Object)listener);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder removeAllListeners() {
            this.listeners.clear();
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMediaSourceFactory(MediaSource.Factory mediaSourceFactory) {
            this.mediaSourceFactory = mediaSourceFactory;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setDecoderFactory(Codec.DecoderFactory decoderFactory) {
            this.decoderFactory = decoderFactory;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setEncoderFactory(Codec.EncoderFactory encoderFactory) {
            this.encoderFactory = encoderFactory;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setFrameProcessorFactory(FrameProcessor.Factory frameProcessorFactory) {
            this.frameProcessorFactory = frameProcessorFactory;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMuxerFactory(Muxer.Factory muxerFactory) {
            this.muxerFactory = muxerFactory;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setLooper(Looper looper) {
            this.looper = looper;
            this.listeners = this.listeners.copy(looper, (listener, flags) -> {});
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setDebugViewProvider(DebugViewProvider debugViewProvider) {
            this.debugViewProvider = debugViewProvider;
            return this;
        }

        @CanIgnoreReturnValue
        @VisibleForTesting
        Builder setClock(Clock clock) {
            this.clock = clock;
            this.listeners = this.listeners.copy(this.looper, clock, (listener, flags) -> {});
            return this;
        }

        public Transformer build() {
            Assertions.checkNotNull((Object)this.context);
            if (this.transformationRequest.audioMimeType != null) {
                this.checkSampleMimeType(this.transformationRequest.audioMimeType);
            }
            if (this.transformationRequest.videoMimeType != null) {
                this.checkSampleMimeType(this.transformationRequest.videoMimeType);
            }
            if (this.mediaSourceFactory == null) {
                DefaultExtractorsFactory defaultExtractorsFactory = new DefaultExtractorsFactory();
                if (this.transformationRequest.flattenForSlowMotion) {
                    defaultExtractorsFactory.setMp4ExtractorFlags(4);
                }
                this.mediaSourceFactory = new DefaultMediaSourceFactory(this.context, (ExtractorsFactory)defaultExtractorsFactory);
            }
            return new Transformer(this.context, this.transformationRequest, this.videoEffects, this.removeAudio, this.removeVideo, this.listeners, this.mediaSourceFactory, this.decoderFactory, this.encoderFactory, this.frameProcessorFactory, this.muxerFactory, this.looper, this.debugViewProvider, this.clock);
        }

        private void checkSampleMimeType(String sampleMimeType) {
            Assertions.checkState((boolean)this.muxerFactory.getSupportedSampleMimeTypes(MimeTypes.getTrackType((String)sampleMimeType)).contains((Object)sampleMimeType), (Object)("Unsupported sample MIME type " + sampleMimeType));
        }
    }
}

