/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.transformer.BaseSamplePipeline;
import com.google.android.exoplayer2.transformer.FallbackListener;
import com.google.android.exoplayer2.transformer.MuxerWrapper;
import com.google.android.exoplayer2.transformer.TransformationRequest;

final class PassthroughSamplePipeline
extends BaseSamplePipeline {
    private final DecoderInputBuffer buffer;
    private final Format format;
    private boolean hasPendingBuffer;

    public PassthroughSamplePipeline(Format format, long streamOffsetUs, long streamStartPositionUs, TransformationRequest transformationRequest, MuxerWrapper muxerWrapper, FallbackListener fallbackListener) {
        super(format, streamOffsetUs, streamStartPositionUs, transformationRequest.flattenForSlowMotion, muxerWrapper);
        this.format = format;
        this.buffer = new DecoderInputBuffer(2);
        fallbackListener.onTransformationRequestFinalized(transformationRequest);
    }

    @Override
    public void release() {
    }

    @Override
    @Nullable
    protected DecoderInputBuffer dequeueInputBufferInternal() {
        return this.hasPendingBuffer ? null : this.buffer;
    }

    @Override
    protected void queueInputBufferInternal() {
        if (this.buffer.data != null && this.buffer.data.hasRemaining()) {
            this.hasPendingBuffer = true;
        }
    }

    @Override
    protected boolean processDataUpToMuxer() {
        return false;
    }

    @Override
    protected Format getMuxerInputFormat() {
        return this.format;
    }

    @Override
    @Nullable
    protected DecoderInputBuffer getMuxerInputBuffer() {
        return this.hasPendingBuffer ? this.buffer : null;
    }

    @Override
    protected void releaseMuxerInputBuffer() {
        this.buffer.clear();
        this.hasPendingBuffer = false;
    }

    @Override
    protected boolean isMuxerInputEnded() {
        return this.buffer.isEndOfStream();
    }
}

