/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.content.Context;
import android.media.MediaCodec;
import android.util.Size;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.transformer.Codec;
import com.google.android.exoplayer2.transformer.EncoderCompatibilityTransformation;
import com.google.android.exoplayer2.transformer.FallbackListener;
import com.google.android.exoplayer2.transformer.FrameProcessingException;
import com.google.android.exoplayer2.transformer.FrameProcessorChain;
import com.google.android.exoplayer2.transformer.GlEffect;
import com.google.android.exoplayer2.transformer.Presentation;
import com.google.android.exoplayer2.transformer.SamplePipeline;
import com.google.android.exoplayer2.transformer.ScaleToFitTransformation;
import com.google.android.exoplayer2.transformer.TransformationException;
import com.google.android.exoplayer2.transformer.TransformationRequest;
import com.google.android.exoplayer2.transformer.Transformer;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.dataflow.qual.Pure;

final class VideoTranscodingSamplePipeline
implements SamplePipeline {
    private final int outputRotationDegrees;
    private final int maxPendingFrameCount;
    private final DecoderInputBuffer decoderInputBuffer = new DecoderInputBuffer(0);
    private final Codec decoder;
    private final ArrayList<Long> decodeOnlyPresentationTimestamps;
    private final FrameProcessorChain frameProcessorChain;
    private final Codec encoder;
    private final DecoderInputBuffer encoderOutputBuffer = new DecoderInputBuffer(0);
    private boolean signaledEndOfStreamToEncoder;

    public VideoTranscodingSamplePipeline(Context context, Format inputFormat, long streamOffsetUs, TransformationRequest transformationRequest, ImmutableList<GlEffect> effects, Codec.DecoderFactory decoderFactory, Codec.EncoderFactory encoderFactory, List<String> allowedOutputMimeTypes, FallbackListener fallbackListener, FrameProcessorChain.Listener frameProcessorChainListener, Transformer.DebugViewProvider debugViewProvider) throws TransformationException {
        this.decodeOnlyPresentationTimestamps = new ArrayList();
        int decodedWidth = inputFormat.rotationDegrees % 180 == 0 ? inputFormat.width : inputFormat.height;
        int decodedHeight = inputFormat.rotationDegrees % 180 == 0 ? inputFormat.height : inputFormat.width;
        ImmutableList.Builder effectsListBuilder = new ImmutableList.Builder().addAll(effects);
        if (transformationRequest.scaleX != 1.0f || transformationRequest.scaleY != 1.0f || transformationRequest.rotationDegrees != 0.0f) {
            effectsListBuilder.add((Object)new ScaleToFitTransformation.Builder().setScale(transformationRequest.scaleX, transformationRequest.scaleY).setRotationDegrees(transformationRequest.rotationDegrees).build());
        }
        if (transformationRequest.outputHeight != -1) {
            effectsListBuilder.add((Object)new Presentation.Builder().setResolution(transformationRequest.outputHeight).build());
        }
        EncoderCompatibilityTransformation encoderCompatibilityTransformation = new EncoderCompatibilityTransformation();
        effectsListBuilder.add((Object)encoderCompatibilityTransformation);
        try {
            this.frameProcessorChain = FrameProcessorChain.create(context, frameProcessorChainListener, inputFormat.pixelWidthHeightRatio, decodedWidth, decodedHeight, streamOffsetUs, (List<GlEffect>)effectsListBuilder.build(), transformationRequest.enableHdrEditing);
        }
        catch (FrameProcessingException e) {
            throw TransformationException.createForFrameProcessorChain(e, 5001);
        }
        Size requestedEncoderSize = this.frameProcessorChain.getOutputSize();
        this.outputRotationDegrees = encoderCompatibilityTransformation.getOutputRotationDegrees();
        Format requestedEncoderFormat = new Format.Builder().setWidth(requestedEncoderSize.getWidth()).setHeight(requestedEncoderSize.getHeight()).setRotationDegrees(0).setFrameRate(inputFormat.frameRate).setSampleMimeType(transformationRequest.videoMimeType != null ? transformationRequest.videoMimeType : inputFormat.sampleMimeType).build();
        this.encoder = encoderFactory.createForVideoEncoding(requestedEncoderFormat, allowedOutputMimeTypes);
        Format encoderSupportedFormat = this.encoder.getConfigurationFormat();
        fallbackListener.onTransformationRequestFinalized(VideoTranscodingSamplePipeline.createFallbackTransformationRequest(transformationRequest, this.outputRotationDegrees == 0, requestedEncoderFormat, encoderSupportedFormat));
        this.frameProcessorChain.setOutputSurface(this.encoder.getInputSurface(), encoderSupportedFormat.width, encoderSupportedFormat.height, debugViewProvider.getDebugPreviewSurfaceView(encoderSupportedFormat.width, encoderSupportedFormat.height));
        this.decoder = decoderFactory.createForVideoDecoding(inputFormat, this.frameProcessorChain.getInputSurface(), transformationRequest.enableRequestSdrToneMapping);
        this.maxPendingFrameCount = this.decoder.getMaxPendingFrameCount();
    }

    @Override
    @Nullable
    public DecoderInputBuffer dequeueInputBuffer() throws TransformationException {
        return this.decoder.maybeDequeueInputBuffer(this.decoderInputBuffer) ? this.decoderInputBuffer : null;
    }

    @Override
    public void queueInputBuffer() throws TransformationException {
        if (this.decoderInputBuffer.isDecodeOnly()) {
            this.decodeOnlyPresentationTimestamps.add(this.decoderInputBuffer.timeUs);
        }
        this.decoder.queueInputBuffer(this.decoderInputBuffer);
    }

    @Override
    public boolean processData() throws TransformationException {
        if (this.frameProcessorChain.isEnded()) {
            if (!this.signaledEndOfStreamToEncoder) {
                this.encoder.signalEndOfInputStream();
                this.signaledEndOfStreamToEncoder = true;
            }
            return false;
        }
        if (this.decoder.isEnded()) {
            return false;
        }
        boolean processedData = false;
        while (this.maybeProcessDecoderOutput()) {
            processedData = true;
        }
        if (this.decoder.isEnded()) {
            this.frameProcessorChain.signalEndOfInputStream();
        }
        return processedData;
    }

    @Override
    @Nullable
    public Format getOutputFormat() throws TransformationException {
        Format format = this.encoder.getOutputFormat();
        return format == null ? null : format.buildUpon().setRotationDegrees(this.outputRotationDegrees).build();
    }

    @Override
    @Nullable
    public DecoderInputBuffer getOutputBuffer() throws TransformationException {
        this.encoderOutputBuffer.data = this.encoder.getOutputBuffer();
        if (this.encoderOutputBuffer.data == null) {
            return null;
        }
        MediaCodec.BufferInfo bufferInfo = (MediaCodec.BufferInfo)Assertions.checkNotNull((Object)this.encoder.getOutputBufferInfo());
        this.encoderOutputBuffer.timeUs = bufferInfo.presentationTimeUs;
        this.encoderOutputBuffer.setFlags(bufferInfo.flags);
        return this.encoderOutputBuffer;
    }

    @Override
    public void releaseOutputBuffer() throws TransformationException {
        this.encoder.releaseOutputBuffer(false);
    }

    @Override
    public boolean isEnded() {
        return this.encoder.isEnded();
    }

    @Override
    public void release() {
        this.frameProcessorChain.release();
        this.decoder.release();
        this.encoder.release();
    }

    @Pure
    private static TransformationRequest createFallbackTransformationRequest(TransformationRequest transformationRequest, boolean hasOutputFormatRotation, Format requestedFormat, Format supportedFormat) {
        if (Util.areEqual((Object)requestedFormat.sampleMimeType, (Object)supportedFormat.sampleMimeType) && (hasOutputFormatRotation ? requestedFormat.width == supportedFormat.width : requestedFormat.height == supportedFormat.height)) {
            return transformationRequest;
        }
        return transformationRequest.buildUpon().setVideoMimeType(supportedFormat.sampleMimeType).setResolution(hasOutputFormatRotation ? requestedFormat.width : requestedFormat.height).build();
    }

    private boolean maybeProcessDecoderOutput() throws TransformationException {
        MediaCodec.BufferInfo decoderOutputBufferInfo = this.decoder.getOutputBufferInfo();
        if (decoderOutputBufferInfo == null) {
            return false;
        }
        if (this.isDecodeOnlyBuffer(decoderOutputBufferInfo.presentationTimeUs)) {
            this.decoder.releaseOutputBuffer(false);
            return true;
        }
        if (this.maxPendingFrameCount != Integer.MAX_VALUE && this.frameProcessorChain.getPendingFrameCount() == this.maxPendingFrameCount) {
            return false;
        }
        this.frameProcessorChain.registerInputFrame();
        this.decoder.releaseOutputBuffer(true);
        return true;
    }

    private boolean isDecodeOnlyBuffer(long presentationTimeUs) {
        int size = this.decodeOnlyPresentationTimestamps.size();
        for (int i = 0; i < size; ++i) {
            if (this.decodeOnlyPresentationTimestamps.get(i) != presentationTimeUs) continue;
            this.decodeOnlyPresentationTimestamps.remove(i);
            return true;
        }
        return false;
    }
}

