/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.annotation.SuppressLint;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.util.Assertions;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

public final class VideoEncoderSettings {
    public static final int NO_VALUE = -1;
    public static final int DEFAULT_COLOR_PROFILE = 2130708361;
    public static final float DEFAULT_I_FRAME_INTERVAL_SECONDS = 1.0f;
    public static final VideoEncoderSettings DEFAULT = new Builder().build();
    public final int bitrate;
    public final int bitrateMode;
    public final int profile;
    public final int level;
    public final int colorProfile;
    public final float iFrameIntervalSeconds;
    public final int operatingRate;
    public final int priority;

    private VideoEncoderSettings(int bitrate, int bitrateMode, int profile, int level, int colorProfile, float iFrameIntervalSeconds, int operatingRate, int priority) {
        this.bitrate = bitrate;
        this.bitrateMode = bitrateMode;
        this.profile = profile;
        this.level = level;
        this.colorProfile = colorProfile;
        this.iFrameIntervalSeconds = iFrameIntervalSeconds;
        this.operatingRate = operatingRate;
        this.priority = priority;
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VideoEncoderSettings)) {
            return false;
        }
        VideoEncoderSettings that = (VideoEncoderSettings)o;
        return this.bitrate == that.bitrate && this.bitrateMode == that.bitrateMode && this.profile == that.profile && this.level == that.level && this.colorProfile == that.colorProfile && this.iFrameIntervalSeconds == that.iFrameIntervalSeconds && this.operatingRate == that.operatingRate && this.priority == that.priority;
    }

    public int hashCode() {
        int result = 7;
        result = 31 * result + this.bitrate;
        result = 31 * result + this.bitrateMode;
        result = 31 * result + this.profile;
        result = 31 * result + this.level;
        result = 31 * result + this.colorProfile;
        result = 31 * result + Float.floatToIntBits(this.iFrameIntervalSeconds);
        result = 31 * result + this.operatingRate;
        result = 31 * result + this.priority;
        return result;
    }

    public static final class Builder {
        private int bitrate;
        private int bitrateMode;
        private int profile;
        private int level;
        private int colorProfile;
        private float iFrameIntervalSeconds;
        private int operatingRate;
        private int priority;

        public Builder() {
            this.bitrate = -1;
            this.bitrateMode = 1;
            this.profile = -1;
            this.level = -1;
            this.colorProfile = 2130708361;
            this.iFrameIntervalSeconds = 1.0f;
            this.operatingRate = -1;
            this.priority = -1;
        }

        private Builder(VideoEncoderSettings videoEncoderSettings) {
            this.bitrate = videoEncoderSettings.bitrate;
            this.bitrateMode = videoEncoderSettings.bitrateMode;
            this.profile = videoEncoderSettings.profile;
            this.level = videoEncoderSettings.level;
            this.colorProfile = videoEncoderSettings.colorProfile;
            this.iFrameIntervalSeconds = videoEncoderSettings.iFrameIntervalSeconds;
            this.operatingRate = videoEncoderSettings.operatingRate;
            this.priority = videoEncoderSettings.priority;
        }

        public Builder setBitrate(int bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public Builder setBitrateMode(int bitrateMode) {
            Assertions.checkArgument((bitrateMode == 1 || bitrateMode == 2 ? 1 : 0) != 0);
            this.bitrateMode = bitrateMode;
            return this;
        }

        public Builder setEncodingProfileLevel(int encodingProfile, int encodingLevel) {
            this.profile = encodingProfile;
            this.level = encodingLevel;
            return this;
        }

        public Builder setColorProfile(int colorProfile) {
            this.colorProfile = colorProfile;
            return this;
        }

        public Builder setiFrameIntervalSeconds(float iFrameIntervalSeconds) {
            this.iFrameIntervalSeconds = iFrameIntervalSeconds;
            return this;
        }

        @VisibleForTesting
        public Builder setEncoderPerformanceParameters(int operatingRate, int priority) {
            this.operatingRate = operatingRate;
            this.priority = priority;
            return this;
        }

        public VideoEncoderSettings build() {
            return new VideoEncoderSettings(this.bitrate, this.bitrateMode, this.profile, this.level, this.colorProfile, this.iFrameIntervalSeconds, this.operatingRate, this.priority);
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    @SuppressLint(value={"InlinedApi"})
    public static @interface BitrateMode {
    }
}

