/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.transformer.FallbackListener;
import com.google.android.exoplayer2.transformer.SamplePipeline;
import com.google.android.exoplayer2.transformer.TransformationRequest;

final class PassthroughSamplePipeline
implements SamplePipeline {
    private final DecoderInputBuffer buffer;
    private final Format format;
    private boolean hasPendingBuffer;

    public PassthroughSamplePipeline(Format format, TransformationRequest transformationRequest, FallbackListener fallbackListener) {
        this.format = format;
        this.buffer = new DecoderInputBuffer(2);
        this.hasPendingBuffer = false;
        fallbackListener.onTransformationRequestFinalized(transformationRequest);
    }

    @Override
    @Nullable
    public DecoderInputBuffer dequeueInputBuffer() {
        return this.hasPendingBuffer ? null : this.buffer;
    }

    @Override
    public void queueInputBuffer() {
        this.hasPendingBuffer = true;
    }

    @Override
    public boolean processData() {
        return false;
    }

    @Override
    public Format getOutputFormat() {
        return this.format;
    }

    @Override
    @Nullable
    public DecoderInputBuffer getOutputBuffer() {
        return this.hasPendingBuffer ? this.buffer : null;
    }

    @Override
    public void releaseOutputBuffer() {
        this.buffer.clear();
        this.hasPendingBuffer = false;
    }

    @Override
    public boolean isEnded() {
        return this.buffer.isEndOfStream();
    }

    @Override
    public void release() {
    }
}

