/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.annotation.SuppressLint;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.os.ParcelFileDescriptor;
import android.util.SparseLongArray;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.transformer.Muxer;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MediaFormatUtil;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.List;

final class FrameworkMuxer
implements Muxer {
    private static final ImmutableMap<String, ImmutableList<String>> SUPPORTED_CONTAINER_TO_VIDEO_SAMPLE_MIME_TYPES = ImmutableMap.of((Object)"video/mp4", (Object)(Util.SDK_INT >= 24 ? ImmutableList.of((Object)"video/3gpp", (Object)"video/avc", (Object)"video/mp4v-es", (Object)"video/hevc") : ImmutableList.of((Object)"video/3gpp", (Object)"video/avc", (Object)"video/mp4v-es")), (Object)"video/webm", (Object)(Util.SDK_INT >= 24 ? ImmutableList.of((Object)"video/x-vnd.on2.vp8", (Object)"video/x-vnd.on2.vp9") : ImmutableList.of((Object)"video/x-vnd.on2.vp8")));
    private static final ImmutableMap<String, ImmutableList<String>> SUPPORTED_CONTAINER_TO_AUDIO_SAMPLE_MIME_TYPES = ImmutableMap.of((Object)"video/mp4", (Object)ImmutableList.of((Object)"audio/mp4a-latm", (Object)"audio/3gpp", (Object)"audio/amr-wb"), (Object)"video/webm", (Object)ImmutableList.of((Object)"audio/vorbis"));
    private final MediaMuxer mediaMuxer;
    private final MediaCodec.BufferInfo bufferInfo;
    private final SparseLongArray trackIndexToLastPresentationTimeUs;
    private boolean isStarted;

    private FrameworkMuxer(MediaMuxer mediaMuxer) {
        this.mediaMuxer = mediaMuxer;
        this.bufferInfo = new MediaCodec.BufferInfo();
        this.trackIndexToLastPresentationTimeUs = new SparseLongArray();
    }

    @Override
    public int addTrack(Format format) throws Muxer.MuxerException {
        int trackIndex;
        MediaFormat mediaFormat;
        String sampleMimeType = (String)Assertions.checkNotNull((Object)format.sampleMimeType);
        if (MimeTypes.isAudio((String)sampleMimeType)) {
            mediaFormat = MediaFormat.createAudioFormat((String)((String)Util.castNonNull((Object)sampleMimeType)), (int)format.sampleRate, (int)format.channelCount);
        } else {
            mediaFormat = MediaFormat.createVideoFormat((String)((String)Util.castNonNull((Object)sampleMimeType)), (int)format.width, (int)format.height);
            try {
                this.mediaMuxer.setOrientationHint(format.rotationDegrees);
            }
            catch (RuntimeException e) {
                throw new Muxer.MuxerException("Failed to set orientation hint with rotationDegrees=" + format.rotationDegrees, e);
            }
        }
        MediaFormatUtil.setCsdBuffers((MediaFormat)mediaFormat, (List)format.initializationData);
        try {
            trackIndex = this.mediaMuxer.addTrack(mediaFormat);
        }
        catch (RuntimeException e) {
            throw new Muxer.MuxerException("Failed to add track with format=" + format, e);
        }
        return trackIndex;
    }

    @Override
    @SuppressLint(value={"WrongConstant"})
    public void writeSampleData(int trackIndex, ByteBuffer data, boolean isKeyFrame, long presentationTimeUs) throws Muxer.MuxerException {
        if (!this.isStarted) {
            this.isStarted = true;
            try {
                this.mediaMuxer.start();
            }
            catch (RuntimeException e) {
                throw new Muxer.MuxerException("Failed to start the muxer", e);
            }
        }
        int offset = data.position();
        int size = data.limit() - offset;
        int flags = isKeyFrame ? 1 : 0;
        this.bufferInfo.set(offset, size, presentationTimeUs, flags);
        long lastSamplePresentationTimeUs = this.trackIndexToLastPresentationTimeUs.get(trackIndex);
        try {
            Assertions.checkState((Util.SDK_INT > 24 || presentationTimeUs >= lastSamplePresentationTimeUs ? 1 : 0) != 0, (Object)("Samples not in presentation order (" + presentationTimeUs + " < " + lastSamplePresentationTimeUs + ") unsupported on this API version"));
            this.trackIndexToLastPresentationTimeUs.put(trackIndex, presentationTimeUs);
            this.mediaMuxer.writeSampleData(trackIndex, data, this.bufferInfo);
        }
        catch (RuntimeException e) {
            throw new Muxer.MuxerException("Failed to write sample for trackIndex=" + trackIndex + ", presentationTimeUs=" + presentationTimeUs + ", size=" + size, e);
        }
    }

    @Override
    public void release(boolean forCancellation) throws Muxer.MuxerException {
        if (!this.isStarted) {
            this.mediaMuxer.release();
            return;
        }
        this.isStarted = false;
        try {
            FrameworkMuxer.stopMuxer(this.mediaMuxer);
        }
        catch (RuntimeException e) {
            if (!forCancellation) {
                throw new Muxer.MuxerException("Failed to stop the muxer", e);
            }
        }
        finally {
            this.mediaMuxer.release();
        }
    }

    private static int mimeTypeToMuxerOutputFormat(String mimeType) {
        if (mimeType.equals("video/mp4")) {
            return 0;
        }
        if (Util.SDK_INT >= 21 && mimeType.equals("video/webm")) {
            return 1;
        }
        throw new IllegalArgumentException("Unsupported output MIME type: " + mimeType);
    }

    @SuppressLint(value={"PrivateApi"})
    private static void stopMuxer(MediaMuxer mediaMuxer) {
        try {
            mediaMuxer.stop();
        }
        catch (RuntimeException e) {
            if (Util.SDK_INT < 30) {
                try {
                    Field muxerStoppedStateField = MediaMuxer.class.getDeclaredField("MUXER_STATE_STOPPED");
                    muxerStoppedStateField.setAccessible(true);
                    int muxerStoppedState = (Integer)Util.castNonNull((Object)((Integer)muxerStoppedStateField.get(mediaMuxer)));
                    Field muxerStateField = MediaMuxer.class.getDeclaredField("mState");
                    muxerStateField.setAccessible(true);
                    muxerStateField.set(mediaMuxer, muxerStoppedState);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    public static final class Factory
    implements Muxer.Factory {
        @Override
        public FrameworkMuxer create(String path, String outputMimeType) throws IOException {
            MediaMuxer mediaMuxer = new MediaMuxer(path, FrameworkMuxer.mimeTypeToMuxerOutputFormat(outputMimeType));
            return new FrameworkMuxer(mediaMuxer);
        }

        @Override
        @RequiresApi(value=26)
        public FrameworkMuxer create(ParcelFileDescriptor parcelFileDescriptor, String outputMimeType) throws IOException {
            MediaMuxer mediaMuxer = new MediaMuxer(parcelFileDescriptor.getFileDescriptor(), FrameworkMuxer.mimeTypeToMuxerOutputFormat(outputMimeType));
            return new FrameworkMuxer(mediaMuxer);
        }

        @Override
        public boolean supportsOutputMimeType(String mimeType) {
            try {
                FrameworkMuxer.mimeTypeToMuxerOutputFormat(mimeType);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            return true;
        }

        @Override
        public boolean supportsSampleMimeType(@Nullable String sampleMimeType, String containerMimeType) {
            return this.getSupportedSampleMimeTypes(MimeTypes.getTrackType((String)sampleMimeType), containerMimeType).contains((Object)sampleMimeType);
        }

        @Override
        public ImmutableList<String> getSupportedSampleMimeTypes(int trackType, String containerMimeType) {
            if (trackType == 2) {
                return (ImmutableList)SUPPORTED_CONTAINER_TO_VIDEO_SAMPLE_MIME_TYPES.getOrDefault((Object)containerMimeType, (Object)ImmutableList.of());
            }
            if (trackType == 1) {
                return (ImmutableList)SUPPORTED_CONTAINER_TO_AUDIO_SAMPLE_MIME_TYPES.getOrDefault((Object)containerMimeType, (Object)ImmutableList.of());
            }
            return ImmutableList.of();
        }
    }
}

