/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.util.Size;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.exoplayer2.transformer.ExternalTextureProcessor;
import com.google.android.exoplayer2.transformer.FrameProcessingException;
import com.google.android.exoplayer2.transformer.GlEffect;
import com.google.android.exoplayer2.transformer.GlMatrixTransformation;
import com.google.android.exoplayer2.transformer.MatrixTransformationProcessor;
import com.google.android.exoplayer2.transformer.ScaleToFitTransformation;
import com.google.android.exoplayer2.transformer.SingleFrameGlTextureProcessor;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.GlUtil;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

final class FrameProcessorChain {
    private static final String TAG = "FrameProcessorChain";
    private static final String THREAD_NAME = "Transformer:FrameProcessorChain";
    private static final long RELEASE_WAIT_TIME_MS = 100L;
    private final boolean enableExperimentalHdrEditing;
    private final EGLDisplay eglDisplay;
    private final EGLContext eglContext;
    private final ExecutorService singleThreadExecutorService;
    private final long streamOffsetUs;
    private final ConcurrentLinkedQueue<Future<?>> futures;
    private final AtomicInteger pendingFrameCount;
    private final Surface inputSurface;
    private final SurfaceTexture inputSurfaceTexture;
    private final float[] textureTransformMatrix;
    private final ImmutableList<SingleFrameGlTextureProcessor> textureProcessors;
    private final int[] framebuffers;
    private final Listener listener;
    private final AtomicBoolean stopProcessing;
    private int outputWidth;
    private int outputHeight;
    private @MonotonicNonNull Surface outputSurface;
    private @MonotonicNonNull EGLSurface outputEglSurface;
    private @MonotonicNonNull SurfaceViewWrapper debugSurfaceViewWrapper;
    private boolean inputStreamEnded;

    public static FrameProcessorChain create(Context context, Listener listener, float pixelWidthHeightRatio, int inputWidth, int inputHeight, long streamOffsetUs, List<GlEffect> effects, boolean enableExperimentalHdrEditing) throws FrameProcessingException {
        Assertions.checkArgument((inputWidth > 0 ? 1 : 0) != 0, (Object)"inputWidth must be positive");
        Assertions.checkArgument((inputHeight > 0 ? 1 : 0) != 0, (Object)"inputHeight must be positive");
        ExecutorService singleThreadExecutorService = Util.newSingleThreadExecutor((String)THREAD_NAME);
        try {
            return singleThreadExecutorService.submit(() -> FrameProcessorChain.createOpenGlObjectsAndFrameProcessorChain(context, listener, pixelWidthHeightRatio, inputWidth, inputHeight, streamOffsetUs, effects, enableExperimentalHdrEditing, singleThreadExecutorService)).get();
        }
        catch (ExecutionException e) {
            throw new FrameProcessingException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new FrameProcessingException(e);
        }
    }

    @WorkerThread
    private static FrameProcessorChain createOpenGlObjectsAndFrameProcessorChain(Context context, Listener listener, float pixelWidthHeightRatio, int inputWidth, int inputHeight, long streamOffsetUs, List<GlEffect> effects, boolean enableExperimentalHdrEditing, ExecutorService singleThreadExecutorService) throws IOException {
        EGLContext eglContext;
        Assertions.checkState((boolean)Thread.currentThread().getName().equals(THREAD_NAME));
        EGLDisplay eglDisplay = GlUtil.createEglDisplay();
        EGLContext eGLContext = eglContext = enableExperimentalHdrEditing ? GlUtil.createEglContextEs3Rgba1010102((EGLDisplay)eglDisplay) : GlUtil.createEglContext((EGLDisplay)eglDisplay);
        if (GlUtil.isSurfacelessContextExtensionSupported()) {
            GlUtil.focusEglSurface((EGLDisplay)eglDisplay, (EGLContext)eglContext, (EGLSurface)EGL14.EGL_NO_SURFACE, (int)1, (int)1);
        } else if (enableExperimentalHdrEditing) {
            GlUtil.focusPlaceholderEglSurfaceBt2020Pq((EGLContext)eglContext, (EGLDisplay)eglDisplay);
        } else {
            GlUtil.focusPlaceholderEglSurface((EGLContext)eglContext, (EGLDisplay)eglDisplay);
        }
        ExternalTextureProcessor externalTextureProcessor = new ExternalTextureProcessor(enableExperimentalHdrEditing);
        ImmutableList<SingleFrameGlTextureProcessor> textureProcessors = FrameProcessorChain.getTextureProcessors(externalTextureProcessor, pixelWidthHeightRatio, effects);
        int inputExternalTexId = GlUtil.createExternalTexture();
        externalTextureProcessor.initialize(context, inputExternalTexId, inputWidth, inputHeight);
        int[] framebuffers = new int[textureProcessors.size() - 1];
        Size inputSize = externalTextureProcessor.getOutputSize();
        for (int i = 1; i < textureProcessors.size(); ++i) {
            int inputTexId = GlUtil.createTexture((int)inputSize.getWidth(), (int)inputSize.getHeight());
            framebuffers[i - 1] = GlUtil.createFboForTexture((int)inputTexId);
            SingleFrameGlTextureProcessor textureProcessor = (SingleFrameGlTextureProcessor)textureProcessors.get(i);
            textureProcessor.initialize(context, inputTexId, inputSize.getWidth(), inputSize.getHeight());
            inputSize = textureProcessor.getOutputSize();
        }
        return new FrameProcessorChain(eglDisplay, eglContext, singleThreadExecutorService, inputExternalTexId, streamOffsetUs, framebuffers, textureProcessors, listener, enableExperimentalHdrEditing);
    }

    private static ImmutableList<SingleFrameGlTextureProcessor> getTextureProcessors(ExternalTextureProcessor externalTextureProcessor, float pixelWidthHeightRatio, List<GlEffect> effects) {
        ImmutableList.Builder textureProcessors = new ImmutableList.Builder().add((Object)externalTextureProcessor);
        ImmutableList.Builder matrixTransformationListBuilder = new ImmutableList.Builder();
        if (pixelWidthHeightRatio > 1.0f) {
            matrixTransformationListBuilder.add((Object)new ScaleToFitTransformation.Builder().setScale(pixelWidthHeightRatio, 1.0f).build());
        } else if (pixelWidthHeightRatio < 1.0f) {
            matrixTransformationListBuilder.add((Object)new ScaleToFitTransformation.Builder().setScale(1.0f, 1.0f / pixelWidthHeightRatio).build());
        }
        for (int i = 0; i < effects.size(); ++i) {
            GlEffect effect = effects.get(i);
            if (effect instanceof GlMatrixTransformation) {
                matrixTransformationListBuilder.add((Object)((GlMatrixTransformation)effect));
                continue;
            }
            ImmutableList matrixTransformations = matrixTransformationListBuilder.build();
            if (!matrixTransformations.isEmpty()) {
                textureProcessors.add((Object)new MatrixTransformationProcessor((ImmutableList<GlMatrixTransformation>)matrixTransformations));
                matrixTransformationListBuilder = new ImmutableList.Builder();
            }
            textureProcessors.add((Object)effect.toGlTextureProcessor());
        }
        ImmutableList matrixTransformations = matrixTransformationListBuilder.build();
        if (!matrixTransformations.isEmpty()) {
            textureProcessors.add((Object)new MatrixTransformationProcessor((ImmutableList<GlMatrixTransformation>)matrixTransformations));
        }
        return textureProcessors.build();
    }

    private FrameProcessorChain(EGLDisplay eglDisplay, EGLContext eglContext, ExecutorService singleThreadExecutorService, int inputExternalTexId, long streamOffsetUs, int[] framebuffers, ImmutableList<SingleFrameGlTextureProcessor> textureProcessors, Listener listener, boolean enableExperimentalHdrEditing) {
        Assertions.checkState((!textureProcessors.isEmpty() ? 1 : 0) != 0);
        this.eglDisplay = eglDisplay;
        this.eglContext = eglContext;
        this.singleThreadExecutorService = singleThreadExecutorService;
        this.streamOffsetUs = streamOffsetUs;
        this.framebuffers = framebuffers;
        this.textureProcessors = textureProcessors;
        this.listener = listener;
        this.stopProcessing = new AtomicBoolean();
        this.enableExperimentalHdrEditing = enableExperimentalHdrEditing;
        this.futures = new ConcurrentLinkedQueue();
        this.pendingFrameCount = new AtomicInteger();
        this.inputSurfaceTexture = new SurfaceTexture(inputExternalTexId);
        this.inputSurface = new Surface(this.inputSurfaceTexture);
        this.textureTransformMatrix = new float[16];
        this.outputWidth = -1;
        this.outputHeight = -1;
    }

    public Size getOutputSize() {
        return ((SingleFrameGlTextureProcessor)Iterables.getLast(this.textureProcessors)).getOutputSize();
    }

    public void setOutputSurface(Surface outputSurface, int outputWidth, int outputHeight, @Nullable SurfaceView debugSurfaceView) {
        this.outputSurface = outputSurface;
        this.outputWidth = outputWidth;
        this.outputHeight = outputHeight;
        if (debugSurfaceView != null) {
            this.debugSurfaceViewWrapper = new SurfaceViewWrapper(debugSurfaceView);
        }
        this.inputSurfaceTexture.setOnFrameAvailableListener(surfaceTexture -> {
            block3: {
                if (this.stopProcessing.get()) {
                    return;
                }
                try {
                    this.futures.add(this.singleThreadExecutorService.submit(this::processFrame));
                }
                catch (RejectedExecutionException e) {
                    if (this.stopProcessing.get()) break block3;
                    throw e;
                }
            }
        });
    }

    public Surface getInputSurface() {
        return this.inputSurface;
    }

    public void registerInputFrame() {
        Assertions.checkState((!this.inputStreamEnded ? 1 : 0) != 0);
        this.pendingFrameCount.incrementAndGet();
    }

    public int getPendingFrameCount() {
        return this.pendingFrameCount.get();
    }

    public void signalEndOfInputStream() {
        this.inputStreamEnded = true;
    }

    public boolean isEnded() {
        return this.inputStreamEnded && this.getPendingFrameCount() == 0;
    }

    public void release() {
        this.stopProcessing.set(true);
        while (!this.futures.isEmpty()) {
            ((Future)Assertions.checkNotNull(this.futures.poll())).cancel(false);
        }
        this.futures.add(this.singleThreadExecutorService.submit(this::releaseTextureProcessorsAndDestroyGlContext));
        this.singleThreadExecutorService.shutdown();
        try {
            if (!this.singleThreadExecutorService.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                Log.d((String)TAG, (String)"Failed to release FrameProcessorChain");
            }
        }
        catch (InterruptedException e) {
            Log.d((String)TAG, (String)"FrameProcessorChain release was interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        this.inputSurfaceTexture.release();
        this.inputSurface.release();
    }

    @WorkerThread
    private void processFrame() {
        block7: {
            if (this.stopProcessing.get()) {
                return;
            }
            long presentationTimeUs = -9223372036854775807L;
            try {
                Assertions.checkState((boolean)Thread.currentThread().getName().equals(THREAD_NAME));
                if (this.outputEglSurface == null) {
                    Assertions.checkStateNotNull((Object)this.outputSurface);
                    this.outputEglSurface = this.enableExperimentalHdrEditing ? GlUtil.getEglSurfaceBt2020Pq((EGLDisplay)this.eglDisplay, (Object)this.outputSurface) : GlUtil.getEglSurface((EGLDisplay)this.eglDisplay, (Object)this.outputSurface);
                }
                this.inputSurfaceTexture.updateTexImage();
                long inputFrameTimeNs = this.inputSurfaceTexture.getTimestamp();
                presentationTimeUs = inputFrameTimeNs / 1000L - this.streamOffsetUs;
                this.inputSurfaceTexture.getTransformMatrix(this.textureTransformMatrix);
                ((ExternalTextureProcessor)this.textureProcessors.get(0)).setTextureTransformMatrix(this.textureTransformMatrix);
                for (int i = 0; i < this.textureProcessors.size() - 1; ++i) {
                    if (this.stopProcessing.get()) {
                        return;
                    }
                    Size intermediateSize = ((SingleFrameGlTextureProcessor)this.textureProcessors.get(i)).getOutputSize();
                    GlUtil.focusFramebuffer((EGLDisplay)this.eglDisplay, (EGLContext)this.eglContext, (EGLSurface)this.outputEglSurface, (int)this.framebuffers[i], (int)intermediateSize.getWidth(), (int)intermediateSize.getHeight());
                    FrameProcessorChain.clearOutputFrame();
                    ((SingleFrameGlTextureProcessor)this.textureProcessors.get(i)).drawFrame(presentationTimeUs);
                }
                GlUtil.focusEglSurface((EGLDisplay)this.eglDisplay, (EGLContext)this.eglContext, (EGLSurface)this.outputEglSurface, (int)this.outputWidth, (int)this.outputHeight);
                FrameProcessorChain.clearOutputFrame();
                ((SingleFrameGlTextureProcessor)Iterables.getLast(this.textureProcessors)).drawFrame(presentationTimeUs);
                EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.eglDisplay, (EGLSurface)this.outputEglSurface, (long)inputFrameTimeNs);
                EGL14.eglSwapBuffers((EGLDisplay)this.eglDisplay, (EGLSurface)this.outputEglSurface);
                if (this.debugSurfaceViewWrapper != null) {
                    long framePresentationTimeUs = presentationTimeUs;
                    this.debugSurfaceViewWrapper.maybeRenderToSurfaceView(() -> {
                        FrameProcessorChain.clearOutputFrame();
                        try {
                            ((SingleFrameGlTextureProcessor)Iterables.getLast(this.textureProcessors)).drawFrame(framePresentationTimeUs);
                        }
                        catch (FrameProcessingException e) {
                            Log.d((String)TAG, (String)"Error rendering to debug preview", (Throwable)e);
                        }
                    });
                }
                Assertions.checkState((this.pendingFrameCount.getAndDecrement() > 0 ? 1 : 0) != 0);
            }
            catch (FrameProcessingException | RuntimeException e) {
                if (this.stopProcessing.getAndSet(true)) break block7;
                this.listener.onFrameProcessingError(e instanceof FrameProcessingException ? (FrameProcessingException)e : new FrameProcessingException(e, presentationTimeUs));
            }
        }
    }

    private static void clearOutputFrame() {
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GLES20.glClear((int)16384);
        GlUtil.checkGlError();
    }

    @WorkerThread
    private void releaseTextureProcessorsAndDestroyGlContext() {
        try {
            for (int i = 0; i < this.textureProcessors.size(); ++i) {
                ((SingleFrameGlTextureProcessor)this.textureProcessors.get(i)).release();
            }
            GlUtil.destroyEglContext((EGLDisplay)this.eglDisplay, (EGLContext)this.eglContext);
        }
        catch (RuntimeException e) {
            this.listener.onFrameProcessingError(new FrameProcessingException(e));
        }
    }

    static {
        GlUtil.glAssertionsEnabled = true;
    }

    private final class SurfaceViewWrapper
    implements SurfaceHolder.Callback {
        @GuardedBy(value="this")
        @Nullable
        private Surface surface;
        @GuardedBy(value="this")
        @Nullable
        private EGLSurface eglSurface;
        private int width;
        private int height;

        public SurfaceViewWrapper(SurfaceView surfaceView) {
            surfaceView.getHolder().addCallback((SurfaceHolder.Callback)this);
            this.surface = surfaceView.getHolder().getSurface();
            this.width = surfaceView.getWidth();
            this.height = surfaceView.getHeight();
        }

        @WorkerThread
        public synchronized void maybeRenderToSurfaceView(Runnable renderRunnable) {
            if (this.surface == null) {
                return;
            }
            if (this.eglSurface == null) {
                this.eglSurface = FrameProcessorChain.this.enableExperimentalHdrEditing ? GlUtil.getEglSurfaceBt2020Pq((EGLDisplay)FrameProcessorChain.this.eglDisplay, (Object)this.surface) : GlUtil.getEglSurface((EGLDisplay)FrameProcessorChain.this.eglDisplay, (Object)this.surface);
            }
            EGLSurface eglSurface = this.eglSurface;
            GlUtil.focusEglSurface((EGLDisplay)FrameProcessorChain.this.eglDisplay, (EGLContext)FrameProcessorChain.this.eglContext, (EGLSurface)eglSurface, (int)this.width, (int)this.height);
            renderRunnable.run();
            EGL14.eglSwapBuffers((EGLDisplay)FrameProcessorChain.this.eglDisplay, (EGLSurface)eglSurface);
        }

        public void surfaceCreated(SurfaceHolder holder) {
        }

        public synchronized void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            this.width = width;
            this.height = height;
            Surface newSurface = holder.getSurface();
            if (this.surface == null || !this.surface.equals(newSurface)) {
                this.surface = newSurface;
                this.eglSurface = null;
            }
        }

        public synchronized void surfaceDestroyed(SurfaceHolder holder) {
            this.surface = null;
            this.eglSurface = null;
            this.width = -1;
            this.height = -1;
        }
    }

    public static interface Listener {
        public void onFrameProcessingError(FrameProcessingException var1);
    }
}

