/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.media.CamcorderProfile;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.util.Pair;
import android.util.Range;
import android.util.Size;
import androidx.annotation.DoNotInline;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MediaFormatUtil;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import com.google.common.base.Ascii;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import java.util.Collection;

public final class EncoderUtil {
    public static final int LEVEL_UNSET = -1;
    private static final Supplier<ImmutableListMultimap<String, MediaCodecInfo>> MIME_TYPE_TO_ENCODERS = Suppliers.memoize(EncoderUtil::populateEncoderInfos);

    public static ImmutableList<MediaCodecInfo> getSupportedEncoders(String mimeType) {
        return ((ImmutableListMultimap)Assertions.checkNotNull((Object)((ImmutableListMultimap)MIME_TYPE_TO_ENCODERS.get()))).get((Object)Ascii.toLowerCase((String)mimeType));
    }

    public static ImmutableSet<String> getSupportedVideoMimeTypes() {
        return ((ImmutableListMultimap)Assertions.checkNotNull((Object)((ImmutableListMultimap)MIME_TYPE_TO_ENCODERS.get()))).keySet();
    }

    public static boolean isSizeSupported(MediaCodecInfo encoderInfo, String mimeType, int width, int height) {
        if (encoderInfo.getCapabilitiesForType(mimeType).getVideoCapabilities().isSizeSupported(width, height)) {
            return true;
        }
        if (width == 1920 && height == 1080) {
            return CamcorderProfile.hasProfile((int)6);
        }
        if (width == 3840 && height == 2160) {
            return CamcorderProfile.hasProfile((int)8);
        }
        return false;
    }

    public static Range<Integer> getSupportedHeights(MediaCodecInfo encoderInfo, String mimeType, int width) {
        return encoderInfo.getCapabilitiesForType(mimeType).getVideoCapabilities().getSupportedHeightsFor(width);
    }

    public static Pair<Range<Integer>, Range<Integer>> getSupportedResolutionRanges(MediaCodecInfo encoderInfo, String mimeType) {
        MediaCodecInfo.VideoCapabilities videoCapabilities = encoderInfo.getCapabilitiesForType(mimeType).getVideoCapabilities();
        return Pair.create((Object)videoCapabilities.getSupportedWidths(), (Object)videoCapabilities.getSupportedHeights());
    }

    @Nullable
    public static Size getSupportedResolution(MediaCodecInfo encoderInfo, String mimeType, int width, int height) {
        int newHeight;
        MediaCodecInfo.VideoCapabilities videoEncoderCapabilities = encoderInfo.getCapabilitiesForType(mimeType).getVideoCapabilities();
        int widthAlignment = videoEncoderCapabilities.getWidthAlignment();
        int heightAlignment = videoEncoderCapabilities.getHeightAlignment();
        if (EncoderUtil.isSizeSupported(encoderInfo, mimeType, width = EncoderUtil.alignResolution(width, widthAlignment), height = EncoderUtil.alignResolution(height, heightAlignment))) {
            return new Size(width, height);
        }
        int newWidth = EncoderUtil.alignResolution(width * 3 / 4, widthAlignment);
        if (EncoderUtil.isSizeSupported(encoderInfo, mimeType, newWidth, newHeight = EncoderUtil.alignResolution(height * 3 / 4, heightAlignment))) {
            return new Size(newWidth, newHeight);
        }
        newWidth = EncoderUtil.alignResolution(width * 2 / 3, widthAlignment);
        newHeight = EncoderUtil.alignResolution(height * 2 / 3, heightAlignment);
        if (EncoderUtil.isSizeSupported(encoderInfo, mimeType, width, height)) {
            return new Size(newWidth, newHeight);
        }
        newWidth = EncoderUtil.alignResolution(width / 2, widthAlignment);
        if (EncoderUtil.isSizeSupported(encoderInfo, mimeType, newWidth, newHeight = EncoderUtil.alignResolution(height / 2, heightAlignment))) {
            return new Size(newWidth, newHeight);
        }
        newWidth = EncoderUtil.alignResolution(width / 3, widthAlignment);
        if (EncoderUtil.isSizeSupported(encoderInfo, mimeType, newWidth, newHeight = EncoderUtil.alignResolution(height / 3, heightAlignment))) {
            return new Size(newWidth, newHeight);
        }
        width = (Integer)videoEncoderCapabilities.getSupportedWidths().clamp((Comparable)Integer.valueOf(width));
        int adjustedHeight = (Integer)videoEncoderCapabilities.getSupportedHeightsFor(width).clamp((Comparable)Integer.valueOf(height));
        if (adjustedHeight != height) {
            width = EncoderUtil.alignResolution((int)Math.round((double)width * (double)adjustedHeight / (double)height), widthAlignment);
            height = EncoderUtil.alignResolution(adjustedHeight, heightAlignment);
        }
        return EncoderUtil.isSizeSupported(encoderInfo, mimeType, width, height) ? new Size(width, height) : null;
    }

    public static ImmutableSet<Integer> findSupportedEncodingProfiles(MediaCodecInfo encoderInfo, String mimeType) {
        MediaCodecInfo.CodecProfileLevel[] profileLevels = encoderInfo.getCapabilitiesForType((String)mimeType).profileLevels;
        ImmutableSet.Builder supportedProfilesBuilder = new ImmutableSet.Builder();
        for (MediaCodecInfo.CodecProfileLevel profileLevel : profileLevels) {
            supportedProfilesBuilder.add((Object)profileLevel.profile);
        }
        return supportedProfilesBuilder.build();
    }

    public static int findHighestSupportedEncodingLevel(MediaCodecInfo encoderInfo, String mimeType, int profile) {
        MediaCodecInfo.CodecProfileLevel[] profileLevels = encoderInfo.getCapabilitiesForType((String)mimeType).profileLevels;
        int maxSupportedLevel = -1;
        for (MediaCodecInfo.CodecProfileLevel profileLevel : profileLevels) {
            if (profileLevel.profile != profile) continue;
            maxSupportedLevel = Math.max(maxSupportedLevel, profileLevel.level);
        }
        return maxSupportedLevel;
    }

    @Nullable
    public static String findCodecForFormat(MediaFormat format, boolean isDecoder) {
        String mediaCodecName;
        MediaCodecList mediaCodecList = new MediaCodecList(1);
        String frameRate = null;
        if (Util.SDK_INT == 21 && format.containsKey("frame-rate")) {
            frameRate = format.getString("frame-rate");
            format.setString("frame-rate", null);
        }
        String string = mediaCodecName = isDecoder ? mediaCodecList.findDecoderForFormat(format) : mediaCodecList.findEncoderForFormat(format);
        if (Util.SDK_INT == 21) {
            MediaFormatUtil.maybeSetString((MediaFormat)format, (String)"frame-rate", (String)frameRate);
        }
        return mediaCodecName;
    }

    public static Range<Integer> getSupportedBitrateRange(MediaCodecInfo encoderInfo, String mimeType) {
        return encoderInfo.getCapabilitiesForType(mimeType).getVideoCapabilities().getBitrateRange();
    }

    public static boolean isBitrateModeSupported(MediaCodecInfo encoderInfo, String mimeType, int bitrateMode) {
        return encoderInfo.getCapabilitiesForType(mimeType).getEncoderCapabilities().isBitrateModeSupported(bitrateMode);
    }

    public static ImmutableList<Integer> getSupportedColorFormats(MediaCodecInfo encoderInfo, String mimeType) {
        return ImmutableList.copyOf((Collection)Ints.asList((int[])encoderInfo.getCapabilitiesForType((String)mimeType).colorFormats));
    }

    public static boolean isHardwareAccelerated(MediaCodecInfo encoderInfo, String mimeType) {
        if (Util.SDK_INT >= 29) {
            return Api29.isHardwareAccelerated(encoderInfo);
        }
        return !EncoderUtil.isSoftwareOnly(encoderInfo, mimeType);
    }

    public static boolean isFeatureSupported(MediaCodecInfo encoderInfo, String mimeType, String featureName) {
        return encoderInfo.getCapabilitiesForType(mimeType).isFeatureSupported(featureName);
    }

    @RequiresApi(value=23)
    public static int getMaxSupportedInstances(MediaCodecInfo encoderInfo, String mimeType) {
        return encoderInfo.getCapabilitiesForType(mimeType).getMaxSupportedInstances();
    }

    private static boolean isSoftwareOnly(MediaCodecInfo encoderInfo, String mimeType) {
        if (Util.SDK_INT >= 29) {
            return Api29.isSoftwareOnly(encoderInfo);
        }
        if (MimeTypes.isAudio((String)mimeType)) {
            return true;
        }
        String codecName = Ascii.toLowerCase((String)encoderInfo.getName());
        if (codecName.startsWith("arc.")) {
            return false;
        }
        return codecName.startsWith("omx.google.") || codecName.startsWith("omx.ffmpeg.") || codecName.startsWith("omx.sec.") && codecName.contains(".sw.") || codecName.equals("omx.qcom.video.decoder.hevcswvdec") || codecName.startsWith("c2.android.") || codecName.startsWith("c2.google.") || !codecName.startsWith("omx.") && !codecName.startsWith("c2.");
    }

    private static int alignResolution(int size, int alignment) {
        boolean shouldRoundDown = false;
        if (size % 10 == 1) {
            shouldRoundDown = true;
        }
        return shouldRoundDown ? (int)((double)alignment * Math.floor((float)size / (float)alignment)) : alignment * Math.round((float)size / (float)alignment);
    }

    private static ImmutableListMultimap<String, MediaCodecInfo> populateEncoderInfos() {
        MediaCodecInfo[] allCodecInfos;
        ImmutableListMultimap.Builder encoderInfosBuilder = new ImmutableListMultimap.Builder();
        MediaCodecList mediaCodecList = new MediaCodecList(1);
        for (MediaCodecInfo mediaCodecInfo : allCodecInfos = mediaCodecList.getCodecInfos()) {
            String[] supportedMimeTypes;
            if (!mediaCodecInfo.isEncoder()) continue;
            for (String mimeType : supportedMimeTypes = mediaCodecInfo.getSupportedTypes()) {
                if (!MimeTypes.isVideo((String)mimeType)) continue;
                encoderInfosBuilder.put((Object)Ascii.toLowerCase((String)mimeType), (Object)mediaCodecInfo);
            }
        }
        return encoderInfosBuilder.build();
    }

    private EncoderUtil() {
    }

    @RequiresApi(value=29)
    private static final class Api29 {
        private Api29() {
        }

        @DoNotInline
        public static boolean isHardwareAccelerated(MediaCodecInfo encoderInfo) {
            return encoderInfo.isHardwareAccelerated();
        }

        @DoNotInline
        public static boolean isSoftwareOnly(MediaCodecInfo encoderInfo) {
            return encoderInfo.isSoftwareOnly();
        }
    }
}

