/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.media.MediaCodec;
import android.view.Surface;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.transformer.DefaultDecoderFactory;
import com.google.android.exoplayer2.transformer.DefaultEncoderFactory;
import com.google.android.exoplayer2.transformer.TransformationException;
import java.nio.ByteBuffer;
import java.util.List;

public interface Codec {
    public static final int UNLIMITED_PENDING_FRAME_COUNT = Integer.MAX_VALUE;

    public Format getConfigurationFormat();

    public String getName();

    public Surface getInputSurface();

    default public int getMaxPendingFrameCount() {
        return Integer.MAX_VALUE;
    }

    public boolean maybeDequeueInputBuffer(DecoderInputBuffer var1) throws TransformationException;

    public void queueInputBuffer(DecoderInputBuffer var1) throws TransformationException;

    public void signalEndOfInputStream() throws TransformationException;

    @Nullable
    public Format getOutputFormat() throws TransformationException;

    @Nullable
    public ByteBuffer getOutputBuffer() throws TransformationException;

    @Nullable
    public MediaCodec.BufferInfo getOutputBufferInfo() throws TransformationException;

    public void releaseOutputBuffer(boolean var1) throws TransformationException;

    public boolean isEnded();

    public void release();

    public static interface EncoderFactory {
        public static final EncoderFactory DEFAULT = new DefaultEncoderFactory();

        public Codec createForAudioEncoding(Format var1, List<String> var2) throws TransformationException;

        public Codec createForVideoEncoding(Format var1, List<String> var2) throws TransformationException;

        default public boolean audioNeedsEncoding() {
            return false;
        }

        default public boolean videoNeedsEncoding() {
            return false;
        }
    }

    public static interface DecoderFactory {
        public static final DecoderFactory DEFAULT = new DefaultDecoderFactory();

        public Codec createForAudioDecoding(Format var1) throws TransformationException;

        public Codec createForVideoDecoding(Format var1, Surface var2, boolean var3) throws TransformationException;
    }
}

