/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaCodec;
import android.opengl.EGL14;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.view.Surface;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.transformer.MediaCodecAdapterWrapper;
import com.google.android.exoplayer2.transformer.MuxerWrapper;
import com.google.android.exoplayer2.transformer.Transformation;
import com.google.android.exoplayer2.transformer.TransformerBaseRenderer;
import com.google.android.exoplayer2.transformer.TransformerMediaClock;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.GlUtil;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

@RequiresApi(value=18)
final class TransformerTranscodingVideoRenderer
extends TransformerBaseRenderer {
    private static final String TAG = "TransformerTranscodingVideoRenderer";
    private final Context context;
    private final DecoderInputBuffer decoderInputBuffer;
    private final float[] decoderTextureTransformMatrix;
    private @MonotonicNonNull Format decoderInputFormat;
    @Nullable
    private EGLDisplay eglDisplay;
    @Nullable
    private EGLContext eglContext;
    @Nullable
    private EGLSurface eglSurface;
    private int decoderTextureId;
    @Nullable
    private SurfaceTexture decoderSurfaceTexture;
    @Nullable
    private Surface decoderSurface;
    @Nullable
    private MediaCodecAdapterWrapper decoder;
    private volatile boolean isDecoderSurfacePopulated;
    private boolean waitingForPopulatedDecoderSurface;
    @Nullable
    private GlUtil.Uniform decoderTextureTransformUniform;
    @Nullable
    private MediaCodecAdapterWrapper encoder;
    private boolean hasEncoderActualOutputFormat;
    private boolean muxerWrapperTrackEnded;

    public TransformerTranscodingVideoRenderer(Context context, MuxerWrapper muxerWrapper, TransformerMediaClock mediaClock, Transformation transformation) {
        super(2, muxerWrapper, mediaClock, transformation);
        this.context = context;
        this.decoderInputBuffer = new DecoderInputBuffer(2);
        this.decoderTextureTransformMatrix = new float[16];
        this.decoderTextureId = -1;
    }

    public String getName() {
        return TAG;
    }

    public void render(long positionUs, long elapsedRealtimeUs) throws ExoPlaybackException {
        if (!this.isRendererStarted || this.isEnded() || !this.ensureInputFormatRead()) {
            return;
        }
        this.ensureEncoderConfigured();
        MediaCodecAdapterWrapper encoder = this.encoder;
        this.ensureOpenGlConfigured();
        EGLDisplay eglDisplay = this.eglDisplay;
        EGLSurface eglSurface = this.eglSurface;
        GlUtil.Uniform decoderTextureTransformUniform = this.decoderTextureTransformUniform;
        if (!this.ensureDecoderConfigured()) {
            return;
        }
        MediaCodecAdapterWrapper decoder = this.decoder;
        SurfaceTexture decoderSurfaceTexture = this.decoderSurfaceTexture;
        while (this.feedMuxerFromEncoder(encoder)) {
        }
        while (this.feedEncoderFromDecoder(decoder, encoder, decoderSurfaceTexture, eglDisplay, eglSurface, decoderTextureTransformUniform)) {
        }
        while (this.feedDecoderFromInput(decoder)) {
        }
    }

    public boolean isEnded() {
        return this.muxerWrapperTrackEnded;
    }

    protected void onReset() {
        this.decoderInputBuffer.clear();
        this.decoderInputBuffer.data = null;
        GlUtil.destroyEglContext((EGLDisplay)this.eglDisplay, (EGLContext)this.eglContext);
        this.eglDisplay = null;
        this.eglContext = null;
        this.eglSurface = null;
        if (this.decoderTextureId != -1) {
            GlUtil.deleteTexture((int)this.decoderTextureId);
        }
        if (this.decoderSurfaceTexture != null) {
            this.decoderSurfaceTexture.release();
            this.decoderSurfaceTexture = null;
        }
        if (this.decoderSurface != null) {
            this.decoderSurface.release();
            this.decoderSurface = null;
        }
        if (this.decoder != null) {
            this.decoder.release();
            this.decoder = null;
        }
        this.isDecoderSurfacePopulated = false;
        this.waitingForPopulatedDecoderSurface = false;
        this.decoderTextureTransformUniform = null;
        if (this.encoder != null) {
            this.encoder.release();
            this.encoder = null;
        }
        this.hasEncoderActualOutputFormat = false;
        this.muxerWrapperTrackEnded = false;
    }

    @EnsuresNonNullIf(expression={"decoderInputFormat"}, result=true)
    private boolean ensureInputFormatRead() {
        if (this.decoderInputFormat != null) {
            return true;
        }
        FormatHolder formatHolder = this.getFormatHolder();
        int result = this.readSource(formatHolder, this.decoderInputBuffer, 2);
        if (result != -5) {
            return false;
        }
        this.decoderInputFormat = (Format)Assertions.checkNotNull((Object)formatHolder.format);
        return true;
    }

    @RequiresNonNull(value={"decoderInputFormat"})
    @EnsuresNonNull(value={"encoder"})
    private void ensureEncoderConfigured() throws ExoPlaybackException {
        if (this.encoder != null) {
            return;
        }
        try {
            this.encoder = MediaCodecAdapterWrapper.createForVideoEncoding(new Format.Builder().setWidth(this.decoderInputFormat.width).setHeight(this.decoderInputFormat.height).setSampleMimeType(this.transformation.videoMimeType != null ? this.transformation.videoMimeType : this.decoderInputFormat.sampleMimeType).build(), (Map<String, Integer>)ImmutableMap.of());
        }
        catch (IOException e) {
            throw this.createRendererException(e, this.decoderInputFormat, 4001);
        }
    }

    @RequiresNonNull(value={"encoder", "decoderInputFormat"})
    @EnsuresNonNull(value={"eglDisplay", "eglSurface", "decoderTextureTransformUniform"})
    private void ensureOpenGlConfigured() {
        GlUtil.Program copyProgram;
        EGLContext eglContext;
        if (this.eglDisplay != null && this.eglSurface != null && this.decoderTextureTransformUniform != null) {
            return;
        }
        MediaCodecAdapterWrapper encoder = this.encoder;
        EGLDisplay eglDisplay = GlUtil.createEglDisplay();
        try {
            this.eglContext = eglContext = GlUtil.createEglContext((EGLDisplay)eglDisplay);
        }
        catch (GlUtil.UnsupportedEglVersionException e) {
            throw new IllegalStateException("EGL version is unsupported", e);
        }
        EGLSurface eglSurface = GlUtil.getEglSurface((EGLDisplay)eglDisplay, (Object)Assertions.checkNotNull((Object)encoder.getInputSurface()));
        GlUtil.focusSurface((EGLDisplay)eglDisplay, (EGLContext)eglContext, (EGLSurface)eglSurface, (int)this.decoderInputFormat.width, (int)this.decoderInputFormat.height);
        this.decoderTextureId = GlUtil.createExternalTexture();
        try {
            copyProgram = new GlUtil.Program(this.context, "shaders/blit_vertex_shader.glsl", "shaders/copy_external_fragment_shader.glsl");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        copyProgram.use();
        GlUtil.Attribute[] copyAttributes = copyProgram.getAttributes();
        Assertions.checkState((copyAttributes.length == 2 ? 1 : 0) != 0, (Object)"Expected program to have two vertex attributes.");
        for (GlUtil.Attribute copyAttribute : copyAttributes) {
            if (copyAttribute.name.equals("a_position")) {
                copyAttribute.setBuffer(new float[]{-1.0f, -1.0f, 0.0f, 1.0f, 1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f}, 4);
            } else if (copyAttribute.name.equals("a_texcoord")) {
                copyAttribute.setBuffer(new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f}, 4);
            } else {
                throw new IllegalStateException("Unexpected attribute name.");
            }
            copyAttribute.bind();
        }
        GlUtil.Uniform[] copyUniforms = copyProgram.getUniforms();
        Assertions.checkState((copyUniforms.length == 2 ? 1 : 0) != 0, (Object)"Expected program to have two uniforms.");
        for (GlUtil.Uniform copyUniform : copyUniforms) {
            if (copyUniform.name.equals("tex_sampler")) {
                copyUniform.setSamplerTexId(this.decoderTextureId, 0);
                copyUniform.bind();
                continue;
            }
            if (copyUniform.name.equals("tex_transform")) {
                this.decoderTextureTransformUniform = copyUniform;
                continue;
            }
            throw new IllegalStateException("Unexpected uniform name.");
        }
        Assertions.checkNotNull((Object)this.decoderTextureTransformUniform);
        this.eglDisplay = eglDisplay;
        this.eglSurface = eglSurface;
    }

    @RequiresNonNull(value={"decoderInputFormat"})
    @EnsuresNonNullIf(expression={"decoder", "decoderSurfaceTexture"}, result=true)
    private boolean ensureDecoderConfigured() throws ExoPlaybackException {
        if (this.decoder != null && this.decoderSurfaceTexture != null) {
            return true;
        }
        Assertions.checkState((this.decoderTextureId != -1 ? 1 : 0) != 0);
        SurfaceTexture decoderSurfaceTexture = new SurfaceTexture(this.decoderTextureId);
        decoderSurfaceTexture.setOnFrameAvailableListener(surfaceTexture -> {
            this.isDecoderSurfacePopulated = true;
        });
        this.decoderSurface = new Surface(decoderSurfaceTexture);
        try {
            this.decoder = MediaCodecAdapterWrapper.createForVideoDecoding(this.decoderInputFormat, this.decoderSurface);
        }
        catch (IOException e) {
            throw this.createRendererException(e, this.decoderInputFormat, 4001);
        }
        this.decoderSurfaceTexture = decoderSurfaceTexture;
        return true;
    }

    private boolean feedDecoderFromInput(MediaCodecAdapterWrapper decoder) {
        if (!decoder.maybeDequeueInputBuffer(this.decoderInputBuffer)) {
            return false;
        }
        this.decoderInputBuffer.clear();
        int result = this.readSource(this.getFormatHolder(), this.decoderInputBuffer, 0);
        switch (result) {
            case -5: {
                throw new IllegalStateException("Format changes are not supported.");
            }
            case -4: {
                this.mediaClock.updateTimeForTrackType(this.getTrackType(), this.decoderInputBuffer.timeUs);
                this.decoderInputBuffer.timeUs -= this.streamOffsetUs;
                ByteBuffer data = (ByteBuffer)Assertions.checkNotNull((Object)this.decoderInputBuffer.data);
                data.flip();
                decoder.queueInputBuffer(this.decoderInputBuffer);
                return !this.decoderInputBuffer.isEndOfStream();
            }
        }
        return false;
    }

    private boolean feedEncoderFromDecoder(MediaCodecAdapterWrapper decoder, MediaCodecAdapterWrapper encoder, SurfaceTexture decoderSurfaceTexture, EGLDisplay eglDisplay, EGLSurface eglSurface, GlUtil.Uniform decoderTextureTransformUniform) {
        if (decoder.isEnded()) {
            return false;
        }
        if (!this.isDecoderSurfacePopulated) {
            if (!this.waitingForPopulatedDecoderSurface) {
                if (decoder.getOutputBufferInfo() != null) {
                    decoder.releaseOutputBuffer(true);
                    this.waitingForPopulatedDecoderSurface = true;
                }
                if (decoder.isEnded()) {
                    encoder.signalEndOfInputStream();
                }
            }
            return false;
        }
        this.waitingForPopulatedDecoderSurface = false;
        decoderSurfaceTexture.updateTexImage();
        decoderSurfaceTexture.getTransformMatrix(this.decoderTextureTransformMatrix);
        decoderTextureTransformUniform.setFloats(this.decoderTextureTransformMatrix);
        decoderTextureTransformUniform.bind();
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        long decoderSurfaceTextureTimestampNs = decoderSurfaceTexture.getTimestamp();
        EGLExt.eglPresentationTimeANDROID((EGLDisplay)eglDisplay, (EGLSurface)eglSurface, (long)decoderSurfaceTextureTimestampNs);
        EGL14.eglSwapBuffers((EGLDisplay)eglDisplay, (EGLSurface)eglSurface);
        this.isDecoderSurfacePopulated = false;
        return true;
    }

    private boolean feedMuxerFromEncoder(MediaCodecAdapterWrapper encoder) {
        if (!this.hasEncoderActualOutputFormat) {
            Format encoderOutputFormat = encoder.getOutputFormat();
            if (encoderOutputFormat == null) {
                return false;
            }
            this.hasEncoderActualOutputFormat = true;
            this.muxerWrapper.addTrackFormat(encoderOutputFormat);
        }
        if (encoder.isEnded()) {
            this.muxerWrapper.endTrack(this.getTrackType());
            this.muxerWrapperTrackEnded = true;
            return false;
        }
        ByteBuffer encoderOutputBuffer = encoder.getOutputBuffer();
        if (encoderOutputBuffer == null) {
            return false;
        }
        MediaCodec.BufferInfo encoderOutputBufferInfo = (MediaCodec.BufferInfo)Assertions.checkNotNull((Object)encoder.getOutputBufferInfo());
        if (!this.muxerWrapper.writeSample(this.getTrackType(), encoderOutputBuffer, (encoderOutputBufferInfo.flags & 1) > 0, encoderOutputBufferInfo.presentationTimeUs)) {
            return false;
        }
        encoder.releaseOutputBuffer();
        return true;
    }

    static {
        GlUtil.glAssertionsEnabled = true;
    }
}

