/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.annotation.SuppressLint;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.os.ParcelFileDescriptor;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.transformer.Muxer;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MediaFormatUtil;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.List;

@RequiresApi(value=18)
final class FrameworkMuxer
implements Muxer {
    private final MediaMuxer mediaMuxer;
    private final MediaCodec.BufferInfo bufferInfo;
    private boolean isStarted;

    private FrameworkMuxer(MediaMuxer mediaMuxer) {
        this.mediaMuxer = mediaMuxer;
        this.bufferInfo = new MediaCodec.BufferInfo();
    }

    @Override
    public int addTrack(Format format) {
        MediaFormat mediaFormat;
        String sampleMimeType = (String)Assertions.checkNotNull((Object)format.sampleMimeType);
        if (MimeTypes.isAudio((String)sampleMimeType)) {
            mediaFormat = MediaFormat.createAudioFormat((String)((String)Util.castNonNull((Object)sampleMimeType)), (int)format.sampleRate, (int)format.channelCount);
        } else {
            mediaFormat = MediaFormat.createVideoFormat((String)((String)Util.castNonNull((Object)sampleMimeType)), (int)format.width, (int)format.height);
            this.mediaMuxer.setOrientationHint(format.rotationDegrees);
        }
        MediaFormatUtil.setCsdBuffers((MediaFormat)mediaFormat, (List)format.initializationData);
        return this.mediaMuxer.addTrack(mediaFormat);
    }

    @Override
    @SuppressLint(value={"WrongConstant"})
    public void writeSampleData(int trackIndex, ByteBuffer data, boolean isKeyFrame, long presentationTimeUs) {
        if (!this.isStarted) {
            this.isStarted = true;
            this.mediaMuxer.start();
        }
        int offset = data.position();
        int size = data.limit() - offset;
        int flags = isKeyFrame ? 1 : 0;
        this.bufferInfo.set(offset, size, presentationTimeUs, flags);
        this.mediaMuxer.writeSampleData(trackIndex, data, this.bufferInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(boolean forCancellation) {
        if (!this.isStarted) {
            this.mediaMuxer.release();
            return;
        }
        this.isStarted = false;
        try {
            this.mediaMuxer.stop();
        }
        catch (IllegalStateException e) {
            if (Util.SDK_INT < 30) {
                try {
                    Field muxerStoppedStateField = MediaMuxer.class.getDeclaredField("MUXER_STATE_STOPPED");
                    muxerStoppedStateField.setAccessible(true);
                    int muxerStoppedState = (Integer)Util.castNonNull((Object)((Integer)muxerStoppedStateField.get(this.mediaMuxer)));
                    Field muxerStateField = MediaMuxer.class.getDeclaredField("mState");
                    muxerStateField.setAccessible(true);
                    muxerStateField.set(this.mediaMuxer, muxerStoppedState);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!forCancellation) {
                throw e;
            }
        }
        finally {
            this.mediaMuxer.release();
        }
    }

    private static int mimeTypeToMuxerOutputFormat(String mimeType) {
        if (mimeType.equals("video/mp4")) {
            return 0;
        }
        if (Util.SDK_INT >= 21 && mimeType.equals("video/webm")) {
            return 1;
        }
        String string = String.valueOf(mimeType);
        throw new IllegalArgumentException(string.length() != 0 ? "Unsupported output MIME type: ".concat(string) : new String("Unsupported output MIME type: "));
    }

    public static final class Factory
    implements Muxer.Factory {
        @Override
        public FrameworkMuxer create(String path, String outputMimeType) throws IOException {
            MediaMuxer mediaMuxer = new MediaMuxer(path, FrameworkMuxer.mimeTypeToMuxerOutputFormat(outputMimeType));
            return new FrameworkMuxer(mediaMuxer);
        }

        @Override
        @RequiresApi(value=26)
        public FrameworkMuxer create(ParcelFileDescriptor parcelFileDescriptor, String outputMimeType) throws IOException {
            MediaMuxer mediaMuxer = new MediaMuxer(parcelFileDescriptor.getFileDescriptor(), FrameworkMuxer.mimeTypeToMuxerOutputFormat(outputMimeType));
            return new FrameworkMuxer(mediaMuxer);
        }

        @Override
        public boolean supportsOutputMimeType(String mimeType) {
            try {
                FrameworkMuxer.mimeTypeToMuxerOutputFormat(mimeType);
            }
            catch (IllegalStateException e) {
                return false;
            }
            return true;
        }

        @Override
        public boolean supportsSampleMimeType(@Nullable String sampleMimeType, String containerMimeType) {
            boolean isAudio = MimeTypes.isAudio((String)sampleMimeType);
            boolean isVideo = MimeTypes.isVideo((String)sampleMimeType);
            if (containerMimeType.equals("video/mp4")) {
                if (isVideo) {
                    return "video/3gpp".equals(sampleMimeType) || "video/avc".equals(sampleMimeType) || "video/mp4v-es".equals(sampleMimeType) || Util.SDK_INT >= 24 && "video/hevc".equals(sampleMimeType);
                }
                if (isAudio) {
                    return "audio/mp4a-latm".equals(sampleMimeType) || "audio/3gpp".equals(sampleMimeType) || "audio/amr-wb".equals(sampleMimeType);
                }
            } else if (containerMimeType.equals("video/webm") && Util.SDK_INT >= 21) {
                if (isVideo) {
                    return "video/x-vnd.on2.vp8".equals(sampleMimeType) || Util.SDK_INT >= 24 && "video/x-vnd.on2.vp9".equals(sampleMimeType);
                }
                if (isAudio) {
                    return "audio/vorbis".equals(sampleMimeType);
                }
            }
            return false;
        }
    }
}

