/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.mp4.SlowMotionData;
import com.google.android.exoplayer2.metadata.mp4.SmtaMetadataEntry;
import com.google.android.exoplayer2.transformer.SampleTransformer;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.NalUnitUtil;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

final class SefSlowMotionVideoSampleTransformer
implements SampleTransformer {
    @VisibleForTesting
    static final int INPUT_FRAME_RATE = 30;
    private static final int TARGET_OUTPUT_FRAME_RATE = 30;
    private static final int NAL_START_CODE_LENGTH = NalUnitUtil.NAL_START_CODE.length;
    private static final int NAL_UNIT_TYPE_PREFIX = 14;
    private final byte[] scratch = new byte[NAL_START_CODE_LENGTH];
    @Nullable
    private final SlowMotionData slowMotionData;
    private final Iterator<SlowMotionData.Segment> segmentIterator;
    private final float captureFrameRate;
    private final int inputMaxLayer;
    private final int normalSpeedMaxLayer;
    @Nullable
    private SegmentInfo currentSegmentInfo;
    @Nullable
    private SegmentInfo nextSegmentInfo;
    private long frameTimeDeltaUs;

    public SefSlowMotionVideoSampleTransformer(Format format) {
        MetadataInfo metadataInfo = SefSlowMotionVideoSampleTransformer.getMetadataInfo(format.metadata);
        this.slowMotionData = metadataInfo.slowMotionData;
        ImmutableList segments = this.slowMotionData != null ? this.slowMotionData.segments : ImmutableList.of();
        this.segmentIterator = segments.iterator();
        this.captureFrameRate = metadataInfo.captureFrameRate;
        this.inputMaxLayer = metadataInfo.inputMaxLayer;
        this.normalSpeedMaxLayer = metadataInfo.normalSpeedMaxLayer;
        SegmentInfo segmentInfo = this.nextSegmentInfo = this.segmentIterator.hasNext() ? new SegmentInfo(this.segmentIterator.next(), this.inputMaxLayer, this.normalSpeedMaxLayer) : null;
        if (this.slowMotionData != null) {
            String string = String.valueOf(format.sampleMimeType);
            Assertions.checkArgument((boolean)"video/avc".equals(format.sampleMimeType), (Object)(string.length() != 0 ? "Unsupported MIME type for SEF slow motion video track: ".concat(string) : new String("Unsupported MIME type for SEF slow motion video track: ")));
        }
    }

    @Override
    public void transformSample(DecoderInputBuffer buffer) {
        if (this.slowMotionData == null) {
            return;
        }
        ByteBuffer data = (ByteBuffer)Util.castNonNull((Object)buffer.data);
        int originalPosition = data.position();
        data.position(originalPosition + NAL_START_CODE_LENGTH);
        data.get(this.scratch, 0, 4);
        int nalUnitType = this.scratch[0] & 0x1F;
        boolean svcExtensionFlag = (this.scratch[1] & 0xFF) >> 7 == 1;
        Assertions.checkState((nalUnitType == 14 && svcExtensionFlag ? 1 : 0) != 0, (Object)"Missing SVC extension prefix NAL unit.");
        int layer = (this.scratch[3] & 0xFF) >> 5;
        boolean shouldKeepFrame = this.processCurrentFrame(layer, buffer.timeUs);
        if (shouldKeepFrame) {
            buffer.timeUs = this.getCurrentFrameOutputTimeUs(buffer.timeUs);
            this.skipToNextNalUnit(data);
        } else {
            buffer.data = null;
        }
    }

    @VisibleForTesting
    boolean processCurrentFrame(int layer, long timeUs) {
        while (this.nextSegmentInfo != null && timeUs >= this.nextSegmentInfo.endTimeUs) {
            this.enterNextSegment();
        }
        if (this.nextSegmentInfo != null && timeUs >= this.nextSegmentInfo.startTimeUs) {
            this.enterNextSegment();
        } else if (this.currentSegmentInfo != null && timeUs >= this.currentSegmentInfo.endTimeUs) {
            this.leaveCurrentSegment();
        }
        int maxLayer = this.currentSegmentInfo != null ? this.currentSegmentInfo.maxLayer : this.normalSpeedMaxLayer;
        return layer <= maxLayer || this.shouldKeepFrameForOutputValidity(layer, timeUs);
    }

    private void enterNextSegment() {
        if (this.currentSegmentInfo != null) {
            this.leaveCurrentSegment();
        }
        this.currentSegmentInfo = this.nextSegmentInfo;
        this.nextSegmentInfo = this.segmentIterator.hasNext() ? new SegmentInfo(this.segmentIterator.next(), this.inputMaxLayer, this.normalSpeedMaxLayer) : null;
    }

    @RequiresNonNull(value={"currentSegmentInfo"})
    private void leaveCurrentSegment() {
        this.frameTimeDeltaUs += (this.currentSegmentInfo.endTimeUs - this.currentSegmentInfo.startTimeUs) * (long)(this.currentSegmentInfo.speedDivisor - 1);
        this.currentSegmentInfo = null;
    }

    private boolean shouldKeepFrameForOutputValidity(int layer, long timeUs) {
        if (this.nextSegmentInfo == null || layer >= this.nextSegmentInfo.maxLayer) {
            return false;
        }
        long frameOffsetToSegmentEstimate = (this.nextSegmentInfo.startTimeUs - timeUs) * 30L / 1000000L;
        float allowedError = 0.45f;
        float baseMaxFrameOffsetToSegment = (float)(-(1 << this.inputMaxLayer - this.nextSegmentInfo.maxLayer)) + allowedError;
        for (int i = 1; i < this.nextSegmentInfo.maxLayer; ++i) {
            if ((float)frameOffsetToSegmentEstimate < (float)(1 << this.inputMaxLayer - i) + baseMaxFrameOffsetToSegment) {
                if (layer > i) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @VisibleForTesting
    long getCurrentFrameOutputTimeUs(long inputTimeUs) {
        long outputTimeUs = inputTimeUs + this.frameTimeDeltaUs;
        if (this.currentSegmentInfo != null) {
            outputTimeUs += (inputTimeUs - this.currentSegmentInfo.startTimeUs) * (long)(this.currentSegmentInfo.speedDivisor - 1);
        }
        return Math.round((float)(outputTimeUs * 30L) / this.captureFrameRate);
    }

    private void skipToNextNalUnit(ByteBuffer data) {
        int newPosition = data.position();
        while (data.remaining() >= NAL_START_CODE_LENGTH) {
            data.get(this.scratch, 0, NAL_START_CODE_LENGTH);
            if (Arrays.equals(this.scratch, NalUnitUtil.NAL_START_CODE)) {
                data.position(newPosition);
                return;
            }
            data.position(++newPosition);
        }
        throw new IllegalStateException("Could not find NAL unit start code.");
    }

    private static MetadataInfo getMetadataInfo(@Nullable Metadata metadata) {
        MetadataInfo metadataInfo = new MetadataInfo();
        if (metadata == null) {
            return metadataInfo;
        }
        for (int i = 0; i < metadata.length(); ++i) {
            Metadata.Entry entry = metadata.get(i);
            if (entry instanceof SmtaMetadataEntry) {
                SmtaMetadataEntry smtaMetadataEntry = (SmtaMetadataEntry)entry;
                metadataInfo.captureFrameRate = smtaMetadataEntry.captureFrameRate;
                metadataInfo.inputMaxLayer = smtaMetadataEntry.svcTemporalLayerCount - 1;
                continue;
            }
            if (!(entry instanceof SlowMotionData)) continue;
            metadataInfo.slowMotionData = (SlowMotionData)entry;
        }
        if (metadataInfo.slowMotionData == null) {
            return metadataInfo;
        }
        Assertions.checkState((metadataInfo.inputMaxLayer != -1 ? 1 : 0) != 0, (Object)"SVC temporal layer count not found.");
        Assertions.checkState((metadataInfo.captureFrameRate != -3.4028235E38f ? 1 : 0) != 0, (Object)"Capture frame rate not found.");
        float i = metadataInfo.captureFrameRate;
        Assertions.checkState((metadataInfo.captureFrameRate % 1.0f == 0.0f && metadataInfo.captureFrameRate % 30.0f == 0.0f ? 1 : 0) != 0, (Object)new StringBuilder(43).append("Invalid capture frame rate: ").append(i).toString());
        int frameCountDivisor = (int)metadataInfo.captureFrameRate / 30;
        for (int normalSpeedMaxLayer = metadataInfo.inputMaxLayer; normalSpeedMaxLayer >= 0; --normalSpeedMaxLayer) {
            if ((frameCountDivisor & 1) == 1) {
                float f = metadataInfo.captureFrameRate;
                Assertions.checkState((frameCountDivisor >> 1 == 0 ? 1 : 0) != 0, (Object)new StringBuilder(84).append("Could not compute normal speed max SVC layer for capture frame rate  ").append(f).toString());
                metadataInfo.normalSpeedMaxLayer = normalSpeedMaxLayer;
                break;
            }
            frameCountDivisor >>= 1;
        }
        return metadataInfo;
    }

    private static final class SegmentInfo {
        public final long startTimeUs;
        public final long endTimeUs;
        public final int speedDivisor;
        public final int maxLayer;

        public SegmentInfo(SlowMotionData.Segment segment, int inputMaxLayer, int normalSpeedLayer) {
            this.startTimeUs = C.msToUs((long)segment.startTimeMs);
            this.endTimeUs = C.msToUs((long)segment.endTimeMs);
            this.speedDivisor = segment.speedDivisor;
            this.maxLayer = SegmentInfo.getSlowMotionMaxLayer(this.speedDivisor, inputMaxLayer, normalSpeedLayer);
        }

        private static int getSlowMotionMaxLayer(int speedDivisor, int inputMaxLayer, int normalSpeedMaxLayer) {
            int maxLayer = normalSpeedMaxLayer;
            for (int shiftedSpeedDivisor = speedDivisor; shiftedSpeedDivisor > 0; shiftedSpeedDivisor >>= 1) {
                if ((shiftedSpeedDivisor & 1) == 1) {
                    Assertions.checkState((shiftedSpeedDivisor >> 1 == 0 ? 1 : 0) != 0, (Object)new StringBuilder(34).append("Invalid speed divisor: ").append(speedDivisor).toString());
                    break;
                }
                ++maxLayer;
            }
            return Math.min(maxLayer, inputMaxLayer);
        }
    }

    private static final class MetadataInfo {
        public float captureFrameRate = -3.4028235E38f;
        public int inputMaxLayer = -1;
        public int normalSpeedMaxLayer = -1;
        @Nullable
        public SlowMotionData slowMotionData;
    }
}

