/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.smoothstreaming.offline;

import android.net.Uri;
import com.google.android.exoplayer2.offline.DownloaderConstructorHelper;
import com.google.android.exoplayer2.offline.SegmentDownloader;
import com.google.android.exoplayer2.source.smoothstreaming.manifest.SsManifest;
import com.google.android.exoplayer2.source.smoothstreaming.manifest.SsManifestParser;
import com.google.android.exoplayer2.source.smoothstreaming.manifest.SsUtil;
import com.google.android.exoplayer2.source.smoothstreaming.manifest.TrackKey;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.ParsingLoadable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class SsDownloader
extends SegmentDownloader<SsManifest, TrackKey> {
    public SsDownloader(Uri manifestUri, DownloaderConstructorHelper constructorHelper) {
        super(SsUtil.fixManifestUri(manifestUri), constructorHelper);
    }

    public TrackKey[] getAllRepresentationKeys() throws IOException {
        ArrayList<TrackKey> keys = new ArrayList<TrackKey>();
        SsManifest manifest = (SsManifest)this.getManifest();
        for (int i = 0; i < manifest.streamElements.length; ++i) {
            SsManifest.StreamElement streamElement = manifest.streamElements[i];
            for (int j = 0; j < streamElement.formats.length; ++j) {
                keys.add(new TrackKey(i, j));
            }
        }
        return keys.toArray(new TrackKey[keys.size()]);
    }

    protected SsManifest getManifest(DataSource dataSource, Uri uri) throws IOException {
        ParsingLoadable loadable = new ParsingLoadable(dataSource, uri, 4, (ParsingLoadable.Parser)new SsManifestParser());
        loadable.load();
        return (SsManifest)loadable.getResult();
    }

    protected List<SegmentDownloader.Segment> getSegments(DataSource dataSource, SsManifest manifest, TrackKey[] keys, boolean allowIndexLoadErrors) throws InterruptedException, IOException {
        ArrayList<SegmentDownloader.Segment> segments = new ArrayList<SegmentDownloader.Segment>();
        for (TrackKey key : keys) {
            SsManifest.StreamElement streamElement = manifest.streamElements[key.streamElementIndex];
            for (int i = 0; i < streamElement.chunkCount; ++i) {
                segments.add(new SegmentDownloader.Segment(streamElement.getStartTimeUs(i), new DataSpec(streamElement.buildRequestUri(key.trackIndex, i))));
            }
        }
        return segments;
    }
}

