/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.smoothstreaming.offline;

import android.net.Uri;
import com.google.android.exoplayer2.offline.DownloaderConstructorHelper;
import com.google.android.exoplayer2.offline.SegmentDownloader;
import com.google.android.exoplayer2.source.smoothstreaming.manifest.SsManifest;
import com.google.android.exoplayer2.source.smoothstreaming.manifest.SsManifestParser;
import com.google.android.exoplayer2.source.smoothstreaming.manifest.TrackKey;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.ParsingLoadable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class SsDownloader
extends SegmentDownloader<SsManifest, TrackKey> {
    public SsDownloader(Uri manifestUri, DownloaderConstructorHelper constructorHelper) {
        super(manifestUri, constructorHelper);
    }

    public SsManifest getManifest(DataSource dataSource, Uri uri) throws IOException {
        DataSpec dataSpec = new DataSpec(uri, 3);
        ParsingLoadable loadable = new ParsingLoadable(dataSource, dataSpec, 4, (ParsingLoadable.Parser)new SsManifestParser());
        loadable.load();
        return (SsManifest)loadable.getResult();
    }

    protected List<SegmentDownloader.Segment> getAllSegments(DataSource dataSource, SsManifest manifest, boolean allowIndexLoadErrors) throws InterruptedException, IOException {
        ArrayList<SegmentDownloader.Segment> segments = new ArrayList<SegmentDownloader.Segment>();
        for (int i = 0; i < manifest.streamElements.length; ++i) {
            SsManifest.StreamElement streamElement = manifest.streamElements[i];
            for (int j = 0; j < streamElement.formats.length; ++j) {
                segments.addAll(this.getSegments(dataSource, manifest, new TrackKey[]{new TrackKey(i, j)}, allowIndexLoadErrors));
            }
        }
        return segments;
    }

    protected List<SegmentDownloader.Segment> getSegments(DataSource dataSource, SsManifest manifest, TrackKey[] keys, boolean allowIndexLoadErrors) throws InterruptedException, IOException {
        ArrayList<SegmentDownloader.Segment> segments = new ArrayList<SegmentDownloader.Segment>();
        for (TrackKey key : keys) {
            SsManifest.StreamElement streamElement = manifest.streamElements[key.streamElementIndex];
            for (int i = 0; i < streamElement.chunkCount; ++i) {
                segments.add(new SegmentDownloader.Segment(streamElement.getStartTimeUs(i), new DataSpec(streamElement.buildRequestUri(key.trackIndex, i))));
            }
        }
        return segments;
    }
}

