/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.smoothstreaming;

import android.net.Uri;
import android.os.Handler;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.ExoPlayerLibraryInfo;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.source.SinglePeriodTimeline;
import com.google.android.exoplayer2.source.ads.AdsMediaSource;
import com.google.android.exoplayer2.source.smoothstreaming.SsChunkSource;
import com.google.android.exoplayer2.source.smoothstreaming.SsMediaPeriod;
import com.google.android.exoplayer2.source.smoothstreaming.manifest.SsManifest;
import com.google.android.exoplayer2.source.smoothstreaming.manifest.SsManifestParser;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.Loader;
import com.google.android.exoplayer2.upstream.LoaderErrorThrower;
import com.google.android.exoplayer2.upstream.ParsingLoadable;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.ArrayList;

public final class SsMediaSource
implements MediaSource,
Loader.Callback<ParsingLoadable<SsManifest>> {
    public static final int DEFAULT_MIN_LOADABLE_RETRY_COUNT = 3;
    public static final long DEFAULT_LIVE_PRESENTATION_DELAY_MS = 30000L;
    private static final int MINIMUM_MANIFEST_REFRESH_PERIOD_MS = 5000;
    private static final long MIN_LIVE_DEFAULT_START_POSITION_US = 5000000L;
    private final Uri manifestUri;
    private final DataSource.Factory manifestDataSourceFactory;
    private final SsChunkSource.Factory chunkSourceFactory;
    private final int minLoadableRetryCount;
    private final long livePresentationDelayMs;
    private final MediaSourceEventListener.EventDispatcher eventDispatcher;
    private final ParsingLoadable.Parser<? extends SsManifest> manifestParser;
    private final ArrayList<SsMediaPeriod> mediaPeriods;
    private MediaSource.Listener sourceListener;
    private DataSource manifestDataSource;
    private Loader manifestLoader;
    private LoaderErrorThrower manifestLoaderErrorThrower;
    private long manifestLoadStartTimestamp;
    private SsManifest manifest;
    private Handler manifestRefreshHandler;

    @Deprecated
    public SsMediaSource(SsManifest manifest, SsChunkSource.Factory chunkSourceFactory, Handler eventHandler, MediaSourceEventListener eventListener) {
        this(manifest, chunkSourceFactory, 3, eventHandler, eventListener);
    }

    @Deprecated
    public SsMediaSource(SsManifest manifest, SsChunkSource.Factory chunkSourceFactory, int minLoadableRetryCount, Handler eventHandler, MediaSourceEventListener eventListener) {
        this(manifest, null, null, null, chunkSourceFactory, minLoadableRetryCount, 30000L, eventHandler, eventListener);
    }

    @Deprecated
    public SsMediaSource(Uri manifestUri, DataSource.Factory manifestDataSourceFactory, SsChunkSource.Factory chunkSourceFactory, Handler eventHandler, MediaSourceEventListener eventListener) {
        this(manifestUri, manifestDataSourceFactory, chunkSourceFactory, 3, 30000L, eventHandler, eventListener);
    }

    @Deprecated
    public SsMediaSource(Uri manifestUri, DataSource.Factory manifestDataSourceFactory, SsChunkSource.Factory chunkSourceFactory, int minLoadableRetryCount, long livePresentationDelayMs, Handler eventHandler, MediaSourceEventListener eventListener) {
        this(manifestUri, manifestDataSourceFactory, new SsManifestParser(), chunkSourceFactory, minLoadableRetryCount, livePresentationDelayMs, eventHandler, eventListener);
    }

    @Deprecated
    public SsMediaSource(Uri manifestUri, DataSource.Factory manifestDataSourceFactory, ParsingLoadable.Parser<? extends SsManifest> manifestParser, SsChunkSource.Factory chunkSourceFactory, int minLoadableRetryCount, long livePresentationDelayMs, Handler eventHandler, MediaSourceEventListener eventListener) {
        this(null, manifestUri, manifestDataSourceFactory, manifestParser, chunkSourceFactory, minLoadableRetryCount, livePresentationDelayMs, eventHandler, eventListener);
    }

    private SsMediaSource(SsManifest manifest, Uri manifestUri, DataSource.Factory manifestDataSourceFactory, ParsingLoadable.Parser<? extends SsManifest> manifestParser, SsChunkSource.Factory chunkSourceFactory, int minLoadableRetryCount, long livePresentationDelayMs, Handler eventHandler, MediaSourceEventListener eventListener) {
        Assertions.checkState((manifest == null || !manifest.isLive ? 1 : 0) != 0);
        this.manifest = manifest;
        this.manifestUri = manifestUri == null ? null : (Util.toLowerInvariant((String)manifestUri.getLastPathSegment()).matches("manifest(\\(.+\\))?") ? manifestUri : Uri.withAppendedPath((Uri)manifestUri, (String)"Manifest"));
        this.manifestDataSourceFactory = manifestDataSourceFactory;
        this.manifestParser = manifestParser;
        this.chunkSourceFactory = chunkSourceFactory;
        this.minLoadableRetryCount = minLoadableRetryCount;
        this.livePresentationDelayMs = livePresentationDelayMs;
        this.eventDispatcher = new MediaSourceEventListener.EventDispatcher(eventHandler, eventListener);
        this.mediaPeriods = new ArrayList();
    }

    public void prepareSource(ExoPlayer player, boolean isTopLevelSource, MediaSource.Listener listener) {
        this.sourceListener = listener;
        if (this.manifest != null) {
            this.manifestLoaderErrorThrower = new LoaderErrorThrower.Dummy();
            this.processManifest();
        } else {
            this.manifestDataSource = this.manifestDataSourceFactory.createDataSource();
            this.manifestLoader = new Loader("Loader:Manifest");
            this.manifestLoaderErrorThrower = this.manifestLoader;
            this.manifestRefreshHandler = new Handler();
            this.startLoadingManifest();
        }
    }

    public void maybeThrowSourceInfoRefreshError() throws IOException {
        this.manifestLoaderErrorThrower.maybeThrowError();
    }

    public MediaPeriod createPeriod(MediaSource.MediaPeriodId id, Allocator allocator) {
        Assertions.checkArgument((id.periodIndex == 0 ? 1 : 0) != 0);
        SsMediaPeriod period = new SsMediaPeriod(this.manifest, this.chunkSourceFactory, this.minLoadableRetryCount, this.eventDispatcher, this.manifestLoaderErrorThrower, allocator);
        this.mediaPeriods.add(period);
        return period;
    }

    public void releasePeriod(MediaPeriod period) {
        ((SsMediaPeriod)period).release();
        this.mediaPeriods.remove(period);
    }

    public void releaseSource() {
        this.sourceListener = null;
        this.manifest = null;
        this.manifestDataSource = null;
        this.manifestLoadStartTimestamp = 0L;
        if (this.manifestLoader != null) {
            this.manifestLoader.release();
            this.manifestLoader = null;
        }
        if (this.manifestRefreshHandler != null) {
            this.manifestRefreshHandler.removeCallbacksAndMessages(null);
            this.manifestRefreshHandler = null;
        }
    }

    public void onLoadCompleted(ParsingLoadable<SsManifest> loadable, long elapsedRealtimeMs, long loadDurationMs) {
        this.eventDispatcher.loadCompleted(loadable.dataSpec, loadable.type, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        this.manifest = (SsManifest)loadable.getResult();
        this.manifestLoadStartTimestamp = elapsedRealtimeMs - loadDurationMs;
        this.processManifest();
        this.scheduleManifestRefresh();
    }

    public void onLoadCanceled(ParsingLoadable<SsManifest> loadable, long elapsedRealtimeMs, long loadDurationMs, boolean released) {
        this.eventDispatcher.loadCompleted(loadable.dataSpec, loadable.type, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
    }

    public int onLoadError(ParsingLoadable<SsManifest> loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error) {
        boolean isFatal = error instanceof ParserException;
        this.eventDispatcher.loadError(loadable.dataSpec, loadable.type, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded(), error, isFatal);
        return isFatal ? 3 : 0;
    }

    private void processManifest() {
        SinglePeriodTimeline timeline;
        for (int i = 0; i < this.mediaPeriods.size(); ++i) {
            this.mediaPeriods.get(i).updateManifest(this.manifest);
        }
        long startTimeUs = Long.MAX_VALUE;
        long endTimeUs = Long.MIN_VALUE;
        for (SsManifest.StreamElement element : this.manifest.streamElements) {
            if (element.chunkCount <= 0) continue;
            startTimeUs = Math.min(startTimeUs, element.getStartTimeUs(0));
            endTimeUs = Math.max(endTimeUs, element.getStartTimeUs(element.chunkCount - 1) + element.getChunkDurationUs(element.chunkCount - 1));
        }
        if (startTimeUs == Long.MAX_VALUE) {
            long periodDurationUs = this.manifest.isLive ? -9223372036854775807L : 0L;
            timeline = new SinglePeriodTimeline(periodDurationUs, 0L, 0L, 0L, true, this.manifest.isLive);
        } else if (this.manifest.isLive) {
            long durationUs;
            long defaultStartPositionUs;
            if (this.manifest.dvrWindowLengthUs != -9223372036854775807L && this.manifest.dvrWindowLengthUs > 0L) {
                startTimeUs = Math.max(startTimeUs, endTimeUs - this.manifest.dvrWindowLengthUs);
            }
            if ((defaultStartPositionUs = (durationUs = endTimeUs - startTimeUs) - C.msToUs((long)this.livePresentationDelayMs)) < 5000000L) {
                defaultStartPositionUs = Math.min(5000000L, durationUs / 2L);
            }
            timeline = new SinglePeriodTimeline(-9223372036854775807L, durationUs, startTimeUs, defaultStartPositionUs, true, true);
        } else {
            long durationUs = this.manifest.durationUs != -9223372036854775807L ? this.manifest.durationUs : endTimeUs - startTimeUs;
            timeline = new SinglePeriodTimeline(startTimeUs + durationUs, durationUs, startTimeUs, 0L, true, false);
        }
        this.sourceListener.onSourceInfoRefreshed((MediaSource)this, (Timeline)timeline, (Object)this.manifest);
    }

    private void scheduleManifestRefresh() {
        if (!this.manifest.isLive) {
            return;
        }
        long nextLoadTimestamp = this.manifestLoadStartTimestamp + 5000L;
        long delayUntilNextLoad = Math.max(0L, nextLoadTimestamp - SystemClock.elapsedRealtime());
        this.manifestRefreshHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                SsMediaSource.this.startLoadingManifest();
            }
        }, delayUntilNextLoad);
    }

    private void startLoadingManifest() {
        ParsingLoadable loadable = new ParsingLoadable(this.manifestDataSource, this.manifestUri, 4, this.manifestParser);
        long elapsedRealtimeMs = this.manifestLoader.startLoading((Loader.Loadable)loadable, (Loader.Callback)this, this.minLoadableRetryCount);
        this.eventDispatcher.loadStarted(loadable.dataSpec, loadable.type, elapsedRealtimeMs);
    }

    static {
        ExoPlayerLibraryInfo.registerModule((String)"goog.exo.smoothstreaming");
    }

    public static final class Factory
    implements AdsMediaSource.MediaSourceFactory {
        private final SsChunkSource.Factory chunkSourceFactory;
        @Nullable
        private final DataSource.Factory manifestDataSourceFactory;
        @Nullable
        private ParsingLoadable.Parser<? extends SsManifest> manifestParser;
        private int minLoadableRetryCount;
        private long livePresentationDelayMs;
        private boolean isCreateCalled;

        public Factory(SsChunkSource.Factory chunkSourceFactory, @Nullable DataSource.Factory manifestDataSourceFactory) {
            this.chunkSourceFactory = (SsChunkSource.Factory)Assertions.checkNotNull((Object)chunkSourceFactory);
            this.manifestDataSourceFactory = manifestDataSourceFactory;
            this.minLoadableRetryCount = 3;
            this.livePresentationDelayMs = 30000L;
        }

        public Factory setMinLoadableRetryCount(int minLoadableRetryCount) {
            Assertions.checkState((!this.isCreateCalled ? 1 : 0) != 0);
            this.minLoadableRetryCount = minLoadableRetryCount;
            return this;
        }

        public Factory setLivePresentationDelayMs(long livePresentationDelayMs) {
            Assertions.checkState((!this.isCreateCalled ? 1 : 0) != 0);
            this.livePresentationDelayMs = livePresentationDelayMs;
            return this;
        }

        public Factory setManifestParser(ParsingLoadable.Parser<? extends SsManifest> manifestParser) {
            Assertions.checkState((!this.isCreateCalled ? 1 : 0) != 0);
            this.manifestParser = (ParsingLoadable.Parser)Assertions.checkNotNull(manifestParser);
            return this;
        }

        public SsMediaSource createMediaSource(SsManifest manifest, @Nullable Handler eventHandler, @Nullable MediaSourceEventListener eventListener) {
            Assertions.checkArgument((!manifest.isLive ? 1 : 0) != 0);
            this.isCreateCalled = true;
            return new SsMediaSource(manifest, null, null, null, this.chunkSourceFactory, this.minLoadableRetryCount, this.livePresentationDelayMs, eventHandler, eventListener);
        }

        public SsMediaSource createMediaSource(Uri manifestUri) {
            return this.createMediaSource(manifestUri, null, null);
        }

        public SsMediaSource createMediaSource(Uri manifestUri, @Nullable Handler eventHandler, @Nullable MediaSourceEventListener eventListener) {
            this.isCreateCalled = true;
            if (this.manifestParser == null) {
                this.manifestParser = new SsManifestParser();
            }
            return new SsMediaSource(null, (Uri)Assertions.checkNotNull((Object)manifestUri), this.manifestDataSourceFactory, this.manifestParser, this.chunkSourceFactory, this.minLoadableRetryCount, this.livePresentationDelayMs, eventHandler, eventListener);
        }

        public int[] getSupportedTypes() {
            return new int[]{1};
        }
    }
}

