/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.smoothstreaming;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.SeekParameters;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.mp4.FragmentedMp4Extractor;
import com.google.android.exoplayer2.extractor.mp4.Track;
import com.google.android.exoplayer2.extractor.mp4.TrackEncryptionBox;
import com.google.android.exoplayer2.source.BehindLiveWindowException;
import com.google.android.exoplayer2.source.chunk.BaseMediaChunkIterator;
import com.google.android.exoplayer2.source.chunk.BundledChunkExtractor;
import com.google.android.exoplayer2.source.chunk.Chunk;
import com.google.android.exoplayer2.source.chunk.ChunkExtractor;
import com.google.android.exoplayer2.source.chunk.ChunkHolder;
import com.google.android.exoplayer2.source.chunk.ContainerMediaChunk;
import com.google.android.exoplayer2.source.chunk.MediaChunk;
import com.google.android.exoplayer2.source.chunk.MediaChunkIterator;
import com.google.android.exoplayer2.source.smoothstreaming.SsChunkSource;
import com.google.android.exoplayer2.source.smoothstreaming.manifest.SsManifest;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelectionUtil;
import com.google.android.exoplayer2.upstream.CmcdConfiguration;
import com.google.android.exoplayer2.upstream.CmcdLog;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.google.android.exoplayer2.upstream.LoaderErrorThrower;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Assertions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;

@Deprecated
public class DefaultSsChunkSource
implements SsChunkSource {
    private final LoaderErrorThrower manifestLoaderErrorThrower;
    private final int streamElementIndex;
    private final ChunkExtractor[] chunkExtractors;
    private final DataSource dataSource;
    @Nullable
    private final CmcdConfiguration cmcdConfiguration;
    private ExoTrackSelection trackSelection;
    private SsManifest manifest;
    private int currentManifestChunkOffset;
    @Nullable
    private IOException fatalError;

    public DefaultSsChunkSource(LoaderErrorThrower manifestLoaderErrorThrower, SsManifest manifest, int streamElementIndex, ExoTrackSelection trackSelection, DataSource dataSource, @Nullable CmcdConfiguration cmcdConfiguration) {
        this.manifestLoaderErrorThrower = manifestLoaderErrorThrower;
        this.manifest = manifest;
        this.streamElementIndex = streamElementIndex;
        this.trackSelection = trackSelection;
        this.dataSource = dataSource;
        this.cmcdConfiguration = cmcdConfiguration;
        SsManifest.StreamElement streamElement = manifest.streamElements[streamElementIndex];
        this.chunkExtractors = new ChunkExtractor[trackSelection.length()];
        for (int i = 0; i < this.chunkExtractors.length; ++i) {
            int manifestTrackIndex = trackSelection.getIndexInTrackGroup(i);
            Format format = streamElement.formats[manifestTrackIndex];
            TrackEncryptionBox[] trackEncryptionBoxes = format.drmInitData != null ? ((SsManifest.ProtectionElement)Assertions.checkNotNull((Object)manifest.protectionElement)).trackEncryptionBoxes : null;
            int nalUnitLengthFieldLength = streamElement.type == 2 ? 4 : 0;
            Track track = new Track(manifestTrackIndex, streamElement.type, streamElement.timescale, -9223372036854775807L, manifest.durationUs, format, 0, trackEncryptionBoxes, nalUnitLengthFieldLength, null, null);
            FragmentedMp4Extractor extractor = new FragmentedMp4Extractor(3, null, track);
            this.chunkExtractors[i] = new BundledChunkExtractor((Extractor)extractor, streamElement.type, format);
        }
    }

    public long getAdjustedSeekPositionUs(long positionUs, SeekParameters seekParameters) {
        SsManifest.StreamElement streamElement = this.manifest.streamElements[this.streamElementIndex];
        int chunkIndex = streamElement.getChunkIndex(positionUs);
        long firstSyncUs = streamElement.getStartTimeUs(chunkIndex);
        long secondSyncUs = firstSyncUs < positionUs && chunkIndex < streamElement.chunkCount - 1 ? streamElement.getStartTimeUs(chunkIndex + 1) : firstSyncUs;
        return seekParameters.resolveSeekPositionUs(positionUs, firstSyncUs, secondSyncUs);
    }

    @Override
    public void updateManifest(SsManifest newManifest) {
        long newElementStartTimeUs;
        long currentElementEndTimeUs;
        SsManifest.StreamElement currentElement = this.manifest.streamElements[this.streamElementIndex];
        int currentElementChunkCount = currentElement.chunkCount;
        SsManifest.StreamElement newElement = newManifest.streamElements[this.streamElementIndex];
        this.currentManifestChunkOffset = currentElementChunkCount == 0 || newElement.chunkCount == 0 ? (this.currentManifestChunkOffset += currentElementChunkCount) : ((currentElementEndTimeUs = currentElement.getStartTimeUs(currentElementChunkCount - 1) + currentElement.getChunkDurationUs(currentElementChunkCount - 1)) <= (newElementStartTimeUs = newElement.getStartTimeUs(0)) ? (this.currentManifestChunkOffset += currentElementChunkCount) : (this.currentManifestChunkOffset += currentElement.getChunkIndex(newElementStartTimeUs)));
        this.manifest = newManifest;
    }

    @Override
    public void updateTrackSelection(ExoTrackSelection trackSelection) {
        this.trackSelection = trackSelection;
    }

    public void maybeThrowError() throws IOException {
        if (this.fatalError != null) {
            throw this.fatalError;
        }
        this.manifestLoaderErrorThrower.maybeThrowError();
    }

    public int getPreferredQueueSize(long playbackPositionUs, List<? extends MediaChunk> queue) {
        if (this.fatalError != null || this.trackSelection.length() < 2) {
            return queue.size();
        }
        return this.trackSelection.evaluateQueueSize(playbackPositionUs, queue);
    }

    public boolean shouldCancelLoad(long playbackPositionUs, Chunk loadingChunk, List<? extends MediaChunk> queue) {
        if (this.fatalError != null) {
            return false;
        }
        return this.trackSelection.shouldCancelChunkLoad(playbackPositionUs, loadingChunk, queue);
    }

    public final void getNextChunk(long playbackPositionUs, long loadPositionUs, List<? extends MediaChunk> queue, ChunkHolder out) {
        int chunkIndex;
        if (this.fatalError != null) {
            return;
        }
        SsManifest.StreamElement streamElement = this.manifest.streamElements[this.streamElementIndex];
        if (streamElement.chunkCount == 0) {
            out.endOfStream = !this.manifest.isLive;
            return;
        }
        if (queue.isEmpty()) {
            chunkIndex = streamElement.getChunkIndex(loadPositionUs);
        } else {
            chunkIndex = (int)(queue.get(queue.size() - 1).getNextChunkIndex() - (long)this.currentManifestChunkOffset);
            if (chunkIndex < 0) {
                this.fatalError = new BehindLiveWindowException();
                return;
            }
        }
        if (chunkIndex >= streamElement.chunkCount) {
            out.endOfStream = !this.manifest.isLive;
            return;
        }
        long bufferedDurationUs = loadPositionUs - playbackPositionUs;
        long timeToLiveEdgeUs = this.resolveTimeToLiveEdgeUs(playbackPositionUs);
        MediaChunkIterator[] chunkIterators = new MediaChunkIterator[this.trackSelection.length()];
        for (int i = 0; i < chunkIterators.length; ++i) {
            int trackIndex = this.trackSelection.getIndexInTrackGroup(i);
            chunkIterators[i] = new StreamElementIterator(streamElement, trackIndex, chunkIndex);
        }
        this.trackSelection.updateSelectedTrack(playbackPositionUs, bufferedDurationUs, timeToLiveEdgeUs, queue, chunkIterators);
        long chunkStartTimeUs = streamElement.getStartTimeUs(chunkIndex);
        long chunkEndTimeUs = chunkStartTimeUs + streamElement.getChunkDurationUs(chunkIndex);
        long chunkSeekTimeUs = queue.isEmpty() ? loadPositionUs : -9223372036854775807L;
        int currentAbsoluteChunkIndex = chunkIndex + this.currentManifestChunkOffset;
        int trackSelectionIndex = this.trackSelection.getSelectedIndex();
        ChunkExtractor chunkExtractor = this.chunkExtractors[trackSelectionIndex];
        int manifestTrackIndex = this.trackSelection.getIndexInTrackGroup(trackSelectionIndex);
        Uri uri = streamElement.buildRequestUri(manifestTrackIndex, chunkIndex);
        CmcdLog cmcdLog = this.cmcdConfiguration == null ? null : CmcdLog.createInstance((CmcdConfiguration)this.cmcdConfiguration, (ExoTrackSelection)this.trackSelection, (long)playbackPositionUs, (long)loadPositionUs);
        out.chunk = DefaultSsChunkSource.newMediaChunk(this.trackSelection.getSelectedFormat(), this.dataSource, uri, currentAbsoluteChunkIndex, chunkStartTimeUs, chunkEndTimeUs, chunkSeekTimeUs, this.trackSelection.getSelectionReason(), this.trackSelection.getSelectionData(), chunkExtractor, cmcdLog);
    }

    public void onChunkLoadCompleted(Chunk chunk) {
    }

    public boolean onChunkLoadError(Chunk chunk, boolean cancelable, LoadErrorHandlingPolicy.LoadErrorInfo loadErrorInfo, LoadErrorHandlingPolicy loadErrorHandlingPolicy) {
        LoadErrorHandlingPolicy.FallbackSelection fallbackSelection = loadErrorHandlingPolicy.getFallbackSelectionFor(TrackSelectionUtil.createFallbackOptions((ExoTrackSelection)this.trackSelection), loadErrorInfo);
        return cancelable && fallbackSelection != null && fallbackSelection.type == 2 && this.trackSelection.excludeTrack(this.trackSelection.indexOf(chunk.trackFormat), fallbackSelection.exclusionDurationMs);
    }

    public void release() {
        for (ChunkExtractor chunkExtractor : this.chunkExtractors) {
            chunkExtractor.release();
        }
    }

    private static MediaChunk newMediaChunk(Format format, DataSource dataSource, Uri uri, int chunkIndex, long chunkStartTimeUs, long chunkEndTimeUs, long chunkSeekTimeUs, int trackSelectionReason, @Nullable Object trackSelectionData, ChunkExtractor chunkExtractor, @Nullable CmcdLog cmcdLog) {
        ImmutableMap httpRequestHeaders = cmcdLog == null ? ImmutableMap.of() : cmcdLog.getHttpRequestHeaders();
        DataSpec dataSpec = new DataSpec.Builder().setUri(uri).setHttpRequestHeaders((Map)httpRequestHeaders).build();
        long sampleOffsetUs = chunkStartTimeUs;
        return new ContainerMediaChunk(dataSource, dataSpec, format, trackSelectionReason, trackSelectionData, chunkStartTimeUs, chunkEndTimeUs, chunkSeekTimeUs, -9223372036854775807L, (long)chunkIndex, 1, sampleOffsetUs, chunkExtractor);
    }

    private long resolveTimeToLiveEdgeUs(long playbackPositionUs) {
        if (!this.manifest.isLive) {
            return -9223372036854775807L;
        }
        SsManifest.StreamElement currentElement = this.manifest.streamElements[this.streamElementIndex];
        int lastChunkIndex = currentElement.chunkCount - 1;
        long lastChunkEndTimeUs = currentElement.getStartTimeUs(lastChunkIndex) + currentElement.getChunkDurationUs(lastChunkIndex);
        return lastChunkEndTimeUs - playbackPositionUs;
    }

    private static final class StreamElementIterator
    extends BaseMediaChunkIterator {
        private final SsManifest.StreamElement streamElement;
        private final int trackIndex;

        public StreamElementIterator(SsManifest.StreamElement streamElement, int trackIndex, int chunkIndex) {
            super((long)chunkIndex, (long)(streamElement.chunkCount - 1));
            this.streamElement = streamElement;
            this.trackIndex = trackIndex;
        }

        public DataSpec getDataSpec() {
            this.checkInBounds();
            Uri uri = this.streamElement.buildRequestUri(this.trackIndex, (int)this.getCurrentIndex());
            return new DataSpec(uri);
        }

        public long getChunkStartTimeUs() {
            this.checkInBounds();
            return this.streamElement.getStartTimeUs((int)this.getCurrentIndex());
        }

        public long getChunkEndTimeUs() {
            long chunkStartTimeUs = this.getChunkStartTimeUs();
            return chunkStartTimeUs + this.streamElement.getChunkDurationUs((int)this.getCurrentIndex());
        }
    }

    public static final class Factory
    implements SsChunkSource.Factory {
        private final DataSource.Factory dataSourceFactory;

        public Factory(DataSource.Factory dataSourceFactory) {
            this.dataSourceFactory = dataSourceFactory;
        }

        @Override
        public SsChunkSource createChunkSource(LoaderErrorThrower manifestLoaderErrorThrower, SsManifest manifest, int streamElementIndex, ExoTrackSelection trackSelection, @Nullable TransferListener transferListener, @Nullable CmcdConfiguration cmcdConfiguration) {
            DataSource dataSource = this.dataSourceFactory.createDataSource();
            if (transferListener != null) {
                dataSource.addTransferListener(transferListener);
            }
            return new DefaultSsChunkSource(manifestLoaderErrorThrower, manifest, streamElementIndex, trackSelection, dataSource, cmcdConfiguration);
        }
    }
}

