/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls.playlist;

import android.net.Uri;
import android.os.Handler;
import android.os.SystemClock;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.source.chunk.ChunkedTrackBlacklistUtil;
import com.google.android.exoplayer2.source.hls.HlsDataSourceFactory;
import com.google.android.exoplayer2.source.hls.playlist.HlsMasterPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsMediaPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylistTracker;
import com.google.android.exoplayer2.upstream.Loader;
import com.google.android.exoplayer2.upstream.ParsingLoadable;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.UriUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;

public final class DefaultHlsPlaylistTracker
implements HlsPlaylistTracker,
Loader.Callback<ParsingLoadable<HlsPlaylist>> {
    private static final double PLAYLIST_STUCK_TARGET_DURATION_COEFFICIENT = 3.5;
    private final HlsDataSourceFactory dataSourceFactory;
    private final ParsingLoadable.Parser<HlsPlaylist> playlistParser;
    private final int minRetryCount;
    private final IdentityHashMap<HlsMasterPlaylist.HlsUrl, MediaPlaylistBundle> playlistBundles;
    private final List<HlsPlaylistTracker.PlaylistEventListener> listeners;
    private MediaSourceEventListener.EventDispatcher eventDispatcher;
    private Loader initialPlaylistLoader;
    private Handler playlistRefreshHandler;
    private HlsPlaylistTracker.PrimaryPlaylistListener primaryPlaylistListener;
    private HlsMasterPlaylist masterPlaylist;
    private HlsMasterPlaylist.HlsUrl primaryHlsUrl;
    private HlsMediaPlaylist primaryUrlSnapshot;
    private boolean isLive;
    private long initialStartTimeUs;

    public DefaultHlsPlaylistTracker(HlsDataSourceFactory dataSourceFactory, int minRetryCount, ParsingLoadable.Parser<HlsPlaylist> playlistParser) {
        this.dataSourceFactory = dataSourceFactory;
        this.minRetryCount = minRetryCount;
        this.playlistParser = playlistParser;
        this.listeners = new ArrayList<HlsPlaylistTracker.PlaylistEventListener>();
        this.playlistBundles = new IdentityHashMap();
        this.initialStartTimeUs = -9223372036854775807L;
    }

    @Override
    public void start(Uri initialPlaylistUri, MediaSourceEventListener.EventDispatcher eventDispatcher, HlsPlaylistTracker.PrimaryPlaylistListener primaryPlaylistListener) {
        this.playlistRefreshHandler = new Handler();
        this.eventDispatcher = eventDispatcher;
        this.primaryPlaylistListener = primaryPlaylistListener;
        ParsingLoadable masterPlaylistLoadable = new ParsingLoadable(this.dataSourceFactory.createDataSource(4), initialPlaylistUri, 4, this.playlistParser);
        Assertions.checkState((this.initialPlaylistLoader == null ? 1 : 0) != 0);
        this.initialPlaylistLoader = new Loader("DefaultHlsPlaylistTracker:MasterPlaylist");
        long elapsedRealtime = this.initialPlaylistLoader.startLoading((Loader.Loadable)masterPlaylistLoadable, (Loader.Callback)this, this.minRetryCount);
        eventDispatcher.loadStarted(masterPlaylistLoadable.dataSpec, masterPlaylistLoadable.type, elapsedRealtime);
    }

    @Override
    public void stop() {
        this.primaryHlsUrl = null;
        this.primaryUrlSnapshot = null;
        this.masterPlaylist = null;
        this.initialStartTimeUs = -9223372036854775807L;
        this.initialPlaylistLoader.release();
        this.initialPlaylistLoader = null;
        for (MediaPlaylistBundle bundle : this.playlistBundles.values()) {
            bundle.release();
        }
        this.playlistRefreshHandler.removeCallbacksAndMessages(null);
        this.playlistRefreshHandler = null;
        this.playlistBundles.clear();
    }

    @Override
    public void addListener(HlsPlaylistTracker.PlaylistEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(HlsPlaylistTracker.PlaylistEventListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public HlsMasterPlaylist getMasterPlaylist() {
        return this.masterPlaylist;
    }

    @Override
    public HlsMediaPlaylist getPlaylistSnapshot(HlsMasterPlaylist.HlsUrl url) {
        HlsMediaPlaylist snapshot = this.playlistBundles.get(url).getPlaylistSnapshot();
        if (snapshot != null) {
            this.maybeSetPrimaryUrl(url);
        }
        return snapshot;
    }

    @Override
    public long getInitialStartTimeUs() {
        return this.initialStartTimeUs;
    }

    @Override
    public boolean isSnapshotValid(HlsMasterPlaylist.HlsUrl url) {
        return this.playlistBundles.get(url).isSnapshotValid();
    }

    @Override
    public void maybeThrowPrimaryPlaylistRefreshError() throws IOException {
        if (this.initialPlaylistLoader != null) {
            this.initialPlaylistLoader.maybeThrowError();
        }
        if (this.primaryHlsUrl != null) {
            this.maybeThrowPlaylistRefreshError(this.primaryHlsUrl);
        }
    }

    @Override
    public void maybeThrowPlaylistRefreshError(HlsMasterPlaylist.HlsUrl url) throws IOException {
        this.playlistBundles.get(url).maybeThrowPlaylistRefreshError();
    }

    @Override
    public void refreshPlaylist(HlsMasterPlaylist.HlsUrl url) {
        this.playlistBundles.get(url).loadPlaylist();
    }

    @Override
    public boolean isLive() {
        return this.isLive;
    }

    public void onLoadCompleted(ParsingLoadable<HlsPlaylist> loadable, long elapsedRealtimeMs, long loadDurationMs) {
        HlsPlaylist result = (HlsPlaylist)loadable.getResult();
        boolean isMediaPlaylist = result instanceof HlsMediaPlaylist;
        HlsMasterPlaylist masterPlaylist = isMediaPlaylist ? HlsMasterPlaylist.createSingleVariantMasterPlaylist(result.baseUri) : (HlsMasterPlaylist)result;
        this.masterPlaylist = masterPlaylist;
        this.primaryHlsUrl = masterPlaylist.variants.get(0);
        ArrayList<HlsMasterPlaylist.HlsUrl> urls = new ArrayList<HlsMasterPlaylist.HlsUrl>();
        urls.addAll(masterPlaylist.variants);
        urls.addAll(masterPlaylist.audios);
        urls.addAll(masterPlaylist.subtitles);
        this.createBundles(urls);
        MediaPlaylistBundle primaryBundle = this.playlistBundles.get(this.primaryHlsUrl);
        if (isMediaPlaylist) {
            primaryBundle.processLoadedPlaylist((HlsMediaPlaylist)result);
        } else {
            primaryBundle.loadPlaylist();
        }
        this.eventDispatcher.loadCompleted(loadable.dataSpec, 4, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
    }

    public void onLoadCanceled(ParsingLoadable<HlsPlaylist> loadable, long elapsedRealtimeMs, long loadDurationMs, boolean released) {
        this.eventDispatcher.loadCanceled(loadable.dataSpec, 4, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
    }

    public int onLoadError(ParsingLoadable<HlsPlaylist> loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error) {
        boolean isFatal = error instanceof ParserException;
        this.eventDispatcher.loadError(loadable.dataSpec, 4, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded(), error, isFatal);
        return isFatal ? 3 : 0;
    }

    private boolean maybeSelectNewPrimaryUrl() {
        List<HlsMasterPlaylist.HlsUrl> variants = this.masterPlaylist.variants;
        int variantsSize = variants.size();
        long currentTimeMs = SystemClock.elapsedRealtime();
        for (int i = 0; i < variantsSize; ++i) {
            MediaPlaylistBundle bundle = this.playlistBundles.get(variants.get(i));
            if (currentTimeMs <= bundle.blacklistUntilMs) continue;
            this.primaryHlsUrl = bundle.playlistUrl;
            bundle.loadPlaylist();
            return true;
        }
        return false;
    }

    private void maybeSetPrimaryUrl(HlsMasterPlaylist.HlsUrl url) {
        if (url == this.primaryHlsUrl || !this.masterPlaylist.variants.contains(url) || this.primaryUrlSnapshot != null && this.primaryUrlSnapshot.hasEndTag) {
            return;
        }
        this.primaryHlsUrl = url;
        this.playlistBundles.get(this.primaryHlsUrl).loadPlaylist();
    }

    private void createBundles(List<HlsMasterPlaylist.HlsUrl> urls) {
        int listSize = urls.size();
        for (int i = 0; i < listSize; ++i) {
            HlsMasterPlaylist.HlsUrl url = urls.get(i);
            MediaPlaylistBundle bundle = new MediaPlaylistBundle(url);
            this.playlistBundles.put(url, bundle);
        }
    }

    private void onPlaylistUpdated(HlsMasterPlaylist.HlsUrl url, HlsMediaPlaylist newSnapshot) {
        if (url == this.primaryHlsUrl) {
            if (this.primaryUrlSnapshot == null) {
                this.isLive = !newSnapshot.hasEndTag;
                this.initialStartTimeUs = newSnapshot.startTimeUs;
            }
            this.primaryUrlSnapshot = newSnapshot;
            this.primaryPlaylistListener.onPrimaryPlaylistRefreshed(newSnapshot);
        }
        int listenersSize = this.listeners.size();
        for (int i = 0; i < listenersSize; ++i) {
            this.listeners.get(i).onPlaylistChanged();
        }
    }

    private boolean notifyPlaylistError(HlsMasterPlaylist.HlsUrl playlistUrl, boolean shouldBlacklist) {
        int listenersSize = this.listeners.size();
        boolean anyBlacklistingFailed = false;
        for (int i = 0; i < listenersSize; ++i) {
            anyBlacklistingFailed |= !this.listeners.get(i).onPlaylistError(playlistUrl, shouldBlacklist);
        }
        return anyBlacklistingFailed;
    }

    private HlsMediaPlaylist getLatestPlaylistSnapshot(HlsMediaPlaylist oldPlaylist, HlsMediaPlaylist loadedPlaylist) {
        if (!loadedPlaylist.isNewerThan(oldPlaylist)) {
            if (loadedPlaylist.hasEndTag) {
                return oldPlaylist.copyWithEndTag();
            }
            return oldPlaylist;
        }
        long startTimeUs = this.getLoadedPlaylistStartTimeUs(oldPlaylist, loadedPlaylist);
        int discontinuitySequence = this.getLoadedPlaylistDiscontinuitySequence(oldPlaylist, loadedPlaylist);
        return loadedPlaylist.copyWith(startTimeUs, discontinuitySequence);
    }

    private long getLoadedPlaylistStartTimeUs(HlsMediaPlaylist oldPlaylist, HlsMediaPlaylist loadedPlaylist) {
        long primarySnapshotStartTimeUs;
        if (loadedPlaylist.hasProgramDateTime) {
            return loadedPlaylist.startTimeUs;
        }
        long l = primarySnapshotStartTimeUs = this.primaryUrlSnapshot != null ? this.primaryUrlSnapshot.startTimeUs : 0L;
        if (oldPlaylist == null) {
            return primarySnapshotStartTimeUs;
        }
        int oldPlaylistSize = oldPlaylist.segments.size();
        HlsMediaPlaylist.Segment firstOldOverlappingSegment = DefaultHlsPlaylistTracker.getFirstOldOverlappingSegment(oldPlaylist, loadedPlaylist);
        if (firstOldOverlappingSegment != null) {
            return oldPlaylist.startTimeUs + firstOldOverlappingSegment.relativeStartTimeUs;
        }
        if ((long)oldPlaylistSize == loadedPlaylist.mediaSequence - oldPlaylist.mediaSequence) {
            return oldPlaylist.getEndTimeUs();
        }
        return primarySnapshotStartTimeUs;
    }

    private int getLoadedPlaylistDiscontinuitySequence(HlsMediaPlaylist oldPlaylist, HlsMediaPlaylist loadedPlaylist) {
        int primaryUrlDiscontinuitySequence;
        if (loadedPlaylist.hasDiscontinuitySequence) {
            return loadedPlaylist.discontinuitySequence;
        }
        int n = primaryUrlDiscontinuitySequence = this.primaryUrlSnapshot != null ? this.primaryUrlSnapshot.discontinuitySequence : 0;
        if (oldPlaylist == null) {
            return primaryUrlDiscontinuitySequence;
        }
        HlsMediaPlaylist.Segment firstOldOverlappingSegment = DefaultHlsPlaylistTracker.getFirstOldOverlappingSegment(oldPlaylist, loadedPlaylist);
        if (firstOldOverlappingSegment != null) {
            return oldPlaylist.discontinuitySequence + firstOldOverlappingSegment.relativeDiscontinuitySequence - loadedPlaylist.segments.get((int)0).relativeDiscontinuitySequence;
        }
        return primaryUrlDiscontinuitySequence;
    }

    private static HlsMediaPlaylist.Segment getFirstOldOverlappingSegment(HlsMediaPlaylist oldPlaylist, HlsMediaPlaylist loadedPlaylist) {
        int mediaSequenceOffset = (int)(loadedPlaylist.mediaSequence - oldPlaylist.mediaSequence);
        List<HlsMediaPlaylist.Segment> oldSegments = oldPlaylist.segments;
        return mediaSequenceOffset < oldSegments.size() ? oldSegments.get(mediaSequenceOffset) : null;
    }

    private final class MediaPlaylistBundle
    implements Loader.Callback<ParsingLoadable<HlsPlaylist>>,
    Runnable {
        private final HlsMasterPlaylist.HlsUrl playlistUrl;
        private final Loader mediaPlaylistLoader;
        private final ParsingLoadable<HlsPlaylist> mediaPlaylistLoadable;
        private HlsMediaPlaylist playlistSnapshot;
        private long lastSnapshotLoadMs;
        private long lastSnapshotChangeMs;
        private long earliestNextLoadTimeMs;
        private long blacklistUntilMs;
        private boolean loadPending;
        private IOException playlistError;

        public MediaPlaylistBundle(HlsMasterPlaylist.HlsUrl playlistUrl) {
            this.playlistUrl = playlistUrl;
            this.mediaPlaylistLoader = new Loader("DefaultHlsPlaylistTracker:MediaPlaylist");
            this.mediaPlaylistLoadable = new ParsingLoadable(DefaultHlsPlaylistTracker.this.dataSourceFactory.createDataSource(4), UriUtil.resolveToUri((String)((DefaultHlsPlaylistTracker)DefaultHlsPlaylistTracker.this).masterPlaylist.baseUri, (String)playlistUrl.url), 4, DefaultHlsPlaylistTracker.this.playlistParser);
        }

        public HlsMediaPlaylist getPlaylistSnapshot() {
            return this.playlistSnapshot;
        }

        public boolean isSnapshotValid() {
            if (this.playlistSnapshot == null) {
                return false;
            }
            long currentTimeMs = SystemClock.elapsedRealtime();
            long snapshotValidityDurationMs = Math.max(30000L, C.usToMs((long)this.playlistSnapshot.durationUs));
            return this.playlistSnapshot.hasEndTag || this.playlistSnapshot.playlistType == 2 || this.playlistSnapshot.playlistType == 1 || this.lastSnapshotLoadMs + snapshotValidityDurationMs > currentTimeMs;
        }

        public void release() {
            this.mediaPlaylistLoader.release();
        }

        public void loadPlaylist() {
            this.blacklistUntilMs = 0L;
            if (this.loadPending || this.mediaPlaylistLoader.isLoading()) {
                return;
            }
            long currentTimeMs = SystemClock.elapsedRealtime();
            if (currentTimeMs < this.earliestNextLoadTimeMs) {
                this.loadPending = true;
                DefaultHlsPlaylistTracker.this.playlistRefreshHandler.postDelayed((Runnable)this, this.earliestNextLoadTimeMs - currentTimeMs);
            } else {
                this.loadPlaylistImmediately();
            }
        }

        public void maybeThrowPlaylistRefreshError() throws IOException {
            this.mediaPlaylistLoader.maybeThrowError();
            if (this.playlistError != null) {
                throw this.playlistError;
            }
        }

        public void onLoadCompleted(ParsingLoadable<HlsPlaylist> loadable, long elapsedRealtimeMs, long loadDurationMs) {
            HlsPlaylist result = (HlsPlaylist)loadable.getResult();
            if (result instanceof HlsMediaPlaylist) {
                this.processLoadedPlaylist((HlsMediaPlaylist)result);
                DefaultHlsPlaylistTracker.this.eventDispatcher.loadCompleted(loadable.dataSpec, 4, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
            } else {
                this.playlistError = new ParserException("Loaded playlist has unexpected type.");
            }
        }

        public void onLoadCanceled(ParsingLoadable<HlsPlaylist> loadable, long elapsedRealtimeMs, long loadDurationMs, boolean released) {
            DefaultHlsPlaylistTracker.this.eventDispatcher.loadCanceled(loadable.dataSpec, 4, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        }

        public int onLoadError(ParsingLoadable<HlsPlaylist> loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error) {
            boolean shouldRetryIfNotFatal;
            boolean isFatal = error instanceof ParserException;
            DefaultHlsPlaylistTracker.this.eventDispatcher.loadError(loadable.dataSpec, 4, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded(), error, isFatal);
            boolean shouldBlacklist = ChunkedTrackBlacklistUtil.shouldBlacklist((Exception)error);
            boolean bl = shouldRetryIfNotFatal = DefaultHlsPlaylistTracker.this.notifyPlaylistError(this.playlistUrl, shouldBlacklist) || !shouldBlacklist;
            if (isFatal) {
                return 3;
            }
            if (shouldBlacklist) {
                shouldRetryIfNotFatal |= this.blacklistPlaylist();
            }
            return shouldRetryIfNotFatal ? 0 : 2;
        }

        @Override
        public void run() {
            this.loadPending = false;
            this.loadPlaylistImmediately();
        }

        private void loadPlaylistImmediately() {
            long elapsedRealtime = this.mediaPlaylistLoader.startLoading(this.mediaPlaylistLoadable, (Loader.Callback)this, DefaultHlsPlaylistTracker.this.minRetryCount);
            DefaultHlsPlaylistTracker.this.eventDispatcher.loadStarted(this.mediaPlaylistLoadable.dataSpec, this.mediaPlaylistLoadable.type, elapsedRealtime);
        }

        private void processLoadedPlaylist(HlsMediaPlaylist loadedPlaylist) {
            long currentTimeMs;
            HlsMediaPlaylist oldPlaylist = this.playlistSnapshot;
            this.lastSnapshotLoadMs = currentTimeMs = SystemClock.elapsedRealtime();
            this.playlistSnapshot = DefaultHlsPlaylistTracker.this.getLatestPlaylistSnapshot(oldPlaylist, loadedPlaylist);
            if (this.playlistSnapshot != oldPlaylist) {
                this.playlistError = null;
                this.lastSnapshotChangeMs = currentTimeMs;
                DefaultHlsPlaylistTracker.this.onPlaylistUpdated(this.playlistUrl, this.playlistSnapshot);
            } else if (!this.playlistSnapshot.hasEndTag) {
                if (loadedPlaylist.mediaSequence + (long)loadedPlaylist.segments.size() < this.playlistSnapshot.mediaSequence) {
                    this.playlistError = new HlsPlaylistTracker.PlaylistResetException(this.playlistUrl.url);
                    DefaultHlsPlaylistTracker.this.notifyPlaylistError(this.playlistUrl, false);
                } else if ((double)(currentTimeMs - this.lastSnapshotChangeMs) > (double)C.usToMs((long)this.playlistSnapshot.targetDurationUs) * 3.5) {
                    this.playlistError = new HlsPlaylistTracker.PlaylistStuckException(this.playlistUrl.url);
                    DefaultHlsPlaylistTracker.this.notifyPlaylistError(this.playlistUrl, true);
                    this.blacklistPlaylist();
                }
            }
            this.earliestNextLoadTimeMs = currentTimeMs + C.usToMs((long)(this.playlistSnapshot != oldPlaylist ? this.playlistSnapshot.targetDurationUs : this.playlistSnapshot.targetDurationUs / 2L));
            if (this.playlistUrl == DefaultHlsPlaylistTracker.this.primaryHlsUrl && !this.playlistSnapshot.hasEndTag) {
                this.loadPlaylist();
            }
        }

        private boolean blacklistPlaylist() {
            this.blacklistUntilMs = SystemClock.elapsedRealtime() + 60000L;
            return DefaultHlsPlaylistTracker.this.primaryHlsUrl == this.playlistUrl && !DefaultHlsPlaylistTracker.this.maybeSelectNewPrimaryUrl();
        }
    }
}

