/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls.playlist;

import android.net.Uri;
import android.support.annotation.Nullable;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.source.hls.playlist.HlsMasterPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsMediaPlaylist;
import java.io.IOException;

public interface HlsPlaylistTracker {
    public void start(Uri var1, MediaSourceEventListener.EventDispatcher var2, PrimaryPlaylistListener var3);

    public void release();

    public void addListener(PlaylistEventListener var1);

    public void removeListener(PlaylistEventListener var1);

    @Nullable
    public HlsMasterPlaylist getMasterPlaylist();

    @Nullable
    public HlsMediaPlaylist getPlaylistSnapshot(HlsMasterPlaylist.HlsUrl var1);

    public long getInitialStartTimeUs();

    public boolean isSnapshotValid(HlsMasterPlaylist.HlsUrl var1);

    public void maybeThrowPrimaryPlaylistRefreshError() throws IOException;

    public void maybeThrowPlaylistRefreshError(HlsMasterPlaylist.HlsUrl var1) throws IOException;

    public void refreshPlaylist(HlsMasterPlaylist.HlsUrl var1);

    public boolean isLive();

    public static final class PlaylistResetException
    extends IOException {
        public final String url;

        public PlaylistResetException(String url) {
            this.url = url;
        }
    }

    public static final class PlaylistStuckException
    extends IOException {
        public final String url;

        public PlaylistStuckException(String url) {
            this.url = url;
        }
    }

    public static interface PlaylistEventListener {
        public void onPlaylistChanged();

        public boolean onPlaylistError(HlsMasterPlaylist.HlsUrl var1, boolean var2);
    }

    public static interface PrimaryPlaylistListener {
        public void onPrimaryPlaylistRefreshed(HlsMediaPlaylist var1);
    }
}

