/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls.playlist;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.RenditionKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class HlsMasterPlaylist
extends HlsPlaylist {
    public final List<HlsUrl> variants;
    public final List<HlsUrl> audios;
    public final List<HlsUrl> subtitles;
    public final Format muxedAudioFormat;
    public final List<Format> muxedCaptionFormats;

    public HlsMasterPlaylist(String baseUri, List<String> tags, List<HlsUrl> variants, List<HlsUrl> audios, List<HlsUrl> subtitles, Format muxedAudioFormat, List<Format> muxedCaptionFormats) {
        super(baseUri, tags);
        this.variants = Collections.unmodifiableList(variants);
        this.audios = Collections.unmodifiableList(audios);
        this.subtitles = Collections.unmodifiableList(subtitles);
        this.muxedAudioFormat = muxedAudioFormat;
        this.muxedCaptionFormats = muxedCaptionFormats != null ? Collections.unmodifiableList(muxedCaptionFormats) : null;
    }

    public HlsMasterPlaylist copy(List<RenditionKey> renditionKeys) {
        return new HlsMasterPlaylist(this.baseUri, this.tags, HlsMasterPlaylist.copyRenditionsList(this.variants, 0, renditionKeys), HlsMasterPlaylist.copyRenditionsList(this.audios, 1, renditionKeys), HlsMasterPlaylist.copyRenditionsList(this.subtitles, 2, renditionKeys), this.muxedAudioFormat, this.muxedCaptionFormats);
    }

    public static HlsMasterPlaylist createSingleVariantMasterPlaylist(String variantUrl) {
        List<HlsUrl> variant = Collections.singletonList(HlsUrl.createMediaPlaylistHlsUrl(variantUrl));
        List<HlsUrl> emptyList = Collections.emptyList();
        return new HlsMasterPlaylist(null, Collections.emptyList(), variant, emptyList, emptyList, null, null);
    }

    private static List<HlsUrl> copyRenditionsList(List<HlsUrl> renditions, int renditionType, List<RenditionKey> renditionKeys) {
        ArrayList<HlsUrl> copiedRenditions = new ArrayList<HlsUrl>(renditionKeys.size());
        block0: for (int i = 0; i < renditions.size(); ++i) {
            HlsUrl rendition = renditions.get(i);
            for (int j = 0; j < renditionKeys.size(); ++j) {
                RenditionKey renditionKey = renditionKeys.get(j);
                if (renditionKey.type != renditionType || renditionKey.trackIndex != i) continue;
                copiedRenditions.add(rendition);
                continue block0;
            }
        }
        return copiedRenditions;
    }

    public static final class HlsUrl {
        public final String url;
        public final Format format;

        public static HlsUrl createMediaPlaylistHlsUrl(String url) {
            Format format = Format.createContainerFormat((String)"0", (String)"application/x-mpegURL", null, null, (int)-1, (int)0, null);
            return new HlsUrl(url, format);
        }

        public HlsUrl(String url, Format format) {
            this.url = url;
            this.format = format;
        }
    }
}

