/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls;

import android.util.Pair;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.extractor.DefaultExtractorInput;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.id3.Id3Decoder;
import com.google.android.exoplayer2.metadata.id3.PrivFrame;
import com.google.android.exoplayer2.source.chunk.MediaChunk;
import com.google.android.exoplayer2.source.hls.Aes128DataSource;
import com.google.android.exoplayer2.source.hls.HlsExtractorFactory;
import com.google.android.exoplayer2.source.hls.HlsSampleStreamWrapper;
import com.google.android.exoplayer2.source.hls.playlist.HlsMasterPlaylist;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.TimestampAdjuster;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

final class HlsMediaChunk
extends MediaChunk {
    private static final String PRIV_TIMESTAMP_FRAME_OWNER = "com.apple.streaming.transportStreamTimestamp";
    private static final AtomicInteger uidSource = new AtomicInteger();
    public final int uid;
    public final int discontinuitySequenceNumber;
    public final HlsMasterPlaylist.HlsUrl hlsUrl;
    private final DataSource initDataSource;
    private final DataSpec initDataSpec;
    private final boolean isEncrypted;
    private final boolean isMasterTimestampSource;
    private final boolean hasGapTag;
    private final TimestampAdjuster timestampAdjuster;
    private final boolean shouldSpliceIn;
    private final Extractor extractor;
    private final boolean isPackedAudioExtractor;
    private final boolean reusingExtractor;
    private final Id3Decoder id3Decoder;
    private final ParsableByteArray id3Data;
    private HlsSampleStreamWrapper output;
    private int initSegmentBytesLoaded;
    private int bytesLoaded;
    private boolean id3TimestampPeeked;
    private boolean initLoadCompleted;
    private volatile boolean loadCanceled;
    private volatile boolean loadCompleted;

    public HlsMediaChunk(HlsExtractorFactory extractorFactory, DataSource dataSource, DataSpec dataSpec, DataSpec initDataSpec, HlsMasterPlaylist.HlsUrl hlsUrl, List<Format> muxedCaptionFormats, int trackSelectionReason, Object trackSelectionData, long startTimeUs, long endTimeUs, long chunkMediaSequence, int discontinuitySequenceNumber, boolean hasGapTag, boolean isMasterTimestampSource, TimestampAdjuster timestampAdjuster, HlsMediaChunk previousChunk, DrmInitData drmInitData, byte[] fullSegmentEncryptionKey, byte[] encryptionIv) {
        super(HlsMediaChunk.buildDataSource(dataSource, fullSegmentEncryptionKey, encryptionIv), dataSpec, hlsUrl.format, trackSelectionReason, trackSelectionData, startTimeUs, endTimeUs, chunkMediaSequence);
        this.discontinuitySequenceNumber = discontinuitySequenceNumber;
        this.initDataSpec = initDataSpec;
        this.hlsUrl = hlsUrl;
        this.isMasterTimestampSource = isMasterTimestampSource;
        this.timestampAdjuster = timestampAdjuster;
        this.isEncrypted = this.dataSource instanceof Aes128DataSource;
        this.hasGapTag = hasGapTag;
        Extractor previousExtractor = null;
        if (previousChunk != null) {
            this.shouldSpliceIn = previousChunk.hlsUrl != hlsUrl;
            previousExtractor = previousChunk.discontinuitySequenceNumber != discontinuitySequenceNumber || this.shouldSpliceIn ? null : previousChunk.extractor;
        } else {
            this.shouldSpliceIn = false;
        }
        Pair<Extractor, Boolean> extractorData = extractorFactory.createExtractor(previousExtractor, dataSpec.uri, this.trackFormat, muxedCaptionFormats, drmInitData, timestampAdjuster);
        this.extractor = (Extractor)extractorData.first;
        this.isPackedAudioExtractor = (Boolean)extractorData.second;
        this.reusingExtractor = this.extractor == previousExtractor;
        boolean bl = this.initLoadCompleted = this.reusingExtractor && initDataSpec != null;
        if (this.isPackedAudioExtractor) {
            if (previousChunk != null && previousChunk.id3Data != null) {
                this.id3Decoder = previousChunk.id3Decoder;
                this.id3Data = previousChunk.id3Data;
            } else {
                this.id3Decoder = new Id3Decoder();
                this.id3Data = new ParsableByteArray(10);
            }
        } else {
            this.id3Decoder = null;
            this.id3Data = null;
        }
        this.initDataSource = dataSource;
        this.uid = uidSource.getAndIncrement();
    }

    public void init(HlsSampleStreamWrapper output) {
        this.output = output;
        output.init(this.uid, this.shouldSpliceIn, this.reusingExtractor);
        if (!this.reusingExtractor) {
            this.extractor.init((ExtractorOutput)output);
        }
    }

    public boolean isLoadCompleted() {
        return this.loadCompleted;
    }

    public long bytesLoaded() {
        return this.bytesLoaded;
    }

    public void cancelLoad() {
        this.loadCanceled = true;
    }

    public boolean isLoadCanceled() {
        return this.loadCanceled;
    }

    public void load() throws IOException, InterruptedException {
        this.maybeLoadInitData();
        if (!this.loadCanceled) {
            if (!this.hasGapTag) {
                this.loadMedia();
            }
            this.loadCompleted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeLoadInitData() throws IOException, InterruptedException {
        if (this.initLoadCompleted || this.initDataSpec == null) {
            return;
        }
        DataSpec initSegmentDataSpec = this.initDataSpec.subrange((long)this.initSegmentBytesLoaded);
        try {
            DefaultExtractorInput input = new DefaultExtractorInput(this.initDataSource, initSegmentDataSpec.absoluteStreamPosition, this.initDataSource.open(initSegmentDataSpec));
            try {
                int result = 0;
                while (result == 0 && !this.loadCanceled) {
                    result = this.extractor.read((ExtractorInput)input, null);
                }
            }
            finally {
                this.initSegmentBytesLoaded = (int)(input.getPosition() - this.initDataSpec.absoluteStreamPosition);
            }
        }
        finally {
            Util.closeQuietly((DataSource)this.dataSource);
        }
        this.initLoadCompleted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMedia() throws IOException, InterruptedException {
        boolean skipLoadedBytes;
        DataSpec loadDataSpec;
        if (this.isEncrypted) {
            loadDataSpec = this.dataSpec;
            skipLoadedBytes = this.bytesLoaded != 0;
        } else {
            loadDataSpec = this.dataSpec.subrange((long)this.bytesLoaded);
            skipLoadedBytes = false;
        }
        if (!this.isMasterTimestampSource) {
            this.timestampAdjuster.waitUntilInitialized();
        } else if (this.timestampAdjuster.getFirstSampleTimestampUs() == Long.MAX_VALUE) {
            this.timestampAdjuster.setFirstSampleTimestampUs(this.startTimeUs);
        }
        try {
            DefaultExtractorInput input = new DefaultExtractorInput(this.dataSource, loadDataSpec.absoluteStreamPosition, this.dataSource.open(loadDataSpec));
            if (this.isPackedAudioExtractor && !this.id3TimestampPeeked) {
                long id3Timestamp = this.peekId3PrivTimestamp((ExtractorInput)input);
                this.id3TimestampPeeked = true;
                this.output.setSampleOffsetUs(id3Timestamp != -9223372036854775807L ? this.timestampAdjuster.adjustTsTimestamp(id3Timestamp) : this.startTimeUs);
            }
            if (skipLoadedBytes) {
                input.skipFully(this.bytesLoaded);
            }
            try {
                int result = 0;
                while (result == 0 && !this.loadCanceled) {
                    result = this.extractor.read((ExtractorInput)input, null);
                }
            }
            finally {
                this.bytesLoaded = (int)(input.getPosition() - this.dataSpec.absoluteStreamPosition);
            }
        }
        finally {
            Util.closeQuietly((DataSource)this.dataSource);
        }
    }

    private long peekId3PrivTimestamp(ExtractorInput input) throws IOException, InterruptedException {
        input.resetPeekPosition();
        if (!input.peekFully(this.id3Data.data, 0, 10, true)) {
            return -9223372036854775807L;
        }
        this.id3Data.reset(10);
        int id = this.id3Data.readUnsignedInt24();
        if (id != Id3Decoder.ID3_TAG) {
            return -9223372036854775807L;
        }
        this.id3Data.skipBytes(3);
        int id3Size = this.id3Data.readSynchSafeInt();
        int requiredCapacity = id3Size + 10;
        if (requiredCapacity > this.id3Data.capacity()) {
            byte[] data = this.id3Data.data;
            this.id3Data.reset(requiredCapacity);
            System.arraycopy(data, 0, this.id3Data.data, 0, 10);
        }
        if (!input.peekFully(this.id3Data.data, 10, id3Size, true)) {
            return -9223372036854775807L;
        }
        Metadata metadata = this.id3Decoder.decode(this.id3Data.data, id3Size);
        if (metadata == null) {
            return -9223372036854775807L;
        }
        int metadataLength = metadata.length();
        for (int i = 0; i < metadataLength; ++i) {
            Metadata.Entry frame = metadata.get(i);
            if (!(frame instanceof PrivFrame)) continue;
            PrivFrame privFrame = (PrivFrame)frame;
            if (!PRIV_TIMESTAMP_FRAME_OWNER.equals(privFrame.owner)) continue;
            System.arraycopy(privFrame.privateData, 0, this.id3Data.data, 0, 8);
            this.id3Data.reset(8);
            return this.id3Data.readLong() & 0x1FFFFFFFFL;
        }
        return -9223372036854775807L;
    }

    private static DataSource buildDataSource(DataSource dataSource, byte[] fullSegmentEncryptionKey, byte[] encryptionIv) {
        if (fullSegmentEncryptionKey != null) {
            return new Aes128DataSource(dataSource, fullSegmentEncryptionKey, encryptionIv);
        }
        return dataSource;
    }
}

