/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls;

import android.net.Uri;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSourceInputStream;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.util.Assertions;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

final class Aes128DataSource
implements DataSource {
    private final DataSource upstream;
    private final byte[] encryptionKey;
    private final byte[] encryptionIv;
    private CipherInputStream cipherInputStream;

    public Aes128DataSource(DataSource upstream, byte[] encryptionKey, byte[] encryptionIv) {
        this.upstream = upstream;
        this.encryptionKey = encryptionKey;
        this.encryptionIv = encryptionIv;
    }

    public long open(DataSpec dataSpec) throws IOException {
        Cipher cipher;
        try {
            cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
        SecretKeySpec cipherKey = new SecretKeySpec(this.encryptionKey, "AES");
        IvParameterSpec cipherIV = new IvParameterSpec(this.encryptionIv);
        try {
            cipher.init(2, (Key)cipherKey, cipherIV);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        DataSourceInputStream inputStream = new DataSourceInputStream(this.upstream, dataSpec);
        this.cipherInputStream = new CipherInputStream((InputStream)inputStream, cipher);
        inputStream.open();
        return -1L;
    }

    public void close() throws IOException {
        if (this.cipherInputStream != null) {
            this.cipherInputStream = null;
            this.upstream.close();
        }
    }

    public int read(byte[] buffer, int offset, int readLength) throws IOException {
        Assertions.checkState((this.cipherInputStream != null ? 1 : 0) != 0);
        int bytesRead = this.cipherInputStream.read(buffer, offset, readLength);
        if (bytesRead < 0) {
            return -1;
        }
        return bytesRead;
    }

    public Uri getUri() {
        return this.upstream.getUri();
    }
}

