/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls;

import android.os.Handler;
import android.util.Log;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.extractor.DummyTrackOutput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.source.SampleQueue;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.source.SequenceableLoader;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.source.chunk.Chunk;
import com.google.android.exoplayer2.source.hls.HlsChunkSource;
import com.google.android.exoplayer2.source.hls.HlsMediaChunk;
import com.google.android.exoplayer2.source.hls.HlsSampleStream;
import com.google.android.exoplayer2.source.hls.playlist.HlsMasterPlaylist;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.Loader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

final class HlsSampleStreamWrapper
implements Loader.Callback<Chunk>,
Loader.ReleaseCallback,
SequenceableLoader,
ExtractorOutput,
SampleQueue.UpstreamFormatChangedListener {
    private static final String TAG = "HlsSampleStreamWrapper";
    public static final int SAMPLE_QUEUE_INDEX_PENDING = -1;
    public static final int SAMPLE_QUEUE_INDEX_NO_MAPPING_FATAL = -2;
    public static final int SAMPLE_QUEUE_INDEX_NO_MAPPING_NON_FATAL = -3;
    private static final int PRIMARY_TYPE_NONE = 0;
    private static final int PRIMARY_TYPE_TEXT = 1;
    private static final int PRIMARY_TYPE_AUDIO = 2;
    private static final int PRIMARY_TYPE_VIDEO = 3;
    private final int trackType;
    private final Callback callback;
    private final HlsChunkSource chunkSource;
    private final Allocator allocator;
    private final Format muxedAudioFormat;
    private final int minLoadableRetryCount;
    private final Loader loader;
    private final MediaSourceEventListener.EventDispatcher eventDispatcher;
    private final HlsChunkSource.HlsChunkHolder nextChunkHolder;
    private final ArrayList<HlsMediaChunk> mediaChunks;
    private final Runnable maybeFinishPrepareRunnable;
    private final Runnable onTracksEndedRunnable;
    private final Handler handler;
    private SampleQueue[] sampleQueues;
    private int[] sampleQueueTrackIds;
    private boolean audioSampleQueueMappingDone;
    private int audioSampleQueueIndex;
    private boolean videoSampleQueueMappingDone;
    private int videoSampleQueueIndex;
    private boolean sampleQueuesBuilt;
    private boolean prepared;
    private int enabledTrackGroupCount;
    private Format downstreamTrackFormat;
    private boolean released;
    private TrackGroupArray trackGroups;
    private TrackGroupArray optionalTrackGroups;
    private int[] trackGroupToSampleQueueIndex;
    private int primaryTrackGroupIndex;
    private boolean haveAudioVideoSampleQueues;
    private boolean[] sampleQueuesEnabledStates;
    private boolean[] sampleQueueIsAudioVideoFlags;
    private long lastSeekPositionUs;
    private long pendingResetPositionUs;
    private boolean pendingResetUpstreamFormats;
    private boolean seenFirstTrackSelection;
    private boolean loadingFinished;
    private boolean tracksEnded;
    private long sampleOffsetUs;

    public HlsSampleStreamWrapper(int trackType, Callback callback, HlsChunkSource chunkSource, Allocator allocator, long positionUs, Format muxedAudioFormat, int minLoadableRetryCount, MediaSourceEventListener.EventDispatcher eventDispatcher) {
        this.trackType = trackType;
        this.callback = callback;
        this.chunkSource = chunkSource;
        this.allocator = allocator;
        this.muxedAudioFormat = muxedAudioFormat;
        this.minLoadableRetryCount = minLoadableRetryCount;
        this.eventDispatcher = eventDispatcher;
        this.loader = new Loader("Loader:HlsSampleStreamWrapper");
        this.nextChunkHolder = new HlsChunkSource.HlsChunkHolder();
        this.sampleQueueTrackIds = new int[0];
        this.audioSampleQueueIndex = -1;
        this.videoSampleQueueIndex = -1;
        this.sampleQueues = new SampleQueue[0];
        this.sampleQueueIsAudioVideoFlags = new boolean[0];
        this.sampleQueuesEnabledStates = new boolean[0];
        this.mediaChunks = new ArrayList();
        this.maybeFinishPrepareRunnable = new Runnable(){

            @Override
            public void run() {
                HlsSampleStreamWrapper.this.maybeFinishPrepare();
            }
        };
        this.onTracksEndedRunnable = new Runnable(){

            @Override
            public void run() {
                HlsSampleStreamWrapper.this.onTracksEnded();
            }
        };
        this.handler = new Handler();
        this.lastSeekPositionUs = positionUs;
        this.pendingResetPositionUs = positionUs;
    }

    public void continuePreparing() {
        if (!this.prepared) {
            this.continueLoading(this.lastSeekPositionUs);
        }
    }

    public void prepareWithMasterPlaylistInfo(TrackGroupArray trackGroups, int primaryTrackGroupIndex, TrackGroupArray optionalTrackGroups) {
        this.prepared = true;
        this.trackGroups = trackGroups;
        this.optionalTrackGroups = optionalTrackGroups;
        this.primaryTrackGroupIndex = primaryTrackGroupIndex;
        this.callback.onPrepared();
    }

    public void maybeThrowPrepareError() throws IOException {
        this.maybeThrowError();
    }

    public TrackGroupArray getTrackGroups() {
        return this.trackGroups;
    }

    public int bindSampleQueueToSampleStream(int trackGroupIndex) {
        if (this.trackGroupToSampleQueueIndex == null) {
            return -1;
        }
        int sampleQueueIndex = this.trackGroupToSampleQueueIndex[trackGroupIndex];
        if (sampleQueueIndex == -1) {
            return this.optionalTrackGroups.indexOf(this.trackGroups.get(trackGroupIndex)) == -1 ? -2 : -3;
        }
        if (this.sampleQueuesEnabledStates[sampleQueueIndex]) {
            return -2;
        }
        this.sampleQueuesEnabledStates[sampleQueueIndex] = true;
        return sampleQueueIndex;
    }

    public void unbindSampleQueue(int trackGroupIndex) {
        int sampleQueueIndex = this.trackGroupToSampleQueueIndex[trackGroupIndex];
        Assertions.checkState((boolean)this.sampleQueuesEnabledStates[sampleQueueIndex]);
        this.sampleQueuesEnabledStates[sampleQueueIndex] = false;
    }

    public boolean selectTracks(TrackSelection[] selections, boolean[] mayRetainStreamFlags, SampleStream[] streams, boolean[] streamResetFlags, long positionUs, boolean forceReset) {
        int i;
        TrackSelection oldPrimaryTrackSelection;
        Assertions.checkState((boolean)this.prepared);
        int oldEnabledTrackGroupCount = this.enabledTrackGroupCount;
        for (int i2 = 0; i2 < selections.length; ++i2) {
            if (streams[i2] == null || selections[i2] != null && mayRetainStreamFlags[i2]) continue;
            --this.enabledTrackGroupCount;
            ((HlsSampleStream)streams[i2]).unbindSampleQueue();
            streams[i2] = null;
        }
        boolean seekRequired = forceReset || (this.seenFirstTrackSelection ? oldEnabledTrackGroupCount == 0 : positionUs != this.lastSeekPositionUs);
        TrackSelection primaryTrackSelection = oldPrimaryTrackSelection = this.chunkSource.getTrackSelection();
        for (i = 0; i < selections.length; ++i) {
            if (streams[i] != null || selections[i] == null) continue;
            ++this.enabledTrackGroupCount;
            TrackSelection selection = selections[i];
            int trackGroupIndex = this.trackGroups.indexOf(selection.getTrackGroup());
            if (trackGroupIndex == this.primaryTrackGroupIndex) {
                primaryTrackSelection = selection;
                this.chunkSource.selectTracks(selection);
            }
            streams[i] = new HlsSampleStream(this, trackGroupIndex);
            streamResetFlags[i] = true;
            if (!this.sampleQueuesBuilt || seekRequired) continue;
            SampleQueue sampleQueue = this.sampleQueues[this.trackGroupToSampleQueueIndex[trackGroupIndex]];
            sampleQueue.rewind();
            seekRequired = sampleQueue.advanceTo(positionUs, true, true) == -1 && sampleQueue.getReadIndex() != 0;
        }
        if (this.enabledTrackGroupCount == 0) {
            this.chunkSource.reset();
            this.downstreamTrackFormat = null;
            this.mediaChunks.clear();
            if (this.loader.isLoading()) {
                if (this.sampleQueuesBuilt) {
                    for (SampleQueue sampleQueue : this.sampleQueues) {
                        sampleQueue.discardToEnd();
                    }
                }
                this.loader.cancelLoading();
            } else {
                this.resetSampleQueues();
            }
        } else {
            if (!this.mediaChunks.isEmpty() && !Util.areEqual((Object)primaryTrackSelection, (Object)oldPrimaryTrackSelection)) {
                boolean primarySampleQueueDirty = false;
                if (!this.seenFirstTrackSelection) {
                    long bufferedDurationUs = positionUs < 0L ? -positionUs : 0L;
                    primaryTrackSelection.updateSelectedTrack(positionUs, bufferedDurationUs, -9223372036854775807L);
                    int chunkIndex = this.chunkSource.getTrackGroup().indexOf(this.getLastMediaChunk().trackFormat);
                    if (primaryTrackSelection.getSelectedIndexInTrackGroup() != chunkIndex) {
                        primarySampleQueueDirty = true;
                    }
                } else {
                    primarySampleQueueDirty = true;
                }
                if (primarySampleQueueDirty) {
                    forceReset = true;
                    seekRequired = true;
                    this.pendingResetUpstreamFormats = true;
                }
            }
            if (seekRequired) {
                this.seekToUs(positionUs, forceReset);
                for (i = 0; i < streams.length; ++i) {
                    if (streams[i] == null) continue;
                    streamResetFlags[i] = true;
                }
            }
        }
        this.seenFirstTrackSelection = true;
        return seekRequired;
    }

    public void discardBuffer(long positionUs, boolean toKeyframe) {
        if (!this.sampleQueuesBuilt) {
            return;
        }
        int sampleQueueCount = this.sampleQueues.length;
        for (int i = 0; i < sampleQueueCount; ++i) {
            this.sampleQueues[i].discardTo(positionUs, toKeyframe, this.sampleQueuesEnabledStates[i]);
        }
    }

    public boolean seekToUs(long positionUs, boolean forceReset) {
        this.lastSeekPositionUs = positionUs;
        if (this.sampleQueuesBuilt && !forceReset && !this.isPendingReset() && this.seekInsideBufferUs(positionUs)) {
            return false;
        }
        this.pendingResetPositionUs = positionUs;
        this.loadingFinished = false;
        this.mediaChunks.clear();
        if (this.loader.isLoading()) {
            this.loader.cancelLoading();
        } else {
            this.resetSampleQueues();
        }
        return true;
    }

    public void release() {
        if (this.prepared) {
            for (SampleQueue sampleQueue : this.sampleQueues) {
                sampleQueue.discardToEnd();
            }
        }
        this.loader.release((Loader.ReleaseCallback)this);
        this.handler.removeCallbacksAndMessages(null);
        this.released = true;
    }

    public void onLoaderReleased() {
        this.resetSampleQueues();
    }

    public void setIsTimestampMaster(boolean isTimestampMaster) {
        this.chunkSource.setIsTimestampMaster(isTimestampMaster);
    }

    public boolean onPlaylistError(HlsMasterPlaylist.HlsUrl url, boolean shouldBlacklist) {
        return this.chunkSource.onPlaylistError(url, shouldBlacklist);
    }

    public boolean isReady(int sampleQueueIndex) {
        return this.loadingFinished || !this.isPendingReset() && this.sampleQueues[sampleQueueIndex].hasNextSample();
    }

    public void maybeThrowError() throws IOException {
        this.loader.maybeThrowError();
        this.chunkSource.maybeThrowError();
    }

    public int readData(int sampleQueueIndex, FormatHolder formatHolder, DecoderInputBuffer buffer, boolean requireFormat) {
        if (this.isPendingReset()) {
            return -3;
        }
        if (!this.mediaChunks.isEmpty()) {
            int discardToMediaChunkIndex;
            for (discardToMediaChunkIndex = 0; discardToMediaChunkIndex < this.mediaChunks.size() - 1 && this.finishedReadingChunk(this.mediaChunks.get(discardToMediaChunkIndex)); ++discardToMediaChunkIndex) {
            }
            if (discardToMediaChunkIndex > 0) {
                Util.removeRange(this.mediaChunks, (int)0, (int)discardToMediaChunkIndex);
            }
            HlsMediaChunk currentChunk = this.mediaChunks.get(0);
            Format trackFormat = currentChunk.trackFormat;
            if (!trackFormat.equals((Object)this.downstreamTrackFormat)) {
                this.eventDispatcher.downstreamFormatChanged(this.trackType, trackFormat, currentChunk.trackSelectionReason, currentChunk.trackSelectionData, currentChunk.startTimeUs);
            }
            this.downstreamTrackFormat = trackFormat;
        }
        return this.sampleQueues[sampleQueueIndex].read(formatHolder, buffer, requireFormat, this.loadingFinished, this.lastSeekPositionUs);
    }

    public int skipData(int sampleQueueIndex, long positionUs) {
        if (this.isPendingReset()) {
            return 0;
        }
        SampleQueue sampleQueue = this.sampleQueues[sampleQueueIndex];
        if (this.loadingFinished && positionUs > sampleQueue.getLargestQueuedTimestampUs()) {
            return sampleQueue.advanceToEnd();
        }
        int skipCount = sampleQueue.advanceTo(positionUs, true, true);
        return skipCount == -1 ? 0 : skipCount;
    }

    public long getBufferedPositionUs() {
        HlsMediaChunk lastCompletedMediaChunk;
        if (this.loadingFinished) {
            return Long.MIN_VALUE;
        }
        if (this.isPendingReset()) {
            return this.pendingResetPositionUs;
        }
        long bufferedPositionUs = this.lastSeekPositionUs;
        HlsMediaChunk lastMediaChunk = this.getLastMediaChunk();
        HlsMediaChunk hlsMediaChunk = lastMediaChunk.isLoadCompleted() ? lastMediaChunk : (lastCompletedMediaChunk = this.mediaChunks.size() > 1 ? this.mediaChunks.get(this.mediaChunks.size() - 2) : null);
        if (lastCompletedMediaChunk != null) {
            bufferedPositionUs = Math.max(bufferedPositionUs, lastCompletedMediaChunk.endTimeUs);
        }
        if (this.sampleQueuesBuilt) {
            for (SampleQueue sampleQueue : this.sampleQueues) {
                bufferedPositionUs = Math.max(bufferedPositionUs, sampleQueue.getLargestQueuedTimestampUs());
            }
        }
        return bufferedPositionUs;
    }

    public long getNextLoadPositionUs() {
        if (this.isPendingReset()) {
            return this.pendingResetPositionUs;
        }
        return this.loadingFinished ? Long.MIN_VALUE : this.getLastMediaChunk().endTimeUs;
    }

    public boolean continueLoading(long positionUs) {
        long loadPositionUs;
        HlsMediaChunk previousChunk;
        if (this.loadingFinished || this.loader.isLoading()) {
            return false;
        }
        if (this.isPendingReset()) {
            previousChunk = null;
            loadPositionUs = this.pendingResetPositionUs;
        } else {
            previousChunk = this.getLastMediaChunk();
            loadPositionUs = previousChunk.endTimeUs;
        }
        this.chunkSource.getNextChunk(previousChunk, positionUs, loadPositionUs, this.nextChunkHolder);
        boolean endOfStream = this.nextChunkHolder.endOfStream;
        Chunk loadable = this.nextChunkHolder.chunk;
        HlsMasterPlaylist.HlsUrl playlistToLoad = this.nextChunkHolder.playlist;
        this.nextChunkHolder.clear();
        if (endOfStream) {
            this.pendingResetPositionUs = -9223372036854775807L;
            this.loadingFinished = true;
            return true;
        }
        if (loadable == null) {
            if (playlistToLoad != null) {
                this.callback.onPlaylistRefreshRequired(playlistToLoad);
            }
            return false;
        }
        if (HlsSampleStreamWrapper.isMediaChunk(loadable)) {
            this.pendingResetPositionUs = -9223372036854775807L;
            HlsMediaChunk mediaChunk = (HlsMediaChunk)loadable;
            mediaChunk.init(this);
            this.mediaChunks.add(mediaChunk);
        }
        long elapsedRealtimeMs = this.loader.startLoading((Loader.Loadable)loadable, (Loader.Callback)this, this.minLoadableRetryCount);
        this.eventDispatcher.loadStarted(loadable.dataSpec, loadable.type, this.trackType, loadable.trackFormat, loadable.trackSelectionReason, loadable.trackSelectionData, loadable.startTimeUs, loadable.endTimeUs, elapsedRealtimeMs);
        return true;
    }

    public void reevaluateBuffer(long positionUs) {
    }

    public void onLoadCompleted(Chunk loadable, long elapsedRealtimeMs, long loadDurationMs) {
        this.chunkSource.onChunkLoadCompleted(loadable);
        this.eventDispatcher.loadCompleted(loadable.dataSpec, loadable.type, this.trackType, loadable.trackFormat, loadable.trackSelectionReason, loadable.trackSelectionData, loadable.startTimeUs, loadable.endTimeUs, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        if (!this.prepared) {
            this.continueLoading(this.lastSeekPositionUs);
        } else {
            this.callback.onContinueLoadingRequested(this);
        }
    }

    public void onLoadCanceled(Chunk loadable, long elapsedRealtimeMs, long loadDurationMs, boolean released) {
        this.eventDispatcher.loadCanceled(loadable.dataSpec, loadable.type, this.trackType, loadable.trackFormat, loadable.trackSelectionReason, loadable.trackSelectionData, loadable.startTimeUs, loadable.endTimeUs, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        if (!released) {
            this.resetSampleQueues();
            if (this.enabledTrackGroupCount > 0) {
                this.callback.onContinueLoadingRequested(this);
            }
        }
    }

    public int onLoadError(Chunk loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error) {
        long bytesLoaded = loadable.bytesLoaded();
        boolean isMediaChunk = HlsSampleStreamWrapper.isMediaChunk(loadable);
        boolean cancelable = !isMediaChunk || bytesLoaded == 0L;
        boolean canceled = false;
        if (this.chunkSource.onChunkLoadError(loadable, cancelable, error)) {
            if (isMediaChunk) {
                HlsMediaChunk removed = this.mediaChunks.remove(this.mediaChunks.size() - 1);
                Assertions.checkState((removed == loadable ? 1 : 0) != 0);
                if (this.mediaChunks.isEmpty()) {
                    this.pendingResetPositionUs = this.lastSeekPositionUs;
                }
            }
            canceled = true;
        }
        this.eventDispatcher.loadError(loadable.dataSpec, loadable.type, this.trackType, loadable.trackFormat, loadable.trackSelectionReason, loadable.trackSelectionData, loadable.startTimeUs, loadable.endTimeUs, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded(), error, canceled);
        if (canceled) {
            if (!this.prepared) {
                this.continueLoading(this.lastSeekPositionUs);
            } else {
                this.callback.onContinueLoadingRequested(this);
            }
            return 2;
        }
        return error instanceof ParserException ? 3 : 0;
    }

    public void init(int chunkUid, boolean shouldSpliceIn, boolean reusingExtractor) {
        if (!reusingExtractor) {
            this.audioSampleQueueMappingDone = false;
            this.videoSampleQueueMappingDone = false;
        }
        for (SampleQueue sampleQueue : this.sampleQueues) {
            sampleQueue.sourceId(chunkUid);
        }
        if (shouldSpliceIn) {
            for (SampleQueue sampleQueue : this.sampleQueues) {
                sampleQueue.splice();
            }
        }
    }

    public TrackOutput track(int id, int type) {
        int trackCount = this.sampleQueues.length;
        if (type == 1) {
            if (this.audioSampleQueueIndex != -1) {
                if (this.audioSampleQueueMappingDone) {
                    return this.sampleQueueTrackIds[this.audioSampleQueueIndex] == id ? this.sampleQueues[this.audioSampleQueueIndex] : HlsSampleStreamWrapper.createDummyTrackOutput(id, type);
                }
                this.audioSampleQueueMappingDone = true;
                this.sampleQueueTrackIds[this.audioSampleQueueIndex] = id;
                return this.sampleQueues[this.audioSampleQueueIndex];
            }
            if (this.tracksEnded) {
                return HlsSampleStreamWrapper.createDummyTrackOutput(id, type);
            }
        } else if (type == 2) {
            if (this.videoSampleQueueIndex != -1) {
                if (this.videoSampleQueueMappingDone) {
                    return this.sampleQueueTrackIds[this.videoSampleQueueIndex] == id ? this.sampleQueues[this.videoSampleQueueIndex] : HlsSampleStreamWrapper.createDummyTrackOutput(id, type);
                }
                this.videoSampleQueueMappingDone = true;
                this.sampleQueueTrackIds[this.videoSampleQueueIndex] = id;
                return this.sampleQueues[this.videoSampleQueueIndex];
            }
            if (this.tracksEnded) {
                return HlsSampleStreamWrapper.createDummyTrackOutput(id, type);
            }
        } else {
            for (int i = 0; i < trackCount; ++i) {
                if (this.sampleQueueTrackIds[i] != id) continue;
                return this.sampleQueues[i];
            }
            if (this.tracksEnded) {
                return HlsSampleStreamWrapper.createDummyTrackOutput(id, type);
            }
        }
        SampleQueue trackOutput = new SampleQueue(this.allocator);
        trackOutput.setSampleOffsetUs(this.sampleOffsetUs);
        trackOutput.setUpstreamFormatChangeListener((SampleQueue.UpstreamFormatChangedListener)this);
        this.sampleQueueTrackIds = Arrays.copyOf(this.sampleQueueTrackIds, trackCount + 1);
        this.sampleQueueTrackIds[trackCount] = id;
        this.sampleQueues = Arrays.copyOf(this.sampleQueues, trackCount + 1);
        this.sampleQueues[trackCount] = trackOutput;
        this.sampleQueueIsAudioVideoFlags = Arrays.copyOf(this.sampleQueueIsAudioVideoFlags, trackCount + 1);
        this.sampleQueueIsAudioVideoFlags[trackCount] = type == 1 || type == 2;
        this.haveAudioVideoSampleQueues |= this.sampleQueueIsAudioVideoFlags[trackCount];
        if (type == 1) {
            this.audioSampleQueueMappingDone = true;
            this.audioSampleQueueIndex = trackCount;
        } else if (type == 2) {
            this.videoSampleQueueMappingDone = true;
            this.videoSampleQueueIndex = trackCount;
        }
        this.sampleQueuesEnabledStates = Arrays.copyOf(this.sampleQueuesEnabledStates, trackCount + 1);
        return trackOutput;
    }

    public void endTracks() {
        this.tracksEnded = true;
        this.handler.post(this.onTracksEndedRunnable);
    }

    public void seekMap(SeekMap seekMap) {
    }

    public void onUpstreamFormatChanged(Format format) {
        this.handler.post(this.maybeFinishPrepareRunnable);
    }

    public void setSampleOffsetUs(long sampleOffsetUs) {
        this.sampleOffsetUs = sampleOffsetUs;
        for (SampleQueue sampleQueue : this.sampleQueues) {
            sampleQueue.setSampleOffsetUs(sampleOffsetUs);
        }
    }

    private boolean finishedReadingChunk(HlsMediaChunk chunk) {
        int chunkUid = chunk.uid;
        int sampleQueueCount = this.sampleQueues.length;
        for (int i = 0; i < sampleQueueCount; ++i) {
            if (!this.sampleQueuesEnabledStates[i] || this.sampleQueues[i].peekSourceId() != chunkUid) continue;
            return false;
        }
        return true;
    }

    private void resetSampleQueues() {
        for (SampleQueue sampleQueue : this.sampleQueues) {
            sampleQueue.reset(this.pendingResetUpstreamFormats);
        }
        this.pendingResetUpstreamFormats = false;
    }

    private void onTracksEnded() {
        this.sampleQueuesBuilt = true;
        this.maybeFinishPrepare();
    }

    private void maybeFinishPrepare() {
        if (this.released || this.trackGroupToSampleQueueIndex != null || !this.sampleQueuesBuilt) {
            return;
        }
        for (SampleQueue sampleQueue : this.sampleQueues) {
            if (sampleQueue.getUpstreamFormat() != null) continue;
            return;
        }
        if (this.trackGroups != null) {
            this.mapSampleQueuesToMatchTrackGroups();
        } else {
            this.buildTracksFromSampleStreams();
            this.prepared = true;
            this.callback.onPrepared();
        }
    }

    private void mapSampleQueuesToMatchTrackGroups() {
        int trackGroupCount = this.trackGroups.length;
        this.trackGroupToSampleQueueIndex = new int[trackGroupCount];
        Arrays.fill(this.trackGroupToSampleQueueIndex, -1);
        block0: for (int i = 0; i < trackGroupCount; ++i) {
            for (int queueIndex = 0; queueIndex < this.sampleQueues.length; ++queueIndex) {
                SampleQueue sampleQueue = this.sampleQueues[queueIndex];
                if (!HlsSampleStreamWrapper.formatsMatch(sampleQueue.getUpstreamFormat(), this.trackGroups.get(i).getFormat(0))) continue;
                this.trackGroupToSampleQueueIndex[i] = queueIndex;
                continue block0;
            }
        }
    }

    private void buildTracksFromSampleStreams() {
        int primaryExtractorTrackType = 0;
        int primaryExtractorTrackIndex = -1;
        int extractorTrackCount = this.sampleQueues.length;
        for (int i = 0; i < extractorTrackCount; ++i) {
            String sampleMimeType = this.sampleQueues[i].getUpstreamFormat().sampleMimeType;
            int trackType = MimeTypes.isVideo((String)sampleMimeType) ? 3 : (MimeTypes.isAudio((String)sampleMimeType) ? 2 : (MimeTypes.isText((String)sampleMimeType) ? 1 : 0));
            if (trackType > primaryExtractorTrackType) {
                primaryExtractorTrackType = trackType;
                primaryExtractorTrackIndex = i;
                continue;
            }
            if (trackType != primaryExtractorTrackType || primaryExtractorTrackIndex == -1) continue;
            primaryExtractorTrackIndex = -1;
        }
        TrackGroup chunkSourceTrackGroup = this.chunkSource.getTrackGroup();
        int chunkSourceTrackCount = chunkSourceTrackGroup.length;
        this.primaryTrackGroupIndex = -1;
        this.trackGroupToSampleQueueIndex = new int[extractorTrackCount];
        for (int i = 0; i < extractorTrackCount; ++i) {
            this.trackGroupToSampleQueueIndex[i] = i;
        }
        TrackGroup[] trackGroups = new TrackGroup[extractorTrackCount];
        for (int i = 0; i < extractorTrackCount; ++i) {
            Format sampleFormat = this.sampleQueues[i].getUpstreamFormat();
            if (i == primaryExtractorTrackIndex) {
                Format[] formats = new Format[chunkSourceTrackCount];
                for (int j = 0; j < chunkSourceTrackCount; ++j) {
                    formats[j] = HlsSampleStreamWrapper.deriveFormat(chunkSourceTrackGroup.getFormat(j), sampleFormat, true);
                }
                trackGroups[i] = new TrackGroup(formats);
                this.primaryTrackGroupIndex = i;
                continue;
            }
            Format trackFormat = primaryExtractorTrackType == 3 && MimeTypes.isAudio((String)sampleFormat.sampleMimeType) ? this.muxedAudioFormat : null;
            trackGroups[i] = new TrackGroup(new Format[]{HlsSampleStreamWrapper.deriveFormat(trackFormat, sampleFormat, false)});
        }
        this.trackGroups = new TrackGroupArray(trackGroups);
        Assertions.checkState((this.optionalTrackGroups == null ? 1 : 0) != 0);
        this.optionalTrackGroups = TrackGroupArray.EMPTY;
    }

    private HlsMediaChunk getLastMediaChunk() {
        return this.mediaChunks.get(this.mediaChunks.size() - 1);
    }

    private boolean isPendingReset() {
        return this.pendingResetPositionUs != -9223372036854775807L;
    }

    private boolean seekInsideBufferUs(long positionUs) {
        int sampleQueueCount = this.sampleQueues.length;
        for (int i = 0; i < sampleQueueCount; ++i) {
            boolean seekInsideQueue;
            SampleQueue sampleQueue = this.sampleQueues[i];
            sampleQueue.rewind();
            boolean bl = seekInsideQueue = sampleQueue.advanceTo(positionUs, true, false) != -1;
            if (seekInsideQueue || !this.sampleQueueIsAudioVideoFlags[i] && this.haveAudioVideoSampleQueues) continue;
            return false;
        }
        return true;
    }

    private static Format deriveFormat(Format playlistFormat, Format sampleFormat, boolean propagateBitrate) {
        if (playlistFormat == null) {
            return sampleFormat;
        }
        int bitrate = propagateBitrate ? playlistFormat.bitrate : -1;
        int sampleTrackType = MimeTypes.getTrackType((String)sampleFormat.sampleMimeType);
        String codecs = Util.getCodecsOfType((String)playlistFormat.codecs, (int)sampleTrackType);
        String mimeType = MimeTypes.getMediaMimeType((String)codecs);
        if (mimeType == null) {
            mimeType = sampleFormat.sampleMimeType;
        }
        return sampleFormat.copyWithContainerInfo(playlistFormat.id, mimeType, codecs, bitrate, playlistFormat.width, playlistFormat.height, playlistFormat.selectionFlags, playlistFormat.language);
    }

    private static boolean isMediaChunk(Chunk chunk) {
        return chunk instanceof HlsMediaChunk;
    }

    private static boolean formatsMatch(Format manifestFormat, Format sampleFormat) {
        String manifestFormatMimeType = manifestFormat.sampleMimeType;
        String sampleFormatMimeType = sampleFormat.sampleMimeType;
        int manifestFormatTrackType = MimeTypes.getTrackType((String)manifestFormatMimeType);
        if (manifestFormatTrackType != 3) {
            return manifestFormatTrackType == MimeTypes.getTrackType((String)sampleFormatMimeType);
        }
        if (!Util.areEqual((Object)manifestFormatMimeType, (Object)sampleFormatMimeType)) {
            return false;
        }
        if ("application/cea-608".equals(manifestFormatMimeType) || "application/cea-708".equals(manifestFormatMimeType)) {
            return manifestFormat.accessibilityChannel == sampleFormat.accessibilityChannel;
        }
        return true;
    }

    private static DummyTrackOutput createDummyTrackOutput(int id, int type) {
        Log.w((String)TAG, (String)("Unmapped track with id " + id + " of type " + type));
        return new DummyTrackOutput();
    }

    public static interface Callback
    extends SequenceableLoader.Callback<HlsSampleStreamWrapper> {
        public void onPrepared();

        public void onPlaylistRefreshRequired(HlsMasterPlaylist.HlsUrl var1);
    }
}

