/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls;

import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.source.hls.HlsSampleStreamWrapper;
import com.google.android.exoplayer2.source.hls.SampleQueueMappingException;
import java.io.IOException;

final class HlsSampleStream
implements SampleStream {
    private final int trackGroupIndex;
    private final HlsSampleStreamWrapper sampleStreamWrapper;
    private int sampleQueueIndex;

    public HlsSampleStream(HlsSampleStreamWrapper sampleStreamWrapper, int trackGroupIndex) {
        this.sampleStreamWrapper = sampleStreamWrapper;
        this.trackGroupIndex = trackGroupIndex;
        this.sampleQueueIndex = -1;
    }

    public void unbindSampleQueue() {
        if (this.sampleQueueIndex != -1) {
            this.sampleStreamWrapper.unbindSampleQueue(this.trackGroupIndex);
            this.sampleQueueIndex = -1;
        }
    }

    public boolean isReady() {
        return this.sampleQueueIndex == -3 || this.maybeMapToSampleQueue() && this.sampleStreamWrapper.isReady(this.sampleQueueIndex);
    }

    public void maybeThrowError() throws IOException {
        this.maybeMapToSampleQueue();
        if (this.sampleQueueIndex == -2) {
            throw new SampleQueueMappingException(this.sampleStreamWrapper.getTrackGroups().get((int)this.trackGroupIndex).getFormat((int)0).sampleMimeType);
        }
        this.sampleStreamWrapper.maybeThrowError();
    }

    public int readData(FormatHolder formatHolder, DecoderInputBuffer buffer, boolean requireFormat) {
        return this.maybeMapToSampleQueue() ? this.sampleStreamWrapper.readData(this.sampleQueueIndex, formatHolder, buffer, requireFormat) : -3;
    }

    public int skipData(long positionUs) {
        return this.maybeMapToSampleQueue() ? this.sampleStreamWrapper.skipData(this.sampleQueueIndex, positionUs) : 0;
    }

    private boolean maybeMapToSampleQueue() {
        if (this.sampleQueueIndex == -1) {
            this.sampleQueueIndex = this.sampleStreamWrapper.bindSampleQueueToSampleStream(this.trackGroupIndex);
        }
        return this.sampleQueueIndex != -1 && this.sampleQueueIndex != -3 && this.sampleQueueIndex != -2;
    }
}

