/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls.playlist;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylist;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class HlsMasterPlaylist
extends HlsPlaylist {
    public final List<HlsUrl> variants;
    public final List<HlsUrl> audios;
    public final List<HlsUrl> subtitles;
    public final Format muxedAudioFormat;
    public final List<Format> muxedCaptionFormats;

    public HlsMasterPlaylist(String baseUri, List<String> tags, List<HlsUrl> variants, List<HlsUrl> audios, List<HlsUrl> subtitles, Format muxedAudioFormat, List<Format> muxedCaptionFormats) {
        super(baseUri, tags);
        this.variants = Collections.unmodifiableList(variants);
        this.audios = Collections.unmodifiableList(audios);
        this.subtitles = Collections.unmodifiableList(subtitles);
        this.muxedAudioFormat = muxedAudioFormat;
        this.muxedCaptionFormats = muxedCaptionFormats != null ? Collections.unmodifiableList(muxedCaptionFormats) : null;
    }

    public HlsMasterPlaylist copy(List<String> renditionUrls) {
        return new HlsMasterPlaylist(this.baseUri, this.tags, HlsMasterPlaylist.copyRenditionsList(this.variants, renditionUrls), HlsMasterPlaylist.copyRenditionsList(this.audios, renditionUrls), HlsMasterPlaylist.copyRenditionsList(this.subtitles, renditionUrls), this.muxedAudioFormat, this.muxedCaptionFormats);
    }

    public static HlsMasterPlaylist createSingleVariantMasterPlaylist(String variantUrl) {
        List<HlsUrl> variant = Collections.singletonList(HlsUrl.createMediaPlaylistHlsUrl(variantUrl));
        List<HlsUrl> emptyList = Collections.emptyList();
        return new HlsMasterPlaylist(null, Collections.emptyList(), variant, emptyList, emptyList, null, null);
    }

    private static List<HlsUrl> copyRenditionsList(List<HlsUrl> renditions, List<String> urls) {
        ArrayList<HlsUrl> copiedRenditions = new ArrayList<HlsUrl>(urls.size());
        for (int i = 0; i < renditions.size(); ++i) {
            HlsUrl rendition = renditions.get(i);
            if (!urls.contains(rendition.url)) continue;
            copiedRenditions.add(rendition);
        }
        return copiedRenditions;
    }

    public static final class HlsUrl {
        public final String url;
        public final Format format;

        public static HlsUrl createMediaPlaylistHlsUrl(String url) {
            Format format = Format.createContainerFormat((String)"0", (String)"application/x-mpegURL", null, null, (int)-1, (int)0, null);
            return new HlsUrl(url, format);
        }

        public HlsUrl(String url, Format format) {
            this.url = url;
            this.format = format;
        }
    }
}

