/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls.offline;

import android.net.Uri;
import com.google.android.exoplayer2.offline.DownloaderConstructorHelper;
import com.google.android.exoplayer2.offline.SegmentDownloader;
import com.google.android.exoplayer2.source.hls.playlist.HlsMasterPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsMediaPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylistParser;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.ParsingLoadable;
import com.google.android.exoplayer2.util.UriUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class HlsDownloader
extends SegmentDownloader<HlsMasterPlaylist, String> {
    public HlsDownloader(Uri manifestUri, DownloaderConstructorHelper constructorHelper) {
        super(manifestUri, constructorHelper);
    }

    protected HlsMasterPlaylist getManifest(DataSource dataSource, Uri uri) throws IOException {
        HlsPlaylist hlsPlaylist = this.loadManifest(dataSource, uri);
        if (hlsPlaylist instanceof HlsMasterPlaylist) {
            return (HlsMasterPlaylist)hlsPlaylist;
        }
        return HlsMasterPlaylist.createSingleVariantMasterPlaylist(hlsPlaylist.baseUri);
    }

    protected List<SegmentDownloader.Segment> getAllSegments(DataSource dataSource, HlsMasterPlaylist manifest, boolean allowIndexLoadErrors) throws InterruptedException, IOException {
        ArrayList<String> urls = new ArrayList<String>();
        HlsDownloader.extractUrls(manifest.variants, urls);
        HlsDownloader.extractUrls(manifest.audios, urls);
        HlsDownloader.extractUrls(manifest.subtitles, urls);
        return this.getSegments(dataSource, manifest, urls.toArray(new String[urls.size()]), allowIndexLoadErrors);
    }

    protected List<SegmentDownloader.Segment> getSegments(DataSource dataSource, HlsMasterPlaylist manifest, String[] keys, boolean allowIndexLoadErrors) throws InterruptedException, IOException {
        HashSet<Uri> encryptionKeyUris = new HashSet<Uri>();
        ArrayList<SegmentDownloader.Segment> segments = new ArrayList<SegmentDownloader.Segment>();
        for (String playlistUrl : keys) {
            Uri uri;
            HlsMediaPlaylist mediaPlaylist;
            block5: {
                mediaPlaylist = null;
                uri = UriUtil.resolveToUri((String)manifest.baseUri, (String)playlistUrl);
                try {
                    mediaPlaylist = (HlsMediaPlaylist)this.loadManifest(dataSource, uri);
                }
                catch (IOException e) {
                    if (allowIndexLoadErrors) break block5;
                    throw e;
                }
            }
            segments.add(new SegmentDownloader.Segment(mediaPlaylist != null ? mediaPlaylist.startTimeUs : Long.MIN_VALUE, new DataSpec(uri)));
            if (mediaPlaylist == null) continue;
            HlsMediaPlaylist.Segment initSegment = mediaPlaylist.initializationSegment;
            if (initSegment != null) {
                HlsDownloader.addSegment(segments, mediaPlaylist, initSegment, encryptionKeyUris);
            }
            List<HlsMediaPlaylist.Segment> hlsSegments = mediaPlaylist.segments;
            for (int i = 0; i < hlsSegments.size(); ++i) {
                HlsDownloader.addSegment(segments, mediaPlaylist, hlsSegments.get(i), encryptionKeyUris);
            }
        }
        return segments;
    }

    private HlsPlaylist loadManifest(DataSource dataSource, Uri uri) throws IOException {
        DataSpec dataSpec = new DataSpec(uri, 3);
        ParsingLoadable loadable = new ParsingLoadable(dataSource, dataSpec, 4, (ParsingLoadable.Parser)new HlsPlaylistParser());
        loadable.load();
        return (HlsPlaylist)loadable.getResult();
    }

    private static void addSegment(ArrayList<SegmentDownloader.Segment> segments, HlsMediaPlaylist mediaPlaylist, HlsMediaPlaylist.Segment hlsSegment, HashSet<Uri> encryptionKeyUris) throws IOException, InterruptedException {
        Uri keyUri;
        long startTimeUs = mediaPlaylist.startTimeUs + hlsSegment.relativeStartTimeUs;
        if (hlsSegment.fullSegmentEncryptionKeyUri != null && encryptionKeyUris.add(keyUri = UriUtil.resolveToUri((String)mediaPlaylist.baseUri, (String)hlsSegment.fullSegmentEncryptionKeyUri))) {
            segments.add(new SegmentDownloader.Segment(startTimeUs, new DataSpec(keyUri)));
        }
        Uri resolvedUri = UriUtil.resolveToUri((String)mediaPlaylist.baseUri, (String)hlsSegment.url);
        segments.add(new SegmentDownloader.Segment(startTimeUs, new DataSpec(resolvedUri, hlsSegment.byterangeOffset, hlsSegment.byterangeLength, null)));
    }

    private static void extractUrls(List<HlsMasterPlaylist.HlsUrl> hlsUrls, ArrayList<String> urls) {
        for (int i = 0; i < hlsUrls.size(); ++i) {
            urls.add(hlsUrls.get((int)i).url);
        }
    }
}

