/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls;

import android.os.Handler;
import android.text.TextUtils;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.source.SampleQueue;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.source.SequenceableLoader;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.source.chunk.Chunk;
import com.google.android.exoplayer2.source.hls.HlsChunkSource;
import com.google.android.exoplayer2.source.hls.HlsMediaChunk;
import com.google.android.exoplayer2.source.hls.HlsSampleStream;
import com.google.android.exoplayer2.source.hls.playlist.HlsMasterPlaylist;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.Loader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;

final class HlsSampleStreamWrapper
implements Loader.Callback<Chunk>,
Loader.ReleaseCallback,
SequenceableLoader,
ExtractorOutput,
SampleQueue.UpstreamFormatChangedListener {
    private static final int PRIMARY_TYPE_NONE = 0;
    private static final int PRIMARY_TYPE_TEXT = 1;
    private static final int PRIMARY_TYPE_AUDIO = 2;
    private static final int PRIMARY_TYPE_VIDEO = 3;
    private final int trackType;
    private final Callback callback;
    private final HlsChunkSource chunkSource;
    private final Allocator allocator;
    private final Format muxedAudioFormat;
    private final int minLoadableRetryCount;
    private final Loader loader;
    private final MediaSourceEventListener.EventDispatcher eventDispatcher;
    private final HlsChunkSource.HlsChunkHolder nextChunkHolder;
    private final LinkedList<HlsMediaChunk> mediaChunks;
    private final Runnable maybeFinishPrepareRunnable;
    private final Handler handler;
    private SampleQueue[] sampleQueues;
    private int[] sampleQueueTrackIds;
    private boolean sampleQueuesBuilt;
    private boolean prepared;
    private int enabledTrackCount;
    private Format downstreamTrackFormat;
    private boolean released;
    private TrackGroupArray trackGroups;
    private int primaryTrackGroupIndex;
    private boolean haveAudioVideoTrackGroups;
    private boolean[] trackGroupEnabledStates;
    private boolean[] trackGroupIsAudioVideoFlags;
    private long sampleOffsetUs;
    private long lastSeekPositionUs;
    private long pendingResetPositionUs;
    private boolean pendingResetUpstreamFormats;
    private boolean seenFirstTrackSelection;
    private boolean loadingFinished;

    public HlsSampleStreamWrapper(int trackType, Callback callback, HlsChunkSource chunkSource, Allocator allocator, long positionUs, Format muxedAudioFormat, int minLoadableRetryCount, MediaSourceEventListener.EventDispatcher eventDispatcher) {
        this.trackType = trackType;
        this.callback = callback;
        this.chunkSource = chunkSource;
        this.allocator = allocator;
        this.muxedAudioFormat = muxedAudioFormat;
        this.minLoadableRetryCount = minLoadableRetryCount;
        this.eventDispatcher = eventDispatcher;
        this.loader = new Loader("Loader:HlsSampleStreamWrapper");
        this.nextChunkHolder = new HlsChunkSource.HlsChunkHolder();
        this.sampleQueueTrackIds = new int[0];
        this.sampleQueues = new SampleQueue[0];
        this.mediaChunks = new LinkedList();
        this.maybeFinishPrepareRunnable = new Runnable(){

            @Override
            public void run() {
                HlsSampleStreamWrapper.this.maybeFinishPrepare();
            }
        };
        this.handler = new Handler();
        this.lastSeekPositionUs = positionUs;
        this.pendingResetPositionUs = positionUs;
    }

    public void continuePreparing() {
        if (!this.prepared) {
            this.continueLoading(this.lastSeekPositionUs);
        }
    }

    public void prepareSingleTrack(Format format) {
        this.track(0, -1).format(format);
        this.sampleQueuesBuilt = true;
        this.maybeFinishPrepare();
    }

    public void maybeThrowPrepareError() throws IOException {
        this.maybeThrowError();
    }

    public TrackGroupArray getTrackGroups() {
        return this.trackGroups;
    }

    public boolean selectTracks(TrackSelection[] selections, boolean[] mayRetainStreamFlags, SampleStream[] streams, boolean[] streamResetFlags, long positionUs, boolean forceReset) {
        int i;
        TrackSelection oldPrimaryTrackSelection;
        Assertions.checkState((boolean)this.prepared);
        int oldEnabledTrackCount = this.enabledTrackCount;
        for (int i2 = 0; i2 < selections.length; ++i2) {
            if (streams[i2] == null || selections[i2] != null && mayRetainStreamFlags[i2]) continue;
            int group = ((HlsSampleStream)streams[i2]).group;
            this.setTrackGroupEnabledState(group, false);
            streams[i2] = null;
        }
        boolean seekRequired = forceReset || (this.seenFirstTrackSelection ? oldEnabledTrackCount == 0 : positionUs != this.lastSeekPositionUs);
        TrackSelection primaryTrackSelection = oldPrimaryTrackSelection = this.chunkSource.getTrackSelection();
        for (i = 0; i < selections.length; ++i) {
            if (streams[i] != null || selections[i] == null) continue;
            TrackSelection selection = selections[i];
            int trackGroupIndex = this.trackGroups.indexOf(selection.getTrackGroup());
            this.setTrackGroupEnabledState(trackGroupIndex, true);
            if (trackGroupIndex == this.primaryTrackGroupIndex) {
                primaryTrackSelection = selection;
                this.chunkSource.selectTracks(selection);
            }
            streams[i] = new HlsSampleStream(this, trackGroupIndex);
            streamResetFlags[i] = true;
            if (seekRequired) continue;
            SampleQueue sampleQueue = this.sampleQueues[trackGroupIndex];
            sampleQueue.rewind();
            seekRequired = sampleQueue.advanceTo(positionUs, true, true) == -1 && sampleQueue.getReadIndex() != 0;
        }
        if (this.enabledTrackCount == 0) {
            this.chunkSource.reset();
            this.downstreamTrackFormat = null;
            this.mediaChunks.clear();
            if (this.loader.isLoading()) {
                for (SampleQueue sampleQueue : this.sampleQueues) {
                    sampleQueue.discardToEnd();
                }
                this.loader.cancelLoading();
            } else {
                this.resetSampleQueues();
            }
        } else {
            if (!this.mediaChunks.isEmpty() && !Util.areEqual((Object)primaryTrackSelection, (Object)oldPrimaryTrackSelection)) {
                boolean primarySampleQueueDirty = false;
                if (!this.seenFirstTrackSelection) {
                    long bufferedDurationUs = positionUs < 0L ? -positionUs : 0L;
                    primaryTrackSelection.updateSelectedTrack(positionUs, bufferedDurationUs, -9223372036854775807L);
                    int chunkIndex = this.chunkSource.getTrackGroup().indexOf(this.mediaChunks.getLast().trackFormat);
                    if (primaryTrackSelection.getSelectedIndexInTrackGroup() != chunkIndex) {
                        primarySampleQueueDirty = true;
                    }
                } else {
                    primarySampleQueueDirty = true;
                }
                if (primarySampleQueueDirty) {
                    forceReset = true;
                    seekRequired = true;
                    this.pendingResetUpstreamFormats = true;
                }
            }
            if (seekRequired) {
                this.seekToUs(positionUs, forceReset);
                for (i = 0; i < streams.length; ++i) {
                    if (streams[i] == null) continue;
                    streamResetFlags[i] = true;
                }
            }
        }
        this.seenFirstTrackSelection = true;
        return seekRequired;
    }

    public void discardBuffer(long positionUs) {
        int sampleQueueCount = this.sampleQueues.length;
        for (int i = 0; i < sampleQueueCount; ++i) {
            this.sampleQueues[i].discardTo(positionUs, false, this.trackGroupEnabledStates[i]);
        }
    }

    public boolean seekToUs(long positionUs, boolean forceReset) {
        this.lastSeekPositionUs = positionUs;
        if (!forceReset && !this.isPendingReset() && this.seekInsideBufferUs(positionUs)) {
            return false;
        }
        this.pendingResetPositionUs = positionUs;
        this.loadingFinished = false;
        this.mediaChunks.clear();
        if (this.loader.isLoading()) {
            this.loader.cancelLoading();
        } else {
            this.resetSampleQueues();
        }
        return true;
    }

    public long getBufferedPositionUs() {
        HlsMediaChunk lastCompletedMediaChunk;
        if (this.loadingFinished) {
            return Long.MIN_VALUE;
        }
        if (this.isPendingReset()) {
            return this.pendingResetPositionUs;
        }
        long bufferedPositionUs = this.lastSeekPositionUs;
        HlsMediaChunk lastMediaChunk = this.mediaChunks.getLast();
        HlsMediaChunk hlsMediaChunk = lastMediaChunk.isLoadCompleted() ? lastMediaChunk : (lastCompletedMediaChunk = this.mediaChunks.size() > 1 ? this.mediaChunks.get(this.mediaChunks.size() - 2) : null);
        if (lastCompletedMediaChunk != null) {
            bufferedPositionUs = Math.max(bufferedPositionUs, lastCompletedMediaChunk.endTimeUs);
        }
        for (SampleQueue sampleQueue : this.sampleQueues) {
            bufferedPositionUs = Math.max(bufferedPositionUs, sampleQueue.getLargestQueuedTimestampUs());
        }
        return bufferedPositionUs;
    }

    public void release() {
        boolean releasedSynchronously = this.loader.release((Loader.ReleaseCallback)this);
        if (this.prepared && !releasedSynchronously) {
            for (SampleQueue sampleQueue : this.sampleQueues) {
                sampleQueue.discardToEnd();
            }
        }
        this.handler.removeCallbacksAndMessages(null);
        this.released = true;
    }

    public void onLoaderReleased() {
        this.resetSampleQueues();
    }

    public void setIsTimestampMaster(boolean isTimestampMaster) {
        this.chunkSource.setIsTimestampMaster(isTimestampMaster);
    }

    public void onPlaylistBlacklisted(HlsMasterPlaylist.HlsUrl url, long blacklistMs) {
        this.chunkSource.onPlaylistBlacklisted(url, blacklistMs);
    }

    public boolean isReady(int trackGroupIndex) {
        return this.loadingFinished || !this.isPendingReset() && this.sampleQueues[trackGroupIndex].hasNextSample();
    }

    public void maybeThrowError() throws IOException {
        this.loader.maybeThrowError();
        this.chunkSource.maybeThrowError();
    }

    public int readData(int trackGroupIndex, FormatHolder formatHolder, DecoderInputBuffer buffer, boolean requireFormat) {
        if (this.isPendingReset()) {
            return -3;
        }
        int result = this.sampleQueues[trackGroupIndex].read(formatHolder, buffer, requireFormat, this.loadingFinished, this.lastSeekPositionUs);
        if (result == -4) {
            this.discardToRead();
        }
        return result;
    }

    public int skipData(int trackGroupIndex, long positionUs) {
        int skipCount;
        if (this.isPendingReset()) {
            return 0;
        }
        SampleQueue sampleQueue = this.sampleQueues[trackGroupIndex];
        if (this.loadingFinished && positionUs > sampleQueue.getLargestQueuedTimestampUs()) {
            skipCount = sampleQueue.advanceToEnd();
        } else {
            skipCount = sampleQueue.advanceTo(positionUs, true, true);
            if (skipCount == -1) {
                skipCount = 0;
            }
        }
        if (skipCount > 0) {
            this.discardToRead();
        }
        return skipCount;
    }

    private void discardToRead() {
        if (!this.mediaChunks.isEmpty()) {
            while (this.mediaChunks.size() > 1 && this.finishedReadingChunk(this.mediaChunks.getFirst())) {
                this.mediaChunks.removeFirst();
            }
            HlsMediaChunk currentChunk = this.mediaChunks.getFirst();
            Format trackFormat = currentChunk.trackFormat;
            if (!trackFormat.equals((Object)this.downstreamTrackFormat)) {
                this.eventDispatcher.downstreamFormatChanged(this.trackType, trackFormat, currentChunk.trackSelectionReason, currentChunk.trackSelectionData, currentChunk.startTimeUs);
            }
            this.downstreamTrackFormat = trackFormat;
        }
    }

    private boolean finishedReadingChunk(HlsMediaChunk chunk) {
        int chunkUid = chunk.uid;
        for (int i = 0; i < this.sampleQueues.length; ++i) {
            if (!this.trackGroupEnabledStates[i] || this.sampleQueues[i].peekSourceId() != chunkUid) continue;
            return false;
        }
        return true;
    }

    private void resetSampleQueues() {
        for (SampleQueue sampleQueue : this.sampleQueues) {
            sampleQueue.reset(this.pendingResetUpstreamFormats);
        }
        this.pendingResetUpstreamFormats = false;
    }

    public boolean continueLoading(long positionUs) {
        long loadPositionUs;
        HlsMediaChunk previousChunk;
        if (this.loadingFinished || this.loader.isLoading()) {
            return false;
        }
        if (this.isPendingReset()) {
            previousChunk = null;
            loadPositionUs = this.pendingResetPositionUs;
        } else {
            previousChunk = this.mediaChunks.getLast();
            loadPositionUs = previousChunk.endTimeUs;
        }
        this.chunkSource.getNextChunk(previousChunk, positionUs, loadPositionUs, this.nextChunkHolder);
        boolean endOfStream = this.nextChunkHolder.endOfStream;
        Chunk loadable = this.nextChunkHolder.chunk;
        HlsMasterPlaylist.HlsUrl playlistToLoad = this.nextChunkHolder.playlist;
        this.nextChunkHolder.clear();
        if (endOfStream) {
            this.pendingResetPositionUs = -9223372036854775807L;
            this.loadingFinished = true;
            return true;
        }
        if (loadable == null) {
            if (playlistToLoad != null) {
                this.callback.onPlaylistRefreshRequired(playlistToLoad);
            }
            return false;
        }
        if (this.isMediaChunk(loadable)) {
            this.pendingResetPositionUs = -9223372036854775807L;
            HlsMediaChunk mediaChunk = (HlsMediaChunk)loadable;
            mediaChunk.init(this);
            this.mediaChunks.add(mediaChunk);
        }
        long elapsedRealtimeMs = this.loader.startLoading((Loader.Loadable)loadable, (Loader.Callback)this, this.minLoadableRetryCount);
        this.eventDispatcher.loadStarted(loadable.dataSpec, loadable.type, this.trackType, loadable.trackFormat, loadable.trackSelectionReason, loadable.trackSelectionData, loadable.startTimeUs, loadable.endTimeUs, elapsedRealtimeMs);
        return true;
    }

    public long getNextLoadPositionUs() {
        if (this.isPendingReset()) {
            return this.pendingResetPositionUs;
        }
        return this.loadingFinished ? Long.MIN_VALUE : this.mediaChunks.getLast().endTimeUs;
    }

    public void onLoadCompleted(Chunk loadable, long elapsedRealtimeMs, long loadDurationMs) {
        this.chunkSource.onChunkLoadCompleted(loadable);
        this.eventDispatcher.loadCompleted(loadable.dataSpec, loadable.type, this.trackType, loadable.trackFormat, loadable.trackSelectionReason, loadable.trackSelectionData, loadable.startTimeUs, loadable.endTimeUs, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        if (!this.prepared) {
            this.continueLoading(this.lastSeekPositionUs);
        } else {
            this.callback.onContinueLoadingRequested(this);
        }
    }

    public void onLoadCanceled(Chunk loadable, long elapsedRealtimeMs, long loadDurationMs, boolean released) {
        this.eventDispatcher.loadCanceled(loadable.dataSpec, loadable.type, this.trackType, loadable.trackFormat, loadable.trackSelectionReason, loadable.trackSelectionData, loadable.startTimeUs, loadable.endTimeUs, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        if (!released) {
            this.resetSampleQueues();
            if (this.enabledTrackCount > 0) {
                this.callback.onContinueLoadingRequested(this);
            }
        }
    }

    public int onLoadError(Chunk loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error) {
        long bytesLoaded = loadable.bytesLoaded();
        boolean isMediaChunk = this.isMediaChunk(loadable);
        boolean cancelable = !isMediaChunk || bytesLoaded == 0L;
        boolean canceled = false;
        if (this.chunkSource.onChunkLoadError(loadable, cancelable, error)) {
            if (isMediaChunk) {
                HlsMediaChunk removed = this.mediaChunks.removeLast();
                Assertions.checkState((removed == loadable ? 1 : 0) != 0);
                if (this.mediaChunks.isEmpty()) {
                    this.pendingResetPositionUs = this.lastSeekPositionUs;
                }
            }
            canceled = true;
        }
        this.eventDispatcher.loadError(loadable.dataSpec, loadable.type, this.trackType, loadable.trackFormat, loadable.trackSelectionReason, loadable.trackSelectionData, loadable.startTimeUs, loadable.endTimeUs, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded(), error, canceled);
        if (canceled) {
            if (!this.prepared) {
                this.continueLoading(this.lastSeekPositionUs);
            } else {
                this.callback.onContinueLoadingRequested(this);
            }
            return 2;
        }
        return 0;
    }

    public void init(int chunkUid, boolean shouldSpliceIn) {
        for (SampleQueue sampleQueue : this.sampleQueues) {
            sampleQueue.sourceId(chunkUid);
        }
        if (shouldSpliceIn) {
            for (SampleQueue sampleQueue : this.sampleQueues) {
                sampleQueue.splice();
            }
        }
    }

    public SampleQueue track(int id, int type) {
        int trackCount = this.sampleQueues.length;
        for (int i = 0; i < trackCount; ++i) {
            if (this.sampleQueueTrackIds[i] != id) continue;
            return this.sampleQueues[i];
        }
        SampleQueue trackOutput = new SampleQueue(this.allocator);
        trackOutput.setSampleOffsetUs(this.sampleOffsetUs);
        trackOutput.setUpstreamFormatChangeListener((SampleQueue.UpstreamFormatChangedListener)this);
        this.sampleQueueTrackIds = Arrays.copyOf(this.sampleQueueTrackIds, trackCount + 1);
        this.sampleQueueTrackIds[trackCount] = id;
        this.sampleQueues = Arrays.copyOf(this.sampleQueues, trackCount + 1);
        this.sampleQueues[trackCount] = trackOutput;
        return trackOutput;
    }

    public void endTracks() {
        this.sampleQueuesBuilt = true;
        this.handler.post(this.maybeFinishPrepareRunnable);
    }

    public void seekMap(SeekMap seekMap) {
    }

    public void onUpstreamFormatChanged(Format format) {
        this.handler.post(this.maybeFinishPrepareRunnable);
    }

    public void setSampleOffsetUs(long sampleOffsetUs) {
        this.sampleOffsetUs = sampleOffsetUs;
        for (SampleQueue sampleQueue : this.sampleQueues) {
            sampleQueue.setSampleOffsetUs(sampleOffsetUs);
        }
    }

    private void maybeFinishPrepare() {
        if (this.released || this.prepared || !this.sampleQueuesBuilt) {
            return;
        }
        for (SampleQueue sampleQueue : this.sampleQueues) {
            if (sampleQueue.getUpstreamFormat() != null) continue;
            return;
        }
        this.buildTracks();
        this.prepared = true;
        this.callback.onPrepared();
    }

    private void buildTracks() {
        int primaryExtractorTrackType = 0;
        int primaryExtractorTrackIndex = -1;
        int extractorTrackCount = this.sampleQueues.length;
        for (int i = 0; i < extractorTrackCount; ++i) {
            String sampleMimeType = this.sampleQueues[i].getUpstreamFormat().sampleMimeType;
            int trackType = MimeTypes.isVideo((String)sampleMimeType) ? 3 : (MimeTypes.isAudio((String)sampleMimeType) ? 2 : (MimeTypes.isText((String)sampleMimeType) ? 1 : 0));
            if (trackType > primaryExtractorTrackType) {
                primaryExtractorTrackType = trackType;
                primaryExtractorTrackIndex = i;
                continue;
            }
            if (trackType != primaryExtractorTrackType || primaryExtractorTrackIndex == -1) continue;
            primaryExtractorTrackIndex = -1;
        }
        TrackGroup chunkSourceTrackGroup = this.chunkSource.getTrackGroup();
        int chunkSourceTrackCount = chunkSourceTrackGroup.length;
        this.primaryTrackGroupIndex = -1;
        this.trackGroupEnabledStates = new boolean[extractorTrackCount];
        this.trackGroupIsAudioVideoFlags = new boolean[extractorTrackCount];
        TrackGroup[] trackGroups = new TrackGroup[extractorTrackCount];
        for (int i = 0; i < extractorTrackCount; ++i) {
            boolean isAudioVideo;
            Format sampleFormat = this.sampleQueues[i].getUpstreamFormat();
            String mimeType = sampleFormat.sampleMimeType;
            this.trackGroupIsAudioVideoFlags[i] = isAudioVideo = MimeTypes.isVideo((String)mimeType) || MimeTypes.isAudio((String)mimeType);
            this.haveAudioVideoTrackGroups |= isAudioVideo;
            if (i == primaryExtractorTrackIndex) {
                Format[] formats = new Format[chunkSourceTrackCount];
                for (int j = 0; j < chunkSourceTrackCount; ++j) {
                    formats[j] = HlsSampleStreamWrapper.deriveFormat(chunkSourceTrackGroup.getFormat(j), sampleFormat);
                }
                trackGroups[i] = new TrackGroup(formats);
                this.primaryTrackGroupIndex = i;
                continue;
            }
            Format trackFormat = primaryExtractorTrackType == 3 && MimeTypes.isAudio((String)sampleFormat.sampleMimeType) ? this.muxedAudioFormat : null;
            trackGroups[i] = new TrackGroup(new Format[]{HlsSampleStreamWrapper.deriveFormat(trackFormat, sampleFormat)});
        }
        this.trackGroups = new TrackGroupArray(trackGroups);
    }

    private void setTrackGroupEnabledState(int trackGroupIndex, boolean enabledState) {
        Assertions.checkState((this.trackGroupEnabledStates[trackGroupIndex] != enabledState ? 1 : 0) != 0);
        this.trackGroupEnabledStates[trackGroupIndex] = enabledState;
        this.enabledTrackCount += enabledState ? 1 : -1;
    }

    private static Format deriveFormat(Format containerFormat, Format sampleFormat) {
        if (containerFormat == null) {
            return sampleFormat;
        }
        String codecs = null;
        int sampleTrackType = MimeTypes.getTrackType((String)sampleFormat.sampleMimeType);
        if (sampleTrackType == 1) {
            codecs = HlsSampleStreamWrapper.getAudioCodecs(containerFormat.codecs);
        } else if (sampleTrackType == 2) {
            codecs = HlsSampleStreamWrapper.getVideoCodecs(containerFormat.codecs);
        }
        return sampleFormat.copyWithContainerInfo(containerFormat.id, codecs, containerFormat.bitrate, containerFormat.width, containerFormat.height, containerFormat.selectionFlags, containerFormat.language);
    }

    private boolean isMediaChunk(Chunk chunk) {
        return chunk instanceof HlsMediaChunk;
    }

    private boolean isPendingReset() {
        return this.pendingResetPositionUs != -9223372036854775807L;
    }

    private boolean seekInsideBufferUs(long positionUs) {
        int trackCount = this.sampleQueues.length;
        for (int i = 0; i < trackCount; ++i) {
            boolean seekInsideQueue;
            SampleQueue sampleQueue = this.sampleQueues[i];
            sampleQueue.rewind();
            boolean bl = seekInsideQueue = sampleQueue.advanceTo(positionUs, true, false) != -1;
            if (!(seekInsideQueue || !this.trackGroupIsAudioVideoFlags[i] && this.haveAudioVideoTrackGroups)) {
                return false;
            }
            sampleQueue.discardToRead();
        }
        return true;
    }

    private static String getAudioCodecs(String codecs) {
        return HlsSampleStreamWrapper.getCodecsOfType(codecs, 1);
    }

    private static String getVideoCodecs(String codecs) {
        return HlsSampleStreamWrapper.getCodecsOfType(codecs, 2);
    }

    private static String getCodecsOfType(String codecs, int trackType) {
        if (TextUtils.isEmpty((CharSequence)codecs)) {
            return null;
        }
        String[] codecArray = codecs.split("(\\s*,\\s*)|(\\s*$)");
        StringBuilder builder = new StringBuilder();
        for (String codec : codecArray) {
            if (trackType != MimeTypes.getTrackTypeOfCodec((String)codec)) continue;
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append(codec);
        }
        return builder.length() > 0 ? builder.toString() : null;
    }

    public static interface Callback
    extends SequenceableLoader.Callback<HlsSampleStreamWrapper> {
        public void onPrepared();

        public void onPlaylistRefreshRequired(HlsMasterPlaylist.HlsUrl var1);
    }
}

