/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls;

import android.net.Uri;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.mp3.Mp3Extractor;
import com.google.android.exoplayer2.extractor.mp4.FragmentedMp4Extractor;
import com.google.android.exoplayer2.extractor.ts.Ac3Extractor;
import com.google.android.exoplayer2.extractor.ts.AdtsExtractor;
import com.google.android.exoplayer2.extractor.ts.DefaultTsPayloadReaderFactory;
import com.google.android.exoplayer2.extractor.ts.TsExtractor;
import com.google.android.exoplayer2.extractor.ts.TsPayloadReader;
import com.google.android.exoplayer2.source.hls.HlsExtractorFactory;
import com.google.android.exoplayer2.source.hls.WebvttExtractor;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.TimestampAdjuster;
import java.util.Collections;
import java.util.List;

public final class DefaultHlsExtractorFactory
implements HlsExtractorFactory {
    public static final String AAC_FILE_EXTENSION = ".aac";
    public static final String AC3_FILE_EXTENSION = ".ac3";
    public static final String EC3_FILE_EXTENSION = ".ec3";
    public static final String MP3_FILE_EXTENSION = ".mp3";
    public static final String MP4_FILE_EXTENSION = ".mp4";
    public static final String M4_FILE_EXTENSION_PREFIX = ".m4";
    public static final String MP4_FILE_EXTENSION_PREFIX = ".mp4";
    public static final String VTT_FILE_EXTENSION = ".vtt";
    public static final String WEBVTT_FILE_EXTENSION = ".webvtt";

    @Override
    public Pair<Extractor, Boolean> createExtractor(Extractor previousExtractor, Uri uri, Format format, List<Format> muxedCaptionFormats, DrmInitData drmInitData, TimestampAdjuster timestampAdjuster) {
        WebvttExtractor extractor;
        String lastPathSegment = uri.getLastPathSegment();
        boolean isPackedAudioExtractor = false;
        if ("text/vtt".equals(format.sampleMimeType) || lastPathSegment.endsWith(WEBVTT_FILE_EXTENSION) || lastPathSegment.endsWith(VTT_FILE_EXTENSION)) {
            extractor = new WebvttExtractor(format.language, timestampAdjuster);
        } else if (lastPathSegment.endsWith(AAC_FILE_EXTENSION)) {
            isPackedAudioExtractor = true;
            extractor = new AdtsExtractor();
        } else if (lastPathSegment.endsWith(AC3_FILE_EXTENSION) || lastPathSegment.endsWith(EC3_FILE_EXTENSION)) {
            isPackedAudioExtractor = true;
            extractor = new Ac3Extractor();
        } else if (lastPathSegment.endsWith(MP3_FILE_EXTENSION)) {
            isPackedAudioExtractor = true;
            extractor = new Mp3Extractor(0, 0L);
        } else if (previousExtractor != null) {
            extractor = previousExtractor;
        } else if (lastPathSegment.endsWith(".mp4") || lastPathSegment.startsWith(M4_FILE_EXTENSION_PREFIX, lastPathSegment.length() - 4) || lastPathSegment.startsWith(".mp4", lastPathSegment.length() - 5)) {
            extractor = new FragmentedMp4Extractor(0, timestampAdjuster, null, drmInitData, muxedCaptionFormats != null ? muxedCaptionFormats : Collections.emptyList());
        } else {
            int esReaderFactoryFlags = 16;
            if (muxedCaptionFormats != null) {
                esReaderFactoryFlags |= 0x20;
            } else {
                muxedCaptionFormats = Collections.emptyList();
            }
            String codecs = format.codecs;
            if (!TextUtils.isEmpty((CharSequence)codecs)) {
                if (!"audio/mp4a-latm".equals(MimeTypes.getAudioMediaMimeType((String)codecs))) {
                    esReaderFactoryFlags |= 2;
                }
                if (!"video/avc".equals(MimeTypes.getVideoMediaMimeType((String)codecs))) {
                    esReaderFactoryFlags |= 4;
                }
            }
            extractor = new TsExtractor(2, timestampAdjuster, (TsPayloadReader.Factory)new DefaultTsPayloadReaderFactory(esReaderFactoryFlags, muxedCaptionFormats));
        }
        return Pair.create((Object)extractor, (Object)isPackedAudioExtractor);
    }
}

