/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls.offline;

import android.net.Uri;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.offline.SegmentDownloader;
import com.google.android.exoplayer2.source.hls.playlist.HlsMediaPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsMultivariantPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylistParser;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.ParsingLoadable;
import com.google.android.exoplayer2.upstream.cache.CacheDataSource;
import com.google.android.exoplayer2.util.UriUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;

@Deprecated
public final class HlsDownloader
extends SegmentDownloader<HlsPlaylist> {
    public HlsDownloader(MediaItem mediaItem, CacheDataSource.Factory cacheDataSourceFactory) {
        this(mediaItem, cacheDataSourceFactory, Runnable::run);
    }

    public HlsDownloader(MediaItem mediaItem, CacheDataSource.Factory cacheDataSourceFactory, Executor executor) {
        this(mediaItem, new HlsPlaylistParser(), cacheDataSourceFactory, executor, 20000L);
    }

    @Deprecated
    public HlsDownloader(MediaItem mediaItem, ParsingLoadable.Parser<HlsPlaylist> manifestParser, CacheDataSource.Factory cacheDataSourceFactory, Executor executor) {
        this(mediaItem, manifestParser, cacheDataSourceFactory, executor, 20000L);
    }

    public HlsDownloader(MediaItem mediaItem, ParsingLoadable.Parser<HlsPlaylist> manifestParser, CacheDataSource.Factory cacheDataSourceFactory, Executor executor, long maxMergedSegmentStartTimeDiffMs) {
        super(mediaItem, manifestParser, cacheDataSourceFactory, executor, maxMergedSegmentStartTimeDiffMs);
    }

    protected List<SegmentDownloader.Segment> getSegments(DataSource dataSource, HlsPlaylist manifest, boolean removing) throws IOException, InterruptedException {
        ArrayList<DataSpec> mediaPlaylistDataSpecs = new ArrayList<DataSpec>();
        if (manifest instanceof HlsMultivariantPlaylist) {
            HlsMultivariantPlaylist multivariantPlaylist = (HlsMultivariantPlaylist)manifest;
            this.addMediaPlaylistDataSpecs(multivariantPlaylist.mediaPlaylistUrls, mediaPlaylistDataSpecs);
        } else {
            mediaPlaylistDataSpecs.add(SegmentDownloader.getCompressibleDataSpec((Uri)Uri.parse((String)manifest.baseUri)));
        }
        ArrayList<SegmentDownloader.Segment> segments = new ArrayList<SegmentDownloader.Segment>();
        HashSet<Uri> seenEncryptionKeyUris = new HashSet<Uri>();
        for (DataSpec mediaPlaylistDataSpec : mediaPlaylistDataSpecs) {
            HlsMediaPlaylist mediaPlaylist;
            segments.add(new SegmentDownloader.Segment(0L, mediaPlaylistDataSpec));
            try {
                mediaPlaylist = (HlsMediaPlaylist)this.getManifest(dataSource, mediaPlaylistDataSpec, removing);
            }
            catch (IOException e) {
                if (removing) continue;
                throw e;
            }
            HlsMediaPlaylist.Segment lastInitSegment = null;
            List<HlsMediaPlaylist.Segment> hlsSegments = mediaPlaylist.segments;
            for (int i = 0; i < hlsSegments.size(); ++i) {
                HlsMediaPlaylist.Segment segment = hlsSegments.get(i);
                HlsMediaPlaylist.Segment initSegment = segment.initializationSegment;
                if (initSegment != null && initSegment != lastInitSegment) {
                    lastInitSegment = initSegment;
                    this.addSegment(mediaPlaylist, initSegment, seenEncryptionKeyUris, segments);
                }
                this.addSegment(mediaPlaylist, segment, seenEncryptionKeyUris, segments);
            }
        }
        return segments;
    }

    private void addMediaPlaylistDataSpecs(List<Uri> mediaPlaylistUrls, List<DataSpec> out) {
        for (int i = 0; i < mediaPlaylistUrls.size(); ++i) {
            out.add(SegmentDownloader.getCompressibleDataSpec((Uri)mediaPlaylistUrls.get(i)));
        }
    }

    private void addSegment(HlsMediaPlaylist mediaPlaylist, HlsMediaPlaylist.Segment segment, HashSet<Uri> seenEncryptionKeyUris, ArrayList<SegmentDownloader.Segment> out) {
        Uri keyUri;
        String baseUri = mediaPlaylist.baseUri;
        long startTimeUs = mediaPlaylist.startTimeUs + segment.relativeStartTimeUs;
        if (segment.fullSegmentEncryptionKeyUri != null && seenEncryptionKeyUris.add(keyUri = UriUtil.resolveToUri((String)baseUri, (String)segment.fullSegmentEncryptionKeyUri))) {
            out.add(new SegmentDownloader.Segment(startTimeUs, SegmentDownloader.getCompressibleDataSpec((Uri)keyUri)));
        }
        Uri segmentUri = UriUtil.resolveToUri((String)baseUri, (String)segment.url);
        DataSpec dataSpec = new DataSpec(segmentUri, segment.byteRangeOffset, segment.byteRangeLength);
        out.add(new SegmentDownloader.Segment(startTimeUs, dataSpec));
    }
}

