/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls.playlist;

import android.net.Uri;
import android.os.Handler;
import android.os.SystemClock;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.source.LoadEventInfo;
import com.google.android.exoplayer2.source.MediaLoadData;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.source.hls.HlsDataSourceFactory;
import com.google.android.exoplayer2.source.hls.playlist.HlsMediaPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsMultivariantPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylistParser;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylistParserFactory;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylistTracker;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.HttpDataSource;
import com.google.android.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.google.android.exoplayer2.upstream.Loader;
import com.google.android.exoplayer2.upstream.ParsingLoadable;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@Deprecated
public final class DefaultHlsPlaylistTracker
implements HlsPlaylistTracker,
Loader.Callback<ParsingLoadable<HlsPlaylist>> {
    public static final HlsPlaylistTracker.Factory FACTORY = DefaultHlsPlaylistTracker::new;
    public static final double DEFAULT_PLAYLIST_STUCK_TARGET_DURATION_COEFFICIENT = 3.5;
    private final HlsDataSourceFactory dataSourceFactory;
    private final HlsPlaylistParserFactory playlistParserFactory;
    private final LoadErrorHandlingPolicy loadErrorHandlingPolicy;
    private final HashMap<Uri, MediaPlaylistBundle> playlistBundles;
    private final CopyOnWriteArrayList<HlsPlaylistTracker.PlaylistEventListener> listeners;
    private final double playlistStuckTargetDurationCoefficient;
    @Nullable
    private MediaSourceEventListener.EventDispatcher eventDispatcher;
    @Nullable
    private Loader initialPlaylistLoader;
    @Nullable
    private Handler playlistRefreshHandler;
    @Nullable
    private HlsPlaylistTracker.PrimaryPlaylistListener primaryPlaylistListener;
    @Nullable
    private HlsMultivariantPlaylist multivariantPlaylist;
    @Nullable
    private Uri primaryMediaPlaylistUrl;
    @Nullable
    private HlsMediaPlaylist primaryMediaPlaylistSnapshot;
    private boolean isLive;
    private long initialStartTimeUs;

    public DefaultHlsPlaylistTracker(HlsDataSourceFactory dataSourceFactory, LoadErrorHandlingPolicy loadErrorHandlingPolicy, HlsPlaylistParserFactory playlistParserFactory) {
        this(dataSourceFactory, loadErrorHandlingPolicy, playlistParserFactory, 3.5);
    }

    public DefaultHlsPlaylistTracker(HlsDataSourceFactory dataSourceFactory, LoadErrorHandlingPolicy loadErrorHandlingPolicy, HlsPlaylistParserFactory playlistParserFactory, double playlistStuckTargetDurationCoefficient) {
        this.dataSourceFactory = dataSourceFactory;
        this.playlistParserFactory = playlistParserFactory;
        this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
        this.playlistStuckTargetDurationCoefficient = playlistStuckTargetDurationCoefficient;
        this.listeners = new CopyOnWriteArrayList();
        this.playlistBundles = new HashMap();
        this.initialStartTimeUs = -9223372036854775807L;
    }

    @Override
    public void start(Uri initialPlaylistUri, MediaSourceEventListener.EventDispatcher eventDispatcher, HlsPlaylistTracker.PrimaryPlaylistListener primaryPlaylistListener) {
        this.playlistRefreshHandler = Util.createHandlerForCurrentLooper();
        this.eventDispatcher = eventDispatcher;
        this.primaryPlaylistListener = primaryPlaylistListener;
        ParsingLoadable multivariantPlaylistLoadable = new ParsingLoadable(this.dataSourceFactory.createDataSource(4), initialPlaylistUri, 4, this.playlistParserFactory.createPlaylistParser());
        Assertions.checkState((this.initialPlaylistLoader == null ? 1 : 0) != 0);
        this.initialPlaylistLoader = new Loader("DefaultHlsPlaylistTracker:MultivariantPlaylist");
        long elapsedRealtime = this.initialPlaylistLoader.startLoading((Loader.Loadable)multivariantPlaylistLoadable, (Loader.Callback)this, this.loadErrorHandlingPolicy.getMinimumLoadableRetryCount(multivariantPlaylistLoadable.type));
        eventDispatcher.loadStarted(new LoadEventInfo(multivariantPlaylistLoadable.loadTaskId, multivariantPlaylistLoadable.dataSpec, elapsedRealtime), multivariantPlaylistLoadable.type);
    }

    @Override
    public void stop() {
        this.primaryMediaPlaylistUrl = null;
        this.primaryMediaPlaylistSnapshot = null;
        this.multivariantPlaylist = null;
        this.initialStartTimeUs = -9223372036854775807L;
        this.initialPlaylistLoader.release();
        this.initialPlaylistLoader = null;
        for (MediaPlaylistBundle bundle : this.playlistBundles.values()) {
            bundle.release();
        }
        this.playlistRefreshHandler.removeCallbacksAndMessages(null);
        this.playlistRefreshHandler = null;
        this.playlistBundles.clear();
    }

    @Override
    public void addListener(HlsPlaylistTracker.PlaylistEventListener listener) {
        Assertions.checkNotNull((Object)listener);
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(HlsPlaylistTracker.PlaylistEventListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    @Nullable
    public HlsMultivariantPlaylist getMultivariantPlaylist() {
        return this.multivariantPlaylist;
    }

    @Override
    @Nullable
    public HlsMediaPlaylist getPlaylistSnapshot(Uri url, boolean isForPlayback) {
        HlsMediaPlaylist snapshot = this.playlistBundles.get(url).getPlaylistSnapshot();
        if (snapshot != null && isForPlayback) {
            this.maybeSetPrimaryUrl(url);
        }
        return snapshot;
    }

    @Override
    public long getInitialStartTimeUs() {
        return this.initialStartTimeUs;
    }

    @Override
    public boolean isSnapshotValid(Uri url) {
        return this.playlistBundles.get(url).isSnapshotValid();
    }

    @Override
    public void maybeThrowPrimaryPlaylistRefreshError() throws IOException {
        if (this.initialPlaylistLoader != null) {
            this.initialPlaylistLoader.maybeThrowError();
        }
        if (this.primaryMediaPlaylistUrl != null) {
            this.maybeThrowPlaylistRefreshError(this.primaryMediaPlaylistUrl);
        }
    }

    @Override
    public void maybeThrowPlaylistRefreshError(Uri url) throws IOException {
        this.playlistBundles.get(url).maybeThrowPlaylistRefreshError();
    }

    @Override
    public void refreshPlaylist(Uri url) {
        this.playlistBundles.get(url).loadPlaylist();
    }

    @Override
    public boolean isLive() {
        return this.isLive;
    }

    @Override
    public boolean excludeMediaPlaylist(Uri playlistUrl, long exclusionDurationMs) {
        MediaPlaylistBundle bundle = this.playlistBundles.get(playlistUrl);
        if (bundle != null) {
            return !bundle.excludePlaylist(exclusionDurationMs);
        }
        return false;
    }

    public void onLoadCompleted(ParsingLoadable<HlsPlaylist> loadable, long elapsedRealtimeMs, long loadDurationMs) {
        HlsPlaylist result = (HlsPlaylist)loadable.getResult();
        boolean isMediaPlaylist = result instanceof HlsMediaPlaylist;
        HlsMultivariantPlaylist multivariantPlaylist = isMediaPlaylist ? HlsMultivariantPlaylist.createSingleVariantMultivariantPlaylist(result.baseUri) : (HlsMultivariantPlaylist)result;
        this.multivariantPlaylist = multivariantPlaylist;
        this.primaryMediaPlaylistUrl = multivariantPlaylist.variants.get((int)0).url;
        this.listeners.add(new FirstPrimaryMediaPlaylistListener());
        this.createBundles(multivariantPlaylist.mediaPlaylistUrls);
        LoadEventInfo loadEventInfo = new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, loadable.getUri(), loadable.getResponseHeaders(), elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        MediaPlaylistBundle primaryBundle = this.playlistBundles.get(this.primaryMediaPlaylistUrl);
        if (isMediaPlaylist) {
            primaryBundle.processLoadedPlaylist((HlsMediaPlaylist)result, loadEventInfo);
        } else {
            primaryBundle.loadPlaylist();
        }
        this.loadErrorHandlingPolicy.onLoadTaskConcluded(loadable.loadTaskId);
        this.eventDispatcher.loadCompleted(loadEventInfo, 4);
    }

    public void onLoadCanceled(ParsingLoadable<HlsPlaylist> loadable, long elapsedRealtimeMs, long loadDurationMs, boolean released) {
        LoadEventInfo loadEventInfo = new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, loadable.getUri(), loadable.getResponseHeaders(), elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        this.loadErrorHandlingPolicy.onLoadTaskConcluded(loadable.loadTaskId);
        this.eventDispatcher.loadCanceled(loadEventInfo, 4);
    }

    public Loader.LoadErrorAction onLoadError(ParsingLoadable<HlsPlaylist> loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error, int errorCount) {
        MediaLoadData mediaLoadData;
        LoadEventInfo loadEventInfo = new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, loadable.getUri(), loadable.getResponseHeaders(), elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        long retryDelayMs = this.loadErrorHandlingPolicy.getRetryDelayMsFor(new LoadErrorHandlingPolicy.LoadErrorInfo(loadEventInfo, mediaLoadData = new MediaLoadData(loadable.type), error, errorCount));
        boolean isFatal = retryDelayMs == -9223372036854775807L;
        this.eventDispatcher.loadError(loadEventInfo, loadable.type, error, isFatal);
        if (isFatal) {
            this.loadErrorHandlingPolicy.onLoadTaskConcluded(loadable.loadTaskId);
        }
        return isFatal ? Loader.DONT_RETRY_FATAL : Loader.createRetryAction((boolean)false, (long)retryDelayMs);
    }

    private boolean maybeSelectNewPrimaryUrl() {
        List<HlsMultivariantPlaylist.Variant> variants = this.multivariantPlaylist.variants;
        int variantsSize = variants.size();
        long currentTimeMs = SystemClock.elapsedRealtime();
        for (int i = 0; i < variantsSize; ++i) {
            MediaPlaylistBundle bundle = (MediaPlaylistBundle)Assertions.checkNotNull((Object)this.playlistBundles.get(variants.get((int)i).url));
            if (currentTimeMs <= bundle.excludeUntilMs) continue;
            this.primaryMediaPlaylistUrl = bundle.playlistUrl;
            bundle.loadPlaylistInternal(this.getRequestUriForPrimaryChange(this.primaryMediaPlaylistUrl));
            return true;
        }
        return false;
    }

    private void maybeSetPrimaryUrl(Uri url) {
        if (url.equals((Object)this.primaryMediaPlaylistUrl) || !this.isVariantUrl(url) || this.primaryMediaPlaylistSnapshot != null && this.primaryMediaPlaylistSnapshot.hasEndTag) {
            return;
        }
        this.primaryMediaPlaylistUrl = url;
        MediaPlaylistBundle newPrimaryBundle = this.playlistBundles.get(this.primaryMediaPlaylistUrl);
        HlsMediaPlaylist newPrimarySnapshot = newPrimaryBundle.playlistSnapshot;
        if (newPrimarySnapshot != null && newPrimarySnapshot.hasEndTag) {
            this.primaryMediaPlaylistSnapshot = newPrimarySnapshot;
            this.primaryPlaylistListener.onPrimaryPlaylistRefreshed(newPrimarySnapshot);
        } else {
            newPrimaryBundle.loadPlaylistInternal(this.getRequestUriForPrimaryChange(url));
        }
    }

    private Uri getRequestUriForPrimaryChange(Uri newPrimaryPlaylistUri) {
        HlsMediaPlaylist.RenditionReport renditionReport;
        if (this.primaryMediaPlaylistSnapshot != null && this.primaryMediaPlaylistSnapshot.serverControl.canBlockReload && (renditionReport = this.primaryMediaPlaylistSnapshot.renditionReports.get(newPrimaryPlaylistUri)) != null) {
            Uri.Builder uriBuilder = newPrimaryPlaylistUri.buildUpon();
            uriBuilder.appendQueryParameter("_HLS_msn", String.valueOf(renditionReport.lastMediaSequence));
            if (renditionReport.lastPartIndex != -1) {
                uriBuilder.appendQueryParameter("_HLS_part", String.valueOf(renditionReport.lastPartIndex));
            }
            return uriBuilder.build();
        }
        return newPrimaryPlaylistUri;
    }

    private boolean isVariantUrl(Uri playlistUrl) {
        List<HlsMultivariantPlaylist.Variant> variants = this.multivariantPlaylist.variants;
        for (int i = 0; i < variants.size(); ++i) {
            if (!playlistUrl.equals((Object)variants.get((int)i).url)) continue;
            return true;
        }
        return false;
    }

    private void createBundles(List<Uri> urls) {
        int listSize = urls.size();
        for (int i = 0; i < listSize; ++i) {
            Uri url = urls.get(i);
            MediaPlaylistBundle bundle = new MediaPlaylistBundle(url);
            this.playlistBundles.put(url, bundle);
        }
    }

    private void onPlaylistUpdated(Uri url, HlsMediaPlaylist newSnapshot) {
        if (url.equals((Object)this.primaryMediaPlaylistUrl)) {
            if (this.primaryMediaPlaylistSnapshot == null) {
                this.isLive = !newSnapshot.hasEndTag;
                this.initialStartTimeUs = newSnapshot.startTimeUs;
            }
            this.primaryMediaPlaylistSnapshot = newSnapshot;
            this.primaryPlaylistListener.onPrimaryPlaylistRefreshed(newSnapshot);
        }
        for (HlsPlaylistTracker.PlaylistEventListener listener : this.listeners) {
            listener.onPlaylistChanged();
        }
    }

    private boolean notifyPlaylistError(Uri playlistUrl, LoadErrorHandlingPolicy.LoadErrorInfo loadErrorInfo, boolean forceRetry) {
        boolean anyExclusionFailed = false;
        for (HlsPlaylistTracker.PlaylistEventListener listener : this.listeners) {
            anyExclusionFailed |= !listener.onPlaylistError(playlistUrl, loadErrorInfo, forceRetry);
        }
        return anyExclusionFailed;
    }

    private HlsMediaPlaylist getLatestPlaylistSnapshot(@Nullable HlsMediaPlaylist oldPlaylist, HlsMediaPlaylist loadedPlaylist) {
        if (!loadedPlaylist.isNewerThan(oldPlaylist)) {
            if (loadedPlaylist.hasEndTag) {
                return oldPlaylist.copyWithEndTag();
            }
            return oldPlaylist;
        }
        long startTimeUs = this.getLoadedPlaylistStartTimeUs(oldPlaylist, loadedPlaylist);
        int discontinuitySequence = this.getLoadedPlaylistDiscontinuitySequence(oldPlaylist, loadedPlaylist);
        return loadedPlaylist.copyWith(startTimeUs, discontinuitySequence);
    }

    private long getLoadedPlaylistStartTimeUs(@Nullable HlsMediaPlaylist oldPlaylist, HlsMediaPlaylist loadedPlaylist) {
        long primarySnapshotStartTimeUs;
        if (loadedPlaylist.hasProgramDateTime) {
            return loadedPlaylist.startTimeUs;
        }
        long l = primarySnapshotStartTimeUs = this.primaryMediaPlaylistSnapshot != null ? this.primaryMediaPlaylistSnapshot.startTimeUs : 0L;
        if (oldPlaylist == null) {
            return primarySnapshotStartTimeUs;
        }
        int oldPlaylistSize = oldPlaylist.segments.size();
        HlsMediaPlaylist.Segment firstOldOverlappingSegment = DefaultHlsPlaylistTracker.getFirstOldOverlappingSegment(oldPlaylist, loadedPlaylist);
        if (firstOldOverlappingSegment != null) {
            return oldPlaylist.startTimeUs + firstOldOverlappingSegment.relativeStartTimeUs;
        }
        if ((long)oldPlaylistSize == loadedPlaylist.mediaSequence - oldPlaylist.mediaSequence) {
            return oldPlaylist.getEndTimeUs();
        }
        return primarySnapshotStartTimeUs;
    }

    private int getLoadedPlaylistDiscontinuitySequence(@Nullable HlsMediaPlaylist oldPlaylist, HlsMediaPlaylist loadedPlaylist) {
        int primaryUrlDiscontinuitySequence;
        if (loadedPlaylist.hasDiscontinuitySequence) {
            return loadedPlaylist.discontinuitySequence;
        }
        int n = primaryUrlDiscontinuitySequence = this.primaryMediaPlaylistSnapshot != null ? this.primaryMediaPlaylistSnapshot.discontinuitySequence : 0;
        if (oldPlaylist == null) {
            return primaryUrlDiscontinuitySequence;
        }
        HlsMediaPlaylist.Segment firstOldOverlappingSegment = DefaultHlsPlaylistTracker.getFirstOldOverlappingSegment(oldPlaylist, loadedPlaylist);
        if (firstOldOverlappingSegment != null) {
            return oldPlaylist.discontinuitySequence + firstOldOverlappingSegment.relativeDiscontinuitySequence - loadedPlaylist.segments.get((int)0).relativeDiscontinuitySequence;
        }
        return primaryUrlDiscontinuitySequence;
    }

    private static HlsMediaPlaylist.Segment getFirstOldOverlappingSegment(HlsMediaPlaylist oldPlaylist, HlsMediaPlaylist loadedPlaylist) {
        int mediaSequenceOffset = (int)(loadedPlaylist.mediaSequence - oldPlaylist.mediaSequence);
        List<HlsMediaPlaylist.Segment> oldSegments = oldPlaylist.segments;
        return mediaSequenceOffset < oldSegments.size() ? oldSegments.get(mediaSequenceOffset) : null;
    }

    private class FirstPrimaryMediaPlaylistListener
    implements HlsPlaylistTracker.PlaylistEventListener {
        private FirstPrimaryMediaPlaylistListener() {
        }

        @Override
        public void onPlaylistChanged() {
            DefaultHlsPlaylistTracker.this.listeners.remove(this);
        }

        @Override
        public boolean onPlaylistError(Uri url, LoadErrorHandlingPolicy.LoadErrorInfo loadErrorInfo, boolean forceRetry) {
            if (DefaultHlsPlaylistTracker.this.primaryMediaPlaylistSnapshot == null) {
                MediaPlaylistBundle mediaPlaylistBundle;
                long nowMs = SystemClock.elapsedRealtime();
                int variantExclusionCounter = 0;
                List<HlsMultivariantPlaylist.Variant> variants = ((HlsMultivariantPlaylist)Util.castNonNull((Object)((DefaultHlsPlaylistTracker)DefaultHlsPlaylistTracker.this).multivariantPlaylist)).variants;
                for (int i = 0; i < variants.size(); ++i) {
                    MediaPlaylistBundle mediaPlaylistBundle2 = (MediaPlaylistBundle)DefaultHlsPlaylistTracker.this.playlistBundles.get(variants.get((int)i).url);
                    if (mediaPlaylistBundle2 == null || nowMs >= mediaPlaylistBundle2.excludeUntilMs) continue;
                    ++variantExclusionCounter;
                }
                LoadErrorHandlingPolicy.FallbackOptions fallbackOptions = new LoadErrorHandlingPolicy.FallbackOptions(1, 0, ((DefaultHlsPlaylistTracker)DefaultHlsPlaylistTracker.this).multivariantPlaylist.variants.size(), variantExclusionCounter);
                LoadErrorHandlingPolicy.FallbackSelection fallbackSelection = DefaultHlsPlaylistTracker.this.loadErrorHandlingPolicy.getFallbackSelectionFor(fallbackOptions, loadErrorInfo);
                if (fallbackSelection != null && fallbackSelection.type == 2 && (mediaPlaylistBundle = (MediaPlaylistBundle)DefaultHlsPlaylistTracker.this.playlistBundles.get(url)) != null) {
                    mediaPlaylistBundle.excludePlaylist(fallbackSelection.exclusionDurationMs);
                }
            }
            return false;
        }
    }

    private final class MediaPlaylistBundle
    implements Loader.Callback<ParsingLoadable<HlsPlaylist>> {
        private static final String BLOCK_MSN_PARAM = "_HLS_msn";
        private static final String BLOCK_PART_PARAM = "_HLS_part";
        private static final String SKIP_PARAM = "_HLS_skip";
        private final Uri playlistUrl;
        private final Loader mediaPlaylistLoader;
        private final DataSource mediaPlaylistDataSource;
        @Nullable
        private HlsMediaPlaylist playlistSnapshot;
        private long lastSnapshotLoadMs;
        private long lastSnapshotChangeMs;
        private long earliestNextLoadTimeMs;
        private long excludeUntilMs;
        private boolean loadPending;
        @Nullable
        private IOException playlistError;

        public MediaPlaylistBundle(Uri playlistUrl) {
            this.playlistUrl = playlistUrl;
            this.mediaPlaylistLoader = new Loader("DefaultHlsPlaylistTracker:MediaPlaylist");
            this.mediaPlaylistDataSource = DefaultHlsPlaylistTracker.this.dataSourceFactory.createDataSource(4);
        }

        @Nullable
        public HlsMediaPlaylist getPlaylistSnapshot() {
            return this.playlistSnapshot;
        }

        public boolean isSnapshotValid() {
            if (this.playlistSnapshot == null) {
                return false;
            }
            long currentTimeMs = SystemClock.elapsedRealtime();
            long snapshotValidityDurationMs = Math.max(30000L, Util.usToMs((long)this.playlistSnapshot.durationUs));
            return this.playlistSnapshot.hasEndTag || this.playlistSnapshot.playlistType == 2 || this.playlistSnapshot.playlistType == 1 || this.lastSnapshotLoadMs + snapshotValidityDurationMs > currentTimeMs;
        }

        public void loadPlaylist() {
            this.loadPlaylistInternal(this.playlistUrl);
        }

        public void maybeThrowPlaylistRefreshError() throws IOException {
            this.mediaPlaylistLoader.maybeThrowError();
            if (this.playlistError != null) {
                throw this.playlistError;
            }
        }

        public void release() {
            this.mediaPlaylistLoader.release();
        }

        public void onLoadCompleted(ParsingLoadable<HlsPlaylist> loadable, long elapsedRealtimeMs, long loadDurationMs) {
            HlsPlaylist result = (HlsPlaylist)loadable.getResult();
            LoadEventInfo loadEventInfo = new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, loadable.getUri(), loadable.getResponseHeaders(), elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
            if (result instanceof HlsMediaPlaylist) {
                this.processLoadedPlaylist((HlsMediaPlaylist)result, loadEventInfo);
                DefaultHlsPlaylistTracker.this.eventDispatcher.loadCompleted(loadEventInfo, 4);
            } else {
                this.playlistError = ParserException.createForMalformedManifest((String)"Loaded playlist has unexpected type.", null);
                DefaultHlsPlaylistTracker.this.eventDispatcher.loadError(loadEventInfo, 4, this.playlistError, true);
            }
            DefaultHlsPlaylistTracker.this.loadErrorHandlingPolicy.onLoadTaskConcluded(loadable.loadTaskId);
        }

        public void onLoadCanceled(ParsingLoadable<HlsPlaylist> loadable, long elapsedRealtimeMs, long loadDurationMs, boolean released) {
            LoadEventInfo loadEventInfo = new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, loadable.getUri(), loadable.getResponseHeaders(), elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
            DefaultHlsPlaylistTracker.this.loadErrorHandlingPolicy.onLoadTaskConcluded(loadable.loadTaskId);
            DefaultHlsPlaylistTracker.this.eventDispatcher.loadCanceled(loadEventInfo, 4);
        }

        public Loader.LoadErrorAction onLoadError(ParsingLoadable<HlsPlaylist> loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error, int errorCount) {
            long retryDelay;
            MediaLoadData mediaLoadData;
            LoadErrorHandlingPolicy.LoadErrorInfo loadErrorInfo;
            boolean exclusionFailed;
            LoadEventInfo loadEventInfo = new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, loadable.getUri(), loadable.getResponseHeaders(), elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
            boolean isBlockingRequest = loadable.getUri().getQueryParameter(BLOCK_MSN_PARAM) != null;
            boolean deltaUpdateFailed = error instanceof HlsPlaylistParser.DeltaUpdateException;
            if (isBlockingRequest || deltaUpdateFailed) {
                int responseCode = Integer.MAX_VALUE;
                if (error instanceof HttpDataSource.InvalidResponseCodeException) {
                    responseCode = ((HttpDataSource.InvalidResponseCodeException)error).responseCode;
                }
                if (deltaUpdateFailed || responseCode == 400 || responseCode == 503) {
                    this.earliestNextLoadTimeMs = SystemClock.elapsedRealtime();
                    this.loadPlaylist();
                    ((MediaSourceEventListener.EventDispatcher)Util.castNonNull((Object)DefaultHlsPlaylistTracker.this.eventDispatcher)).loadError(loadEventInfo, loadable.type, error, true);
                    return Loader.DONT_RETRY;
                }
            }
            Loader.LoadErrorAction loadErrorAction = (exclusionFailed = DefaultHlsPlaylistTracker.this.notifyPlaylistError(this.playlistUrl, loadErrorInfo = new LoadErrorHandlingPolicy.LoadErrorInfo(loadEventInfo, mediaLoadData = new MediaLoadData(loadable.type), error, errorCount), false)) ? ((retryDelay = DefaultHlsPlaylistTracker.this.loadErrorHandlingPolicy.getRetryDelayMsFor(loadErrorInfo)) != -9223372036854775807L ? Loader.createRetryAction((boolean)false, (long)retryDelay) : Loader.DONT_RETRY_FATAL) : Loader.DONT_RETRY;
            boolean wasCanceled = !loadErrorAction.isRetry();
            DefaultHlsPlaylistTracker.this.eventDispatcher.loadError(loadEventInfo, loadable.type, error, wasCanceled);
            if (wasCanceled) {
                DefaultHlsPlaylistTracker.this.loadErrorHandlingPolicy.onLoadTaskConcluded(loadable.loadTaskId);
            }
            return loadErrorAction;
        }

        private void loadPlaylistInternal(Uri playlistRequestUri) {
            this.excludeUntilMs = 0L;
            if (this.loadPending || this.mediaPlaylistLoader.isLoading() || this.mediaPlaylistLoader.hasFatalError()) {
                return;
            }
            long currentTimeMs = SystemClock.elapsedRealtime();
            if (currentTimeMs < this.earliestNextLoadTimeMs) {
                this.loadPending = true;
                DefaultHlsPlaylistTracker.this.playlistRefreshHandler.postDelayed(() -> {
                    this.loadPending = false;
                    this.loadPlaylistImmediately(playlistRequestUri);
                }, this.earliestNextLoadTimeMs - currentTimeMs);
            } else {
                this.loadPlaylistImmediately(playlistRequestUri);
            }
        }

        private void loadPlaylistImmediately(Uri playlistRequestUri) {
            ParsingLoadable.Parser<HlsPlaylist> mediaPlaylistParser = DefaultHlsPlaylistTracker.this.playlistParserFactory.createPlaylistParser(DefaultHlsPlaylistTracker.this.multivariantPlaylist, this.playlistSnapshot);
            ParsingLoadable mediaPlaylistLoadable = new ParsingLoadable(this.mediaPlaylistDataSource, playlistRequestUri, 4, mediaPlaylistParser);
            long elapsedRealtime = this.mediaPlaylistLoader.startLoading((Loader.Loadable)mediaPlaylistLoadable, (Loader.Callback)this, DefaultHlsPlaylistTracker.this.loadErrorHandlingPolicy.getMinimumLoadableRetryCount(mediaPlaylistLoadable.type));
            DefaultHlsPlaylistTracker.this.eventDispatcher.loadStarted(new LoadEventInfo(mediaPlaylistLoadable.loadTaskId, mediaPlaylistLoadable.dataSpec, elapsedRealtime), mediaPlaylistLoadable.type);
        }

        private void processLoadedPlaylist(HlsMediaPlaylist loadedPlaylist, LoadEventInfo loadEventInfo) {
            boolean scheduleLoad;
            long currentTimeMs;
            HlsMediaPlaylist oldPlaylist = this.playlistSnapshot;
            this.lastSnapshotLoadMs = currentTimeMs = SystemClock.elapsedRealtime();
            this.playlistSnapshot = DefaultHlsPlaylistTracker.this.getLatestPlaylistSnapshot(oldPlaylist, loadedPlaylist);
            if (this.playlistSnapshot != oldPlaylist) {
                this.playlistError = null;
                this.lastSnapshotChangeMs = currentTimeMs;
                DefaultHlsPlaylistTracker.this.onPlaylistUpdated(this.playlistUrl, this.playlistSnapshot);
            } else if (!this.playlistSnapshot.hasEndTag) {
                boolean forceRetry = false;
                IOException playlistError = null;
                if (loadedPlaylist.mediaSequence + (long)loadedPlaylist.segments.size() < this.playlistSnapshot.mediaSequence) {
                    forceRetry = true;
                    playlistError = new HlsPlaylistTracker.PlaylistResetException(this.playlistUrl);
                } else if ((double)(currentTimeMs - this.lastSnapshotChangeMs) > (double)Util.usToMs((long)this.playlistSnapshot.targetDurationUs) * DefaultHlsPlaylistTracker.this.playlistStuckTargetDurationCoefficient) {
                    playlistError = new HlsPlaylistTracker.PlaylistStuckException(this.playlistUrl);
                }
                if (playlistError != null) {
                    this.playlistError = playlistError;
                    DefaultHlsPlaylistTracker.this.notifyPlaylistError(this.playlistUrl, new LoadErrorHandlingPolicy.LoadErrorInfo(loadEventInfo, new MediaLoadData(4), playlistError, 1), forceRetry);
                }
            }
            long durationUntilNextLoadUs = 0L;
            if (!this.playlistSnapshot.serverControl.canBlockReload) {
                durationUntilNextLoadUs = this.playlistSnapshot != oldPlaylist ? this.playlistSnapshot.targetDurationUs : this.playlistSnapshot.targetDurationUs / 2L;
            }
            this.earliestNextLoadTimeMs = currentTimeMs + Util.usToMs((long)durationUntilNextLoadUs);
            boolean bl = scheduleLoad = this.playlistSnapshot.partTargetDurationUs != -9223372036854775807L || this.playlistUrl.equals((Object)DefaultHlsPlaylistTracker.this.primaryMediaPlaylistUrl);
            if (scheduleLoad && !this.playlistSnapshot.hasEndTag) {
                this.loadPlaylistInternal(this.getMediaPlaylistUriForReload());
            }
        }

        private Uri getMediaPlaylistUriForReload() {
            if (this.playlistSnapshot == null || this.playlistSnapshot.serverControl.skipUntilUs == -9223372036854775807L && !this.playlistSnapshot.serverControl.canBlockReload) {
                return this.playlistUrl;
            }
            Uri.Builder uriBuilder = this.playlistUrl.buildUpon();
            if (this.playlistSnapshot.serverControl.canBlockReload) {
                long targetMediaSequence = this.playlistSnapshot.mediaSequence + (long)this.playlistSnapshot.segments.size();
                uriBuilder.appendQueryParameter(BLOCK_MSN_PARAM, String.valueOf(targetMediaSequence));
                if (this.playlistSnapshot.partTargetDurationUs != -9223372036854775807L) {
                    List<HlsMediaPlaylist.Part> trailingParts = this.playlistSnapshot.trailingParts;
                    int targetPartIndex = trailingParts.size();
                    if (!trailingParts.isEmpty() && ((HlsMediaPlaylist.Part)Iterables.getLast(trailingParts)).isPreload) {
                        --targetPartIndex;
                    }
                    uriBuilder.appendQueryParameter(BLOCK_PART_PARAM, String.valueOf(targetPartIndex));
                }
            }
            if (this.playlistSnapshot.serverControl.skipUntilUs != -9223372036854775807L) {
                uriBuilder.appendQueryParameter(SKIP_PARAM, this.playlistSnapshot.serverControl.canSkipDateRanges ? "v2" : "YES");
            }
            return uriBuilder.build();
        }

        private boolean excludePlaylist(long exclusionDurationMs) {
            this.excludeUntilMs = SystemClock.elapsedRealtime() + exclusionDurationMs;
            return this.playlistUrl.equals((Object)DefaultHlsPlaylistTracker.this.primaryMediaPlaylistUrl) && !DefaultHlsPlaylistTracker.this.maybeSelectNewPrimaryUrl();
        }
    }
}

