/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls.playlist;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.offline.StreamKey;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylist;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class HlsMediaPlaylist
extends HlsPlaylist {
    public static final int PLAYLIST_TYPE_UNKNOWN = 0;
    public static final int PLAYLIST_TYPE_VOD = 1;
    public static final int PLAYLIST_TYPE_EVENT = 2;
    public final int playlistType;
    public final long startOffsetUs;
    public final boolean hasPositiveStartOffset;
    public final boolean preciseStart;
    public final long startTimeUs;
    public final boolean hasDiscontinuitySequence;
    public final int discontinuitySequence;
    public final long mediaSequence;
    public final int version;
    public final long targetDurationUs;
    public final long partTargetDurationUs;
    public final boolean hasEndTag;
    public final boolean hasProgramDateTime;
    @Nullable
    public final DrmInitData protectionSchemes;
    public final List<Segment> segments;
    public final List<Part> trailingParts;
    public final Map<Uri, RenditionReport> renditionReports;
    public final long durationUs;
    public final ServerControl serverControl;

    public HlsMediaPlaylist(int playlistType, String baseUri, List<String> tags, long startOffsetUs, boolean preciseStart, long startTimeUs, boolean hasDiscontinuitySequence, int discontinuitySequence, long mediaSequence, int version, long targetDurationUs, long partTargetDurationUs, boolean hasIndependentSegments, boolean hasEndTag, boolean hasProgramDateTime, @Nullable DrmInitData protectionSchemes, List<Segment> segments, List<Part> trailingParts, ServerControl serverControl, Map<Uri, RenditionReport> renditionReports) {
        super(baseUri, tags, hasIndependentSegments);
        this.playlistType = playlistType;
        this.startTimeUs = startTimeUs;
        this.preciseStart = preciseStart;
        this.hasDiscontinuitySequence = hasDiscontinuitySequence;
        this.discontinuitySequence = discontinuitySequence;
        this.mediaSequence = mediaSequence;
        this.version = version;
        this.targetDurationUs = targetDurationUs;
        this.partTargetDurationUs = partTargetDurationUs;
        this.hasEndTag = hasEndTag;
        this.hasProgramDateTime = hasProgramDateTime;
        this.protectionSchemes = protectionSchemes;
        this.segments = ImmutableList.copyOf(segments);
        this.trailingParts = ImmutableList.copyOf(trailingParts);
        this.renditionReports = ImmutableMap.copyOf(renditionReports);
        if (!trailingParts.isEmpty()) {
            Part lastPart = (Part)Iterables.getLast(trailingParts);
            this.durationUs = lastPart.relativeStartTimeUs + lastPart.durationUs;
        } else if (!segments.isEmpty()) {
            Segment lastSegment = (Segment)Iterables.getLast(segments);
            this.durationUs = lastSegment.relativeStartTimeUs + lastSegment.durationUs;
        } else {
            this.durationUs = 0L;
        }
        this.startOffsetUs = startOffsetUs == -9223372036854775807L ? -9223372036854775807L : (startOffsetUs >= 0L ? Math.min(this.durationUs, startOffsetUs) : Math.max(0L, this.durationUs + startOffsetUs));
        this.hasPositiveStartOffset = startOffsetUs >= 0L;
        this.serverControl = serverControl;
    }

    public HlsMediaPlaylist copy(List<StreamKey> streamKeys) {
        return this;
    }

    public boolean isNewerThan(@Nullable HlsMediaPlaylist other) {
        int otherPartCount;
        if (other == null || this.mediaSequence > other.mediaSequence) {
            return true;
        }
        if (this.mediaSequence < other.mediaSequence) {
            return false;
        }
        int segmentCountDifference = this.segments.size() - other.segments.size();
        if (segmentCountDifference != 0) {
            return segmentCountDifference > 0;
        }
        int partCount = this.trailingParts.size();
        return partCount > (otherPartCount = other.trailingParts.size()) || partCount == otherPartCount && this.hasEndTag && !other.hasEndTag;
    }

    public long getEndTimeUs() {
        return this.startTimeUs + this.durationUs;
    }

    public HlsMediaPlaylist copyWith(long startTimeUs, int discontinuitySequence) {
        return new HlsMediaPlaylist(this.playlistType, this.baseUri, this.tags, this.startOffsetUs, this.preciseStart, startTimeUs, true, discontinuitySequence, this.mediaSequence, this.version, this.targetDurationUs, this.partTargetDurationUs, this.hasIndependentSegments, this.hasEndTag, this.hasProgramDateTime, this.protectionSchemes, this.segments, this.trailingParts, this.serverControl, this.renditionReports);
    }

    public HlsMediaPlaylist copyWithEndTag() {
        if (this.hasEndTag) {
            return this;
        }
        return new HlsMediaPlaylist(this.playlistType, this.baseUri, this.tags, this.startOffsetUs, this.preciseStart, this.startTimeUs, this.hasDiscontinuitySequence, this.discontinuitySequence, this.mediaSequence, this.version, this.targetDurationUs, this.partTargetDurationUs, this.hasIndependentSegments, true, this.hasProgramDateTime, this.protectionSchemes, this.segments, this.trailingParts, this.serverControl, this.renditionReports);
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface PlaylistType {
    }

    public static final class RenditionReport {
        public final Uri playlistUri;
        public final long lastMediaSequence;
        public final int lastPartIndex;

        public RenditionReport(Uri playlistUri, long lastMediaSequence, int lastPartIndex) {
            this.playlistUri = playlistUri;
            this.lastMediaSequence = lastMediaSequence;
            this.lastPartIndex = lastPartIndex;
        }
    }

    public static class SegmentBase
    implements Comparable<Long> {
        public final String url;
        @Nullable
        public final Segment initializationSegment;
        public final long durationUs;
        public final int relativeDiscontinuitySequence;
        public final long relativeStartTimeUs;
        @Nullable
        public final DrmInitData drmInitData;
        @Nullable
        public final String fullSegmentEncryptionKeyUri;
        @Nullable
        public final String encryptionIV;
        public final long byteRangeOffset;
        public final long byteRangeLength;
        public final boolean hasGapTag;

        private SegmentBase(String url, @Nullable Segment initializationSegment, long durationUs, int relativeDiscontinuitySequence, long relativeStartTimeUs, @Nullable DrmInitData drmInitData, @Nullable String fullSegmentEncryptionKeyUri, @Nullable String encryptionIV, long byteRangeOffset, long byteRangeLength, boolean hasGapTag) {
            this.url = url;
            this.initializationSegment = initializationSegment;
            this.durationUs = durationUs;
            this.relativeDiscontinuitySequence = relativeDiscontinuitySequence;
            this.relativeStartTimeUs = relativeStartTimeUs;
            this.drmInitData = drmInitData;
            this.fullSegmentEncryptionKeyUri = fullSegmentEncryptionKeyUri;
            this.encryptionIV = encryptionIV;
            this.byteRangeOffset = byteRangeOffset;
            this.byteRangeLength = byteRangeLength;
            this.hasGapTag = hasGapTag;
        }

        @Override
        public int compareTo(Long relativeStartTimeUs) {
            return this.relativeStartTimeUs > relativeStartTimeUs ? 1 : (this.relativeStartTimeUs < relativeStartTimeUs ? -1 : 0);
        }
    }

    public static final class Part
    extends SegmentBase {
        public final boolean isIndependent;
        public final boolean isPreload;

        public Part(String url, @Nullable Segment initializationSegment, long durationUs, int relativeDiscontinuitySequence, long relativeStartTimeUs, @Nullable DrmInitData drmInitData, @Nullable String fullSegmentEncryptionKeyUri, @Nullable String encryptionIV, long byteRangeOffset, long byteRangeLength, boolean hasGapTag, boolean isIndependent, boolean isPreload) {
            super(url, initializationSegment, durationUs, relativeDiscontinuitySequence, relativeStartTimeUs, drmInitData, fullSegmentEncryptionKeyUri, encryptionIV, byteRangeOffset, byteRangeLength, hasGapTag);
            this.isIndependent = isIndependent;
            this.isPreload = isPreload;
        }

        public Part copyWith(long relativeStartTimeUs, int relativeDiscontinuitySequence) {
            return new Part(this.url, this.initializationSegment, this.durationUs, relativeDiscontinuitySequence, relativeStartTimeUs, this.drmInitData, this.fullSegmentEncryptionKeyUri, this.encryptionIV, this.byteRangeOffset, this.byteRangeLength, this.hasGapTag, this.isIndependent, this.isPreload);
        }
    }

    public static final class Segment
    extends SegmentBase {
        public final String title;
        public final List<Part> parts;

        public Segment(String uri, long byteRangeOffset, long byteRangeLength, @Nullable String fullSegmentEncryptionKeyUri, @Nullable String encryptionIV) {
            this(uri, null, "", 0L, -1, -9223372036854775807L, null, fullSegmentEncryptionKeyUri, encryptionIV, byteRangeOffset, byteRangeLength, false, (List<Part>)ImmutableList.of());
        }

        public Segment(String url, @Nullable Segment initializationSegment, String title, long durationUs, int relativeDiscontinuitySequence, long relativeStartTimeUs, @Nullable DrmInitData drmInitData, @Nullable String fullSegmentEncryptionKeyUri, @Nullable String encryptionIV, long byteRangeOffset, long byteRangeLength, boolean hasGapTag, List<Part> parts) {
            super(url, initializationSegment, durationUs, relativeDiscontinuitySequence, relativeStartTimeUs, drmInitData, fullSegmentEncryptionKeyUri, encryptionIV, byteRangeOffset, byteRangeLength, hasGapTag);
            this.title = title;
            this.parts = ImmutableList.copyOf(parts);
        }

        public Segment copyWith(long relativeStartTimeUs, int relativeDiscontinuitySequence) {
            ArrayList<Part> updatedParts = new ArrayList<Part>();
            long relativePartStartTimeUs = relativeStartTimeUs;
            for (int i = 0; i < this.parts.size(); ++i) {
                Part part = this.parts.get(i);
                updatedParts.add(part.copyWith(relativePartStartTimeUs, relativeDiscontinuitySequence));
                relativePartStartTimeUs += part.durationUs;
            }
            return new Segment(this.url, this.initializationSegment, this.title, this.durationUs, relativeDiscontinuitySequence, relativeStartTimeUs, this.drmInitData, this.fullSegmentEncryptionKeyUri, this.encryptionIV, this.byteRangeOffset, this.byteRangeLength, this.hasGapTag, updatedParts);
        }
    }

    public static final class ServerControl {
        public final long skipUntilUs;
        public final boolean canSkipDateRanges;
        public final long holdBackUs;
        public final long partHoldBackUs;
        public final boolean canBlockReload;

        public ServerControl(long skipUntilUs, boolean canSkipDateRanges, long holdBackUs, long partHoldBackUs, boolean canBlockReload) {
            this.skipUntilUs = skipUntilUs;
            this.canSkipDateRanges = canSkipDateRanges;
            this.holdBackUs = holdBackUs;
            this.partHoldBackUs = partHoldBackUs;
            this.canBlockReload = canBlockReload;
        }
    }
}

