/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls;

import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.source.hls.HlsSampleStreamWrapper;
import com.google.android.exoplayer2.source.hls.SampleQueueMappingException;
import com.google.android.exoplayer2.util.Assertions;
import java.io.IOException;

final class HlsSampleStream
implements SampleStream {
    private final int trackGroupIndex;
    private final HlsSampleStreamWrapper sampleStreamWrapper;
    private int sampleQueueIndex;

    public HlsSampleStream(HlsSampleStreamWrapper sampleStreamWrapper, int trackGroupIndex) {
        this.sampleStreamWrapper = sampleStreamWrapper;
        this.trackGroupIndex = trackGroupIndex;
        this.sampleQueueIndex = -1;
    }

    public void bindSampleQueue() {
        Assertions.checkArgument((this.sampleQueueIndex == -1 ? 1 : 0) != 0);
        this.sampleQueueIndex = this.sampleStreamWrapper.bindSampleQueueToSampleStream(this.trackGroupIndex);
    }

    public void unbindSampleQueue() {
        if (this.sampleQueueIndex != -1) {
            this.sampleStreamWrapper.unbindSampleQueue(this.trackGroupIndex);
            this.sampleQueueIndex = -1;
        }
    }

    public boolean isReady() {
        return this.sampleQueueIndex == -3 || this.hasValidSampleQueueIndex() && this.sampleStreamWrapper.isReady(this.sampleQueueIndex);
    }

    public void maybeThrowError() throws IOException {
        if (this.sampleQueueIndex == -2) {
            throw new SampleQueueMappingException(this.sampleStreamWrapper.getTrackGroups().get((int)this.trackGroupIndex).getFormat((int)0).sampleMimeType);
        }
        if (this.sampleQueueIndex == -1) {
            this.sampleStreamWrapper.maybeThrowError();
        } else if (this.sampleQueueIndex != -3) {
            this.sampleStreamWrapper.maybeThrowError(this.sampleQueueIndex);
        }
    }

    public int readData(FormatHolder formatHolder, DecoderInputBuffer buffer, int readFlags) {
        if (this.sampleQueueIndex == -3) {
            buffer.addFlag(4);
            return -4;
        }
        return this.hasValidSampleQueueIndex() ? this.sampleStreamWrapper.readData(this.sampleQueueIndex, formatHolder, buffer, readFlags) : -3;
    }

    public int skipData(long positionUs) {
        return this.hasValidSampleQueueIndex() ? this.sampleStreamWrapper.skipData(this.sampleQueueIndex, positionUs) : 0;
    }

    private boolean hasValidSampleQueueIndex() {
        return this.sampleQueueIndex != -1 && this.sampleQueueIndex != -3 && this.sampleQueueIndex != -2;
    }
}

