/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls;

import android.net.Uri;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.ExoPlayerLibraryInfo;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.drm.DefaultDrmSessionManagerProvider;
import com.google.android.exoplayer2.drm.DrmSessionEventListener;
import com.google.android.exoplayer2.drm.DrmSessionManager;
import com.google.android.exoplayer2.drm.DrmSessionManagerProvider;
import com.google.android.exoplayer2.offline.StreamKey;
import com.google.android.exoplayer2.source.BaseMediaSource;
import com.google.android.exoplayer2.source.CompositeSequenceableLoaderFactory;
import com.google.android.exoplayer2.source.DefaultCompositeSequenceableLoaderFactory;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.source.MediaSourceFactory;
import com.google.android.exoplayer2.source.SinglePeriodTimeline;
import com.google.android.exoplayer2.source.hls.DefaultHlsDataSourceFactory;
import com.google.android.exoplayer2.source.hls.HlsDataSourceFactory;
import com.google.android.exoplayer2.source.hls.HlsExtractorFactory;
import com.google.android.exoplayer2.source.hls.HlsManifest;
import com.google.android.exoplayer2.source.hls.HlsMediaPeriod;
import com.google.android.exoplayer2.source.hls.playlist.DefaultHlsPlaylistParserFactory;
import com.google.android.exoplayer2.source.hls.playlist.DefaultHlsPlaylistTracker;
import com.google.android.exoplayer2.source.hls.playlist.FilteringHlsPlaylistParserFactory;
import com.google.android.exoplayer2.source.hls.playlist.HlsMasterPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsMediaPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylistParserFactory;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylistTracker;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultLoadErrorHandlingPolicy;
import com.google.android.exoplayer2.upstream.HttpDataSource;
import com.google.android.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.List;

public final class HlsMediaSource
extends BaseMediaSource
implements HlsPlaylistTracker.PrimaryPlaylistListener {
    public static final int METADATA_TYPE_ID3 = 1;
    public static final int METADATA_TYPE_EMSG = 3;
    private final HlsExtractorFactory extractorFactory;
    private final MediaItem.LocalConfiguration localConfiguration;
    private final HlsDataSourceFactory dataSourceFactory;
    private final CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory;
    private final DrmSessionManager drmSessionManager;
    private final LoadErrorHandlingPolicy loadErrorHandlingPolicy;
    private final boolean allowChunklessPreparation;
    private final int metadataType;
    private final boolean useSessionKeys;
    private final HlsPlaylistTracker playlistTracker;
    private final long elapsedRealTimeOffsetMs;
    private final MediaItem mediaItem;
    private MediaItem.LiveConfiguration liveConfiguration;
    @Nullable
    private TransferListener mediaTransferListener;

    private HlsMediaSource(MediaItem mediaItem, HlsDataSourceFactory dataSourceFactory, HlsExtractorFactory extractorFactory, CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory, DrmSessionManager drmSessionManager, LoadErrorHandlingPolicy loadErrorHandlingPolicy, HlsPlaylistTracker playlistTracker, long elapsedRealTimeOffsetMs, boolean allowChunklessPreparation, int metadataType, boolean useSessionKeys) {
        this.localConfiguration = (MediaItem.LocalConfiguration)Assertions.checkNotNull((Object)mediaItem.localConfiguration);
        this.mediaItem = mediaItem;
        this.liveConfiguration = mediaItem.liveConfiguration;
        this.dataSourceFactory = dataSourceFactory;
        this.extractorFactory = extractorFactory;
        this.compositeSequenceableLoaderFactory = compositeSequenceableLoaderFactory;
        this.drmSessionManager = drmSessionManager;
        this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
        this.playlistTracker = playlistTracker;
        this.elapsedRealTimeOffsetMs = elapsedRealTimeOffsetMs;
        this.allowChunklessPreparation = allowChunklessPreparation;
        this.metadataType = metadataType;
        this.useSessionKeys = useSessionKeys;
    }

    public MediaItem getMediaItem() {
        return this.mediaItem;
    }

    protected void prepareSourceInternal(@Nullable TransferListener mediaTransferListener) {
        this.mediaTransferListener = mediaTransferListener;
        this.drmSessionManager.prepare();
        MediaSourceEventListener.EventDispatcher eventDispatcher = this.createEventDispatcher(null);
        this.playlistTracker.start(this.localConfiguration.uri, eventDispatcher, this);
    }

    public void maybeThrowSourceInfoRefreshError() throws IOException {
        this.playlistTracker.maybeThrowPrimaryPlaylistRefreshError();
    }

    public MediaPeriod createPeriod(MediaSource.MediaPeriodId id, Allocator allocator, long startPositionUs) {
        MediaSourceEventListener.EventDispatcher mediaSourceEventDispatcher = this.createEventDispatcher(id);
        DrmSessionEventListener.EventDispatcher drmEventDispatcher = this.createDrmEventDispatcher(id);
        return new HlsMediaPeriod(this.extractorFactory, this.playlistTracker, this.dataSourceFactory, this.mediaTransferListener, this.drmSessionManager, drmEventDispatcher, this.loadErrorHandlingPolicy, mediaSourceEventDispatcher, allocator, this.compositeSequenceableLoaderFactory, this.allowChunklessPreparation, this.metadataType, this.useSessionKeys);
    }

    public void releasePeriod(MediaPeriod mediaPeriod) {
        ((HlsMediaPeriod)mediaPeriod).release();
    }

    protected void releaseSourceInternal() {
        this.playlistTracker.stop();
        this.drmSessionManager.release();
    }

    @Override
    public void onPrimaryPlaylistRefreshed(HlsMediaPlaylist mediaPlaylist) {
        long windowStartTimeMs = mediaPlaylist.hasProgramDateTime ? Util.usToMs((long)mediaPlaylist.startTimeUs) : -9223372036854775807L;
        long presentationStartTimeMs = mediaPlaylist.playlistType == 2 || mediaPlaylist.playlistType == 1 ? windowStartTimeMs : -9223372036854775807L;
        HlsManifest manifest = new HlsManifest((HlsMasterPlaylist)Assertions.checkNotNull((Object)this.playlistTracker.getMasterPlaylist()), mediaPlaylist);
        SinglePeriodTimeline timeline = this.playlistTracker.isLive() ? this.createTimelineForLive(mediaPlaylist, presentationStartTimeMs, windowStartTimeMs, manifest) : this.createTimelineForOnDemand(mediaPlaylist, presentationStartTimeMs, windowStartTimeMs, manifest);
        this.refreshSourceInfo((Timeline)timeline);
    }

    private SinglePeriodTimeline createTimelineForLive(HlsMediaPlaylist playlist, long presentationStartTimeMs, long windowStartTimeMs, HlsManifest manifest) {
        long offsetFromInitialStartTimeUs = playlist.startTimeUs - this.playlistTracker.getInitialStartTimeUs();
        long periodDurationUs = playlist.hasEndTag ? offsetFromInitialStartTimeUs + playlist.durationUs : -9223372036854775807L;
        long liveEdgeOffsetUs = this.getLiveEdgeOffsetUs(playlist);
        long targetLiveOffsetUs = this.liveConfiguration.targetOffsetMs != -9223372036854775807L ? Util.msToUs((long)this.liveConfiguration.targetOffsetMs) : HlsMediaSource.getTargetLiveOffsetUs(playlist, liveEdgeOffsetUs);
        targetLiveOffsetUs = Util.constrainValue((long)targetLiveOffsetUs, (long)liveEdgeOffsetUs, (long)(playlist.durationUs + liveEdgeOffsetUs));
        this.maybeUpdateLiveConfiguration(targetLiveOffsetUs);
        long windowDefaultStartPositionUs = this.getLiveWindowDefaultStartPositionUs(playlist, liveEdgeOffsetUs);
        boolean suppressPositionProjection = playlist.playlistType == 2 && playlist.hasPositiveStartOffset;
        return new SinglePeriodTimeline(presentationStartTimeMs, windowStartTimeMs, -9223372036854775807L, periodDurationUs, playlist.durationUs, offsetFromInitialStartTimeUs, windowDefaultStartPositionUs, true, !playlist.hasEndTag, suppressPositionProjection, (Object)manifest, this.mediaItem, this.liveConfiguration);
    }

    private SinglePeriodTimeline createTimelineForOnDemand(HlsMediaPlaylist playlist, long presentationStartTimeMs, long windowStartTimeMs, HlsManifest manifest) {
        long windowDefaultStartPositionUs = playlist.startOffsetUs == -9223372036854775807L || playlist.segments.isEmpty() ? 0L : (playlist.preciseStart || playlist.startOffsetUs == playlist.durationUs ? playlist.startOffsetUs : HlsMediaSource.findClosestPrecedingSegment(playlist.segments, (long)playlist.startOffsetUs).relativeStartTimeUs);
        return new SinglePeriodTimeline(presentationStartTimeMs, windowStartTimeMs, -9223372036854775807L, playlist.durationUs, playlist.durationUs, 0L, windowDefaultStartPositionUs, true, false, true, (Object)manifest, this.mediaItem, null);
    }

    private long getLiveEdgeOffsetUs(HlsMediaPlaylist playlist) {
        return playlist.hasProgramDateTime ? Util.msToUs((long)Util.getNowUnixTimeMs((long)this.elapsedRealTimeOffsetMs)) - playlist.getEndTimeUs() : 0L;
    }

    private long getLiveWindowDefaultStartPositionUs(HlsMediaPlaylist playlist, long liveEdgeOffsetUs) {
        long startPositionUs;
        long l = startPositionUs = playlist.startOffsetUs != -9223372036854775807L ? playlist.startOffsetUs : playlist.durationUs + liveEdgeOffsetUs - Util.msToUs((long)this.liveConfiguration.targetOffsetMs);
        if (playlist.preciseStart) {
            return startPositionUs;
        }
        HlsMediaPlaylist.Part part = HlsMediaSource.findClosestPrecedingIndependentPart(playlist.trailingParts, startPositionUs);
        if (part != null) {
            return part.relativeStartTimeUs;
        }
        if (playlist.segments.isEmpty()) {
            return 0L;
        }
        HlsMediaPlaylist.Segment segment = HlsMediaSource.findClosestPrecedingSegment(playlist.segments, startPositionUs);
        part = HlsMediaSource.findClosestPrecedingIndependentPart(segment.parts, startPositionUs);
        if (part != null) {
            return part.relativeStartTimeUs;
        }
        return segment.relativeStartTimeUs;
    }

    private void maybeUpdateLiveConfiguration(long targetLiveOffsetUs) {
        long targetLiveOffsetMs = Util.usToMs((long)targetLiveOffsetUs);
        if (targetLiveOffsetMs != this.liveConfiguration.targetOffsetMs) {
            this.liveConfiguration = this.liveConfiguration.buildUpon().setTargetOffsetMs(targetLiveOffsetMs).build();
        }
    }

    private static long getTargetLiveOffsetUs(HlsMediaPlaylist playlist, long liveEdgeOffsetUs) {
        HlsMediaPlaylist.ServerControl serverControl = playlist.serverControl;
        long targetOffsetUs = playlist.startOffsetUs != -9223372036854775807L ? playlist.durationUs - playlist.startOffsetUs : (serverControl.partHoldBackUs != -9223372036854775807L && playlist.partTargetDurationUs != -9223372036854775807L ? serverControl.partHoldBackUs : (serverControl.holdBackUs != -9223372036854775807L ? serverControl.holdBackUs : 3L * playlist.targetDurationUs));
        return targetOffsetUs + liveEdgeOffsetUs;
    }

    @Nullable
    private static HlsMediaPlaylist.Part findClosestPrecedingIndependentPart(List<HlsMediaPlaylist.Part> parts, long positionUs) {
        HlsMediaPlaylist.Part closestPart = null;
        for (int i = 0; i < parts.size(); ++i) {
            HlsMediaPlaylist.Part part = parts.get(i);
            if (part.relativeStartTimeUs <= positionUs && part.isIndependent) {
                closestPart = part;
                continue;
            }
            if (part.relativeStartTimeUs > positionUs) break;
        }
        return closestPart;
    }

    private static HlsMediaPlaylist.Segment findClosestPrecedingSegment(List<HlsMediaPlaylist.Segment> segments, long positionUs) {
        int segmentIndex = Util.binarySearchFloor(segments, (Comparable)Long.valueOf(positionUs), (boolean)true, (boolean)true);
        return segments.get(segmentIndex);
    }

    static {
        ExoPlayerLibraryInfo.registerModule((String)"goog.exo.hls");
    }

    public static final class Factory
    implements MediaSourceFactory {
        private final HlsDataSourceFactory hlsDataSourceFactory;
        private HlsExtractorFactory extractorFactory;
        private HlsPlaylistParserFactory playlistParserFactory;
        private HlsPlaylistTracker.Factory playlistTrackerFactory;
        private CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory;
        private boolean usingCustomDrmSessionManagerProvider;
        private DrmSessionManagerProvider drmSessionManagerProvider;
        private LoadErrorHandlingPolicy loadErrorHandlingPolicy;
        private boolean allowChunklessPreparation;
        private int metadataType;
        private boolean useSessionKeys;
        private List<StreamKey> streamKeys;
        @Nullable
        private Object tag;
        private long elapsedRealTimeOffsetMs;

        public Factory(DataSource.Factory dataSourceFactory) {
            this(new DefaultHlsDataSourceFactory(dataSourceFactory));
        }

        public Factory(HlsDataSourceFactory hlsDataSourceFactory) {
            this.hlsDataSourceFactory = (HlsDataSourceFactory)Assertions.checkNotNull((Object)hlsDataSourceFactory);
            this.drmSessionManagerProvider = new DefaultDrmSessionManagerProvider();
            this.playlistParserFactory = new DefaultHlsPlaylistParserFactory();
            this.playlistTrackerFactory = DefaultHlsPlaylistTracker.FACTORY;
            this.extractorFactory = HlsExtractorFactory.DEFAULT;
            this.loadErrorHandlingPolicy = new DefaultLoadErrorHandlingPolicy();
            this.compositeSequenceableLoaderFactory = new DefaultCompositeSequenceableLoaderFactory();
            this.metadataType = 1;
            this.streamKeys = Collections.emptyList();
            this.elapsedRealTimeOffsetMs = -9223372036854775807L;
        }

        @Deprecated
        public Factory setTag(@Nullable Object tag) {
            this.tag = tag;
            return this;
        }

        public Factory setExtractorFactory(@Nullable HlsExtractorFactory extractorFactory) {
            this.extractorFactory = extractorFactory != null ? extractorFactory : HlsExtractorFactory.DEFAULT;
            return this;
        }

        public Factory setLoadErrorHandlingPolicy(@Nullable LoadErrorHandlingPolicy loadErrorHandlingPolicy) {
            this.loadErrorHandlingPolicy = loadErrorHandlingPolicy != null ? loadErrorHandlingPolicy : new DefaultLoadErrorHandlingPolicy();
            return this;
        }

        public Factory setPlaylistParserFactory(@Nullable HlsPlaylistParserFactory playlistParserFactory) {
            this.playlistParserFactory = playlistParserFactory != null ? playlistParserFactory : new DefaultHlsPlaylistParserFactory();
            return this;
        }

        public Factory setPlaylistTrackerFactory(@Nullable HlsPlaylistTracker.Factory playlistTrackerFactory) {
            this.playlistTrackerFactory = playlistTrackerFactory != null ? playlistTrackerFactory : DefaultHlsPlaylistTracker.FACTORY;
            return this;
        }

        public Factory setCompositeSequenceableLoaderFactory(@Nullable CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory) {
            this.compositeSequenceableLoaderFactory = compositeSequenceableLoaderFactory != null ? compositeSequenceableLoaderFactory : new DefaultCompositeSequenceableLoaderFactory();
            return this;
        }

        public Factory setAllowChunklessPreparation(boolean allowChunklessPreparation) {
            this.allowChunklessPreparation = allowChunklessPreparation;
            return this;
        }

        public Factory setMetadataType(int metadataType) {
            this.metadataType = metadataType;
            return this;
        }

        public Factory setUseSessionKeys(boolean useSessionKeys) {
            this.useSessionKeys = useSessionKeys;
            return this;
        }

        public Factory setDrmSessionManagerProvider(@Nullable DrmSessionManagerProvider drmSessionManagerProvider) {
            if (drmSessionManagerProvider != null) {
                this.drmSessionManagerProvider = drmSessionManagerProvider;
                this.usingCustomDrmSessionManagerProvider = true;
            } else {
                this.drmSessionManagerProvider = new DefaultDrmSessionManagerProvider();
                this.usingCustomDrmSessionManagerProvider = false;
            }
            return this;
        }

        @Deprecated
        public Factory setDrmSessionManager(@Nullable DrmSessionManager drmSessionManager) {
            if (drmSessionManager == null) {
                this.setDrmSessionManagerProvider(null);
            } else {
                this.setDrmSessionManagerProvider(unusedMediaItem -> drmSessionManager);
            }
            return this;
        }

        @Deprecated
        public Factory setDrmHttpDataSourceFactory(@Nullable HttpDataSource.Factory drmHttpDataSourceFactory) {
            if (!this.usingCustomDrmSessionManagerProvider) {
                ((DefaultDrmSessionManagerProvider)this.drmSessionManagerProvider).setDrmHttpDataSourceFactory(drmHttpDataSourceFactory);
            }
            return this;
        }

        @Deprecated
        public Factory setDrmUserAgent(@Nullable String userAgent) {
            if (!this.usingCustomDrmSessionManagerProvider) {
                ((DefaultDrmSessionManagerProvider)this.drmSessionManagerProvider).setDrmUserAgent(userAgent);
            }
            return this;
        }

        @Deprecated
        public Factory setStreamKeys(@Nullable List<StreamKey> streamKeys) {
            this.streamKeys = streamKeys != null ? streamKeys : Collections.emptyList();
            return this;
        }

        @VisibleForTesting
        Factory setElapsedRealTimeOffsetMs(long elapsedRealTimeOffsetMs) {
            this.elapsedRealTimeOffsetMs = elapsedRealTimeOffsetMs;
            return this;
        }

        @Deprecated
        public HlsMediaSource createMediaSource(Uri uri) {
            return this.createMediaSource(new MediaItem.Builder().setUri(uri).setMimeType("application/x-mpegURL").build());
        }

        public HlsMediaSource createMediaSource(MediaItem mediaItem) {
            boolean needsStreamKeys;
            List streamKeys;
            Assertions.checkNotNull((Object)mediaItem.localConfiguration);
            HlsPlaylistParserFactory playlistParserFactory = this.playlistParserFactory;
            List list = streamKeys = mediaItem.localConfiguration.streamKeys.isEmpty() ? this.streamKeys : mediaItem.localConfiguration.streamKeys;
            if (!streamKeys.isEmpty()) {
                playlistParserFactory = new FilteringHlsPlaylistParserFactory(playlistParserFactory, streamKeys);
            }
            boolean needsTag = mediaItem.localConfiguration.tag == null && this.tag != null;
            boolean bl = needsStreamKeys = mediaItem.localConfiguration.streamKeys.isEmpty() && !streamKeys.isEmpty();
            if (needsTag && needsStreamKeys) {
                mediaItem = mediaItem.buildUpon().setTag(this.tag).setStreamKeys(streamKeys).build();
            } else if (needsTag) {
                mediaItem = mediaItem.buildUpon().setTag(this.tag).build();
            } else if (needsStreamKeys) {
                mediaItem = mediaItem.buildUpon().setStreamKeys(streamKeys).build();
            }
            return new HlsMediaSource(mediaItem, this.hlsDataSourceFactory, this.extractorFactory, this.compositeSequenceableLoaderFactory, this.drmSessionManagerProvider.get(mediaItem), this.loadErrorHandlingPolicy, this.playlistTrackerFactory.createTracker(this.hlsDataSourceFactory, this.loadErrorHandlingPolicy, playlistParserFactory), this.elapsedRealTimeOffsetMs, this.allowChunklessPreparation, this.metadataType, this.useSessionKeys);
        }

        public int[] getSupportedTypes() {
            return new int[]{2};
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface MetadataType {
    }
}

