/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls;

import android.annotation.SuppressLint;
import android.media.MediaFormat;
import android.media.MediaParser;
import android.text.TextUtils;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.source.hls.BundledHlsMediaChunkExtractor;
import com.google.android.exoplayer2.source.hls.HlsExtractorFactory;
import com.google.android.exoplayer2.source.hls.HlsMediaChunkExtractor;
import com.google.android.exoplayer2.source.hls.WebvttExtractor;
import com.google.android.exoplayer2.source.mediaparser.InputReaderAdapterV30;
import com.google.android.exoplayer2.source.mediaparser.MediaParserUtil;
import com.google.android.exoplayer2.source.mediaparser.OutputConsumerAdapterV30;
import com.google.android.exoplayer2.upstream.DataReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.FileTypes;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.common.collect.ImmutableList;
import java.io.IOException;

@RequiresApi(value=30)
public final class MediaParserHlsMediaChunkExtractor
implements HlsMediaChunkExtractor {
    public static final HlsExtractorFactory FACTORY = (uri, format, muxedCaptionFormats, timestampAdjuster, responseHeaders, sniffingExtractorInput) -> {
        if (FileTypes.inferFileTypeFromMimeType((String)format.sampleMimeType) == 13) {
            return new BundledHlsMediaChunkExtractor(new WebvttExtractor(format.language, timestampAdjuster), format, timestampAdjuster);
        }
        boolean overrideInBandCaptionDeclarations = muxedCaptionFormats != null;
        ImmutableList.Builder muxedCaptionMediaFormatsBuilder = ImmutableList.builder();
        if (muxedCaptionFormats != null) {
            for (int i = 0; i < muxedCaptionFormats.size(); ++i) {
                muxedCaptionMediaFormatsBuilder.add((Object)MediaParserUtil.toCaptionsMediaFormat((Format)((Format)muxedCaptionFormats.get(i))));
            }
        } else {
            muxedCaptionMediaFormatsBuilder.add((Object)MediaParserUtil.toCaptionsMediaFormat((Format)new Format.Builder().setSampleMimeType("application/cea-608").build()));
        }
        ImmutableList muxedCaptionMediaFormats = muxedCaptionMediaFormatsBuilder.build();
        OutputConsumerAdapterV30 outputConsumerAdapter = new OutputConsumerAdapterV30();
        outputConsumerAdapter.setMuxedCaptionFormats(muxedCaptionFormats != null ? muxedCaptionFormats : ImmutableList.of());
        outputConsumerAdapter.setTimestampAdjuster(timestampAdjuster);
        MediaParser mediaParser = MediaParserHlsMediaChunkExtractor.createMediaParserInstance((MediaParser.OutputConsumer)outputConsumerAdapter, format, overrideInBandCaptionDeclarations, (ImmutableList<MediaFormat>)muxedCaptionMediaFormats, "android.media.mediaparser.FragmentedMp4Parser", "android.media.mediaparser.Ac3Parser", "android.media.mediaparser.Ac4Parser", "android.media.mediaparser.AdtsParser", "android.media.mediaparser.Mp3Parser", "android.media.mediaparser.TsParser");
        PeekingInputReader peekingInputReader = new PeekingInputReader(sniffingExtractorInput);
        mediaParser.advance((MediaParser.SeekableInputReader)peekingInputReader);
        outputConsumerAdapter.setSelectedParserName(mediaParser.getParserName());
        return new MediaParserHlsMediaChunkExtractor(mediaParser, outputConsumerAdapter, format, overrideInBandCaptionDeclarations, (ImmutableList<MediaFormat>)muxedCaptionMediaFormats, peekingInputReader.totalPeekedBytes);
    };
    private final OutputConsumerAdapterV30 outputConsumerAdapter;
    private final InputReaderAdapterV30 inputReaderAdapter;
    private final MediaParser mediaParser;
    private final Format format;
    private final boolean overrideInBandCaptionDeclarations;
    private final ImmutableList<MediaFormat> muxedCaptionMediaFormats;
    private int pendingSkipBytes;

    public MediaParserHlsMediaChunkExtractor(MediaParser mediaParser, OutputConsumerAdapterV30 outputConsumerAdapter, Format format, boolean overrideInBandCaptionDeclarations, ImmutableList<MediaFormat> muxedCaptionMediaFormats, int leadingBytesToSkip) {
        this.mediaParser = mediaParser;
        this.outputConsumerAdapter = outputConsumerAdapter;
        this.overrideInBandCaptionDeclarations = overrideInBandCaptionDeclarations;
        this.muxedCaptionMediaFormats = muxedCaptionMediaFormats;
        this.format = format;
        this.pendingSkipBytes = leadingBytesToSkip;
        this.inputReaderAdapter = new InputReaderAdapterV30();
    }

    @Override
    public void init(ExtractorOutput extractorOutput) {
        this.outputConsumerAdapter.setExtractorOutput(extractorOutput);
    }

    @Override
    public boolean read(ExtractorInput extractorInput) throws IOException {
        extractorInput.skipFully(this.pendingSkipBytes);
        this.pendingSkipBytes = 0;
        this.inputReaderAdapter.setDataReader((DataReader)extractorInput, extractorInput.getLength());
        return this.mediaParser.advance((MediaParser.SeekableInputReader)this.inputReaderAdapter);
    }

    @Override
    public boolean isPackedAudioExtractor() {
        String parserName = this.mediaParser.getParserName();
        return "android.media.mediaparser.Ac3Parser".equals(parserName) || "android.media.mediaparser.Ac4Parser".equals(parserName) || "android.media.mediaparser.AdtsParser".equals(parserName) || "android.media.mediaparser.Mp3Parser".equals(parserName);
    }

    @Override
    public boolean isReusable() {
        String parserName = this.mediaParser.getParserName();
        return "android.media.mediaparser.FragmentedMp4Parser".equals(parserName) || "android.media.mediaparser.TsParser".equals(parserName);
    }

    @Override
    public HlsMediaChunkExtractor recreate() {
        Assertions.checkState((!this.isReusable() ? 1 : 0) != 0);
        return new MediaParserHlsMediaChunkExtractor(MediaParserHlsMediaChunkExtractor.createMediaParserInstance((MediaParser.OutputConsumer)this.outputConsumerAdapter, this.format, this.overrideInBandCaptionDeclarations, this.muxedCaptionMediaFormats, this.mediaParser.getParserName()), this.outputConsumerAdapter, this.format, this.overrideInBandCaptionDeclarations, this.muxedCaptionMediaFormats, 0);
    }

    @Override
    public void onTruncatedSegmentParsed() {
        this.mediaParser.seek(MediaParser.SeekPoint.START);
    }

    @SuppressLint(value={"WrongConstant"})
    private static MediaParser createMediaParserInstance(MediaParser.OutputConsumer outputConsumer, Format format, boolean overrideInBandCaptionDeclarations, ImmutableList<MediaFormat> muxedCaptionMediaFormats, String ... parserNames) {
        MediaParser mediaParser = parserNames.length == 1 ? MediaParser.createByName((String)parserNames[0], (MediaParser.OutputConsumer)outputConsumer) : MediaParser.create((MediaParser.OutputConsumer)outputConsumer, (String[])parserNames);
        mediaParser.setParameter("android.media.mediaParser.exposeCaptionFormats", muxedCaptionMediaFormats);
        mediaParser.setParameter("android.media.mediaParser.overrideInBandCaptionDeclarations", (Object)overrideInBandCaptionDeclarations);
        mediaParser.setParameter("android.media.mediaparser.inBandCryptoInfo", (Object)true);
        mediaParser.setParameter("android.media.mediaparser.eagerlyExposeTrackType", (Object)true);
        mediaParser.setParameter("android.media.mediaparser.ignoreTimestampOffset", (Object)true);
        mediaParser.setParameter("android.media.mediaparser.ts.ignoreSpliceInfoStream", (Object)true);
        mediaParser.setParameter("android.media.mediaparser.ts.mode", (Object)"hls");
        String codecs = format.codecs;
        if (!TextUtils.isEmpty((CharSequence)codecs)) {
            if (!"audio/mp4a-latm".equals(MimeTypes.getAudioMediaMimeType((String)codecs))) {
                mediaParser.setParameter("android.media.mediaparser.ts.ignoreAacStream", (Object)true);
            }
            if (!"video/avc".equals(MimeTypes.getVideoMediaMimeType((String)codecs))) {
                mediaParser.setParameter("android.media.mediaparser.ts.ignoreAvcStream", (Object)true);
            }
        }
        return mediaParser;
    }

    private static final class PeekingInputReader
    implements MediaParser.SeekableInputReader {
        private final ExtractorInput extractorInput;
        private int totalPeekedBytes;

        private PeekingInputReader(ExtractorInput extractorInput) {
            this.extractorInput = extractorInput;
        }

        public int read(byte[] buffer, int offset, int readLength) throws IOException {
            int peekedBytes = this.extractorInput.peek(buffer, offset, readLength);
            this.totalPeekedBytes += peekedBytes;
            return peekedBytes;
        }

        public long getPosition() {
            return this.extractorInput.getPeekPosition();
        }

        public long getLength() {
            return this.extractorInput.getLength();
        }

        public void seekToPosition(long position) {
            throw new UnsupportedOperationException();
        }
    }
}

