/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls;

import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.util.SparseIntArray;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.drm.DrmSessionEventListener;
import com.google.android.exoplayer2.drm.DrmSessionManager;
import com.google.android.exoplayer2.extractor.DummyTrackOutput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.emsg.EventMessage;
import com.google.android.exoplayer2.metadata.emsg.EventMessageDecoder;
import com.google.android.exoplayer2.metadata.id3.PrivFrame;
import com.google.android.exoplayer2.source.LoadEventInfo;
import com.google.android.exoplayer2.source.MediaLoadData;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.source.SampleQueue;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.source.SequenceableLoader;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.source.chunk.Chunk;
import com.google.android.exoplayer2.source.chunk.MediaChunkIterator;
import com.google.android.exoplayer2.source.hls.HlsChunkSource;
import com.google.android.exoplayer2.source.hls.HlsMediaChunk;
import com.google.android.exoplayer2.source.hls.HlsSampleStream;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelectionUtil;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.DataReader;
import com.google.android.exoplayer2.upstream.HttpDataSource;
import com.google.android.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.google.android.exoplayer2.upstream.Loader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.NullableType;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

final class HlsSampleStreamWrapper
implements Loader.Callback<Chunk>,
Loader.ReleaseCallback,
SequenceableLoader,
ExtractorOutput,
SampleQueue.UpstreamFormatChangedListener {
    private static final String TAG = "HlsSampleStreamWrapper";
    public static final int SAMPLE_QUEUE_INDEX_PENDING = -1;
    public static final int SAMPLE_QUEUE_INDEX_NO_MAPPING_FATAL = -2;
    public static final int SAMPLE_QUEUE_INDEX_NO_MAPPING_NON_FATAL = -3;
    private static final Set<Integer> MAPPABLE_TYPES = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(1, 2, 5)));
    private final int trackType;
    private final Callback callback;
    private final HlsChunkSource chunkSource;
    private final Allocator allocator;
    @Nullable
    private final Format muxedAudioFormat;
    private final DrmSessionManager drmSessionManager;
    private final DrmSessionEventListener.EventDispatcher drmEventDispatcher;
    private final LoadErrorHandlingPolicy loadErrorHandlingPolicy;
    private final Loader loader;
    private final MediaSourceEventListener.EventDispatcher mediaSourceEventDispatcher;
    private final int metadataType;
    private final HlsChunkSource.HlsChunkHolder nextChunkHolder;
    private final ArrayList<HlsMediaChunk> mediaChunks;
    private final List<HlsMediaChunk> readOnlyMediaChunks;
    private final Runnable maybeFinishPrepareRunnable;
    private final Runnable onTracksEndedRunnable;
    private final Handler handler;
    private final ArrayList<HlsSampleStream> hlsSampleStreams;
    private final Map<String, DrmInitData> overridingDrmInitData;
    @Nullable
    private Chunk loadingChunk;
    private HlsSampleQueue[] sampleQueues;
    private int[] sampleQueueTrackIds;
    private Set<Integer> sampleQueueMappingDoneByType;
    private SparseIntArray sampleQueueIndicesByType;
    private @MonotonicNonNull TrackOutput emsgUnwrappingTrackOutput;
    private int primarySampleQueueType;
    private int primarySampleQueueIndex;
    private boolean sampleQueuesBuilt;
    private boolean prepared;
    private int enabledTrackGroupCount;
    private @MonotonicNonNull Format upstreamTrackFormat;
    @Nullable
    private Format downstreamTrackFormat;
    private boolean released;
    private @MonotonicNonNull TrackGroupArray trackGroups;
    private @MonotonicNonNull Set<TrackGroup> optionalTrackGroups;
    private int @MonotonicNonNull [] trackGroupToSampleQueueIndex;
    private int primaryTrackGroupIndex;
    private boolean haveAudioVideoSampleQueues;
    private boolean[] sampleQueuesEnabledStates;
    private boolean[] sampleQueueIsAudioVideoFlags;
    private long lastSeekPositionUs;
    private long pendingResetPositionUs;
    private boolean pendingResetUpstreamFormats;
    private boolean seenFirstTrackSelection;
    private boolean loadingFinished;
    private boolean tracksEnded;
    private long sampleOffsetUs;
    @Nullable
    private DrmInitData drmInitData;
    @Nullable
    private HlsMediaChunk sourceChunk;

    public HlsSampleStreamWrapper(int trackType, Callback callback, HlsChunkSource chunkSource, Map<String, DrmInitData> overridingDrmInitData, Allocator allocator, long positionUs, @Nullable Format muxedAudioFormat, DrmSessionManager drmSessionManager, DrmSessionEventListener.EventDispatcher drmEventDispatcher, LoadErrorHandlingPolicy loadErrorHandlingPolicy, MediaSourceEventListener.EventDispatcher mediaSourceEventDispatcher, int metadataType) {
        Runnable onTracksEndedRunnable;
        Runnable maybeFinishPrepareRunnable;
        this.trackType = trackType;
        this.callback = callback;
        this.chunkSource = chunkSource;
        this.overridingDrmInitData = overridingDrmInitData;
        this.allocator = allocator;
        this.muxedAudioFormat = muxedAudioFormat;
        this.drmSessionManager = drmSessionManager;
        this.drmEventDispatcher = drmEventDispatcher;
        this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
        this.mediaSourceEventDispatcher = mediaSourceEventDispatcher;
        this.metadataType = metadataType;
        this.loader = new Loader("Loader:HlsSampleStreamWrapper");
        this.nextChunkHolder = new HlsChunkSource.HlsChunkHolder();
        this.sampleQueueTrackIds = new int[0];
        this.sampleQueueMappingDoneByType = new HashSet<Integer>(MAPPABLE_TYPES.size());
        this.sampleQueueIndicesByType = new SparseIntArray(MAPPABLE_TYPES.size());
        this.sampleQueues = new HlsSampleQueue[0];
        this.sampleQueueIsAudioVideoFlags = new boolean[0];
        this.sampleQueuesEnabledStates = new boolean[0];
        this.mediaChunks = new ArrayList();
        this.readOnlyMediaChunks = Collections.unmodifiableList(this.mediaChunks);
        this.hlsSampleStreams = new ArrayList();
        this.maybeFinishPrepareRunnable = maybeFinishPrepareRunnable = this::maybeFinishPrepare;
        this.onTracksEndedRunnable = onTracksEndedRunnable = this::onTracksEnded;
        this.handler = Util.createHandlerForCurrentLooper();
        this.lastSeekPositionUs = positionUs;
        this.pendingResetPositionUs = positionUs;
    }

    public void continuePreparing() {
        if (!this.prepared) {
            this.continueLoading(this.lastSeekPositionUs);
        }
    }

    public void prepareWithMasterPlaylistInfo(TrackGroup[] trackGroups, int primaryTrackGroupIndex, int ... optionalTrackGroupsIndices) {
        this.trackGroups = this.createTrackGroupArrayWithDrmInfo(trackGroups);
        this.optionalTrackGroups = new HashSet<TrackGroup>();
        for (int optionalTrackGroupIndex : optionalTrackGroupsIndices) {
            this.optionalTrackGroups.add(this.trackGroups.get(optionalTrackGroupIndex));
        }
        this.primaryTrackGroupIndex = primaryTrackGroupIndex;
        this.handler.post(this.callback::onPrepared);
        this.setIsPrepared();
    }

    public void maybeThrowPrepareError() throws IOException {
        this.maybeThrowError();
        if (this.loadingFinished && !this.prepared) {
            throw ParserException.createForMalformedContainer((String)"Loading finished before preparation is complete.", null);
        }
    }

    public TrackGroupArray getTrackGroups() {
        this.assertIsPrepared();
        return this.trackGroups;
    }

    public int getPrimaryTrackGroupIndex() {
        return this.primaryTrackGroupIndex;
    }

    public int bindSampleQueueToSampleStream(int trackGroupIndex) {
        this.assertIsPrepared();
        Assertions.checkNotNull((Object)this.trackGroupToSampleQueueIndex);
        int sampleQueueIndex = this.trackGroupToSampleQueueIndex[trackGroupIndex];
        if (sampleQueueIndex == -1) {
            return this.optionalTrackGroups.contains(this.trackGroups.get(trackGroupIndex)) ? -3 : -2;
        }
        if (this.sampleQueuesEnabledStates[sampleQueueIndex]) {
            return -2;
        }
        this.sampleQueuesEnabledStates[sampleQueueIndex] = true;
        return sampleQueueIndex;
    }

    public void unbindSampleQueue(int trackGroupIndex) {
        this.assertIsPrepared();
        Assertions.checkNotNull((Object)this.trackGroupToSampleQueueIndex);
        int sampleQueueIndex = this.trackGroupToSampleQueueIndex[trackGroupIndex];
        Assertions.checkState((boolean)this.sampleQueuesEnabledStates[sampleQueueIndex]);
        this.sampleQueuesEnabledStates[sampleQueueIndex] = false;
    }

    public boolean selectTracks(@NullableType ExoTrackSelection[] selections, boolean[] mayRetainStreamFlags, @NullableType SampleStream[] streams, boolean[] streamResetFlags, long positionUs, boolean forceReset) {
        int i;
        ExoTrackSelection oldPrimaryTrackSelection;
        this.assertIsPrepared();
        int oldEnabledTrackGroupCount = this.enabledTrackGroupCount;
        for (int i2 = 0; i2 < selections.length; ++i2) {
            HlsSampleStream stream = (HlsSampleStream)streams[i2];
            if (stream == null || selections[i2] != null && mayRetainStreamFlags[i2]) continue;
            --this.enabledTrackGroupCount;
            stream.unbindSampleQueue();
            streams[i2] = null;
        }
        boolean seekRequired = forceReset || (this.seenFirstTrackSelection ? oldEnabledTrackGroupCount == 0 : positionUs != this.lastSeekPositionUs);
        ExoTrackSelection primaryTrackSelection = oldPrimaryTrackSelection = this.chunkSource.getTrackSelection();
        for (i = 0; i < selections.length; ++i) {
            ExoTrackSelection selection = selections[i];
            if (selection == null) continue;
            int trackGroupIndex = this.trackGroups.indexOf(selection.getTrackGroup());
            if (trackGroupIndex == this.primaryTrackGroupIndex) {
                primaryTrackSelection = selection;
                this.chunkSource.setTrackSelection(selection);
            }
            if (streams[i] != null) continue;
            ++this.enabledTrackGroupCount;
            streams[i] = new HlsSampleStream(this, trackGroupIndex);
            streamResetFlags[i] = true;
            if (this.trackGroupToSampleQueueIndex == null) continue;
            ((HlsSampleStream)streams[i]).bindSampleQueue();
            if (seekRequired) continue;
            HlsSampleQueue sampleQueue = this.sampleQueues[this.trackGroupToSampleQueueIndex[trackGroupIndex]];
            seekRequired = !sampleQueue.seekTo(positionUs, true) && sampleQueue.getReadIndex() != 0;
        }
        if (this.enabledTrackGroupCount == 0) {
            this.chunkSource.reset();
            this.downstreamTrackFormat = null;
            this.pendingResetUpstreamFormats = true;
            this.mediaChunks.clear();
            if (this.loader.isLoading()) {
                if (this.sampleQueuesBuilt) {
                    for (HlsSampleQueue sampleQueue : this.sampleQueues) {
                        sampleQueue.discardToEnd();
                    }
                }
                this.loader.cancelLoading();
            } else {
                this.resetSampleQueues();
            }
        } else {
            if (!this.mediaChunks.isEmpty() && !Util.areEqual((Object)primaryTrackSelection, (Object)oldPrimaryTrackSelection)) {
                boolean primarySampleQueueDirty = false;
                if (!this.seenFirstTrackSelection) {
                    long bufferedDurationUs = positionUs < 0L ? -positionUs : 0L;
                    HlsMediaChunk lastMediaChunk = this.getLastMediaChunk();
                    MediaChunkIterator[] mediaChunkIterators = this.chunkSource.createMediaChunkIterators(lastMediaChunk, positionUs);
                    primaryTrackSelection.updateSelectedTrack(positionUs, bufferedDurationUs, -9223372036854775807L, this.readOnlyMediaChunks, mediaChunkIterators);
                    int chunkIndex = this.chunkSource.getTrackGroup().indexOf(lastMediaChunk.trackFormat);
                    if (primaryTrackSelection.getSelectedIndexInTrackGroup() != chunkIndex) {
                        primarySampleQueueDirty = true;
                    }
                } else {
                    primarySampleQueueDirty = true;
                }
                if (primarySampleQueueDirty) {
                    forceReset = true;
                    seekRequired = true;
                    this.pendingResetUpstreamFormats = true;
                }
            }
            if (seekRequired) {
                this.seekToUs(positionUs, forceReset);
                for (i = 0; i < streams.length; ++i) {
                    if (streams[i] == null) continue;
                    streamResetFlags[i] = true;
                }
            }
        }
        this.updateSampleStreams(streams);
        this.seenFirstTrackSelection = true;
        return seekRequired;
    }

    public void discardBuffer(long positionUs, boolean toKeyframe) {
        if (!this.sampleQueuesBuilt || this.isPendingReset()) {
            return;
        }
        int sampleQueueCount = this.sampleQueues.length;
        for (int i = 0; i < sampleQueueCount; ++i) {
            this.sampleQueues[i].discardTo(positionUs, toKeyframe, this.sampleQueuesEnabledStates[i]);
        }
    }

    public boolean seekToUs(long positionUs, boolean forceReset) {
        this.lastSeekPositionUs = positionUs;
        if (this.isPendingReset()) {
            this.pendingResetPositionUs = positionUs;
            return true;
        }
        if (this.sampleQueuesBuilt && !forceReset && this.seekInsideBufferUs(positionUs)) {
            return false;
        }
        this.pendingResetPositionUs = positionUs;
        this.loadingFinished = false;
        this.mediaChunks.clear();
        if (this.loader.isLoading()) {
            if (this.sampleQueuesBuilt) {
                for (HlsSampleQueue sampleQueue : this.sampleQueues) {
                    sampleQueue.discardToEnd();
                }
            }
            this.loader.cancelLoading();
        } else {
            this.loader.clearFatalError();
            this.resetSampleQueues();
        }
        return true;
    }

    public void onPlaylistUpdated() {
        if (this.mediaChunks.isEmpty()) {
            return;
        }
        HlsMediaChunk lastMediaChunk = (HlsMediaChunk)((Object)Iterables.getLast(this.mediaChunks));
        int chunkState = this.chunkSource.getChunkPublicationState(lastMediaChunk);
        if (chunkState == 1) {
            lastMediaChunk.publish();
        } else if (chunkState == 2 && !this.loadingFinished && this.loader.isLoading()) {
            this.loader.cancelLoading();
        }
    }

    public void release() {
        if (this.prepared) {
            for (HlsSampleQueue sampleQueue : this.sampleQueues) {
                sampleQueue.preRelease();
            }
        }
        this.loader.release((Loader.ReleaseCallback)this);
        this.handler.removeCallbacksAndMessages(null);
        this.released = true;
        this.hlsSampleStreams.clear();
    }

    public void onLoaderReleased() {
        for (HlsSampleQueue sampleQueue : this.sampleQueues) {
            sampleQueue.release();
        }
    }

    public void setIsTimestampMaster(boolean isTimestampMaster) {
        this.chunkSource.setIsTimestampMaster(isTimestampMaster);
    }

    public boolean onPlaylistError(Uri playlistUrl, LoadErrorHandlingPolicy.LoadErrorInfo loadErrorInfo, boolean forceRetry) {
        LoadErrorHandlingPolicy.FallbackSelection fallbackSelection;
        if (!this.chunkSource.obtainsChunksForPlaylist(playlistUrl)) {
            return true;
        }
        long exclusionDurationMs = -9223372036854775807L;
        if (!forceRetry && (fallbackSelection = this.loadErrorHandlingPolicy.getFallbackSelectionFor(TrackSelectionUtil.createFallbackOptions((ExoTrackSelection)this.chunkSource.getTrackSelection()), loadErrorInfo)) != null && fallbackSelection.type == 2) {
            exclusionDurationMs = fallbackSelection.exclusionDurationMs;
        }
        return this.chunkSource.onPlaylistError(playlistUrl, exclusionDurationMs) && exclusionDurationMs != -9223372036854775807L;
    }

    public boolean isReady(int sampleQueueIndex) {
        return !this.isPendingReset() && this.sampleQueues[sampleQueueIndex].isReady(this.loadingFinished);
    }

    public void maybeThrowError(int sampleQueueIndex) throws IOException {
        this.maybeThrowError();
        this.sampleQueues[sampleQueueIndex].maybeThrowError();
    }

    public void maybeThrowError() throws IOException {
        this.loader.maybeThrowError();
        this.chunkSource.maybeThrowError();
    }

    public int readData(int sampleQueueIndex, FormatHolder formatHolder, DecoderInputBuffer buffer, int readFlags) {
        if (this.isPendingReset()) {
            return -3;
        }
        if (!this.mediaChunks.isEmpty()) {
            int discardToMediaChunkIndex;
            for (discardToMediaChunkIndex = 0; discardToMediaChunkIndex < this.mediaChunks.size() - 1 && this.finishedReadingChunk(this.mediaChunks.get(discardToMediaChunkIndex)); ++discardToMediaChunkIndex) {
            }
            Util.removeRange(this.mediaChunks, (int)0, (int)discardToMediaChunkIndex);
            HlsMediaChunk currentChunk = this.mediaChunks.get(0);
            Format trackFormat = currentChunk.trackFormat;
            if (!trackFormat.equals((Object)this.downstreamTrackFormat)) {
                this.mediaSourceEventDispatcher.downstreamFormatChanged(this.trackType, trackFormat, currentChunk.trackSelectionReason, currentChunk.trackSelectionData, currentChunk.startTimeUs);
            }
            this.downstreamTrackFormat = trackFormat;
        }
        if (!this.mediaChunks.isEmpty() && !this.mediaChunks.get(0).isPublished()) {
            return -3;
        }
        int result = this.sampleQueues[sampleQueueIndex].read(formatHolder, buffer, readFlags, this.loadingFinished);
        if (result == -5) {
            Format format = (Format)Assertions.checkNotNull((Object)formatHolder.format);
            if (sampleQueueIndex == this.primarySampleQueueIndex) {
                int chunkIndex;
                int chunkUid = this.sampleQueues[sampleQueueIndex].peekSourceId();
                for (chunkIndex = 0; chunkIndex < this.mediaChunks.size() && this.mediaChunks.get((int)chunkIndex).uid != chunkUid; ++chunkIndex) {
                }
                Format trackFormat = chunkIndex < this.mediaChunks.size() ? this.mediaChunks.get((int)chunkIndex).trackFormat : (Format)Assertions.checkNotNull((Object)this.upstreamTrackFormat);
                format = format.withManifestFormatInfo(trackFormat);
            }
            formatHolder.format = format;
        }
        return result;
    }

    public int skipData(int sampleQueueIndex, long positionUs) {
        if (this.isPendingReset()) {
            return 0;
        }
        HlsSampleQueue sampleQueue = this.sampleQueues[sampleQueueIndex];
        int skipCount = sampleQueue.getSkipCount(positionUs, this.loadingFinished);
        HlsMediaChunk lastChunk = (HlsMediaChunk)((Object)Iterables.getLast(this.mediaChunks, null));
        if (lastChunk != null && !lastChunk.isPublished()) {
            int readIndex = sampleQueue.getReadIndex();
            int firstSampleIndex = lastChunk.getFirstSampleIndex(sampleQueueIndex);
            skipCount = Math.min(skipCount, firstSampleIndex - readIndex);
        }
        sampleQueue.skip(skipCount);
        return skipCount;
    }

    public long getBufferedPositionUs() {
        HlsMediaChunk lastCompletedMediaChunk;
        if (this.loadingFinished) {
            return Long.MIN_VALUE;
        }
        if (this.isPendingReset()) {
            return this.pendingResetPositionUs;
        }
        long bufferedPositionUs = this.lastSeekPositionUs;
        HlsMediaChunk lastMediaChunk = this.getLastMediaChunk();
        HlsMediaChunk hlsMediaChunk = lastMediaChunk.isLoadCompleted() ? lastMediaChunk : (lastCompletedMediaChunk = this.mediaChunks.size() > 1 ? this.mediaChunks.get(this.mediaChunks.size() - 2) : null);
        if (lastCompletedMediaChunk != null) {
            bufferedPositionUs = Math.max(bufferedPositionUs, lastCompletedMediaChunk.endTimeUs);
        }
        if (this.sampleQueuesBuilt) {
            for (HlsSampleQueue sampleQueue : this.sampleQueues) {
                bufferedPositionUs = Math.max(bufferedPositionUs, sampleQueue.getLargestQueuedTimestampUs());
            }
        }
        return bufferedPositionUs;
    }

    public long getNextLoadPositionUs() {
        if (this.isPendingReset()) {
            return this.pendingResetPositionUs;
        }
        return this.loadingFinished ? Long.MIN_VALUE : this.getLastMediaChunk().endTimeUs;
    }

    public boolean continueLoading(long positionUs) {
        long loadPositionUs;
        List<Object> chunkQueue;
        if (this.loadingFinished || this.loader.isLoading() || this.loader.hasFatalError()) {
            return false;
        }
        if (this.isPendingReset()) {
            chunkQueue = Collections.emptyList();
            loadPositionUs = this.pendingResetPositionUs;
            for (HlsSampleQueue sampleQueue : this.sampleQueues) {
                sampleQueue.setStartTimeUs(this.pendingResetPositionUs);
            }
        } else {
            chunkQueue = this.readOnlyMediaChunks;
            HlsMediaChunk lastMediaChunk = this.getLastMediaChunk();
            loadPositionUs = lastMediaChunk.isLoadCompleted() ? lastMediaChunk.endTimeUs : Math.max(this.lastSeekPositionUs, lastMediaChunk.startTimeUs);
        }
        this.nextChunkHolder.clear();
        this.chunkSource.getNextChunk(positionUs, loadPositionUs, chunkQueue, this.prepared || !chunkQueue.isEmpty(), this.nextChunkHolder);
        boolean endOfStream = this.nextChunkHolder.endOfStream;
        Chunk loadable = this.nextChunkHolder.chunk;
        Uri playlistUrlToLoad = this.nextChunkHolder.playlistUrl;
        if (endOfStream) {
            this.pendingResetPositionUs = -9223372036854775807L;
            this.loadingFinished = true;
            return true;
        }
        if (loadable == null) {
            if (playlistUrlToLoad != null) {
                this.callback.onPlaylistRefreshRequired(playlistUrlToLoad);
            }
            return false;
        }
        if (HlsSampleStreamWrapper.isMediaChunk(loadable)) {
            this.initMediaChunkLoad((HlsMediaChunk)loadable);
        }
        this.loadingChunk = loadable;
        long elapsedRealtimeMs = this.loader.startLoading((Loader.Loadable)loadable, (Loader.Callback)this, this.loadErrorHandlingPolicy.getMinimumLoadableRetryCount(loadable.type));
        this.mediaSourceEventDispatcher.loadStarted(new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, elapsedRealtimeMs), loadable.type, this.trackType, loadable.trackFormat, loadable.trackSelectionReason, loadable.trackSelectionData, loadable.startTimeUs, loadable.endTimeUs);
        return true;
    }

    public boolean isLoading() {
        return this.loader.isLoading();
    }

    public void reevaluateBuffer(long positionUs) {
        int preferredQueueSize;
        int newQueueSize;
        if (this.loader.hasFatalError() || this.isPendingReset()) {
            return;
        }
        if (this.loader.isLoading()) {
            Assertions.checkNotNull((Object)this.loadingChunk);
            if (this.chunkSource.shouldCancelLoad(positionUs, this.loadingChunk, this.readOnlyMediaChunks)) {
                this.loader.cancelLoading();
            }
            return;
        }
        for (newQueueSize = this.readOnlyMediaChunks.size(); newQueueSize > 0 && this.chunkSource.getChunkPublicationState(this.readOnlyMediaChunks.get(newQueueSize - 1)) == 2; --newQueueSize) {
        }
        if (newQueueSize < this.readOnlyMediaChunks.size()) {
            this.discardUpstream(newQueueSize);
        }
        if ((preferredQueueSize = this.chunkSource.getPreferredQueueSize(positionUs, this.readOnlyMediaChunks)) < this.mediaChunks.size()) {
            this.discardUpstream(preferredQueueSize);
        }
    }

    public void onLoadCompleted(Chunk loadable, long elapsedRealtimeMs, long loadDurationMs) {
        this.loadingChunk = null;
        this.chunkSource.onChunkLoadCompleted(loadable);
        LoadEventInfo loadEventInfo = new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, loadable.getUri(), loadable.getResponseHeaders(), elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        this.loadErrorHandlingPolicy.onLoadTaskConcluded(loadable.loadTaskId);
        this.mediaSourceEventDispatcher.loadCompleted(loadEventInfo, loadable.type, this.trackType, loadable.trackFormat, loadable.trackSelectionReason, loadable.trackSelectionData, loadable.startTimeUs, loadable.endTimeUs);
        if (!this.prepared) {
            this.continueLoading(this.lastSeekPositionUs);
        } else {
            this.callback.onContinueLoadingRequested(this);
        }
    }

    public void onLoadCanceled(Chunk loadable, long elapsedRealtimeMs, long loadDurationMs, boolean released) {
        this.loadingChunk = null;
        LoadEventInfo loadEventInfo = new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, loadable.getUri(), loadable.getResponseHeaders(), elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        this.loadErrorHandlingPolicy.onLoadTaskConcluded(loadable.loadTaskId);
        this.mediaSourceEventDispatcher.loadCanceled(loadEventInfo, loadable.type, this.trackType, loadable.trackFormat, loadable.trackSelectionReason, loadable.trackSelectionData, loadable.startTimeUs, loadable.endTimeUs);
        if (!released) {
            if (this.isPendingReset() || this.enabledTrackGroupCount == 0) {
                this.resetSampleQueues();
            }
            if (this.enabledTrackGroupCount > 0) {
                this.callback.onContinueLoadingRequested(this);
            }
        }
    }

    public Loader.LoadErrorAction onLoadError(Chunk loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error, int errorCount) {
        Loader.LoadErrorAction loadErrorAction;
        int responseCode;
        boolean isMediaChunk = HlsSampleStreamWrapper.isMediaChunk(loadable);
        if (isMediaChunk && !((HlsMediaChunk)loadable).isPublished() && error instanceof HttpDataSource.InvalidResponseCodeException && ((responseCode = ((HttpDataSource.InvalidResponseCodeException)error).responseCode) == 410 || responseCode == 404)) {
            return Loader.RETRY;
        }
        long bytesLoaded = loadable.bytesLoaded();
        boolean exclusionSucceeded = false;
        LoadEventInfo loadEventInfo = new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, loadable.getUri(), loadable.getResponseHeaders(), elapsedRealtimeMs, loadDurationMs, bytesLoaded);
        MediaLoadData mediaLoadData = new MediaLoadData(loadable.type, this.trackType, loadable.trackFormat, loadable.trackSelectionReason, loadable.trackSelectionData, Util.usToMs((long)loadable.startTimeUs), Util.usToMs((long)loadable.endTimeUs));
        LoadErrorHandlingPolicy.LoadErrorInfo loadErrorInfo = new LoadErrorHandlingPolicy.LoadErrorInfo(loadEventInfo, mediaLoadData, error, errorCount);
        LoadErrorHandlingPolicy.FallbackSelection fallbackSelection = this.loadErrorHandlingPolicy.getFallbackSelectionFor(TrackSelectionUtil.createFallbackOptions((ExoTrackSelection)this.chunkSource.getTrackSelection()), loadErrorInfo);
        if (fallbackSelection != null && fallbackSelection.type == 2) {
            exclusionSucceeded = this.chunkSource.maybeExcludeTrack(loadable, fallbackSelection.exclusionDurationMs);
        }
        if (exclusionSucceeded) {
            if (isMediaChunk && bytesLoaded == 0L) {
                HlsMediaChunk removed = this.mediaChunks.remove(this.mediaChunks.size() - 1);
                Assertions.checkState((removed == loadable ? 1 : 0) != 0);
                if (this.mediaChunks.isEmpty()) {
                    this.pendingResetPositionUs = this.lastSeekPositionUs;
                } else {
                    ((HlsMediaChunk)((Object)Iterables.getLast(this.mediaChunks))).invalidateExtractor();
                }
            }
            loadErrorAction = Loader.DONT_RETRY;
        } else {
            long retryDelayMs = this.loadErrorHandlingPolicy.getRetryDelayMsFor(loadErrorInfo);
            loadErrorAction = retryDelayMs != -9223372036854775807L ? Loader.createRetryAction((boolean)false, (long)retryDelayMs) : Loader.DONT_RETRY_FATAL;
        }
        boolean wasCanceled = !loadErrorAction.isRetry();
        this.mediaSourceEventDispatcher.loadError(loadEventInfo, loadable.type, this.trackType, loadable.trackFormat, loadable.trackSelectionReason, loadable.trackSelectionData, loadable.startTimeUs, loadable.endTimeUs, error, wasCanceled);
        if (wasCanceled) {
            this.loadingChunk = null;
            this.loadErrorHandlingPolicy.onLoadTaskConcluded(loadable.loadTaskId);
        }
        if (exclusionSucceeded) {
            if (!this.prepared) {
                this.continueLoading(this.lastSeekPositionUs);
            } else {
                this.callback.onContinueLoadingRequested(this);
            }
        }
        return loadErrorAction;
    }

    private void initMediaChunkLoad(HlsMediaChunk chunk) {
        this.sourceChunk = chunk;
        this.upstreamTrackFormat = chunk.trackFormat;
        this.pendingResetPositionUs = -9223372036854775807L;
        this.mediaChunks.add(chunk);
        ImmutableList.Builder sampleQueueWriteIndicesBuilder = ImmutableList.builder();
        for (HlsSampleQueue sampleQueue : this.sampleQueues) {
            sampleQueueWriteIndicesBuilder.add((Object)sampleQueue.getWriteIndex());
        }
        chunk.init(this, (ImmutableList<Integer>)sampleQueueWriteIndicesBuilder.build());
        for (HlsSampleQueue sampleQueue : this.sampleQueues) {
            sampleQueue.setSourceChunk(chunk);
            if (!chunk.shouldSpliceIn) continue;
            sampleQueue.splice();
        }
    }

    private void discardUpstream(int preferredQueueSize) {
        Assertions.checkState((!this.loader.isLoading() ? 1 : 0) != 0);
        int newQueueSize = -1;
        for (int i = preferredQueueSize; i < this.mediaChunks.size(); ++i) {
            if (!this.canDiscardUpstreamMediaChunksFromIndex(i)) continue;
            newQueueSize = i;
            break;
        }
        if (newQueueSize == -1) {
            return;
        }
        long endTimeUs = this.getLastMediaChunk().endTimeUs;
        HlsMediaChunk firstRemovedChunk = this.discardUpstreamMediaChunksFromIndex(newQueueSize);
        if (this.mediaChunks.isEmpty()) {
            this.pendingResetPositionUs = this.lastSeekPositionUs;
        } else {
            ((HlsMediaChunk)((Object)Iterables.getLast(this.mediaChunks))).invalidateExtractor();
        }
        this.loadingFinished = false;
        this.mediaSourceEventDispatcher.upstreamDiscarded(this.primarySampleQueueType, firstRemovedChunk.startTimeUs, endTimeUs);
    }

    public TrackOutput track(int id, int type) {
        Object trackOutput = null;
        if (MAPPABLE_TYPES.contains(type)) {
            trackOutput = this.getMappedTrackOutput(id, type);
        } else {
            for (int i = 0; i < this.sampleQueues.length; ++i) {
                if (this.sampleQueueTrackIds[i] != id) continue;
                trackOutput = this.sampleQueues[i];
                break;
            }
        }
        if (trackOutput == null) {
            if (this.tracksEnded) {
                return HlsSampleStreamWrapper.createFakeTrackOutput(id, type);
            }
            trackOutput = this.createSampleQueue(id, type);
        }
        if (type == 5) {
            if (this.emsgUnwrappingTrackOutput == null) {
                this.emsgUnwrappingTrackOutput = new EmsgUnwrappingTrackOutput((TrackOutput)trackOutput, this.metadataType);
            }
            return this.emsgUnwrappingTrackOutput;
        }
        return trackOutput;
    }

    @Nullable
    private TrackOutput getMappedTrackOutput(int id, int type) {
        Assertions.checkArgument((boolean)MAPPABLE_TYPES.contains(type));
        int sampleQueueIndex = this.sampleQueueIndicesByType.get(type, -1);
        if (sampleQueueIndex == -1) {
            return null;
        }
        if (this.sampleQueueMappingDoneByType.add(type)) {
            this.sampleQueueTrackIds[sampleQueueIndex] = id;
        }
        return this.sampleQueueTrackIds[sampleQueueIndex] == id ? this.sampleQueues[sampleQueueIndex] : HlsSampleStreamWrapper.createFakeTrackOutput(id, type);
    }

    private SampleQueue createSampleQueue(int id, int type) {
        int trackCount = this.sampleQueues.length;
        boolean isAudioVideo = type == 1 || type == 2;
        HlsSampleQueue sampleQueue = new HlsSampleQueue(this.allocator, this.handler.getLooper(), this.drmSessionManager, this.drmEventDispatcher, this.overridingDrmInitData);
        sampleQueue.setStartTimeUs(this.lastSeekPositionUs);
        if (isAudioVideo) {
            sampleQueue.setDrmInitData(this.drmInitData);
        }
        sampleQueue.setSampleOffsetUs(this.sampleOffsetUs);
        if (this.sourceChunk != null) {
            sampleQueue.setSourceChunk(this.sourceChunk);
        }
        sampleQueue.setUpstreamFormatChangeListener(this);
        this.sampleQueueTrackIds = Arrays.copyOf(this.sampleQueueTrackIds, trackCount + 1);
        this.sampleQueueTrackIds[trackCount] = id;
        this.sampleQueues = (HlsSampleQueue[])Util.nullSafeArrayAppend((Object[])this.sampleQueues, (Object)((Object)sampleQueue));
        this.sampleQueueIsAudioVideoFlags = Arrays.copyOf(this.sampleQueueIsAudioVideoFlags, trackCount + 1);
        this.sampleQueueIsAudioVideoFlags[trackCount] = isAudioVideo;
        this.haveAudioVideoSampleQueues |= this.sampleQueueIsAudioVideoFlags[trackCount];
        this.sampleQueueMappingDoneByType.add(type);
        this.sampleQueueIndicesByType.append(type, trackCount);
        if (HlsSampleStreamWrapper.getTrackTypeScore(type) > HlsSampleStreamWrapper.getTrackTypeScore(this.primarySampleQueueType)) {
            this.primarySampleQueueIndex = trackCount;
            this.primarySampleQueueType = type;
        }
        this.sampleQueuesEnabledStates = Arrays.copyOf(this.sampleQueuesEnabledStates, trackCount + 1);
        return sampleQueue;
    }

    public void endTracks() {
        this.tracksEnded = true;
        this.handler.post(this.onTracksEndedRunnable);
    }

    public void seekMap(SeekMap seekMap) {
    }

    public void onUpstreamFormatChanged(Format format) {
        this.handler.post(this.maybeFinishPrepareRunnable);
    }

    public void onNewExtractor() {
        this.sampleQueueMappingDoneByType.clear();
    }

    public void setSampleOffsetUs(long sampleOffsetUs) {
        if (this.sampleOffsetUs != sampleOffsetUs) {
            this.sampleOffsetUs = sampleOffsetUs;
            for (HlsSampleQueue sampleQueue : this.sampleQueues) {
                sampleQueue.setSampleOffsetUs(sampleOffsetUs);
            }
        }
    }

    public void setDrmInitData(@Nullable DrmInitData drmInitData) {
        if (!Util.areEqual((Object)this.drmInitData, (Object)drmInitData)) {
            this.drmInitData = drmInitData;
            for (int i = 0; i < this.sampleQueues.length; ++i) {
                if (!this.sampleQueueIsAudioVideoFlags[i]) continue;
                this.sampleQueues[i].setDrmInitData(drmInitData);
            }
        }
    }

    private void updateSampleStreams(@NullableType SampleStream[] streams) {
        this.hlsSampleStreams.clear();
        for (SampleStream stream : streams) {
            if (stream == null) continue;
            this.hlsSampleStreams.add((HlsSampleStream)stream);
        }
    }

    private boolean finishedReadingChunk(HlsMediaChunk chunk) {
        int chunkUid = chunk.uid;
        int sampleQueueCount = this.sampleQueues.length;
        for (int i = 0; i < sampleQueueCount; ++i) {
            if (!this.sampleQueuesEnabledStates[i] || this.sampleQueues[i].peekSourceId() != chunkUid) continue;
            return false;
        }
        return true;
    }

    private boolean canDiscardUpstreamMediaChunksFromIndex(int mediaChunkIndex) {
        for (int i = mediaChunkIndex; i < this.mediaChunks.size(); ++i) {
            if (!this.mediaChunks.get((int)i).shouldSpliceIn) continue;
            return false;
        }
        HlsMediaChunk mediaChunk = this.mediaChunks.get(mediaChunkIndex);
        for (int i = 0; i < this.sampleQueues.length; ++i) {
            int discardFromIndex = mediaChunk.getFirstSampleIndex(i);
            if (this.sampleQueues[i].getReadIndex() <= discardFromIndex) continue;
            return false;
        }
        return true;
    }

    private HlsMediaChunk discardUpstreamMediaChunksFromIndex(int chunkIndex) {
        HlsMediaChunk firstRemovedChunk = this.mediaChunks.get(chunkIndex);
        Util.removeRange(this.mediaChunks, (int)chunkIndex, (int)this.mediaChunks.size());
        for (int i = 0; i < this.sampleQueues.length; ++i) {
            int discardFromIndex = firstRemovedChunk.getFirstSampleIndex(i);
            this.sampleQueues[i].discardUpstreamSamples(discardFromIndex);
        }
        return firstRemovedChunk;
    }

    private void resetSampleQueues() {
        for (HlsSampleQueue sampleQueue : this.sampleQueues) {
            sampleQueue.reset(this.pendingResetUpstreamFormats);
        }
        this.pendingResetUpstreamFormats = false;
    }

    private void onTracksEnded() {
        this.sampleQueuesBuilt = true;
        this.maybeFinishPrepare();
    }

    private void maybeFinishPrepare() {
        if (this.released || this.trackGroupToSampleQueueIndex != null || !this.sampleQueuesBuilt) {
            return;
        }
        for (HlsSampleQueue sampleQueue : this.sampleQueues) {
            if (sampleQueue.getUpstreamFormat() != null) continue;
            return;
        }
        if (this.trackGroups != null) {
            this.mapSampleQueuesToMatchTrackGroups();
        } else {
            this.buildTracksFromSampleStreams();
            this.setIsPrepared();
            this.callback.onPrepared();
        }
    }

    @RequiresNonNull(value={"trackGroups"})
    @EnsuresNonNull(value={"trackGroupToSampleQueueIndex"})
    private void mapSampleQueuesToMatchTrackGroups() {
        int trackGroupCount = this.trackGroups.length;
        this.trackGroupToSampleQueueIndex = new int[trackGroupCount];
        Arrays.fill(this.trackGroupToSampleQueueIndex, -1);
        block0: for (int i = 0; i < trackGroupCount; ++i) {
            for (int queueIndex = 0; queueIndex < this.sampleQueues.length; ++queueIndex) {
                HlsSampleQueue sampleQueue = this.sampleQueues[queueIndex];
                Format upstreamFormat = (Format)Assertions.checkStateNotNull((Object)sampleQueue.getUpstreamFormat());
                if (!HlsSampleStreamWrapper.formatsMatch(upstreamFormat, this.trackGroups.get(i).getFormat(0))) continue;
                this.trackGroupToSampleQueueIndex[i] = queueIndex;
                continue block0;
            }
        }
        for (HlsSampleStream sampleStream : this.hlsSampleStreams) {
            sampleStream.bindSampleQueue();
        }
    }

    @EnsuresNonNull(value={"trackGroups", "optionalTrackGroups", "trackGroupToSampleQueueIndex"})
    private void buildTracksFromSampleStreams() {
        int primaryExtractorTrackType = -2;
        int primaryExtractorTrackIndex = -1;
        int extractorTrackCount = this.sampleQueues.length;
        for (int i = 0; i < extractorTrackCount; ++i) {
            String sampleMimeType = ((Format)Assertions.checkStateNotNull((Object)this.sampleQueues[i].getUpstreamFormat())).sampleMimeType;
            int trackType = MimeTypes.isVideo((String)sampleMimeType) ? 2 : (MimeTypes.isAudio((String)sampleMimeType) ? 1 : (MimeTypes.isText((String)sampleMimeType) ? 3 : -2));
            if (HlsSampleStreamWrapper.getTrackTypeScore(trackType) > HlsSampleStreamWrapper.getTrackTypeScore(primaryExtractorTrackType)) {
                primaryExtractorTrackType = trackType;
                primaryExtractorTrackIndex = i;
                continue;
            }
            if (trackType != primaryExtractorTrackType || primaryExtractorTrackIndex == -1) continue;
            primaryExtractorTrackIndex = -1;
        }
        TrackGroup chunkSourceTrackGroup = this.chunkSource.getTrackGroup();
        int chunkSourceTrackCount = chunkSourceTrackGroup.length;
        this.primaryTrackGroupIndex = -1;
        this.trackGroupToSampleQueueIndex = new int[extractorTrackCount];
        for (int i = 0; i < extractorTrackCount; ++i) {
            this.trackGroupToSampleQueueIndex[i] = i;
        }
        TrackGroup[] trackGroups = new TrackGroup[extractorTrackCount];
        for (int i = 0; i < extractorTrackCount; ++i) {
            Format sampleFormat = (Format)Assertions.checkStateNotNull((Object)this.sampleQueues[i].getUpstreamFormat());
            if (i == primaryExtractorTrackIndex) {
                Format[] formats = new Format[chunkSourceTrackCount];
                if (chunkSourceTrackCount == 1) {
                    formats[0] = sampleFormat.withManifestFormatInfo(chunkSourceTrackGroup.getFormat(0));
                } else {
                    for (int j = 0; j < chunkSourceTrackCount; ++j) {
                        formats[j] = HlsSampleStreamWrapper.deriveFormat(chunkSourceTrackGroup.getFormat(j), sampleFormat, true);
                    }
                }
                trackGroups[i] = new TrackGroup(formats);
                this.primaryTrackGroupIndex = i;
                continue;
            }
            Format trackFormat = primaryExtractorTrackType == 2 && MimeTypes.isAudio((String)sampleFormat.sampleMimeType) ? this.muxedAudioFormat : null;
            trackGroups[i] = new TrackGroup(new Format[]{HlsSampleStreamWrapper.deriveFormat(trackFormat, sampleFormat, false)});
        }
        this.trackGroups = this.createTrackGroupArrayWithDrmInfo(trackGroups);
        Assertions.checkState((this.optionalTrackGroups == null ? 1 : 0) != 0);
        this.optionalTrackGroups = Collections.emptySet();
    }

    private TrackGroupArray createTrackGroupArrayWithDrmInfo(TrackGroup[] trackGroups) {
        for (int i = 0; i < trackGroups.length; ++i) {
            TrackGroup trackGroup = trackGroups[i];
            Format[] exposedFormats = new Format[trackGroup.length];
            for (int j = 0; j < trackGroup.length; ++j) {
                Format format = trackGroup.getFormat(j);
                exposedFormats[j] = format.copyWithCryptoType(this.drmSessionManager.getCryptoType(format));
            }
            trackGroups[i] = new TrackGroup(exposedFormats);
        }
        return new TrackGroupArray(trackGroups);
    }

    private HlsMediaChunk getLastMediaChunk() {
        return this.mediaChunks.get(this.mediaChunks.size() - 1);
    }

    private boolean isPendingReset() {
        return this.pendingResetPositionUs != -9223372036854775807L;
    }

    private boolean seekInsideBufferUs(long positionUs) {
        int sampleQueueCount = this.sampleQueues.length;
        for (int i = 0; i < sampleQueueCount; ++i) {
            HlsSampleQueue sampleQueue = this.sampleQueues[i];
            boolean seekInsideQueue = sampleQueue.seekTo(positionUs, false);
            if (seekInsideQueue || !this.sampleQueueIsAudioVideoFlags[i] && this.haveAudioVideoSampleQueues) continue;
            return false;
        }
        return true;
    }

    @RequiresNonNull(value={"trackGroups", "optionalTrackGroups"})
    private void setIsPrepared() {
        this.prepared = true;
    }

    @EnsuresNonNull(value={"trackGroups", "optionalTrackGroups"})
    private void assertIsPrepared() {
        Assertions.checkState((boolean)this.prepared);
        Assertions.checkNotNull((Object)this.trackGroups);
        Assertions.checkNotNull(this.optionalTrackGroups);
    }

    private static int getTrackTypeScore(int trackType) {
        switch (trackType) {
            case 2: {
                return 3;
            }
            case 1: {
                return 2;
            }
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    private static Format deriveFormat(@Nullable Format playlistFormat, Format sampleFormat, boolean propagateBitrates) {
        String sampleMimeType;
        String codecs;
        if (playlistFormat == null) {
            return sampleFormat;
        }
        int sampleTrackType = MimeTypes.getTrackType((String)sampleFormat.sampleMimeType);
        if (Util.getCodecCountOfType((String)playlistFormat.codecs, (int)sampleTrackType) == 1) {
            codecs = Util.getCodecsOfType((String)playlistFormat.codecs, (int)sampleTrackType);
            sampleMimeType = MimeTypes.getMediaMimeType((String)codecs);
        } else {
            codecs = MimeTypes.getCodecsCorrespondingToMimeType((String)playlistFormat.codecs, (String)sampleFormat.sampleMimeType);
            sampleMimeType = sampleFormat.sampleMimeType;
        }
        Format.Builder formatBuilder = sampleFormat.buildUpon().setId(playlistFormat.id).setLabel(playlistFormat.label).setLanguage(playlistFormat.language).setSelectionFlags(playlistFormat.selectionFlags).setRoleFlags(playlistFormat.roleFlags).setAverageBitrate(propagateBitrates ? playlistFormat.averageBitrate : -1).setPeakBitrate(propagateBitrates ? playlistFormat.peakBitrate : -1).setCodecs(codecs);
        if (sampleTrackType == 2) {
            formatBuilder.setWidth(playlistFormat.width).setHeight(playlistFormat.height).setFrameRate(playlistFormat.frameRate);
        }
        if (sampleMimeType != null) {
            formatBuilder.setSampleMimeType(sampleMimeType);
        }
        if (playlistFormat.channelCount != -1 && sampleTrackType == 1) {
            formatBuilder.setChannelCount(playlistFormat.channelCount);
        }
        if (playlistFormat.metadata != null) {
            Metadata metadata = playlistFormat.metadata;
            if (sampleFormat.metadata != null) {
                metadata = sampleFormat.metadata.copyWithAppendedEntriesFrom(metadata);
            }
            formatBuilder.setMetadata(metadata);
        }
        return formatBuilder.build();
    }

    private static boolean isMediaChunk(Chunk chunk) {
        return chunk instanceof HlsMediaChunk;
    }

    private static boolean formatsMatch(Format manifestFormat, Format sampleFormat) {
        String manifestFormatMimeType = manifestFormat.sampleMimeType;
        String sampleFormatMimeType = sampleFormat.sampleMimeType;
        int manifestFormatTrackType = MimeTypes.getTrackType((String)manifestFormatMimeType);
        if (manifestFormatTrackType != 3) {
            return manifestFormatTrackType == MimeTypes.getTrackType((String)sampleFormatMimeType);
        }
        if (!Util.areEqual((Object)manifestFormatMimeType, (Object)sampleFormatMimeType)) {
            return false;
        }
        if ("application/cea-608".equals(manifestFormatMimeType) || "application/cea-708".equals(manifestFormatMimeType)) {
            return manifestFormat.accessibilityChannel == sampleFormat.accessibilityChannel;
        }
        return true;
    }

    private static DummyTrackOutput createFakeTrackOutput(int id, int type) {
        Log.w((String)TAG, (String)new StringBuilder(54).append("Unmapped track with id ").append(id).append(" of type ").append(type).toString());
        return new DummyTrackOutput();
    }

    private static class EmsgUnwrappingTrackOutput
    implements TrackOutput {
        private static final String TAG = "EmsgUnwrappingTrackOutput";
        private static final Format ID3_FORMAT = new Format.Builder().setSampleMimeType("application/id3").build();
        private static final Format EMSG_FORMAT = new Format.Builder().setSampleMimeType("application/x-emsg").build();
        private final EventMessageDecoder emsgDecoder = new EventMessageDecoder();
        private final TrackOutput delegate;
        private final Format delegateFormat;
        private @MonotonicNonNull Format format;
        private byte[] buffer;
        private int bufferPosition;

        public EmsgUnwrappingTrackOutput(TrackOutput delegate, int metadataType) {
            this.delegate = delegate;
            switch (metadataType) {
                case 1: {
                    this.delegateFormat = ID3_FORMAT;
                    break;
                }
                case 3: {
                    this.delegateFormat = EMSG_FORMAT;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuilder(33).append("Unknown metadataType: ").append(metadataType).toString());
                }
            }
            this.buffer = new byte[0];
            this.bufferPosition = 0;
        }

        public void format(Format format) {
            this.format = format;
            this.delegate.format(this.delegateFormat);
        }

        public int sampleData(DataReader input, int length, boolean allowEndOfInput, int sampleDataPart) throws IOException {
            this.ensureBufferCapacity(this.bufferPosition + length);
            int numBytesRead = input.read(this.buffer, this.bufferPosition, length);
            if (numBytesRead == -1) {
                if (allowEndOfInput) {
                    return -1;
                }
                throw new EOFException();
            }
            this.bufferPosition += numBytesRead;
            return numBytesRead;
        }

        public void sampleData(ParsableByteArray data, int length, int sampleDataPart) {
            this.ensureBufferCapacity(this.bufferPosition + length);
            data.readBytes(this.buffer, this.bufferPosition, length);
            this.bufferPosition += length;
        }

        public void sampleMetadata(long timeUs, int flags, int size, int offset, @Nullable TrackOutput.CryptoData cryptoData) {
            ParsableByteArray sampleForDelegate;
            Assertions.checkNotNull((Object)this.format);
            ParsableByteArray sample = this.getSampleAndTrimBuffer(size, offset);
            if (Util.areEqual((Object)this.format.sampleMimeType, (Object)this.delegateFormat.sampleMimeType)) {
                sampleForDelegate = sample;
            } else if ("application/x-emsg".equals(this.format.sampleMimeType)) {
                EventMessage emsg = this.emsgDecoder.decode(sample);
                if (!this.emsgContainsExpectedWrappedFormat(emsg)) {
                    Log.w((String)TAG, (String)String.format("Ignoring EMSG. Expected it to contain wrapped %s but actual wrapped format: %s", this.delegateFormat.sampleMimeType, emsg.getWrappedMetadataFormat()));
                    return;
                }
                sampleForDelegate = new ParsableByteArray((byte[])Assertions.checkNotNull((Object)emsg.getWrappedMetadataBytes()));
            } else {
                String string = String.valueOf(this.format.sampleMimeType);
                Log.w((String)TAG, (String)(string.length() != 0 ? "Ignoring sample for unsupported format: ".concat(string) : new String("Ignoring sample for unsupported format: ")));
                return;
            }
            int sampleSize = sampleForDelegate.bytesLeft();
            this.delegate.sampleData(sampleForDelegate, sampleSize);
            this.delegate.sampleMetadata(timeUs, flags, sampleSize, offset, cryptoData);
        }

        private boolean emsgContainsExpectedWrappedFormat(EventMessage emsg) {
            Format wrappedMetadataFormat = emsg.getWrappedMetadataFormat();
            return wrappedMetadataFormat != null && Util.areEqual((Object)this.delegateFormat.sampleMimeType, (Object)wrappedMetadataFormat.sampleMimeType);
        }

        private void ensureBufferCapacity(int requiredLength) {
            if (this.buffer.length < requiredLength) {
                this.buffer = Arrays.copyOf(this.buffer, requiredLength + requiredLength / 2);
            }
        }

        private ParsableByteArray getSampleAndTrimBuffer(int size, int offset) {
            int sampleEnd = this.bufferPosition - offset;
            int sampleStart = sampleEnd - size;
            byte[] sampleBytes = Arrays.copyOfRange(this.buffer, sampleStart, sampleEnd);
            ParsableByteArray sample = new ParsableByteArray(sampleBytes);
            System.arraycopy(this.buffer, sampleEnd, this.buffer, 0, offset);
            this.bufferPosition = offset;
            return sample;
        }
    }

    private static final class HlsSampleQueue
    extends SampleQueue {
        private final Map<String, DrmInitData> overridingDrmInitData;
        @Nullable
        private DrmInitData drmInitData;

        private HlsSampleQueue(Allocator allocator, Looper playbackLooper, DrmSessionManager drmSessionManager, DrmSessionEventListener.EventDispatcher eventDispatcher, Map<String, DrmInitData> overridingDrmInitData) {
            super(allocator, playbackLooper, drmSessionManager, eventDispatcher);
            this.overridingDrmInitData = overridingDrmInitData;
        }

        public void setSourceChunk(HlsMediaChunk chunk) {
            this.sourceId(chunk.uid);
        }

        public void setDrmInitData(@Nullable DrmInitData drmInitData) {
            this.drmInitData = drmInitData;
            this.invalidateUpstreamFormatAdjustment();
        }

        public Format getAdjustedUpstreamFormat(Format format) {
            DrmInitData overridingDrmInitData;
            DrmInitData drmInitData;
            DrmInitData drmInitData2 = drmInitData = this.drmInitData != null ? this.drmInitData : format.drmInitData;
            if (drmInitData != null && (overridingDrmInitData = this.overridingDrmInitData.get(drmInitData.schemeType)) != null) {
                drmInitData = overridingDrmInitData;
            }
            Metadata metadata = this.getAdjustedMetadata(format.metadata);
            if (drmInitData != format.drmInitData || metadata != format.metadata) {
                format = format.buildUpon().setDrmInitData(drmInitData).setMetadata(metadata).build();
            }
            return super.getAdjustedUpstreamFormat(format);
        }

        @Nullable
        private Metadata getAdjustedMetadata(@Nullable Metadata metadata) {
            if (metadata == null) {
                return null;
            }
            int length = metadata.length();
            int transportStreamTimestampMetadataIndex = -1;
            for (int i = 0; i < length; ++i) {
                Metadata.Entry metadataEntry = metadata.get(i);
                if (!(metadataEntry instanceof PrivFrame)) continue;
                PrivFrame privFrame = (PrivFrame)metadataEntry;
                if (!"com.apple.streaming.transportStreamTimestamp".equals(privFrame.owner)) continue;
                transportStreamTimestampMetadataIndex = i;
                break;
            }
            if (transportStreamTimestampMetadataIndex == -1) {
                return metadata;
            }
            if (length == 1) {
                return null;
            }
            Metadata.Entry[] newMetadataEntries = new Metadata.Entry[length - 1];
            for (int i = 0; i < length; ++i) {
                if (i == transportStreamTimestampMetadataIndex) continue;
                int newIndex = i < transportStreamTimestampMetadataIndex ? i : i - 1;
                newMetadataEntries[newIndex] = metadata.get(i);
            }
            return new Metadata(newMetadataEntries);
        }

        public void sampleMetadata(long timeUs, int flags, int size, int offset, @Nullable TrackOutput.CryptoData cryptoData) {
            super.sampleMetadata(timeUs, flags, size, offset, cryptoData);
        }
    }

    public static interface Callback
    extends SequenceableLoader.Callback<HlsSampleStreamWrapper> {
        public void onPrepared();

        public void onPlaylistRefreshRequired(Uri var1);
    }
}

